<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IPAccountingType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Расчеты ИП | Содержит ответ на запрос стороны исполнительного производства о ходе исполнительного производства, в частности,
 * движение денежных средств по ИП
 * - type: tns:IPAccountingType
 * @subpackage Structs
 */
class IPAccountingType extends AbstractStructBase
{
    /**
     * The InternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ФССП РФ | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от
     * контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $InternalKey;
    /**
     * The IpInternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ИП ФССП РФ | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от
     * контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $IpInternalKey;
    /**
     * The AccDate
     * Meta informations extracted from the WSDL
     * - documentation: Учетная дата записи в регистре | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $AccDate;
    /**
     * The DocType
     * Meta informations extracted from the WSDL
     * - documentation: Тип платежного документа | Тип документа АИС ФССП России (тип документа ПКОСП) | Тип документа электронного документооборота |
     * NSI_Document | Наименование объекта NCORE
     * - maxLength: 31 | 31
     * - minLength: 1 | 1
     * @var string
     */
    public $DocType;
    /**
     * The DocDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата события или документа | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DocDate;
    /**
     * The DocNum
     * Meta informations extracted from the WSDL
     * - documentation: Номер документа | Строка длиной от 1 до 20 символов
     * - minOccurs: 0
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $DocNum;
    /**
     * The RegType
     * Meta informations extracted from the WSDL
     * - documentation: Код типа регистра | Код типа регистра
     * - length: 3
     * @var string
     */
    public $RegType;
    /**
     * The DestType
     * Meta informations extracted from the WSDL
     * - documentation: Тип документа или события | Вид назначения денежных средств
     * - maxLength: 2
     * - minLength: 1
     * @var string
     */
    public $DestType;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - documentation: Сумма | Сумма
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $Amount;
    /**
     * Constructor method for IPAccountingType
     * @uses IPAccountingType::setInternalKey()
     * @uses IPAccountingType::setIpInternalKey()
     * @uses IPAccountingType::setAccDate()
     * @uses IPAccountingType::setDocType()
     * @uses IPAccountingType::setDocDate()
     * @uses IPAccountingType::setDocNum()
     * @uses IPAccountingType::setRegType()
     * @uses IPAccountingType::setDestType()
     * @uses IPAccountingType::setAmount()
     * @param int $internalKey
     * @param int $ipInternalKey
     * @param string $accDate
     * @param string $docType
     * @param string $docDate
     * @param string $docNum
     * @param string $regType
     * @param string $destType
     * @param float $amount
     */
    public function __construct($internalKey = null, $ipInternalKey = null, $accDate = null, $docType = null, $docDate = null, $docNum = null, $regType = null, $destType = null, $amount = null)
    {
        $this
            ->setInternalKey($internalKey)
            ->setIpInternalKey($ipInternalKey)
            ->setAccDate($accDate)
            ->setDocType($docType)
            ->setDocDate($docDate)
            ->setDocNum($docNum)
            ->setRegType($regType)
            ->setDestType($destType)
            ->setAmount($amount);
    }
    /**
     * Get InternalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->InternalKey;
    }
    /**
     * Set InternalKey value
     * @param int $internalKey
     * @return \AisFssp\StructType\IPAccountingType
     */
    public function setInternalKey($internalKey = null)
    {
        // validation for constraint: maxInclusive
        if ($internalKey > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($internalKey < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($internalKey) && !is_numeric($internalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($internalKey)), __LINE__);
        }
        $this->InternalKey = $internalKey;
        return $this;
    }
    /**
     * Get IpInternalKey value
     * @return int|null
     */
    public function getIpInternalKey()
    {
        return $this->IpInternalKey;
    }
    /**
     * Set IpInternalKey value
     * @param int $ipInternalKey
     * @return \AisFssp\StructType\IPAccountingType
     */
    public function setIpInternalKey($ipInternalKey = null)
    {
        // validation for constraint: maxInclusive
        if ($ipInternalKey > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $ipInternalKey), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($ipInternalKey < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $ipInternalKey), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($ipInternalKey) && !is_numeric($ipInternalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ipInternalKey)), __LINE__);
        }
        $this->IpInternalKey = $ipInternalKey;
        return $this;
    }
    /**
     * Get AccDate value
     * @return string|null
     */
    public function getAccDate()
    {
        return $this->AccDate;
    }
    /**
     * Set AccDate value
     * @param string $accDate
     * @return \AisFssp\StructType\IPAccountingType
     */
    public function setAccDate($accDate = null)
    {
        // validation for constraint: maxExclusive
        if ($accDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $accDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($accDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $accDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($accDate) && !is_string($accDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accDate)), __LINE__);
        }
        $this->AccDate = $accDate;
        return $this;
    }
    /**
     * Get DocType value
     * @return string|null
     */
    public function getDocType()
    {
        return $this->DocType;
    }
    /**
     * Set DocType value
     * @param string $docType
     * @return \AisFssp\StructType\IPAccountingType
     */
    public function setDocType($docType = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($docType) && strlen($docType) > 1) || (is_array($docType) && count($docType) > 1)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at most, "%d" length given', is_scalar($docType) ? strlen($docType) : count($docType)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($docType) && strlen($docType) < 1) || (is_array($docType) && count($docType) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docType) && !is_string($docType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docType)), __LINE__);
        }
        $this->DocType = $docType;
        return $this;
    }
    /**
     * Get DocDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->DocDate;
    }
    /**
     * Set DocDate value
     * @param string $docDate
     * @return \AisFssp\StructType\IPAccountingType
     */
    public function setDocDate($docDate = null)
    {
        // validation for constraint: maxExclusive
        if ($docDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $docDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($docDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $docDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docDate) && !is_string($docDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docDate)), __LINE__);
        }
        $this->DocDate = $docDate;
        return $this;
    }
    /**
     * Get DocNum value
     * @return string|null
     */
    public function getDocNum()
    {
        return $this->DocNum;
    }
    /**
     * Set DocNum value
     * @param string $docNum
     * @return \AisFssp\StructType\IPAccountingType
     */
    public function setDocNum($docNum = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($docNum) && strlen($docNum) > 20) || (is_array($docNum) && count($docNum) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($docNum) ? strlen($docNum) : count($docNum)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($docNum) && strlen($docNum) < 1) || (is_array($docNum) && count($docNum) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docNum) && !is_string($docNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docNum)), __LINE__);
        }
        $this->DocNum = $docNum;
        return $this;
    }
    /**
     * Get RegType value
     * @return string|null
     */
    public function getRegType()
    {
        return $this->RegType;
    }
    /**
     * Set RegType value
     * @param string $regType
     * @return \AisFssp\StructType\IPAccountingType
     */
    public function setRegType($regType = null)
    {
        // validation for constraint: length
        if ((is_scalar($regType) && strlen($regType) !== 3) || (is_array($regType) && count($regType) !== 3)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 3 element(s) or a scalar of 3 character(s)', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($regType) && !is_string($regType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($regType)), __LINE__);
        }
        $this->RegType = $regType;
        return $this;
    }
    /**
     * Get DestType value
     * @return string|null
     */
    public function getDestType()
    {
        return $this->DestType;
    }
    /**
     * Set DestType value
     * @param string $destType
     * @return \AisFssp\StructType\IPAccountingType
     */
    public function setDestType($destType = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($destType) && strlen($destType) > 2) || (is_array($destType) && count($destType) > 2)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 2 element(s) or a scalar of 2 character(s) at most, "%d" length given', is_scalar($destType) ? strlen($destType) : count($destType)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($destType) && strlen($destType) < 1) || (is_array($destType) && count($destType) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($destType) && !is_string($destType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($destType)), __LINE__);
        }
        $this->DestType = $destType;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \AisFssp\StructType\IPAccountingType
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($amount) && strlen(substr($amount, strpos($amount, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($amount, strpos($amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($amount) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $amount)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($amount, strpos($amount, '.')))), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\IPAccountingType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
