<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IP StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип данных IP «Исполнительное производство» | Тип данных содержит исчерпывающие сведения об исполнительном производстве.
 * @subpackage Structs
 */
class IP extends AbstractStructBase
{
    /**
     * The InternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ФССП России | Уникальный идентификатор исполнительного производства АИС ФССП России | Ключ объекта, присвоенний
     * информационной системой ФССП РФ при создании объекта или при получении объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $InternalKey;
    /**
     * The IdExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор ИД АИС ВК | Идентификатор исполнительного документа, переданного ранее внешним контрагентом. Заполняется в том
     * случае, если ИД получен от того же внешнего контрагента, которому направляются сведения об ИП | Идентификатор объекта, присвоенный
     * объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный идентификатор должен быть уникальным для типа идентифицируемого документа
     * в пространстве обмена данными с конкретным внешним контрагентом.
     * - minOccurs: 0
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $IdExternalKey;
    /**
     * The IPNum
     * Meta informations extracted from the WSDL
     * - documentation: Номер ИП строковый | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $IPNum;
    /**
     * The IPDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата возбуждения ИП | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $IPDate;
    /**
     * The IPName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование ИП | Текст: 1. Для простых ИП: «Исполнительное производство». 2. Для сводных ИП : "Сводное исполнительное
     * производство" | Строка длиной от 1 до 100 символов
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $IPName;
    /**
     * The IDType
     * Meta informations extracted from the WSDL
     * - documentation: Тип ИД | Тип исполнительного документа, на основании которого возбуждено ИП
     * - minOccurs: 0
     * @var string
     */
    public $IDType;
    /**
     * The IDName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование типа ИД | Строка длиной от 1 до 100 символов
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $IDName;
    /**
     * The IDOrgCode
     * Meta informations extracted from the WSDL
     * - documentation: Код органа, выдавшего ИД | Код организации | NSI_MVV_Organization
     * - minOccurs: 0
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $IDOrgCode;
    /**
     * The IDOrgName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование органа, выдавшего ИД | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $IDOrgName;
    /**
     * The IDNum
     * Meta informations extracted from the WSDL
     * - documentation: Номер ИД | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $IDNum;
    /**
     * The IDDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата ИД | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $IDDate;
    /**
     * The AktDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата вступления | Дата вступления в законную силу судебного акта, акта другого органа или должностного лица либо указание на
     * немедленное исполнение | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $AktDate;
    /**
     * The IDSubj
     * Meta informations extracted from the WSDL
     * - documentation: Код предмета исполнения | Код предмета исполнения | NSI_IDoc_Subj_Exec
     * - minOccurs: 0
     * - maxLength: 8
     * - minLength: 1
     * @var string
     */
    public $IDSubj;
    /**
     * The IDSubjName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование предмета исполнения | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $IDSubjName;
    /**
     * The IDSum
     * Meta informations extracted from the WSDL
     * - documentation: Сумма долга по ИД | Сумма
     * - minOccurs: 0
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $IDSum;
    /**
     * The IPDebt
     * Meta informations extracted from the WSDL
     * - documentation: Сумма долга по ИД на момент запроса | Сумма
     * - minOccurs: 0
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $IPDebt;
    /**
     * The DebtorType
     * Meta informations extracted from the WSDL
     * - documentation: Тип должника
     * @var string
     */
    public $DebtorType;
    /**
     * The DebtorName
     * Meta informations extracted from the WSDL
     * - documentation: ФИО полностью/наименование должника | Строка длиной от 1 до 1000 символов
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $DebtorName;
    /**
     * The DebtorFio
     * Meta informations extracted from the WSDL
     * - documentation: Фамиия, имя, отчество должника по частям | Заполняется только в том случае, если в отделе судебных приставов есть возможность
     * заполнить наименование должника раздельно
     * - minOccurs: 0
     * @var \AisFssp\StructType\FioType
     */
    public $DebtorFio;
    /**
     * The DebtorAdr
     * Meta informations extracted from the WSDL
     * - documentation: Адрес должника по ИД | Адрес должника в формате «Код страны» + «запятая» + «Адрес в формате 9 запятых по КЛАДР» или (в случае
     * отсутствия кода страны) в произвольном формате | Строка длиной от 1 до 300 символов
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $DebtorAdr;
    /**
     * The DebtorINN
     * Meta informations extracted from the WSDL
     * - documentation: ИНН ЮЛ/ИП | ИНН
     * - minOccurs: 0
     * - maxLength: 12
     * - minLength: 10
     * - pattern: (([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{8})|(([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{10})
     * @var string
     */
    public $DebtorINN;
    /**
     * The DebtorKPP
     * Meta informations extracted from the WSDL
     * - documentation: КПП | Код причины постановки на учет ЮЛ | КПП
     * - minOccurs: 0
     * - length: 9
     * - pattern: ([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{7}
     * @var string
     */
    public $DebtorKPP;
    /**
     * The DebtorOGRN
     * Meta informations extracted from the WSDL
     * - documentation: ОГРН/ОГРНИП | ОГРН/ОГРНИП ЮЛ/ИП | Основной государственный регистрационный номер (ОГРН)/Основной государственный
     * регистрационный номер индивидуального предпринимателя (ОГРНИП)
     * - minOccurs: 0
     * - maxLength: 15
     * - minLength: 13
     * - pattern: ([0-9]{13})|([0-9]{15})
     * @var string
     */
    public $DebtorOGRN;
    /**
     * The DebtorBirthDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата рождения ФЛ | Заполняется при наличии данных о дате рождения. В противном случае заполняется только поле «Год рождения» |
     * Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DebtorBirthDate;
    /**
     * The DebtorBirthYear
     * Meta informations extracted from the WSDL
     * - documentation: Год рождения ФЛ | Год (выпуска, рождения и т. п.)
     * - minOccurs: 0
     * - maxInclusive: 2099
     * - minInclusive: 1900
     * @var string
     */
    public $DebtorBirthYear;
    /**
     * The DebtorGender
     * Meta informations extracted from the WSDL
     * - documentation: Пол должника ФЛ
     * - minOccurs: 0
     * @var string
     */
    public $DebtorGender;
    /**
     * The DebtorBirthPlace
     * Meta informations extracted from the WSDL
     * - documentation: Место рождения ФЛ | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $DebtorBirthPlace;
    /**
     * The DebtorSnils
     * Meta informations extracted from the WSDL
     * - documentation: СНИЛС ФЛ | СНИЛС
     * - minOccurs: 0
     * - length: 11
     * - pattern: [0-9]{11}
     * @var string
     */
    public $DebtorSnils;
    /**
     * The OSPCode
     * Meta informations extracted from the WSDL
     * - documentation: ОСП | Ведомственный классификатор отделов судебных приставов | NSI_Departments
     * - minOccurs: 0
     * - length: 5
     * - pattern: [0-9]{5}
     * @var string
     */
    public $OSPCode;
    /**
     * The OSPName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование ОСП | Строка длиной от 1 до 100 символов
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $OSPName;
    /**
     * The SPI
     * Meta informations extracted from the WSDL
     * - documentation: Код СПИ, ведущего ИП | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта
     * от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $SPI;
    /**
     * The SPIFio
     * Meta informations extracted from the WSDL
     * - documentation: ФИО полностью СПИ, ведущего ИП | Полное имя физического лица (фамилия, имя, отчество)
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $SPIFio;
    /**
     * The OldIPNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номера прошлых ИП | Номер документа
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string[]
     */
    public $OldIPNumber;
    /**
     * The ChargeOffQueue
     * Meta informations extracted from the WSDL
     * - documentation: Очерёдность списание средств со счета
     * - minOccurs: 0
     * @var string
     */
    public $ChargeOffQueue;
    /**
     * Constructor method for IP
     * @uses IP::setInternalKey()
     * @uses IP::setIdExternalKey()
     * @uses IP::setIPNum()
     * @uses IP::setIPDate()
     * @uses IP::setIPName()
     * @uses IP::setIDType()
     * @uses IP::setIDName()
     * @uses IP::setIDOrgCode()
     * @uses IP::setIDOrgName()
     * @uses IP::setIDNum()
     * @uses IP::setIDDate()
     * @uses IP::setAktDate()
     * @uses IP::setIDSubj()
     * @uses IP::setIDSubjName()
     * @uses IP::setIDSum()
     * @uses IP::setIPDebt()
     * @uses IP::setDebtorType()
     * @uses IP::setDebtorName()
     * @uses IP::setDebtorFio()
     * @uses IP::setDebtorAdr()
     * @uses IP::setDebtorINN()
     * @uses IP::setDebtorKPP()
     * @uses IP::setDebtorOGRN()
     * @uses IP::setDebtorBirthDate()
     * @uses IP::setDebtorBirthYear()
     * @uses IP::setDebtorGender()
     * @uses IP::setDebtorBirthPlace()
     * @uses IP::setDebtorSnils()
     * @uses IP::setOSPCode()
     * @uses IP::setOSPName()
     * @uses IP::setSPI()
     * @uses IP::setSPIFio()
     * @uses IP::setOldIPNumber()
     * @uses IP::setChargeOffQueue()
     * @param int $internalKey
     * @param string $idExternalKey
     * @param string $iPNum
     * @param string $iPDate
     * @param string $iPName
     * @param string $iDType
     * @param string $iDName
     * @param string $iDOrgCode
     * @param string $iDOrgName
     * @param string $iDNum
     * @param string $iDDate
     * @param string $aktDate
     * @param string $iDSubj
     * @param string $iDSubjName
     * @param float $iDSum
     * @param float $iPDebt
     * @param string $debtorType
     * @param string $debtorName
     * @param \AisFssp\StructType\FioType $debtorFio
     * @param string $debtorAdr
     * @param string $debtorINN
     * @param string $debtorKPP
     * @param string $debtorOGRN
     * @param string $debtorBirthDate
     * @param string $debtorBirthYear
     * @param string $debtorGender
     * @param string $debtorBirthPlace
     * @param string $debtorSnils
     * @param string $oSPCode
     * @param string $oSPName
     * @param int $sPI
     * @param string $sPIFio
     * @param string[] $oldIPNumber
     * @param string $chargeOffQueue
     */
    public function __construct($internalKey = null, $idExternalKey = null, $iPNum = null, $iPDate = null, $iPName = null, $iDType = null, $iDName = null, $iDOrgCode = null, $iDOrgName = null, $iDNum = null, $iDDate = null, $aktDate = null, $iDSubj = null, $iDSubjName = null, $iDSum = null, $iPDebt = null, $debtorType = null, $debtorName = null, \AisFssp\StructType\FioType $debtorFio = null, $debtorAdr = null, $debtorINN = null, $debtorKPP = null, $debtorOGRN = null, $debtorBirthDate = null, $debtorBirthYear = null, $debtorGender = null, $debtorBirthPlace = null, $debtorSnils = null, $oSPCode = null, $oSPName = null, $sPI = null, $sPIFio = null, array $oldIPNumber = array(), $chargeOffQueue = null)
    {
        $this
            ->setInternalKey($internalKey)
            ->setIdExternalKey($idExternalKey)
            ->setIPNum($iPNum)
            ->setIPDate($iPDate)
            ->setIPName($iPName)
            ->setIDType($iDType)
            ->setIDName($iDName)
            ->setIDOrgCode($iDOrgCode)
            ->setIDOrgName($iDOrgName)
            ->setIDNum($iDNum)
            ->setIDDate($iDDate)
            ->setAktDate($aktDate)
            ->setIDSubj($iDSubj)
            ->setIDSubjName($iDSubjName)
            ->setIDSum($iDSum)
            ->setIPDebt($iPDebt)
            ->setDebtorType($debtorType)
            ->setDebtorName($debtorName)
            ->setDebtorFio($debtorFio)
            ->setDebtorAdr($debtorAdr)
            ->setDebtorINN($debtorINN)
            ->setDebtorKPP($debtorKPP)
            ->setDebtorOGRN($debtorOGRN)
            ->setDebtorBirthDate($debtorBirthDate)
            ->setDebtorBirthYear($debtorBirthYear)
            ->setDebtorGender($debtorGender)
            ->setDebtorBirthPlace($debtorBirthPlace)
            ->setDebtorSnils($debtorSnils)
            ->setOSPCode($oSPCode)
            ->setOSPName($oSPName)
            ->setSPI($sPI)
            ->setSPIFio($sPIFio)
            ->setOldIPNumber($oldIPNumber)
            ->setChargeOffQueue($chargeOffQueue);
    }
    /**
     * Get InternalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->InternalKey;
    }
    /**
     * Set InternalKey value
     * @param int $internalKey
     * @return \AisFssp\StructType\IP
     */
    public function setInternalKey($internalKey = null)
    {
        // validation for constraint: maxInclusive
        if ($internalKey > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($internalKey < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($internalKey) && !is_numeric($internalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($internalKey)), __LINE__);
        }
        $this->InternalKey = $internalKey;
        return $this;
    }
    /**
     * Get IdExternalKey value
     * @return string|null
     */
    public function getIdExternalKey()
    {
        return $this->IdExternalKey;
    }
    /**
     * Set IdExternalKey value
     * @param string $idExternalKey
     * @return \AisFssp\StructType\IP
     */
    public function setIdExternalKey($idExternalKey = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($idExternalKey) && strlen($idExternalKey) > 60) || (is_array($idExternalKey) && count($idExternalKey) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($idExternalKey) ? strlen($idExternalKey) : count($idExternalKey)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($idExternalKey) && strlen($idExternalKey) < 1) || (is_array($idExternalKey) && count($idExternalKey) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($idExternalKey) && !is_string($idExternalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idExternalKey)), __LINE__);
        }
        $this->IdExternalKey = $idExternalKey;
        return $this;
    }
    /**
     * Get IPNum value
     * @return string|null
     */
    public function getIPNum()
    {
        return $this->IPNum;
    }
    /**
     * Set IPNum value
     * @param string $iPNum
     * @return \AisFssp\StructType\IP
     */
    public function setIPNum($iPNum = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iPNum) && strlen($iPNum) > 25) || (is_array($iPNum) && count($iPNum) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($iPNum) ? strlen($iPNum) : count($iPNum)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($iPNum) && strlen($iPNum) < 1) || (is_array($iPNum) && count($iPNum) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iPNum) && !is_string($iPNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iPNum)), __LINE__);
        }
        $this->IPNum = $iPNum;
        return $this;
    }
    /**
     * Get IPDate value
     * @return string|null
     */
    public function getIPDate()
    {
        return $this->IPDate;
    }
    /**
     * Set IPDate value
     * @param string $iPDate
     * @return \AisFssp\StructType\IP
     */
    public function setIPDate($iPDate = null)
    {
        // validation for constraint: maxExclusive
        if ($iPDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $iPDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($iPDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $iPDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iPDate) && !is_string($iPDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iPDate)), __LINE__);
        }
        $this->IPDate = $iPDate;
        return $this;
    }
    /**
     * Get IPName value
     * @return string|null
     */
    public function getIPName()
    {
        return $this->IPName;
    }
    /**
     * Set IPName value
     * @param string $iPName
     * @return \AisFssp\StructType\IP
     */
    public function setIPName($iPName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iPName) && strlen($iPName) > 100) || (is_array($iPName) && count($iPName) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($iPName) ? strlen($iPName) : count($iPName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($iPName) && strlen($iPName) < 1) || (is_array($iPName) && count($iPName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iPName) && !is_string($iPName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iPName)), __LINE__);
        }
        $this->IPName = $iPName;
        return $this;
    }
    /**
     * Get IDType value
     * @return string|null
     */
    public function getIDType()
    {
        return $this->IDType;
    }
    /**
     * Set IDType value
     * @uses \AisFssp\EnumType\IdType::valueIsValid()
     * @uses \AisFssp\EnumType\IdType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $iDType
     * @return \AisFssp\StructType\IP
     */
    public function setIDType($iDType = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\IdType::valueIsValid($iDType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $iDType, implode(', ', \AisFssp\EnumType\IdType::getValidValues())), __LINE__);
        }
        $this->IDType = $iDType;
        return $this;
    }
    /**
     * Get IDName value
     * @return string|null
     */
    public function getIDName()
    {
        return $this->IDName;
    }
    /**
     * Set IDName value
     * @param string $iDName
     * @return \AisFssp\StructType\IP
     */
    public function setIDName($iDName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iDName) && strlen($iDName) > 100) || (is_array($iDName) && count($iDName) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($iDName) ? strlen($iDName) : count($iDName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($iDName) && strlen($iDName) < 1) || (is_array($iDName) && count($iDName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iDName) && !is_string($iDName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iDName)), __LINE__);
        }
        $this->IDName = $iDName;
        return $this;
    }
    /**
     * Get IDOrgCode value
     * @return string|null
     */
    public function getIDOrgCode()
    {
        return $this->IDOrgCode;
    }
    /**
     * Set IDOrgCode value
     * @param string $iDOrgCode
     * @return \AisFssp\StructType\IP
     */
    public function setIDOrgCode($iDOrgCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iDOrgCode) && strlen($iDOrgCode) > 20) || (is_array($iDOrgCode) && count($iDOrgCode) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($iDOrgCode) ? strlen($iDOrgCode) : count($iDOrgCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($iDOrgCode) && strlen($iDOrgCode) < 1) || (is_array($iDOrgCode) && count($iDOrgCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iDOrgCode) && !is_string($iDOrgCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iDOrgCode)), __LINE__);
        }
        $this->IDOrgCode = $iDOrgCode;
        return $this;
    }
    /**
     * Get IDOrgName value
     * @return string|null
     */
    public function getIDOrgName()
    {
        return $this->IDOrgName;
    }
    /**
     * Set IDOrgName value
     * @param string $iDOrgName
     * @return \AisFssp\StructType\IP
     */
    public function setIDOrgName($iDOrgName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iDOrgName) && strlen($iDOrgName) > 300) || (is_array($iDOrgName) && count($iDOrgName) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($iDOrgName) ? strlen($iDOrgName) : count($iDOrgName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($iDOrgName) && strlen($iDOrgName) < 1) || (is_array($iDOrgName) && count($iDOrgName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iDOrgName) && !is_string($iDOrgName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iDOrgName)), __LINE__);
        }
        $this->IDOrgName = $iDOrgName;
        return $this;
    }
    /**
     * Get IDNum value
     * @return string|null
     */
    public function getIDNum()
    {
        return $this->IDNum;
    }
    /**
     * Set IDNum value
     * @param string $iDNum
     * @return \AisFssp\StructType\IP
     */
    public function setIDNum($iDNum = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iDNum) && strlen($iDNum) > 25) || (is_array($iDNum) && count($iDNum) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($iDNum) ? strlen($iDNum) : count($iDNum)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($iDNum) && strlen($iDNum) < 1) || (is_array($iDNum) && count($iDNum) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iDNum) && !is_string($iDNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iDNum)), __LINE__);
        }
        $this->IDNum = $iDNum;
        return $this;
    }
    /**
     * Get IDDate value
     * @return string|null
     */
    public function getIDDate()
    {
        return $this->IDDate;
    }
    /**
     * Set IDDate value
     * @param string $iDDate
     * @return \AisFssp\StructType\IP
     */
    public function setIDDate($iDDate = null)
    {
        // validation for constraint: maxExclusive
        if ($iDDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $iDDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($iDDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $iDDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iDDate) && !is_string($iDDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iDDate)), __LINE__);
        }
        $this->IDDate = $iDDate;
        return $this;
    }
    /**
     * Get AktDate value
     * @return string|null
     */
    public function getAktDate()
    {
        return $this->AktDate;
    }
    /**
     * Set AktDate value
     * @param string $aktDate
     * @return \AisFssp\StructType\IP
     */
    public function setAktDate($aktDate = null)
    {
        // validation for constraint: maxExclusive
        if ($aktDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $aktDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($aktDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $aktDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aktDate) && !is_string($aktDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aktDate)), __LINE__);
        }
        $this->AktDate = $aktDate;
        return $this;
    }
    /**
     * Get IDSubj value
     * @return string|null
     */
    public function getIDSubj()
    {
        return $this->IDSubj;
    }
    /**
     * Set IDSubj value
     * @param string $iDSubj
     * @return \AisFssp\StructType\IP
     */
    public function setIDSubj($iDSubj = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iDSubj) && strlen($iDSubj) > 8) || (is_array($iDSubj) && count($iDSubj) > 8)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 8 element(s) or a scalar of 8 character(s) at most, "%d" length given', is_scalar($iDSubj) ? strlen($iDSubj) : count($iDSubj)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($iDSubj) && strlen($iDSubj) < 1) || (is_array($iDSubj) && count($iDSubj) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iDSubj) && !is_string($iDSubj)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iDSubj)), __LINE__);
        }
        $this->IDSubj = $iDSubj;
        return $this;
    }
    /**
     * Get IDSubjName value
     * @return string|null
     */
    public function getIDSubjName()
    {
        return $this->IDSubjName;
    }
    /**
     * Set IDSubjName value
     * @param string $iDSubjName
     * @return \AisFssp\StructType\IP
     */
    public function setIDSubjName($iDSubjName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iDSubjName) && strlen($iDSubjName) > 300) || (is_array($iDSubjName) && count($iDSubjName) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($iDSubjName) ? strlen($iDSubjName) : count($iDSubjName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($iDSubjName) && strlen($iDSubjName) < 1) || (is_array($iDSubjName) && count($iDSubjName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iDSubjName) && !is_string($iDSubjName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iDSubjName)), __LINE__);
        }
        $this->IDSubjName = $iDSubjName;
        return $this;
    }
    /**
     * Get IDSum value
     * @return float|null
     */
    public function getIDSum()
    {
        return $this->IDSum;
    }
    /**
     * Set IDSum value
     * @param float $iDSum
     * @return \AisFssp\StructType\IP
     */
    public function setIDSum($iDSum = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($iDSum) && strlen(substr($iDSum, strpos($iDSum, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($iDSum, strpos($iDSum, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($iDSum) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $iDSum)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($iDSum, strpos($iDSum, '.')))), __LINE__);
        }
        $this->IDSum = $iDSum;
        return $this;
    }
    /**
     * Get IPDebt value
     * @return float|null
     */
    public function getIPDebt()
    {
        return $this->IPDebt;
    }
    /**
     * Set IPDebt value
     * @param float $iPDebt
     * @return \AisFssp\StructType\IP
     */
    public function setIPDebt($iPDebt = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($iPDebt) && strlen(substr($iPDebt, strpos($iPDebt, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($iPDebt, strpos($iPDebt, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($iPDebt) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $iPDebt)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($iPDebt, strpos($iPDebt, '.')))), __LINE__);
        }
        $this->IPDebt = $iPDebt;
        return $this;
    }
    /**
     * Get DebtorType value
     * @return string|null
     */
    public function getDebtorType()
    {
        return $this->DebtorType;
    }
    /**
     * Set DebtorType value
     * @uses \AisFssp\EnumType\ContragentType::valueIsValid()
     * @uses \AisFssp\EnumType\ContragentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $debtorType
     * @return \AisFssp\StructType\IP
     */
    public function setDebtorType($debtorType = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\ContragentType::valueIsValid($debtorType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $debtorType, implode(', ', \AisFssp\EnumType\ContragentType::getValidValues())), __LINE__);
        }
        $this->DebtorType = $debtorType;
        return $this;
    }
    /**
     * Get DebtorName value
     * @return string|null
     */
    public function getDebtorName()
    {
        return $this->DebtorName;
    }
    /**
     * Set DebtorName value
     * @param string $debtorName
     * @return \AisFssp\StructType\IP
     */
    public function setDebtorName($debtorName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($debtorName) && strlen($debtorName) > 1000) || (is_array($debtorName) && count($debtorName) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($debtorName) ? strlen($debtorName) : count($debtorName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($debtorName) && strlen($debtorName) < 1) || (is_array($debtorName) && count($debtorName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($debtorName) && !is_string($debtorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($debtorName)), __LINE__);
        }
        $this->DebtorName = $debtorName;
        return $this;
    }
    /**
     * Get DebtorFio value
     * @return \AisFssp\StructType\FioType|null
     */
    public function getDebtorFio()
    {
        return $this->DebtorFio;
    }
    /**
     * Set DebtorFio value
     * @param \AisFssp\StructType\FioType $debtorFio
     * @return \AisFssp\StructType\IP
     */
    public function setDebtorFio(\AisFssp\StructType\FioType $debtorFio = null)
    {
        $this->DebtorFio = $debtorFio;
        return $this;
    }
    /**
     * Get DebtorAdr value
     * @return string|null
     */
    public function getDebtorAdr()
    {
        return $this->DebtorAdr;
    }
    /**
     * Set DebtorAdr value
     * @param string $debtorAdr
     * @return \AisFssp\StructType\IP
     */
    public function setDebtorAdr($debtorAdr = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($debtorAdr) && strlen($debtorAdr) > 300) || (is_array($debtorAdr) && count($debtorAdr) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($debtorAdr) ? strlen($debtorAdr) : count($debtorAdr)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($debtorAdr) && strlen($debtorAdr) < 1) || (is_array($debtorAdr) && count($debtorAdr) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($debtorAdr) && !is_string($debtorAdr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($debtorAdr)), __LINE__);
        }
        $this->DebtorAdr = $debtorAdr;
        return $this;
    }
    /**
     * Get DebtorINN value
     * @return string|null
     */
    public function getDebtorINN()
    {
        return $this->DebtorINN;
    }
    /**
     * Set DebtorINN value
     * @param string $debtorINN
     * @return \AisFssp\StructType\IP
     */
    public function setDebtorINN($debtorINN = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($debtorINN) && strlen($debtorINN) > 12) || (is_array($debtorINN) && count($debtorINN) > 12)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 12 element(s) or a scalar of 12 character(s) at most, "%d" length given', is_scalar($debtorINN) ? strlen($debtorINN) : count($debtorINN)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($debtorINN) && strlen($debtorINN) < 10) || (is_array($debtorINN) && count($debtorINN) < 10)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($debtorINN) && !preg_match('/(([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{8})|(([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{10})/', $debtorINN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{8})|(([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{10})", "%s" given', var_export($debtorINN, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($debtorINN) && !is_string($debtorINN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($debtorINN)), __LINE__);
        }
        $this->DebtorINN = $debtorINN;
        return $this;
    }
    /**
     * Get DebtorKPP value
     * @return string|null
     */
    public function getDebtorKPP()
    {
        return $this->DebtorKPP;
    }
    /**
     * Set DebtorKPP value
     * @param string $debtorKPP
     * @return \AisFssp\StructType\IP
     */
    public function setDebtorKPP($debtorKPP = null)
    {
        // validation for constraint: length
        if ((is_scalar($debtorKPP) && strlen($debtorKPP) !== 9) || (is_array($debtorKPP) && count($debtorKPP) !== 9)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 9 element(s) or a scalar of 9 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($debtorKPP) && !preg_match('/([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{7}/', $debtorKPP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{7}", "%s" given', var_export($debtorKPP, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($debtorKPP) && !is_string($debtorKPP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($debtorKPP)), __LINE__);
        }
        $this->DebtorKPP = $debtorKPP;
        return $this;
    }
    /**
     * Get DebtorOGRN value
     * @return string|null
     */
    public function getDebtorOGRN()
    {
        return $this->DebtorOGRN;
    }
    /**
     * Set DebtorOGRN value
     * @param string $debtorOGRN
     * @return \AisFssp\StructType\IP
     */
    public function setDebtorOGRN($debtorOGRN = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($debtorOGRN) && strlen($debtorOGRN) > 15) || (is_array($debtorOGRN) && count($debtorOGRN) > 15)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 15 element(s) or a scalar of 15 character(s) at most, "%d" length given', is_scalar($debtorOGRN) ? strlen($debtorOGRN) : count($debtorOGRN)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($debtorOGRN) && strlen($debtorOGRN) < 13) || (is_array($debtorOGRN) && count($debtorOGRN) < 13)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 13 element(s) or a scalar of 13 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($debtorOGRN) && !preg_match('/([0-9]{13})|([0-9]{15})/', $debtorOGRN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0-9]{13})|([0-9]{15})", "%s" given', var_export($debtorOGRN, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($debtorOGRN) && !is_string($debtorOGRN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($debtorOGRN)), __LINE__);
        }
        $this->DebtorOGRN = $debtorOGRN;
        return $this;
    }
    /**
     * Get DebtorBirthDate value
     * @return string|null
     */
    public function getDebtorBirthDate()
    {
        return $this->DebtorBirthDate;
    }
    /**
     * Set DebtorBirthDate value
     * @param string $debtorBirthDate
     * @return \AisFssp\StructType\IP
     */
    public function setDebtorBirthDate($debtorBirthDate = null)
    {
        // validation for constraint: maxExclusive
        if ($debtorBirthDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $debtorBirthDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($debtorBirthDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $debtorBirthDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($debtorBirthDate) && !is_string($debtorBirthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($debtorBirthDate)), __LINE__);
        }
        $this->DebtorBirthDate = $debtorBirthDate;
        return $this;
    }
    /**
     * Get DebtorBirthYear value
     * @return string|null
     */
    public function getDebtorBirthYear()
    {
        return $this->DebtorBirthYear;
    }
    /**
     * Set DebtorBirthYear value
     * @param string $debtorBirthYear
     * @return \AisFssp\StructType\IP
     */
    public function setDebtorBirthYear($debtorBirthYear = null)
    {
        // validation for constraint: maxInclusive
        if ($debtorBirthYear > 2099) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 2099, "%s" given', $debtorBirthYear), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($debtorBirthYear < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $debtorBirthYear), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($debtorBirthYear) && !is_string($debtorBirthYear)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($debtorBirthYear)), __LINE__);
        }
        $this->DebtorBirthYear = $debtorBirthYear;
        return $this;
    }
    /**
     * Get DebtorGender value
     * @return string|null
     */
    public function getDebtorGender()
    {
        return $this->DebtorGender;
    }
    /**
     * Set DebtorGender value
     * @uses \AisFssp\EnumType\GenderCodeType::valueIsValid()
     * @uses \AisFssp\EnumType\GenderCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $debtorGender
     * @return \AisFssp\StructType\IP
     */
    public function setDebtorGender($debtorGender = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\GenderCodeType::valueIsValid($debtorGender)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $debtorGender, implode(', ', \AisFssp\EnumType\GenderCodeType::getValidValues())), __LINE__);
        }
        $this->DebtorGender = $debtorGender;
        return $this;
    }
    /**
     * Get DebtorBirthPlace value
     * @return string|null
     */
    public function getDebtorBirthPlace()
    {
        return $this->DebtorBirthPlace;
    }
    /**
     * Set DebtorBirthPlace value
     * @param string $debtorBirthPlace
     * @return \AisFssp\StructType\IP
     */
    public function setDebtorBirthPlace($debtorBirthPlace = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($debtorBirthPlace) && strlen($debtorBirthPlace) > 300) || (is_array($debtorBirthPlace) && count($debtorBirthPlace) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($debtorBirthPlace) ? strlen($debtorBirthPlace) : count($debtorBirthPlace)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($debtorBirthPlace) && strlen($debtorBirthPlace) < 1) || (is_array($debtorBirthPlace) && count($debtorBirthPlace) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($debtorBirthPlace) && !is_string($debtorBirthPlace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($debtorBirthPlace)), __LINE__);
        }
        $this->DebtorBirthPlace = $debtorBirthPlace;
        return $this;
    }
    /**
     * Get DebtorSnils value
     * @return string|null
     */
    public function getDebtorSnils()
    {
        return $this->DebtorSnils;
    }
    /**
     * Set DebtorSnils value
     * @param string $debtorSnils
     * @return \AisFssp\StructType\IP
     */
    public function setDebtorSnils($debtorSnils = null)
    {
        // validation for constraint: length
        if ((is_scalar($debtorSnils) && strlen($debtorSnils) !== 11) || (is_array($debtorSnils) && count($debtorSnils) !== 11)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 11 element(s) or a scalar of 11 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($debtorSnils) && !preg_match('/[0-9]{11}/', $debtorSnils)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{11}", "%s" given', var_export($debtorSnils, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($debtorSnils) && !is_string($debtorSnils)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($debtorSnils)), __LINE__);
        }
        $this->DebtorSnils = $debtorSnils;
        return $this;
    }
    /**
     * Get OSPCode value
     * @return string|null
     */
    public function getOSPCode()
    {
        return $this->OSPCode;
    }
    /**
     * Set OSPCode value
     * @param string $oSPCode
     * @return \AisFssp\StructType\IP
     */
    public function setOSPCode($oSPCode = null)
    {
        // validation for constraint: length
        if ((is_scalar($oSPCode) && strlen($oSPCode) !== 5) || (is_array($oSPCode) && count($oSPCode) !== 5)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 5 element(s) or a scalar of 5 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($oSPCode) && !preg_match('/[0-9]{5}/', $oSPCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{5}", "%s" given', var_export($oSPCode, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($oSPCode) && !is_string($oSPCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oSPCode)), __LINE__);
        }
        $this->OSPCode = $oSPCode;
        return $this;
    }
    /**
     * Get OSPName value
     * @return string|null
     */
    public function getOSPName()
    {
        return $this->OSPName;
    }
    /**
     * Set OSPName value
     * @param string $oSPName
     * @return \AisFssp\StructType\IP
     */
    public function setOSPName($oSPName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($oSPName) && strlen($oSPName) > 100) || (is_array($oSPName) && count($oSPName) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($oSPName) ? strlen($oSPName) : count($oSPName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($oSPName) && strlen($oSPName) < 1) || (is_array($oSPName) && count($oSPName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($oSPName) && !is_string($oSPName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oSPName)), __LINE__);
        }
        $this->OSPName = $oSPName;
        return $this;
    }
    /**
     * Get SPI value
     * @return int|null
     */
    public function getSPI()
    {
        return $this->SPI;
    }
    /**
     * Set SPI value
     * @param int $sPI
     * @return \AisFssp\StructType\IP
     */
    public function setSPI($sPI = null)
    {
        // validation for constraint: maxInclusive
        if ($sPI > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $sPI), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($sPI < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $sPI), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($sPI) && !is_numeric($sPI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sPI)), __LINE__);
        }
        $this->SPI = $sPI;
        return $this;
    }
    /**
     * Get SPIFio value
     * @return string|null
     */
    public function getSPIFio()
    {
        return $this->SPIFio;
    }
    /**
     * Set SPIFio value
     * @param string $sPIFio
     * @return \AisFssp\StructType\IP
     */
    public function setSPIFio($sPIFio = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($sPIFio) && strlen($sPIFio) > 100) || (is_array($sPIFio) && count($sPIFio) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($sPIFio) ? strlen($sPIFio) : count($sPIFio)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($sPIFio) && strlen($sPIFio) < 1) || (is_array($sPIFio) && count($sPIFio) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sPIFio) && !is_string($sPIFio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sPIFio)), __LINE__);
        }
        $this->SPIFio = $sPIFio;
        return $this;
    }
    /**
     * Get OldIPNumber value
     * @return string[]|null
     */
    public function getOldIPNumber()
    {
        return $this->OldIPNumber;
    }
    /**
     * Set OldIPNumber value
     * @throws \InvalidArgumentException
     * @param string[] $oldIPNumber
     * @return \AisFssp\StructType\IP
     */
    public function setOldIPNumber(array $oldIPNumber = array())
    {
        // validation for constraint: maxLength
        if ((is_scalar($oldIPNumber) && strlen($oldIPNumber) > 25) || (is_array($oldIPNumber) && count($oldIPNumber) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($oldIPNumber) ? strlen($oldIPNumber) : count($oldIPNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($oldIPNumber) && strlen($oldIPNumber) < 1) || (is_array($oldIPNumber) && count($oldIPNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        foreach ($oldIPNumber as $iPOldIPNumberItem) {
            // validation for constraint: itemType
            if (!is_string($iPOldIPNumberItem)) {
                throw new \InvalidArgumentException(sprintf('The OldIPNumber property can only contain items of string, "%s" given', is_object($iPOldIPNumberItem) ? get_class($iPOldIPNumberItem) : gettype($iPOldIPNumberItem)), __LINE__);
            }
        }
        $this->OldIPNumber = $oldIPNumber;
        return $this;
    }
    /**
     * Add item to OldIPNumber value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \AisFssp\StructType\IP
     */
    public function addToOldIPNumber($item)
    {
        // validation for constraint: maxLength
        if ((is_scalar($item) && strlen($item) > 25) || (is_array($item) && count($item) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($item) ? strlen($item) : count($item)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($item) && strlen($item) < 1) || (is_array($item) && count($item) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The OldIPNumber property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OldIPNumber[] = $item;
        return $this;
    }
    /**
     * Get ChargeOffQueue value
     * @return string|null
     */
    public function getChargeOffQueue()
    {
        return $this->ChargeOffQueue;
    }
    /**
     * Set ChargeOffQueue value
     * @uses \AisFssp\EnumType\ChargeOffQueueType::valueIsValid()
     * @uses \AisFssp\EnumType\ChargeOffQueueType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $chargeOffQueue
     * @return \AisFssp\StructType\IP
     */
    public function setChargeOffQueue($chargeOffQueue = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\ChargeOffQueueType::valueIsValid($chargeOffQueue)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $chargeOffQueue, implode(', ', \AisFssp\EnumType\ChargeOffQueueType::getValidValues())), __LINE__);
        }
        $this->ChargeOffQueue = $chargeOffQueue;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\IP
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
