<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FounderCompanyDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения об учредителе — юридическом лице
 * @subpackage Structs
 */
class FounderCompanyDatumType extends CompanyDatumType
{
    /**
     * The capitalAmount
     * Meta informations extracted from the WSDL
     * - documentation: Размер вклада в уставной капитал учредителя (в рублях) | Сумма
     * - minOccurs: 0
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $capitalAmount;
    /**
     * Constructor method for FounderCompanyDatumType
     * @uses FounderCompanyDatumType::setCapitalAmount()
     * @param float $capitalAmount
     */
    public function __construct($capitalAmount = null)
    {
        $this
            ->setCapitalAmount($capitalAmount);
    }
    /**
     * Get capitalAmount value
     * @return float|null
     */
    public function getCapitalAmount()
    {
        return $this->capitalAmount;
    }
    /**
     * Set capitalAmount value
     * @param float $capitalAmount
     * @return \AisFssp\StructType\FounderCompanyDatumType
     */
    public function setCapitalAmount($capitalAmount = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($capitalAmount) && strlen(substr($capitalAmount, strpos($capitalAmount, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($capitalAmount, strpos($capitalAmount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($capitalAmount) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $capitalAmount)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($capitalAmount, strpos($capitalAmount, '.')))), __LINE__);
        }
        $this->capitalAmount = $capitalAmount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\FounderCompanyDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
