<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FishQuotaContractDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения о наличии договора на закрепление долей квот добычи (вылова) биоресурсов
 * @subpackage Structs
 */
class FishQuotaContractDatumType extends FishDatumType
{
    /**
     * The quotaCode
     * Meta informations extracted from the WSDL
     * - documentation: Код вида квоты | Строка длиной от 1 до 10 символов
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $quotaCode;
    /**
     * The quotaName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование вида квоты | Строка длиной от 1 до 100 символов
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $quotaName;
    /**
     * The part
     * Meta informations extracted from the WSDL
     * - documentation: Процент доли | Количество
     * - minOccurs: 0
     * - fractionDigits: 3
     * - totalDigits: 15
     * @var float
     */
    public $part;
    /**
     * The startDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата начала договора | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $startDate;
    /**
     * The finishDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата окончания договора | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $finishDate;
    /**
     * The chDocCode
     * Meta informations extracted from the WSDL
     * - documentation: Код документа изменения | Строка длиной от 1 до 10 символов
     * - minOccurs: 0
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $chDocCode;
    /**
     * The chDocType
     * Meta informations extracted from the WSDL
     * - documentation: Наименование документа изменения | Строка длиной от 1 до 100 символов
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $chDocType;
    /**
     * The chDocDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата документа изменения | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $chDocDate;
    /**
     * The chDocNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер документа изменения | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $chDocNumber;
    /**
     * The chDocGround
     * Meta informations extracted from the WSDL
     * - documentation: Основание документа изменения | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $chDocGround;
    /**
     * Constructor method for FishQuotaContractDatumType
     * @uses FishQuotaContractDatumType::setQuotaCode()
     * @uses FishQuotaContractDatumType::setQuotaName()
     * @uses FishQuotaContractDatumType::setPart()
     * @uses FishQuotaContractDatumType::setStartDate()
     * @uses FishQuotaContractDatumType::setFinishDate()
     * @uses FishQuotaContractDatumType::setChDocCode()
     * @uses FishQuotaContractDatumType::setChDocType()
     * @uses FishQuotaContractDatumType::setChDocDate()
     * @uses FishQuotaContractDatumType::setChDocNumber()
     * @uses FishQuotaContractDatumType::setChDocGround()
     * @param string $quotaCode
     * @param string $quotaName
     * @param float $part
     * @param string $startDate
     * @param string $finishDate
     * @param string $chDocCode
     * @param string $chDocType
     * @param string $chDocDate
     * @param string $chDocNumber
     * @param string $chDocGround
     */
    public function __construct($quotaCode = null, $quotaName = null, $part = null, $startDate = null, $finishDate = null, $chDocCode = null, $chDocType = null, $chDocDate = null, $chDocNumber = null, $chDocGround = null)
    {
        $this
            ->setQuotaCode($quotaCode)
            ->setQuotaName($quotaName)
            ->setPart($part)
            ->setStartDate($startDate)
            ->setFinishDate($finishDate)
            ->setChDocCode($chDocCode)
            ->setChDocType($chDocType)
            ->setChDocDate($chDocDate)
            ->setChDocNumber($chDocNumber)
            ->setChDocGround($chDocGround);
    }
    /**
     * Get quotaCode value
     * @return string|null
     */
    public function getQuotaCode()
    {
        return $this->quotaCode;
    }
    /**
     * Set quotaCode value
     * @param string $quotaCode
     * @return \AisFssp\StructType\FishQuotaContractDatumType
     */
    public function setQuotaCode($quotaCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($quotaCode) && strlen($quotaCode) > 10) || (is_array($quotaCode) && count($quotaCode) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($quotaCode) ? strlen($quotaCode) : count($quotaCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($quotaCode) && strlen($quotaCode) < 1) || (is_array($quotaCode) && count($quotaCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($quotaCode) && !is_string($quotaCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($quotaCode)), __LINE__);
        }
        $this->quotaCode = $quotaCode;
        return $this;
    }
    /**
     * Get quotaName value
     * @return string|null
     */
    public function getQuotaName()
    {
        return $this->quotaName;
    }
    /**
     * Set quotaName value
     * @param string $quotaName
     * @return \AisFssp\StructType\FishQuotaContractDatumType
     */
    public function setQuotaName($quotaName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($quotaName) && strlen($quotaName) > 100) || (is_array($quotaName) && count($quotaName) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($quotaName) ? strlen($quotaName) : count($quotaName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($quotaName) && strlen($quotaName) < 1) || (is_array($quotaName) && count($quotaName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($quotaName) && !is_string($quotaName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($quotaName)), __LINE__);
        }
        $this->quotaName = $quotaName;
        return $this;
    }
    /**
     * Get part value
     * @return float|null
     */
    public function getPart()
    {
        return $this->part;
    }
    /**
     * Set part value
     * @param float $part
     * @return \AisFssp\StructType\FishQuotaContractDatumType
     */
    public function setPart($part = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($part) && strlen(substr($part, strpos($part, '.') + 1)) !== 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 3 fraction digits, "%d" given', strlen(substr($part, strpos($part, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($part) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $part)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($part, strpos($part, '.')))), __LINE__);
        }
        $this->part = $part;
        return $this;
    }
    /**
     * Get startDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \AisFssp\StructType\FishQuotaContractDatumType
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: maxExclusive
        if ($startDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $startDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($startDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $startDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get finishDate value
     * @return string|null
     */
    public function getFinishDate()
    {
        return $this->finishDate;
    }
    /**
     * Set finishDate value
     * @param string $finishDate
     * @return \AisFssp\StructType\FishQuotaContractDatumType
     */
    public function setFinishDate($finishDate = null)
    {
        // validation for constraint: maxExclusive
        if ($finishDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $finishDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($finishDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $finishDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($finishDate) && !is_string($finishDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($finishDate)), __LINE__);
        }
        $this->finishDate = $finishDate;
        return $this;
    }
    /**
     * Get chDocCode value
     * @return string|null
     */
    public function getChDocCode()
    {
        return $this->chDocCode;
    }
    /**
     * Set chDocCode value
     * @param string $chDocCode
     * @return \AisFssp\StructType\FishQuotaContractDatumType
     */
    public function setChDocCode($chDocCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($chDocCode) && strlen($chDocCode) > 10) || (is_array($chDocCode) && count($chDocCode) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($chDocCode) ? strlen($chDocCode) : count($chDocCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($chDocCode) && strlen($chDocCode) < 1) || (is_array($chDocCode) && count($chDocCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($chDocCode) && !is_string($chDocCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($chDocCode)), __LINE__);
        }
        $this->chDocCode = $chDocCode;
        return $this;
    }
    /**
     * Get chDocType value
     * @return string|null
     */
    public function getChDocType()
    {
        return $this->chDocType;
    }
    /**
     * Set chDocType value
     * @param string $chDocType
     * @return \AisFssp\StructType\FishQuotaContractDatumType
     */
    public function setChDocType($chDocType = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($chDocType) && strlen($chDocType) > 100) || (is_array($chDocType) && count($chDocType) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($chDocType) ? strlen($chDocType) : count($chDocType)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($chDocType) && strlen($chDocType) < 1) || (is_array($chDocType) && count($chDocType) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($chDocType) && !is_string($chDocType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($chDocType)), __LINE__);
        }
        $this->chDocType = $chDocType;
        return $this;
    }
    /**
     * Get chDocDate value
     * @return string|null
     */
    public function getChDocDate()
    {
        return $this->chDocDate;
    }
    /**
     * Set chDocDate value
     * @param string $chDocDate
     * @return \AisFssp\StructType\FishQuotaContractDatumType
     */
    public function setChDocDate($chDocDate = null)
    {
        // validation for constraint: maxExclusive
        if ($chDocDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $chDocDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($chDocDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $chDocDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($chDocDate) && !is_string($chDocDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($chDocDate)), __LINE__);
        }
        $this->chDocDate = $chDocDate;
        return $this;
    }
    /**
     * Get chDocNumber value
     * @return string|null
     */
    public function getChDocNumber()
    {
        return $this->chDocNumber;
    }
    /**
     * Set chDocNumber value
     * @param string $chDocNumber
     * @return \AisFssp\StructType\FishQuotaContractDatumType
     */
    public function setChDocNumber($chDocNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($chDocNumber) && strlen($chDocNumber) > 25) || (is_array($chDocNumber) && count($chDocNumber) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($chDocNumber) ? strlen($chDocNumber) : count($chDocNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($chDocNumber) && strlen($chDocNumber) < 1) || (is_array($chDocNumber) && count($chDocNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($chDocNumber) && !is_string($chDocNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($chDocNumber)), __LINE__);
        }
        $this->chDocNumber = $chDocNumber;
        return $this;
    }
    /**
     * Get chDocGround value
     * @return string|null
     */
    public function getChDocGround()
    {
        return $this->chDocGround;
    }
    /**
     * Set chDocGround value
     * @param string $chDocGround
     * @return \AisFssp\StructType\FishQuotaContractDatumType
     */
    public function setChDocGround($chDocGround = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($chDocGround) && strlen($chDocGround) > 300) || (is_array($chDocGround) && count($chDocGround) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($chDocGround) ? strlen($chDocGround) : count($chDocGround)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($chDocGround) && strlen($chDocGround) < 1) || (is_array($chDocGround) && count($chDocGround) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($chDocGround) && !is_string($chDocGround)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($chDocGround)), __LINE__);
        }
        $this->chDocGround = $chDocGround;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\FishQuotaContractDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
