<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FioType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Фамилия, имя, отчество
 * @subpackage Structs
 */
class FioType extends AbstractStructBase
{
    /**
     * The Surname
     * Meta informations extracted from the WSDL
     * - documentation: Фамилия | Строка длиной от 1 до 60 символов
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Surname;
    /**
     * The FirstName
     * Meta informations extracted from the WSDL
     * - documentation: Имя | Строка длиной от 1 до 60 символов
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $FirstName;
    /**
     * The Patronymic
     * Meta informations extracted from the WSDL
     * - documentation: Отчество | Строка длиной от 1 до 60 символов
     * - minOccurs: 0
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Patronymic;
    /**
     * Constructor method for FioType
     * @uses FioType::setSurname()
     * @uses FioType::setFirstName()
     * @uses FioType::setPatronymic()
     * @param string $surname
     * @param string $firstName
     * @param string $patronymic
     */
    public function __construct($surname = null, $firstName = null, $patronymic = null)
    {
        $this
            ->setSurname($surname)
            ->setFirstName($firstName)
            ->setPatronymic($patronymic);
    }
    /**
     * Get Surname value
     * @return string|null
     */
    public function getSurname()
    {
        return $this->Surname;
    }
    /**
     * Set Surname value
     * @param string $surname
     * @return \AisFssp\StructType\FioType
     */
    public function setSurname($surname = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($surname) && strlen($surname) > 60) || (is_array($surname) && count($surname) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($surname) ? strlen($surname) : count($surname)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($surname) && strlen($surname) < 1) || (is_array($surname) && count($surname) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($surname) && !is_string($surname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($surname)), __LINE__);
        }
        $this->Surname = $surname;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \AisFssp\StructType\FioType
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($firstName) && strlen($firstName) > 60) || (is_array($firstName) && count($firstName) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($firstName) ? strlen($firstName) : count($firstName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($firstName) && strlen($firstName) < 1) || (is_array($firstName) && count($firstName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get Patronymic value
     * @return string|null
     */
    public function getPatronymic()
    {
        return $this->Patronymic;
    }
    /**
     * Set Patronymic value
     * @param string $patronymic
     * @return \AisFssp\StructType\FioType
     */
    public function setPatronymic($patronymic = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($patronymic) && strlen($patronymic) > 60) || (is_array($patronymic) && count($patronymic) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($patronymic) ? strlen($patronymic) : count($patronymic)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($patronymic) && strlen($patronymic) < 1) || (is_array($patronymic) && count($patronymic) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($patronymic) && !is_string($patronymic)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($patronymic)), __LINE__);
        }
        $this->Patronymic = $patronymic;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\FioType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
