<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EQNotifyAppointment StructType
 * Meta informations extracted from the WSDL
 * - documentation: Документ для изменения статуса заявки записи на приём
 * - type: tns:EQNotifyAppointment
 * @subpackage Structs
 */
class EQNotifyAppointment extends AbstractStructBase
{
    /**
     * The ExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор АИС ВК | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный
     * идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $ExternalKey;
    /**
     * The AppId
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор заявки | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении
     * объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $AppId;
    /**
     * The AppAction
     * Meta informations extracted from the WSDL
     * - documentation: Действие над заявкой
     * @var string
     */
    public $AppAction;
    /**
     * Constructor method for EQNotifyAppointment
     * @uses EQNotifyAppointment::setExternalKey()
     * @uses EQNotifyAppointment::setAppId()
     * @uses EQNotifyAppointment::setAppAction()
     * @param string $externalKey
     * @param int $appId
     * @param string $appAction
     */
    public function __construct($externalKey = null, $appId = null, $appAction = null)
    {
        $this
            ->setExternalKey($externalKey)
            ->setAppId($appId)
            ->setAppAction($appAction);
    }
    /**
     * Get ExternalKey value
     * @return string|null
     */
    public function getExternalKey()
    {
        return $this->ExternalKey;
    }
    /**
     * Set ExternalKey value
     * @param string $externalKey
     * @return \AisFssp\StructType\EQNotifyAppointment
     */
    public function setExternalKey($externalKey = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($externalKey) && strlen($externalKey) > 60) || (is_array($externalKey) && count($externalKey) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($externalKey) ? strlen($externalKey) : count($externalKey)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($externalKey) && strlen($externalKey) < 1) || (is_array($externalKey) && count($externalKey) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($externalKey) && !is_string($externalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externalKey)), __LINE__);
        }
        $this->ExternalKey = $externalKey;
        return $this;
    }
    /**
     * Get AppId value
     * @return int|null
     */
    public function getAppId()
    {
        return $this->AppId;
    }
    /**
     * Set AppId value
     * @param int $appId
     * @return \AisFssp\StructType\EQNotifyAppointment
     */
    public function setAppId($appId = null)
    {
        // validation for constraint: maxInclusive
        if ($appId > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $appId), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($appId < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $appId), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($appId) && !is_numeric($appId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($appId)), __LINE__);
        }
        $this->AppId = $appId;
        return $this;
    }
    /**
     * Get AppAction value
     * @return string|null
     */
    public function getAppAction()
    {
        return $this->AppAction;
    }
    /**
     * Set AppAction value
     * @uses \AisFssp\EnumType\EQAppointmentActionType::valueIsValid()
     * @uses \AisFssp\EnumType\EQAppointmentActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $appAction
     * @return \AisFssp\StructType\EQNotifyAppointment
     */
    public function setAppAction($appAction = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\EQAppointmentActionType::valueIsValid($appAction)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $appAction, implode(', ', \AisFssp\EnumType\EQAppointmentActionType::getValidValues())), __LINE__);
        }
        $this->AppAction = $appAction;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\EQNotifyAppointment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
