<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EQApplicant StructType
 * Meta informations extracted from the WSDL
 * - documentation: Заявитель на личный приём
 * @subpackage Structs
 */
class EQApplicant extends AbstractStructBase
{
    /**
     * The Surname
     * Meta informations extracted from the WSDL
     * - documentation: Фамилия | Строка длиной от 1 до 60 символов
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Surname;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - documentation: Имя | Строка длиной от 1 до 60 символов
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Name;
    /**
     * The Patronymic
     * Meta informations extracted from the WSDL
     * - documentation: Отчество | Строка длиной от 1 до 60 символов
     * - minOccurs: 0
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Patronymic;
    /**
     * The BirthDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата рождения | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $BirthDate;
    /**
     * The Snils
     * Meta informations extracted from the WSDL
     * - documentation: СНИЛС | СНИЛС
     * - length: 11
     * - pattern: [0-9]{11}
     * @var string
     */
    public $Snils;
    /**
     * The Phone
     * Meta informations extracted from the WSDL
     * - documentation: Телефон | Номер телефона
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $Phone;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - documentation: Адрес электронной почты | Адрес электронной почты
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $Email;
    /**
     * The AddressReg
     * Meta informations extracted from the WSDL
     * - documentation: Адрес места регистрации | Строка длиной от 1 до 300 символов
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $AddressReg;
    /**
     * The AddressFact
     * Meta informations extracted from the WSDL
     * - documentation: Адрес фактического проживания | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $AddressFact;
    /**
     * Constructor method for EQApplicant
     * @uses EQApplicant::setSurname()
     * @uses EQApplicant::setName()
     * @uses EQApplicant::setPatronymic()
     * @uses EQApplicant::setBirthDate()
     * @uses EQApplicant::setSnils()
     * @uses EQApplicant::setPhone()
     * @uses EQApplicant::setEmail()
     * @uses EQApplicant::setAddressReg()
     * @uses EQApplicant::setAddressFact()
     * @param string $surname
     * @param string $name
     * @param string $patronymic
     * @param string $birthDate
     * @param string $snils
     * @param string $phone
     * @param string $email
     * @param string $addressReg
     * @param string $addressFact
     */
    public function __construct($surname = null, $name = null, $patronymic = null, $birthDate = null, $snils = null, $phone = null, $email = null, $addressReg = null, $addressFact = null)
    {
        $this
            ->setSurname($surname)
            ->setName($name)
            ->setPatronymic($patronymic)
            ->setBirthDate($birthDate)
            ->setSnils($snils)
            ->setPhone($phone)
            ->setEmail($email)
            ->setAddressReg($addressReg)
            ->setAddressFact($addressFact);
    }
    /**
     * Get Surname value
     * @return string|null
     */
    public function getSurname()
    {
        return $this->Surname;
    }
    /**
     * Set Surname value
     * @param string $surname
     * @return \AisFssp\StructType\EQApplicant
     */
    public function setSurname($surname = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($surname) && strlen($surname) > 60) || (is_array($surname) && count($surname) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($surname) ? strlen($surname) : count($surname)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($surname) && strlen($surname) < 1) || (is_array($surname) && count($surname) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($surname) && !is_string($surname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($surname)), __LINE__);
        }
        $this->Surname = $surname;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \AisFssp\StructType\EQApplicant
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 60) || (is_array($name) && count($name) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($name) && strlen($name) < 1) || (is_array($name) && count($name) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Patronymic value
     * @return string|null
     */
    public function getPatronymic()
    {
        return $this->Patronymic;
    }
    /**
     * Set Patronymic value
     * @param string $patronymic
     * @return \AisFssp\StructType\EQApplicant
     */
    public function setPatronymic($patronymic = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($patronymic) && strlen($patronymic) > 60) || (is_array($patronymic) && count($patronymic) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($patronymic) ? strlen($patronymic) : count($patronymic)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($patronymic) && strlen($patronymic) < 1) || (is_array($patronymic) && count($patronymic) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($patronymic) && !is_string($patronymic)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($patronymic)), __LINE__);
        }
        $this->Patronymic = $patronymic;
        return $this;
    }
    /**
     * Get BirthDate value
     * @return string|null
     */
    public function getBirthDate()
    {
        return $this->BirthDate;
    }
    /**
     * Set BirthDate value
     * @param string $birthDate
     * @return \AisFssp\StructType\EQApplicant
     */
    public function setBirthDate($birthDate = null)
    {
        // validation for constraint: maxExclusive
        if ($birthDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $birthDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($birthDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $birthDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($birthDate) && !is_string($birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($birthDate)), __LINE__);
        }
        $this->BirthDate = $birthDate;
        return $this;
    }
    /**
     * Get Snils value
     * @return string|null
     */
    public function getSnils()
    {
        return $this->Snils;
    }
    /**
     * Set Snils value
     * @param string $snils
     * @return \AisFssp\StructType\EQApplicant
     */
    public function setSnils($snils = null)
    {
        // validation for constraint: length
        if ((is_scalar($snils) && strlen($snils) !== 11) || (is_array($snils) && count($snils) !== 11)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 11 element(s) or a scalar of 11 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($snils) && !preg_match('/[0-9]{11}/', $snils)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{11}", "%s" given', var_export($snils, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($snils) && !is_string($snils)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($snils)), __LINE__);
        }
        $this->Snils = $snils;
        return $this;
    }
    /**
     * Get Phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->Phone;
    }
    /**
     * Set Phone value
     * @param string $phone
     * @return \AisFssp\StructType\EQApplicant
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($phone) && strlen($phone) > 25) || (is_array($phone) && count($phone) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($phone) ? strlen($phone) : count($phone)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($phone) && strlen($phone) < 1) || (is_array($phone) && count($phone) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phone)), __LINE__);
        }
        $this->Phone = $phone;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \AisFssp\StructType\EQApplicant
     */
    public function setEmail($email = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($email) && strlen($email) > 100) || (is_array($email) && count($email) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($email) ? strlen($email) : count($email)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($email) && strlen($email) < 1) || (is_array($email) && count($email) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get AddressReg value
     * @return string|null
     */
    public function getAddressReg()
    {
        return $this->AddressReg;
    }
    /**
     * Set AddressReg value
     * @param string $addressReg
     * @return \AisFssp\StructType\EQApplicant
     */
    public function setAddressReg($addressReg = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($addressReg) && strlen($addressReg) > 300) || (is_array($addressReg) && count($addressReg) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($addressReg) ? strlen($addressReg) : count($addressReg)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($addressReg) && strlen($addressReg) < 1) || (is_array($addressReg) && count($addressReg) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($addressReg) && !is_string($addressReg)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressReg)), __LINE__);
        }
        $this->AddressReg = $addressReg;
        return $this;
    }
    /**
     * Get AddressFact value
     * @return string|null
     */
    public function getAddressFact()
    {
        return $this->AddressFact;
    }
    /**
     * Set AddressFact value
     * @param string $addressFact
     * @return \AisFssp\StructType\EQApplicant
     */
    public function setAddressFact($addressFact = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($addressFact) && strlen($addressFact) > 300) || (is_array($addressFact) && count($addressFact) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($addressFact) ? strlen($addressFact) : count($addressFact)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($addressFact) && strlen($addressFact) < 1) || (is_array($addressFact) && count($addressFact) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($addressFact) && !is_string($addressFact)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressFact)), __LINE__);
        }
        $this->AddressFact = $addressFact;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\EQApplicant
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
