<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DxMessageType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сообщение
 * @subpackage Structs
 */
class DxMessageType extends ObjectType
{
    /**
     * The MessageType
     * Meta informations extracted from the WSDL
     * - documentation: Код сообщения
     * - minOccurs: 1
     * @var string
     */
    public $MessageType;
    /**
     * The DocDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата
     * - minOccurs: 0
     * @var string
     */
    public $DocDate;
    /**
     * The DocNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер
     * - minOccurs: 0
     * - maxLength: 40
     * @var string
     */
    public $DocNumber;
    /**
     * The Text
     * Meta informations extracted from the WSDL
     * - documentation: Текст сообщения
     * - minOccurs: 0
     * - maxLength: 1000
     * @var string
     */
    public $Text;
    /**
     * The SenderDocId
     * Meta informations extracted from the WSDL
     * - documentation: Ключ документа отправителя
     * - minOccurs: 0
     * - maxLength: 60
     * @var string
     */
    public $SenderDocId;
    /**
     * The ReceiverDocId
     * Meta informations extracted from the WSDL
     * - documentation: Ключ документа получателя
     * - minOccurs: 0
     * - maxLength: 60
     * @var string
     */
    public $ReceiverDocId;
    /**
     * The PackId
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор пакета
     * - minOccurs: 0
     * - fractionDigits: 0
     * @var float
     */
    public $PackId;
    /**
     * The Caption
     * Meta informations extracted from the WSDL
     * - documentation: Заголовок
     * - minOccurs: 0
     * - maxLength: 80
     * @var string
     */
    public $Caption;
    /**
     * The ErrorCode
     * Meta informations extracted from the WSDL
     * - documentation: Код ошибки
     * - minOccurs: 0
     * - maxInclusive: 2147483647
     * - minInclusive: -2147483648
     * @var int
     */
    public $ErrorCode;
    /**
     * Constructor method for DxMessageType
     * @uses DxMessageType::setMessageType()
     * @uses DxMessageType::setDocDate()
     * @uses DxMessageType::setDocNumber()
     * @uses DxMessageType::setText()
     * @uses DxMessageType::setSenderDocId()
     * @uses DxMessageType::setReceiverDocId()
     * @uses DxMessageType::setPackId()
     * @uses DxMessageType::setCaption()
     * @uses DxMessageType::setErrorCode()
     * @param string $messageType
     * @param string $docDate
     * @param string $docNumber
     * @param string $text
     * @param string $senderDocId
     * @param string $receiverDocId
     * @param float $packId
     * @param string $caption
     * @param int $errorCode
     */
    public function __construct($messageType = null, $docDate = null, $docNumber = null, $text = null, $senderDocId = null, $receiverDocId = null, $packId = null, $caption = null, $errorCode = null)
    {
        $this
            ->setMessageType($messageType)
            ->setDocDate($docDate)
            ->setDocNumber($docNumber)
            ->setText($text)
            ->setSenderDocId($senderDocId)
            ->setReceiverDocId($receiverDocId)
            ->setPackId($packId)
            ->setCaption($caption)
            ->setErrorCode($errorCode);
    }
    /**
     * Get MessageType value
     * @return string
     */
    public function getMessageType()
    {
        return $this->MessageType;
    }
    /**
     * Set MessageType value
     * @uses \AisFssp\EnumType\DDxMessageTypeType::valueIsValid()
     * @uses \AisFssp\EnumType\DDxMessageTypeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $messageType
     * @return \AisFssp\StructType\DxMessageType
     */
    public function setMessageType($messageType = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\DDxMessageTypeType::valueIsValid($messageType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $messageType, implode(', ', \AisFssp\EnumType\DDxMessageTypeType::getValidValues())), __LINE__);
        }
        $this->MessageType = $messageType;
        return $this;
    }
    /**
     * Get DocDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->DocDate;
    }
    /**
     * Set DocDate value
     * @param string $docDate
     * @return \AisFssp\StructType\DxMessageType
     */
    public function setDocDate($docDate = null)
    {
        // validation for constraint: string
        if (!is_null($docDate) && !is_string($docDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docDate)), __LINE__);
        }
        $this->DocDate = $docDate;
        return $this;
    }
    /**
     * Get DocNumber value
     * @return string|null
     */
    public function getDocNumber()
    {
        return $this->DocNumber;
    }
    /**
     * Set DocNumber value
     * @param string $docNumber
     * @return \AisFssp\StructType\DxMessageType
     */
    public function setDocNumber($docNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($docNumber) && strlen($docNumber) > 40) || (is_array($docNumber) && count($docNumber) > 40)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 40 element(s) or a scalar of 40 character(s) at most, "%d" length given', is_scalar($docNumber) ? strlen($docNumber) : count($docNumber)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docNumber) && !is_string($docNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docNumber)), __LINE__);
        }
        $this->DocNumber = $docNumber;
        return $this;
    }
    /**
     * Get Text value
     * @return string|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param string $text
     * @return \AisFssp\StructType\DxMessageType
     */
    public function setText($text = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($text) && strlen($text) > 1000) || (is_array($text) && count($text) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($text) ? strlen($text) : count($text)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($text)), __LINE__);
        }
        $this->Text = $text;
        return $this;
    }
    /**
     * Get SenderDocId value
     * @return string|null
     */
    public function getSenderDocId()
    {
        return $this->SenderDocId;
    }
    /**
     * Set SenderDocId value
     * @param string $senderDocId
     * @return \AisFssp\StructType\DxMessageType
     */
    public function setSenderDocId($senderDocId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($senderDocId) && strlen($senderDocId) > 60) || (is_array($senderDocId) && count($senderDocId) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($senderDocId) ? strlen($senderDocId) : count($senderDocId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($senderDocId) && !is_string($senderDocId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($senderDocId)), __LINE__);
        }
        $this->SenderDocId = $senderDocId;
        return $this;
    }
    /**
     * Get ReceiverDocId value
     * @return string|null
     */
    public function getReceiverDocId()
    {
        return $this->ReceiverDocId;
    }
    /**
     * Set ReceiverDocId value
     * @param string $receiverDocId
     * @return \AisFssp\StructType\DxMessageType
     */
    public function setReceiverDocId($receiverDocId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($receiverDocId) && strlen($receiverDocId) > 60) || (is_array($receiverDocId) && count($receiverDocId) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($receiverDocId) ? strlen($receiverDocId) : count($receiverDocId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($receiverDocId) && !is_string($receiverDocId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($receiverDocId)), __LINE__);
        }
        $this->ReceiverDocId = $receiverDocId;
        return $this;
    }
    /**
     * Get PackId value
     * @return float|null
     */
    public function getPackId()
    {
        return $this->PackId;
    }
    /**
     * Set PackId value
     * @param float $packId
     * @return \AisFssp\StructType\DxMessageType
     */
    public function setPackId($packId = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($packId) && strlen(substr($packId, strpos($packId, '.') + 1)) !== 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 0 fraction digits, "%d" given', strlen(substr($packId, strpos($packId, '.') + 1))), __LINE__);
        }
        $this->PackId = $packId;
        return $this;
    }
    /**
     * Get Caption value
     * @return string|null
     */
    public function getCaption()
    {
        return $this->Caption;
    }
    /**
     * Set Caption value
     * @param string $caption
     * @return \AisFssp\StructType\DxMessageType
     */
    public function setCaption($caption = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($caption) && strlen($caption) > 80) || (is_array($caption) && count($caption) > 80)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 80 element(s) or a scalar of 80 character(s) at most, "%d" length given', is_scalar($caption) ? strlen($caption) : count($caption)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($caption) && !is_string($caption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($caption)), __LINE__);
        }
        $this->Caption = $caption;
        return $this;
    }
    /**
     * Get ErrorCode value
     * @return int|null
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param int $errorCode
     * @return \AisFssp\StructType\DxMessageType
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: maxInclusive
        if ($errorCode > 2147483647) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 2147483647, "%s" given', $errorCode), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($errorCode < -2147483648) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -2147483648, "%s" given', $errorCode), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($errorCode) && !is_numeric($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\DxMessageType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
