<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Direction StructType
 * Meta informations extracted from the WSDL
 * - documentation: Направление передачи данных
 * @subpackage Structs
 */
class Direction extends AbstractStructBase
{
    /**
     * The Sender
     * Meta informations extracted from the WSDL
     * - documentation: Отправитель
     * @var \AisFssp\StructType\RedAddress
     */
    public $Sender;
    /**
     * The Recipient
     * Meta informations extracted from the WSDL
     * - documentation: Получатель
     * @var \AisFssp\StructType\RedAddress
     */
    public $Recipient;
    /**
     * The Protocol
     * Meta informations extracted from the WSDL
     * - documentation: Протокол | Код протокола
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $Protocol;
    /**
     * Constructor method for Direction
     * @uses Direction::setSender()
     * @uses Direction::setRecipient()
     * @uses Direction::setProtocol()
     * @param \AisFssp\StructType\RedAddress $sender
     * @param \AisFssp\StructType\RedAddress $recipient
     * @param string $protocol
     */
    public function __construct(\AisFssp\StructType\RedAddress $sender = null, \AisFssp\StructType\RedAddress $recipient = null, $protocol = null)
    {
        $this
            ->setSender($sender)
            ->setRecipient($recipient)
            ->setProtocol($protocol);
    }
    /**
     * Get Sender value
     * @return \AisFssp\StructType\RedAddress|null
     */
    public function getSender()
    {
        return $this->Sender;
    }
    /**
     * Set Sender value
     * @param \AisFssp\StructType\RedAddress $sender
     * @return \AisFssp\StructType\Direction
     */
    public function setSender(\AisFssp\StructType\RedAddress $sender = null)
    {
        $this->Sender = $sender;
        return $this;
    }
    /**
     * Get Recipient value
     * @return \AisFssp\StructType\RedAddress|null
     */
    public function getRecipient()
    {
        return $this->Recipient;
    }
    /**
     * Set Recipient value
     * @param \AisFssp\StructType\RedAddress $recipient
     * @return \AisFssp\StructType\Direction
     */
    public function setRecipient(\AisFssp\StructType\RedAddress $recipient = null)
    {
        $this->Recipient = $recipient;
        return $this;
    }
    /**
     * Get Protocol value
     * @return string|null
     */
    public function getProtocol()
    {
        return $this->Protocol;
    }
    /**
     * Set Protocol value
     * @param string $protocol
     * @return \AisFssp\StructType\Direction
     */
    public function setProtocol($protocol = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($protocol) && strlen($protocol) > 20) || (is_array($protocol) && count($protocol) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($protocol) ? strlen($protocol) : count($protocol)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($protocol) && strlen($protocol) < 1) || (is_array($protocol) && count($protocol) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($protocol) && !is_string($protocol)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($protocol)), __LINE__);
        }
        $this->Protocol = $protocol;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\Direction
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
