<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DebtorNewAccountNotice StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения об открытии должниками по ИП новых счетов в кредитных организациях | ЭП
 * - type: tns:DebtorNewAccountNotice
 * @subpackage Structs
 */
class DebtorNewAccountNotice extends AbstractStructBase
{
    /**
     * The ExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор АИС ВК | Идентификатор документа, присвоенный АИС внешнего контрагента | Идентификатор объекта, присвоенный
     * объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный идентификатор должен быть уникальным для типа идентифицируемого документа
     * в пространстве обмена данными с конкретным внешним контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $ExternalKey;
    /**
     * The RestrictnInternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ постановления ФССП России | Уникальный идентификатор Постановления об ограничении, присвоенный АИС ФССП России и
     * переданный ранее внешнему контрагенту в составе документа «Постановление об ограничении» | Ключ объекта, присвоенний информационной
     * системой ФССП РФ при создании объекта или при получении объекта от контрагента
     * - minOccurs: 0
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $RestrictnInternalKey;
    /**
     * The IpInternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ИП ФССП России | Уникальный идентификатор исполнительного производства, присвоенный АИС ФССП Росии и переданный ранее
     * внешнему контрагенту в составе документа «Постановление об ограничении» | Ключ объекта, присвоенний информационной системой ФССП РФ
     * при создании объекта или при получении объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $IpInternalKey;
    /**
     * The IpNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер ИП | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $IpNumber;
    /**
     * The RestrictnDocNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер постановления | Номер документа «Постановление об ограничении» | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $RestrictnDocNumber;
    /**
     * The RestrictnDocDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата постановления | Дата документа «Постановление об ограничении» | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $RestrictnDocDate;
    /**
     * The DocNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер документа | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $DocNumber;
    /**
     * The DocDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата документа | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DocDate;
    /**
     * The AuthorName
     * Meta informations extracted from the WSDL
     * - documentation: ФИО должностного лица | ФИО должностного лица, от имени которого направляется документ | Полное имя физического лица (фамилия,
     * имя, отчество)
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $AuthorName;
    /**
     * The AuthorPost
     * Meta informations extracted from the WSDL
     * - documentation: Должность | Наименование должности | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $AuthorPost;
    /**
     * The AuthorEmail
     * Meta informations extracted from the WSDL
     * - documentation: Электронная почта | Адрес электронной почты должностного лица | Адрес электронной почты
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $AuthorEmail;
    /**
     * The AuthorTelephone
     * Meta informations extracted from the WSDL
     * - documentation: Контактный телефон | Номер телефона
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $AuthorTelephone;
    /**
     * The Data
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о должнике
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\Data[]
     */
    public $Data;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \AisFssp\StructType\SignatureType[]
     */
    public $Signature;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Атрибут документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Id;
    /**
     * Constructor method for DebtorNewAccountNotice
     * @uses DebtorNewAccountNotice::setExternalKey()
     * @uses DebtorNewAccountNotice::setRestrictnInternalKey()
     * @uses DebtorNewAccountNotice::setIpInternalKey()
     * @uses DebtorNewAccountNotice::setIpNumber()
     * @uses DebtorNewAccountNotice::setRestrictnDocNumber()
     * @uses DebtorNewAccountNotice::setRestrictnDocDate()
     * @uses DebtorNewAccountNotice::setDocNumber()
     * @uses DebtorNewAccountNotice::setDocDate()
     * @uses DebtorNewAccountNotice::setAuthorName()
     * @uses DebtorNewAccountNotice::setAuthorPost()
     * @uses DebtorNewAccountNotice::setAuthorEmail()
     * @uses DebtorNewAccountNotice::setAuthorTelephone()
     * @uses DebtorNewAccountNotice::setData()
     * @uses DebtorNewAccountNotice::setSignature()
     * @uses DebtorNewAccountNotice::setId()
     * @param string $externalKey
     * @param int $restrictnInternalKey
     * @param int $ipInternalKey
     * @param string $ipNumber
     * @param string $restrictnDocNumber
     * @param string $restrictnDocDate
     * @param string $docNumber
     * @param string $docDate
     * @param string $authorName
     * @param string $authorPost
     * @param string $authorEmail
     * @param string $authorTelephone
     * @param \AisFssp\StructType\Data[] $data
     * @param \AisFssp\StructType\SignatureType[] $signature
     * @param string $id
     */
    public function __construct($externalKey = null, $restrictnInternalKey = null, $ipInternalKey = null, $ipNumber = null, $restrictnDocNumber = null, $restrictnDocDate = null, $docNumber = null, $docDate = null, $authorName = null, $authorPost = null, $authorEmail = null, $authorTelephone = null, array $data = array(), array $signature = array(), $id = null)
    {
        $this
            ->setExternalKey($externalKey)
            ->setRestrictnInternalKey($restrictnInternalKey)
            ->setIpInternalKey($ipInternalKey)
            ->setIpNumber($ipNumber)
            ->setRestrictnDocNumber($restrictnDocNumber)
            ->setRestrictnDocDate($restrictnDocDate)
            ->setDocNumber($docNumber)
            ->setDocDate($docDate)
            ->setAuthorName($authorName)
            ->setAuthorPost($authorPost)
            ->setAuthorEmail($authorEmail)
            ->setAuthorTelephone($authorTelephone)
            ->setData($data)
            ->setSignature($signature)
            ->setId($id);
    }
    /**
     * Get ExternalKey value
     * @return string|null
     */
    public function getExternalKey()
    {
        return $this->ExternalKey;
    }
    /**
     * Set ExternalKey value
     * @param string $externalKey
     * @return \AisFssp\StructType\DebtorNewAccountNotice
     */
    public function setExternalKey($externalKey = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($externalKey) && strlen($externalKey) > 60) || (is_array($externalKey) && count($externalKey) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($externalKey) ? strlen($externalKey) : count($externalKey)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($externalKey) && strlen($externalKey) < 1) || (is_array($externalKey) && count($externalKey) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($externalKey) && !is_string($externalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externalKey)), __LINE__);
        }
        $this->ExternalKey = $externalKey;
        return $this;
    }
    /**
     * Get RestrictnInternalKey value
     * @return int|null
     */
    public function getRestrictnInternalKey()
    {
        return $this->RestrictnInternalKey;
    }
    /**
     * Set RestrictnInternalKey value
     * @param int $restrictnInternalKey
     * @return \AisFssp\StructType\DebtorNewAccountNotice
     */
    public function setRestrictnInternalKey($restrictnInternalKey = null)
    {
        // validation for constraint: maxInclusive
        if ($restrictnInternalKey > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $restrictnInternalKey), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($restrictnInternalKey < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $restrictnInternalKey), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($restrictnInternalKey) && !is_numeric($restrictnInternalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($restrictnInternalKey)), __LINE__);
        }
        $this->RestrictnInternalKey = $restrictnInternalKey;
        return $this;
    }
    /**
     * Get IpInternalKey value
     * @return int|null
     */
    public function getIpInternalKey()
    {
        return $this->IpInternalKey;
    }
    /**
     * Set IpInternalKey value
     * @param int $ipInternalKey
     * @return \AisFssp\StructType\DebtorNewAccountNotice
     */
    public function setIpInternalKey($ipInternalKey = null)
    {
        // validation for constraint: maxInclusive
        if ($ipInternalKey > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $ipInternalKey), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($ipInternalKey < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $ipInternalKey), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($ipInternalKey) && !is_numeric($ipInternalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ipInternalKey)), __LINE__);
        }
        $this->IpInternalKey = $ipInternalKey;
        return $this;
    }
    /**
     * Get IpNumber value
     * @return string|null
     */
    public function getIpNumber()
    {
        return $this->IpNumber;
    }
    /**
     * Set IpNumber value
     * @param string $ipNumber
     * @return \AisFssp\StructType\DebtorNewAccountNotice
     */
    public function setIpNumber($ipNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($ipNumber) && strlen($ipNumber) > 25) || (is_array($ipNumber) && count($ipNumber) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($ipNumber) ? strlen($ipNumber) : count($ipNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($ipNumber) && strlen($ipNumber) < 1) || (is_array($ipNumber) && count($ipNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ipNumber) && !is_string($ipNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ipNumber)), __LINE__);
        }
        $this->IpNumber = $ipNumber;
        return $this;
    }
    /**
     * Get RestrictnDocNumber value
     * @return string|null
     */
    public function getRestrictnDocNumber()
    {
        return $this->RestrictnDocNumber;
    }
    /**
     * Set RestrictnDocNumber value
     * @param string $restrictnDocNumber
     * @return \AisFssp\StructType\DebtorNewAccountNotice
     */
    public function setRestrictnDocNumber($restrictnDocNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($restrictnDocNumber) && strlen($restrictnDocNumber) > 25) || (is_array($restrictnDocNumber) && count($restrictnDocNumber) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($restrictnDocNumber) ? strlen($restrictnDocNumber) : count($restrictnDocNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($restrictnDocNumber) && strlen($restrictnDocNumber) < 1) || (is_array($restrictnDocNumber) && count($restrictnDocNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($restrictnDocNumber) && !is_string($restrictnDocNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($restrictnDocNumber)), __LINE__);
        }
        $this->RestrictnDocNumber = $restrictnDocNumber;
        return $this;
    }
    /**
     * Get RestrictnDocDate value
     * @return string|null
     */
    public function getRestrictnDocDate()
    {
        return $this->RestrictnDocDate;
    }
    /**
     * Set RestrictnDocDate value
     * @param string $restrictnDocDate
     * @return \AisFssp\StructType\DebtorNewAccountNotice
     */
    public function setRestrictnDocDate($restrictnDocDate = null)
    {
        // validation for constraint: maxExclusive
        if ($restrictnDocDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $restrictnDocDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($restrictnDocDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $restrictnDocDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($restrictnDocDate) && !is_string($restrictnDocDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($restrictnDocDate)), __LINE__);
        }
        $this->RestrictnDocDate = $restrictnDocDate;
        return $this;
    }
    /**
     * Get DocNumber value
     * @return string|null
     */
    public function getDocNumber()
    {
        return $this->DocNumber;
    }
    /**
     * Set DocNumber value
     * @param string $docNumber
     * @return \AisFssp\StructType\DebtorNewAccountNotice
     */
    public function setDocNumber($docNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($docNumber) && strlen($docNumber) > 25) || (is_array($docNumber) && count($docNumber) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($docNumber) ? strlen($docNumber) : count($docNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($docNumber) && strlen($docNumber) < 1) || (is_array($docNumber) && count($docNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docNumber) && !is_string($docNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docNumber)), __LINE__);
        }
        $this->DocNumber = $docNumber;
        return $this;
    }
    /**
     * Get DocDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->DocDate;
    }
    /**
     * Set DocDate value
     * @param string $docDate
     * @return \AisFssp\StructType\DebtorNewAccountNotice
     */
    public function setDocDate($docDate = null)
    {
        // validation for constraint: maxExclusive
        if ($docDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $docDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($docDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $docDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docDate) && !is_string($docDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docDate)), __LINE__);
        }
        $this->DocDate = $docDate;
        return $this;
    }
    /**
     * Get AuthorName value
     * @return string|null
     */
    public function getAuthorName()
    {
        return $this->AuthorName;
    }
    /**
     * Set AuthorName value
     * @param string $authorName
     * @return \AisFssp\StructType\DebtorNewAccountNotice
     */
    public function setAuthorName($authorName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($authorName) && strlen($authorName) > 100) || (is_array($authorName) && count($authorName) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($authorName) ? strlen($authorName) : count($authorName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($authorName) && strlen($authorName) < 1) || (is_array($authorName) && count($authorName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($authorName) && !is_string($authorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authorName)), __LINE__);
        }
        $this->AuthorName = $authorName;
        return $this;
    }
    /**
     * Get AuthorPost value
     * @return string|null
     */
    public function getAuthorPost()
    {
        return $this->AuthorPost;
    }
    /**
     * Set AuthorPost value
     * @param string $authorPost
     * @return \AisFssp\StructType\DebtorNewAccountNotice
     */
    public function setAuthorPost($authorPost = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($authorPost) && strlen($authorPost) > 50) || (is_array($authorPost) && count($authorPost) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($authorPost) ? strlen($authorPost) : count($authorPost)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($authorPost) && strlen($authorPost) < 1) || (is_array($authorPost) && count($authorPost) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($authorPost) && !is_string($authorPost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authorPost)), __LINE__);
        }
        $this->AuthorPost = $authorPost;
        return $this;
    }
    /**
     * Get AuthorEmail value
     * @return string|null
     */
    public function getAuthorEmail()
    {
        return $this->AuthorEmail;
    }
    /**
     * Set AuthorEmail value
     * @param string $authorEmail
     * @return \AisFssp\StructType\DebtorNewAccountNotice
     */
    public function setAuthorEmail($authorEmail = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($authorEmail) && strlen($authorEmail) > 100) || (is_array($authorEmail) && count($authorEmail) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($authorEmail) ? strlen($authorEmail) : count($authorEmail)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($authorEmail) && strlen($authorEmail) < 1) || (is_array($authorEmail) && count($authorEmail) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($authorEmail) && !is_string($authorEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authorEmail)), __LINE__);
        }
        $this->AuthorEmail = $authorEmail;
        return $this;
    }
    /**
     * Get AuthorTelephone value
     * @return string|null
     */
    public function getAuthorTelephone()
    {
        return $this->AuthorTelephone;
    }
    /**
     * Set AuthorTelephone value
     * @param string $authorTelephone
     * @return \AisFssp\StructType\DebtorNewAccountNotice
     */
    public function setAuthorTelephone($authorTelephone = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($authorTelephone) && strlen($authorTelephone) > 25) || (is_array($authorTelephone) && count($authorTelephone) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($authorTelephone) ? strlen($authorTelephone) : count($authorTelephone)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($authorTelephone) && strlen($authorTelephone) < 1) || (is_array($authorTelephone) && count($authorTelephone) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($authorTelephone) && !is_string($authorTelephone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authorTelephone)), __LINE__);
        }
        $this->AuthorTelephone = $authorTelephone;
        return $this;
    }
    /**
     * Get Data value
     * @return \AisFssp\StructType\Data[]|null
     */
    public function getData()
    {
        return $this->Data;
    }
    /**
     * Set Data value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\Data[] $data
     * @return \AisFssp\StructType\DebtorNewAccountNotice
     */
    public function setData(array $data = array())
    {
        foreach ($data as $debtorNewAccountNoticeDataItem) {
            // validation for constraint: itemType
            if (!$debtorNewAccountNoticeDataItem instanceof \AisFssp\StructType\Data) {
                throw new \InvalidArgumentException(sprintf('The Data property can only contain items of \AisFssp\StructType\Data, "%s" given', is_object($debtorNewAccountNoticeDataItem) ? get_class($debtorNewAccountNoticeDataItem) : gettype($debtorNewAccountNoticeDataItem)), __LINE__);
            }
        }
        $this->Data = $data;
        return $this;
    }
    /**
     * Add item to Data value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\Data $item
     * @return \AisFssp\StructType\DebtorNewAccountNotice
     */
    public function addToData(\AisFssp\StructType\Data $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\Data) {
            throw new \InvalidArgumentException(sprintf('The Data property can only contain items of \AisFssp\StructType\Data, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Data[] = $item;
        return $this;
    }
    /**
     * Get Signature value
     * @return \AisFssp\StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType[] $signature
     * @return \AisFssp\StructType\DebtorNewAccountNotice
     */
    public function setSignature(array $signature = array())
    {
        foreach ($signature as $debtorNewAccountNoticeSignatureItem) {
            // validation for constraint: itemType
            if (!$debtorNewAccountNoticeSignatureItem instanceof \AisFssp\StructType\SignatureType) {
                throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($debtorNewAccountNoticeSignatureItem) ? get_class($debtorNewAccountNoticeSignatureItem) : gettype($debtorNewAccountNoticeSignatureItem)), __LINE__);
            }
        }
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType $item
     * @return \AisFssp\StructType\DebtorNewAccountNotice
     */
    public function addToSignature(\AisFssp\StructType\SignatureType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\SignatureType) {
            throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \AisFssp\StructType\DebtorNewAccountNotice
     */
    public function setId($id = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($id) && strlen($id) > 60) || (is_array($id) && count($id) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($id) ? strlen($id) : count($id)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($id) && strlen($id) < 1) || (is_array($id) && count($id) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\DebtorNewAccountNotice
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
