<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DebtorIpNotify StructType
 * Meta informations extracted from the WSDL
 * - documentation: Документ DebtorIpNotify «Информация об уведомлении должника о возбуждении ИП» | ЭП
 * - type: tns:DebtorIpNotify
 * @subpackage Structs
 */
class DebtorIpNotify extends AbstractStructBase
{
    /**
     * The ExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор АИС ВК | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный
     * идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $ExternalKey;
    /**
     * The MessageInternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор сообщения АИС ФССП России | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или
     * при получении объекта от контрагента
     * - minOccurs: 0
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $MessageInternalKey;
    /**
     * The IpNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер ИП | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $IpNumber;
    /**
     * The NotifyState
     * Meta informations extracted from the WSDL
     * - documentation: Состояние отправки сообщения
     * @var string
     */
    public $NotifyState;
    /**
     * The Comment
     * Meta informations extracted from the WSDL
     * - documentation: Комментарий | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $Comment;
    /**
     * The NotifyTimestamp
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время уведомления | Дата и время | Дата и время
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $NotifyTimestamp;
    /**
     * The NotifyType
     * Meta informations extracted from the WSDL
     * - documentation: Способ уведомления
     * @var string
     */
    public $NotifyType;
    /**
     * The Data
     * Meta informations extracted from the WSDL
     * - documentation: Сведения
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\Data[]
     */
    public $Data;
    /**
     * The Attachments
     * Meta informations extracted from the WSDL
     * - documentation: Прикрепленные файлы
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\AttachmentType[]
     */
    public $Attachments;
    /**
     * The SignDateTime
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время формирования подписи | Дата и время | Дата и время
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $SignDateTime;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \AisFssp\StructType\SignatureType[]
     */
    public $Signature;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Атрибут документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Id;
    /**
     * Constructor method for DebtorIpNotify
     * @uses DebtorIpNotify::setExternalKey()
     * @uses DebtorIpNotify::setMessageInternalKey()
     * @uses DebtorIpNotify::setIpNumber()
     * @uses DebtorIpNotify::setNotifyState()
     * @uses DebtorIpNotify::setComment()
     * @uses DebtorIpNotify::setNotifyTimestamp()
     * @uses DebtorIpNotify::setNotifyType()
     * @uses DebtorIpNotify::setData()
     * @uses DebtorIpNotify::setAttachments()
     * @uses DebtorIpNotify::setSignDateTime()
     * @uses DebtorIpNotify::setSignature()
     * @uses DebtorIpNotify::setId()
     * @param string $externalKey
     * @param int $messageInternalKey
     * @param string $ipNumber
     * @param string $notifyState
     * @param string $comment
     * @param string $notifyTimestamp
     * @param string $notifyType
     * @param \AisFssp\StructType\Data[] $data
     * @param \AisFssp\StructType\AttachmentType[] $attachments
     * @param string $signDateTime
     * @param \AisFssp\StructType\SignatureType[] $signature
     * @param string $id
     */
    public function __construct($externalKey = null, $messageInternalKey = null, $ipNumber = null, $notifyState = null, $comment = null, $notifyTimestamp = null, $notifyType = null, array $data = array(), array $attachments = array(), $signDateTime = null, array $signature = array(), $id = null)
    {
        $this
            ->setExternalKey($externalKey)
            ->setMessageInternalKey($messageInternalKey)
            ->setIpNumber($ipNumber)
            ->setNotifyState($notifyState)
            ->setComment($comment)
            ->setNotifyTimestamp($notifyTimestamp)
            ->setNotifyType($notifyType)
            ->setData($data)
            ->setAttachments($attachments)
            ->setSignDateTime($signDateTime)
            ->setSignature($signature)
            ->setId($id);
    }
    /**
     * Get ExternalKey value
     * @return string|null
     */
    public function getExternalKey()
    {
        return $this->ExternalKey;
    }
    /**
     * Set ExternalKey value
     * @param string $externalKey
     * @return \AisFssp\StructType\DebtorIpNotify
     */
    public function setExternalKey($externalKey = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($externalKey) && strlen($externalKey) > 60) || (is_array($externalKey) && count($externalKey) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($externalKey) ? strlen($externalKey) : count($externalKey)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($externalKey) && strlen($externalKey) < 1) || (is_array($externalKey) && count($externalKey) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($externalKey) && !is_string($externalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externalKey)), __LINE__);
        }
        $this->ExternalKey = $externalKey;
        return $this;
    }
    /**
     * Get MessageInternalKey value
     * @return int|null
     */
    public function getMessageInternalKey()
    {
        return $this->MessageInternalKey;
    }
    /**
     * Set MessageInternalKey value
     * @param int $messageInternalKey
     * @return \AisFssp\StructType\DebtorIpNotify
     */
    public function setMessageInternalKey($messageInternalKey = null)
    {
        // validation for constraint: maxInclusive
        if ($messageInternalKey > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $messageInternalKey), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($messageInternalKey < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $messageInternalKey), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($messageInternalKey) && !is_numeric($messageInternalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($messageInternalKey)), __LINE__);
        }
        $this->MessageInternalKey = $messageInternalKey;
        return $this;
    }
    /**
     * Get IpNumber value
     * @return string|null
     */
    public function getIpNumber()
    {
        return $this->IpNumber;
    }
    /**
     * Set IpNumber value
     * @param string $ipNumber
     * @return \AisFssp\StructType\DebtorIpNotify
     */
    public function setIpNumber($ipNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($ipNumber) && strlen($ipNumber) > 25) || (is_array($ipNumber) && count($ipNumber) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($ipNumber) ? strlen($ipNumber) : count($ipNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($ipNumber) && strlen($ipNumber) < 1) || (is_array($ipNumber) && count($ipNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ipNumber) && !is_string($ipNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ipNumber)), __LINE__);
        }
        $this->IpNumber = $ipNumber;
        return $this;
    }
    /**
     * Get NotifyState value
     * @return string|null
     */
    public function getNotifyState()
    {
        return $this->NotifyState;
    }
    /**
     * Set NotifyState value
     * @uses \AisFssp\EnumType\NotifyStateCodeType::valueIsValid()
     * @uses \AisFssp\EnumType\NotifyStateCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $notifyState
     * @return \AisFssp\StructType\DebtorIpNotify
     */
    public function setNotifyState($notifyState = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\NotifyStateCodeType::valueIsValid($notifyState)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $notifyState, implode(', ', \AisFssp\EnumType\NotifyStateCodeType::getValidValues())), __LINE__);
        }
        $this->NotifyState = $notifyState;
        return $this;
    }
    /**
     * Get Comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param string $comment
     * @return \AisFssp\StructType\DebtorIpNotify
     */
    public function setComment($comment = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($comment) && strlen($comment) > 300) || (is_array($comment) && count($comment) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($comment) ? strlen($comment) : count($comment)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($comment) && strlen($comment) < 1) || (is_array($comment) && count($comment) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($comment)), __LINE__);
        }
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Get NotifyTimestamp value
     * @return string|null
     */
    public function getNotifyTimestamp()
    {
        return $this->NotifyTimestamp;
    }
    /**
     * Set NotifyTimestamp value
     * @param string $notifyTimestamp
     * @return \AisFssp\StructType\DebtorIpNotify
     */
    public function setNotifyTimestamp($notifyTimestamp = null)
    {
        // validation for constraint: maxExclusive
        if ($notifyTimestamp >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $notifyTimestamp), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($notifyTimestamp < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $notifyTimestamp), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($notifyTimestamp) && !is_string($notifyTimestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notifyTimestamp)), __LINE__);
        }
        $this->NotifyTimestamp = $notifyTimestamp;
        return $this;
    }
    /**
     * Get NotifyType value
     * @return string|null
     */
    public function getNotifyType()
    {
        return $this->NotifyType;
    }
    /**
     * Set NotifyType value
     * @uses \AisFssp\EnumType\DebtorNotifyType::valueIsValid()
     * @uses \AisFssp\EnumType\DebtorNotifyType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $notifyType
     * @return \AisFssp\StructType\DebtorIpNotify
     */
    public function setNotifyType($notifyType = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\DebtorNotifyType::valueIsValid($notifyType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $notifyType, implode(', ', \AisFssp\EnumType\DebtorNotifyType::getValidValues())), __LINE__);
        }
        $this->NotifyType = $notifyType;
        return $this;
    }
    /**
     * Get Data value
     * @return \AisFssp\StructType\Data[]|null
     */
    public function getData()
    {
        return $this->Data;
    }
    /**
     * Set Data value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\Data[] $data
     * @return \AisFssp\StructType\DebtorIpNotify
     */
    public function setData(array $data = array())
    {
        foreach ($data as $debtorIpNotifyDataItem) {
            // validation for constraint: itemType
            if (!$debtorIpNotifyDataItem instanceof \AisFssp\StructType\Data) {
                throw new \InvalidArgumentException(sprintf('The Data property can only contain items of \AisFssp\StructType\Data, "%s" given', is_object($debtorIpNotifyDataItem) ? get_class($debtorIpNotifyDataItem) : gettype($debtorIpNotifyDataItem)), __LINE__);
            }
        }
        $this->Data = $data;
        return $this;
    }
    /**
     * Add item to Data value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\Data $item
     * @return \AisFssp\StructType\DebtorIpNotify
     */
    public function addToData(\AisFssp\StructType\Data $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\Data) {
            throw new \InvalidArgumentException(sprintf('The Data property can only contain items of \AisFssp\StructType\Data, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Data[] = $item;
        return $this;
    }
    /**
     * Get Attachments value
     * @return \AisFssp\StructType\AttachmentType[]|null
     */
    public function getAttachments()
    {
        return $this->Attachments;
    }
    /**
     * Set Attachments value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\AttachmentType[] $attachments
     * @return \AisFssp\StructType\DebtorIpNotify
     */
    public function setAttachments(array $attachments = array())
    {
        foreach ($attachments as $debtorIpNotifyAttachmentsItem) {
            // validation for constraint: itemType
            if (!$debtorIpNotifyAttachmentsItem instanceof \AisFssp\StructType\AttachmentType) {
                throw new \InvalidArgumentException(sprintf('The Attachments property can only contain items of \AisFssp\StructType\AttachmentType, "%s" given', is_object($debtorIpNotifyAttachmentsItem) ? get_class($debtorIpNotifyAttachmentsItem) : gettype($debtorIpNotifyAttachmentsItem)), __LINE__);
            }
        }
        $this->Attachments = $attachments;
        return $this;
    }
    /**
     * Add item to Attachments value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\AttachmentType $item
     * @return \AisFssp\StructType\DebtorIpNotify
     */
    public function addToAttachments(\AisFssp\StructType\AttachmentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\AttachmentType) {
            throw new \InvalidArgumentException(sprintf('The Attachments property can only contain items of \AisFssp\StructType\AttachmentType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Attachments[] = $item;
        return $this;
    }
    /**
     * Get SignDateTime value
     * @return string|null
     */
    public function getSignDateTime()
    {
        return $this->SignDateTime;
    }
    /**
     * Set SignDateTime value
     * @param string $signDateTime
     * @return \AisFssp\StructType\DebtorIpNotify
     */
    public function setSignDateTime($signDateTime = null)
    {
        // validation for constraint: maxExclusive
        if ($signDateTime >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $signDateTime), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($signDateTime < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $signDateTime), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($signDateTime) && !is_string($signDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($signDateTime)), __LINE__);
        }
        $this->SignDateTime = $signDateTime;
        return $this;
    }
    /**
     * Get Signature value
     * @return \AisFssp\StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType[] $signature
     * @return \AisFssp\StructType\DebtorIpNotify
     */
    public function setSignature(array $signature = array())
    {
        foreach ($signature as $debtorIpNotifySignatureItem) {
            // validation for constraint: itemType
            if (!$debtorIpNotifySignatureItem instanceof \AisFssp\StructType\SignatureType) {
                throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($debtorIpNotifySignatureItem) ? get_class($debtorIpNotifySignatureItem) : gettype($debtorIpNotifySignatureItem)), __LINE__);
            }
        }
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType $item
     * @return \AisFssp\StructType\DebtorIpNotify
     */
    public function addToSignature(\AisFssp\StructType\SignatureType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\SignatureType) {
            throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \AisFssp\StructType\DebtorIpNotify
     */
    public function setId($id = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($id) && strlen($id) > 60) || (is_array($id) && count($id) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($id) ? strlen($id) : count($id)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($id) && strlen($id) < 1) || (is_array($id) && count($id) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\DebtorIpNotify
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
