<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Debt StructType
 * Meta informations extracted from the WSDL
 * - documentation: Документ Debt «Остатки долга» | Содержит сведения об остатках долга по находящимся на исполнении исполнительным производствам
 * для использования в системах платежей | ЭП
 * - type: tns:Debt
 * @subpackage Structs
 */
class Debt extends AbstractStructBase
{
    /**
     * The InternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ФССП России | Уникальный идентификатор реестра, присвоенный АИС ФССП России | Ключ объекта, присвоенний информационной
     * системой ФССП РФ при создании объекта или при получении объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $InternalKey;
    /**
     * The RequestExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор запроса АИС ВК | Идентификатор запроса реестра, полученный ранее от АИС внешнего контрагента | Идентификатор
     * объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный идентификатор должен быть уникальным для типа
     * идентифицируемого документа в пространстве обмена данными с конкретным внешним контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $RequestExternalKey;
    /**
     * The ReeIDD
     * Meta informations extracted from the WSDL
     * - documentation: Номер реестра долга | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $ReeIDD;
    /**
     * The IsUpdate
     * Meta informations extracted from the WSDL
     * - documentation: Признак обновления | Устанавливается в true в случае если файл данных это обновление, а не полная выгрузка данных | Обертка
     * стандартного xs:boolean | Логический
     * @var bool
     */
    public $IsUpdate;
    /**
     * The UnloadDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата выгрузки | Дата актуальности выгруженных данных | Дата и время | Дата и время
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $UnloadDate;
    /**
     * The PrevDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата предыдущей выгрузки | В случае если передается полная выгрузка данных не заполняется | Дата и время | Дата и время
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $PrevDate;
    /**
     * The HasMoreDebt
     * Meta informations extracted from the WSDL
     * - documentation: Признак наличия обновлений | Устанавливается в true в случае, если это не последний реестр обновлений и существуют ещё данные |
     * Обертка стандартного xs:boolean | Логический
     * @var bool
     */
    public $HasMoreDebt;
    /**
     * The DebtRecordCount
     * Meta informations extracted from the WSDL
     * - documentation: Количество записей реестра долга | Количество записей о задолженности по ИП в файле долга. Нулевое количество обозначает, что
     * система не может найти реестр долга, соответствующий условиям запроса | Целое | Целое
     * - maxInclusive: 2147483647
     * @var int
     */
    public $DebtRecordCount;
    /**
     * The ToFrom
     * Meta informations extracted from the WSDL
     * - documentation: Код территориального органа | Код территориального органа, для которого сформирован реестр. | Ведомственный классификатор
     * территориальных отделов судебных приставов | NSI_Departments
     * - minOccurs: 0
     * - length: 2
     * - pattern: [0-9]{2}
     * @var string
     */
    public $ToFrom;
    /**
     * The DebtDetail
     * Meta informations extracted from the WSDL
     * - documentation: Реестр задолженности | Ссылка на файл в SOAP mime-attachment. Файл данных с данными задолженностей по ИП передается как часть SOAP
     * сообщения в mime-формате, тип содержимого (content type) application/zip. Данное поле не заполняется в случае, если система не может найти реестр,
     * соответствующий условиям запроса. Реквизитный состав реестра задолженности указан в альбоме форматов АИС ФССП России Приложение 10.
     * Формат реестра задолженности для платежных систем.
     * - expectedContentTypes: application/zip
     * - minOccurs: 0
     * @var string
     */
    public $DebtDetail;
    /**
     * The SignDateTime
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время формирования подписи | Дата и время | Дата и время
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $SignDateTime;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \AisFssp\StructType\SignatureType[]
     */
    public $Signature;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Атрибут документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Id;
    /**
     * Constructor method for Debt
     * @uses Debt::setInternalKey()
     * @uses Debt::setRequestExternalKey()
     * @uses Debt::setReeIDD()
     * @uses Debt::setIsUpdate()
     * @uses Debt::setUnloadDate()
     * @uses Debt::setPrevDate()
     * @uses Debt::setHasMoreDebt()
     * @uses Debt::setDebtRecordCount()
     * @uses Debt::setToFrom()
     * @uses Debt::setDebtDetail()
     * @uses Debt::setSignDateTime()
     * @uses Debt::setSignature()
     * @uses Debt::setId()
     * @param int $internalKey
     * @param string $requestExternalKey
     * @param string $reeIDD
     * @param bool $isUpdate
     * @param string $unloadDate
     * @param string $prevDate
     * @param bool $hasMoreDebt
     * @param int $debtRecordCount
     * @param string $toFrom
     * @param string $debtDetail
     * @param string $signDateTime
     * @param \AisFssp\StructType\SignatureType[] $signature
     * @param string $id
     */
    public function __construct($internalKey = null, $requestExternalKey = null, $reeIDD = null, $isUpdate = null, $unloadDate = null, $prevDate = null, $hasMoreDebt = null, $debtRecordCount = null, $toFrom = null, $debtDetail = null, $signDateTime = null, array $signature = array(), $id = null)
    {
        $this
            ->setInternalKey($internalKey)
            ->setRequestExternalKey($requestExternalKey)
            ->setReeIDD($reeIDD)
            ->setIsUpdate($isUpdate)
            ->setUnloadDate($unloadDate)
            ->setPrevDate($prevDate)
            ->setHasMoreDebt($hasMoreDebt)
            ->setDebtRecordCount($debtRecordCount)
            ->setToFrom($toFrom)
            ->setDebtDetail($debtDetail)
            ->setSignDateTime($signDateTime)
            ->setSignature($signature)
            ->setId($id);
    }
    /**
     * Get InternalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->InternalKey;
    }
    /**
     * Set InternalKey value
     * @param int $internalKey
     * @return \AisFssp\StructType\Debt
     */
    public function setInternalKey($internalKey = null)
    {
        // validation for constraint: maxInclusive
        if ($internalKey > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($internalKey < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($internalKey) && !is_numeric($internalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($internalKey)), __LINE__);
        }
        $this->InternalKey = $internalKey;
        return $this;
    }
    /**
     * Get RequestExternalKey value
     * @return string|null
     */
    public function getRequestExternalKey()
    {
        return $this->RequestExternalKey;
    }
    /**
     * Set RequestExternalKey value
     * @param string $requestExternalKey
     * @return \AisFssp\StructType\Debt
     */
    public function setRequestExternalKey($requestExternalKey = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestExternalKey) && strlen($requestExternalKey) > 60) || (is_array($requestExternalKey) && count($requestExternalKey) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($requestExternalKey) ? strlen($requestExternalKey) : count($requestExternalKey)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($requestExternalKey) && strlen($requestExternalKey) < 1) || (is_array($requestExternalKey) && count($requestExternalKey) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestExternalKey) && !is_string($requestExternalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestExternalKey)), __LINE__);
        }
        $this->RequestExternalKey = $requestExternalKey;
        return $this;
    }
    /**
     * Get ReeIDD value
     * @return string|null
     */
    public function getReeIDD()
    {
        return $this->ReeIDD;
    }
    /**
     * Set ReeIDD value
     * @param string $reeIDD
     * @return \AisFssp\StructType\Debt
     */
    public function setReeIDD($reeIDD = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($reeIDD) && strlen($reeIDD) > 25) || (is_array($reeIDD) && count($reeIDD) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($reeIDD) ? strlen($reeIDD) : count($reeIDD)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($reeIDD) && strlen($reeIDD) < 1) || (is_array($reeIDD) && count($reeIDD) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($reeIDD) && !is_string($reeIDD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reeIDD)), __LINE__);
        }
        $this->ReeIDD = $reeIDD;
        return $this;
    }
    /**
     * Get IsUpdate value
     * @return bool|null
     */
    public function getIsUpdate()
    {
        return $this->IsUpdate;
    }
    /**
     * Set IsUpdate value
     * @param bool $isUpdate
     * @return \AisFssp\StructType\Debt
     */
    public function setIsUpdate($isUpdate = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUpdate) && !is_bool($isUpdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isUpdate)), __LINE__);
        }
        $this->IsUpdate = $isUpdate;
        return $this;
    }
    /**
     * Get UnloadDate value
     * @return string|null
     */
    public function getUnloadDate()
    {
        return $this->UnloadDate;
    }
    /**
     * Set UnloadDate value
     * @param string $unloadDate
     * @return \AisFssp\StructType\Debt
     */
    public function setUnloadDate($unloadDate = null)
    {
        // validation for constraint: maxExclusive
        if ($unloadDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $unloadDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($unloadDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $unloadDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($unloadDate) && !is_string($unloadDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unloadDate)), __LINE__);
        }
        $this->UnloadDate = $unloadDate;
        return $this;
    }
    /**
     * Get PrevDate value
     * @return string|null
     */
    public function getPrevDate()
    {
        return $this->PrevDate;
    }
    /**
     * Set PrevDate value
     * @param string $prevDate
     * @return \AisFssp\StructType\Debt
     */
    public function setPrevDate($prevDate = null)
    {
        // validation for constraint: maxExclusive
        if ($prevDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $prevDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($prevDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $prevDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($prevDate) && !is_string($prevDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($prevDate)), __LINE__);
        }
        $this->PrevDate = $prevDate;
        return $this;
    }
    /**
     * Get HasMoreDebt value
     * @return bool|null
     */
    public function getHasMoreDebt()
    {
        return $this->HasMoreDebt;
    }
    /**
     * Set HasMoreDebt value
     * @param bool $hasMoreDebt
     * @return \AisFssp\StructType\Debt
     */
    public function setHasMoreDebt($hasMoreDebt = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasMoreDebt) && !is_bool($hasMoreDebt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hasMoreDebt)), __LINE__);
        }
        $this->HasMoreDebt = $hasMoreDebt;
        return $this;
    }
    /**
     * Get DebtRecordCount value
     * @return int|null
     */
    public function getDebtRecordCount()
    {
        return $this->DebtRecordCount;
    }
    /**
     * Set DebtRecordCount value
     * @param int $debtRecordCount
     * @return \AisFssp\StructType\Debt
     */
    public function setDebtRecordCount($debtRecordCount = null)
    {
        // validation for constraint: maxInclusive
        if ($debtRecordCount > 2147483647) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 2147483647, "%s" given', $debtRecordCount), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($debtRecordCount) && !is_numeric($debtRecordCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($debtRecordCount)), __LINE__);
        }
        $this->DebtRecordCount = $debtRecordCount;
        return $this;
    }
    /**
     * Get ToFrom value
     * @return string|null
     */
    public function getToFrom()
    {
        return $this->ToFrom;
    }
    /**
     * Set ToFrom value
     * @param string $toFrom
     * @return \AisFssp\StructType\Debt
     */
    public function setToFrom($toFrom = null)
    {
        // validation for constraint: length
        if ((is_scalar($toFrom) && strlen($toFrom) !== 2) || (is_array($toFrom) && count($toFrom) !== 2)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 2 element(s) or a scalar of 2 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($toFrom) && !preg_match('/[0-9]{2}/', $toFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{2}", "%s" given', var_export($toFrom, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($toFrom) && !is_string($toFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($toFrom)), __LINE__);
        }
        $this->ToFrom = $toFrom;
        return $this;
    }
    /**
     * Get DebtDetail value
     * @return string|null
     */
    public function getDebtDetail()
    {
        return $this->DebtDetail;
    }
    /**
     * Set DebtDetail value
     * @param string $debtDetail
     * @return \AisFssp\StructType\Debt
     */
    public function setDebtDetail($debtDetail = null)
    {
        // validation for constraint: string
        if (!is_null($debtDetail) && !is_string($debtDetail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($debtDetail)), __LINE__);
        }
        $this->DebtDetail = $debtDetail;
        return $this;
    }
    /**
     * Get SignDateTime value
     * @return string|null
     */
    public function getSignDateTime()
    {
        return $this->SignDateTime;
    }
    /**
     * Set SignDateTime value
     * @param string $signDateTime
     * @return \AisFssp\StructType\Debt
     */
    public function setSignDateTime($signDateTime = null)
    {
        // validation for constraint: maxExclusive
        if ($signDateTime >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $signDateTime), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($signDateTime < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $signDateTime), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($signDateTime) && !is_string($signDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($signDateTime)), __LINE__);
        }
        $this->SignDateTime = $signDateTime;
        return $this;
    }
    /**
     * Get Signature value
     * @return \AisFssp\StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType[] $signature
     * @return \AisFssp\StructType\Debt
     */
    public function setSignature(array $signature = array())
    {
        foreach ($signature as $debtSignatureItem) {
            // validation for constraint: itemType
            if (!$debtSignatureItem instanceof \AisFssp\StructType\SignatureType) {
                throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($debtSignatureItem) ? get_class($debtSignatureItem) : gettype($debtSignatureItem)), __LINE__);
            }
        }
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType $item
     * @return \AisFssp\StructType\Debt
     */
    public function addToSignature(\AisFssp\StructType\SignatureType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\SignatureType) {
            throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \AisFssp\StructType\Debt
     */
    public function setId($id = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($id) && strlen($id) > 60) || (is_array($id) && count($id) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($id) ? strlen($id) : count($id)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($id) && strlen($id) < 1) || (is_array($id) && count($id) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\Debt
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
