<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeathDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения о смерти
 * @subpackage Structs
 */
class DeathDatumType extends InformationType
{
    /**
     * The ActNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер актовой записи о смерти | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $ActNumber;
    /**
     * The AktDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата актовой записи о смерти | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $AktDate;
    /**
     * The RegistrationData
     * Meta informations extracted from the WSDL
     * - documentation: Место государственной регистрации | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $RegistrationData;
    /**
     * The DeathDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата смерти | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DeathDate;
    /**
     * The DeathPlace
     * Meta informations extracted from the WSDL
     * - documentation: Место смерти | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $DeathPlace;
    /**
     * The ComplementaryInfo
     * Meta informations extracted from the WSDL
     * - documentation: Дополнительная информация | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $ComplementaryInfo;
    /**
     * Constructor method for DeathDatumType
     * @uses DeathDatumType::setActNumber()
     * @uses DeathDatumType::setAktDate()
     * @uses DeathDatumType::setRegistrationData()
     * @uses DeathDatumType::setDeathDate()
     * @uses DeathDatumType::setDeathPlace()
     * @uses DeathDatumType::setComplementaryInfo()
     * @param string $actNumber
     * @param string $aktDate
     * @param string $registrationData
     * @param string $deathDate
     * @param string $deathPlace
     * @param string $complementaryInfo
     */
    public function __construct($actNumber = null, $aktDate = null, $registrationData = null, $deathDate = null, $deathPlace = null, $complementaryInfo = null)
    {
        $this
            ->setActNumber($actNumber)
            ->setAktDate($aktDate)
            ->setRegistrationData($registrationData)
            ->setDeathDate($deathDate)
            ->setDeathPlace($deathPlace)
            ->setComplementaryInfo($complementaryInfo);
    }
    /**
     * Get ActNumber value
     * @return string|null
     */
    public function getActNumber()
    {
        return $this->ActNumber;
    }
    /**
     * Set ActNumber value
     * @param string $actNumber
     * @return \AisFssp\StructType\DeathDatumType
     */
    public function setActNumber($actNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($actNumber) && strlen($actNumber) > 25) || (is_array($actNumber) && count($actNumber) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($actNumber) ? strlen($actNumber) : count($actNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($actNumber) && strlen($actNumber) < 1) || (is_array($actNumber) && count($actNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($actNumber) && !is_string($actNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($actNumber)), __LINE__);
        }
        $this->ActNumber = $actNumber;
        return $this;
    }
    /**
     * Get AktDate value
     * @return string|null
     */
    public function getAktDate()
    {
        return $this->AktDate;
    }
    /**
     * Set AktDate value
     * @param string $aktDate
     * @return \AisFssp\StructType\DeathDatumType
     */
    public function setAktDate($aktDate = null)
    {
        // validation for constraint: maxExclusive
        if ($aktDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $aktDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($aktDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $aktDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aktDate) && !is_string($aktDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aktDate)), __LINE__);
        }
        $this->AktDate = $aktDate;
        return $this;
    }
    /**
     * Get RegistrationData value
     * @return string|null
     */
    public function getRegistrationData()
    {
        return $this->RegistrationData;
    }
    /**
     * Set RegistrationData value
     * @param string $registrationData
     * @return \AisFssp\StructType\DeathDatumType
     */
    public function setRegistrationData($registrationData = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($registrationData) && strlen($registrationData) > 300) || (is_array($registrationData) && count($registrationData) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($registrationData) ? strlen($registrationData) : count($registrationData)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($registrationData) && strlen($registrationData) < 1) || (is_array($registrationData) && count($registrationData) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($registrationData) && !is_string($registrationData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($registrationData)), __LINE__);
        }
        $this->RegistrationData = $registrationData;
        return $this;
    }
    /**
     * Get DeathDate value
     * @return string|null
     */
    public function getDeathDate()
    {
        return $this->DeathDate;
    }
    /**
     * Set DeathDate value
     * @param string $deathDate
     * @return \AisFssp\StructType\DeathDatumType
     */
    public function setDeathDate($deathDate = null)
    {
        // validation for constraint: maxExclusive
        if ($deathDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $deathDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($deathDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $deathDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($deathDate) && !is_string($deathDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deathDate)), __LINE__);
        }
        $this->DeathDate = $deathDate;
        return $this;
    }
    /**
     * Get DeathPlace value
     * @return string|null
     */
    public function getDeathPlace()
    {
        return $this->DeathPlace;
    }
    /**
     * Set DeathPlace value
     * @param string $deathPlace
     * @return \AisFssp\StructType\DeathDatumType
     */
    public function setDeathPlace($deathPlace = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($deathPlace) && strlen($deathPlace) > 300) || (is_array($deathPlace) && count($deathPlace) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($deathPlace) ? strlen($deathPlace) : count($deathPlace)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($deathPlace) && strlen($deathPlace) < 1) || (is_array($deathPlace) && count($deathPlace) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($deathPlace) && !is_string($deathPlace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deathPlace)), __LINE__);
        }
        $this->DeathPlace = $deathPlace;
        return $this;
    }
    /**
     * Get ComplementaryInfo value
     * @return string|null
     */
    public function getComplementaryInfo()
    {
        return $this->ComplementaryInfo;
    }
    /**
     * Set ComplementaryInfo value
     * @param string $complementaryInfo
     * @return \AisFssp\StructType\DeathDatumType
     */
    public function setComplementaryInfo($complementaryInfo = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($complementaryInfo) && strlen($complementaryInfo) > 1000) || (is_array($complementaryInfo) && count($complementaryInfo) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($complementaryInfo) ? strlen($complementaryInfo) : count($complementaryInfo)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($complementaryInfo) && strlen($complementaryInfo) < 1) || (is_array($complementaryInfo) && count($complementaryInfo) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($complementaryInfo) && !is_string($complementaryInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($complementaryInfo)), __LINE__);
        }
        $this->ComplementaryInfo = $complementaryInfo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\DeathDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
