<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Data StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип данных Data «Сведения» | Данный контейнер содержит один элемент сведений о должнике. Допустимые типы элементов перечислены в
 * таблице (Удостоверение личности, Адрес и т. п.). При необходимости указать в документе несколько сведений следует завести в документе
 * несколько объектов типа Data «Сведения».
 * @subpackage Structs
 */
class Data extends AbstractStructBase
{
    /**
     * The IdentificationData
     * Meta informations extracted from the WSDL
     * - documentation: Удостоверение личности
     * @var \AisFssp\StructType\IdentificationDataType
     */
    public $IdentificationData;
    /**
     * The AddressData
     * Meta informations extracted from the WSDL
     * - documentation: Адрес
     * @var \AisFssp\StructType\AddressDataType
     */
    public $AddressData;
    /**
     * The TelephoneData
     * Meta informations extracted from the WSDL
     * - documentation: Телефон
     * @var \AisFssp\StructType\TelephoneDataType
     */
    public $TelephoneData;
    /**
     * The TransportData
     * Meta informations extracted from the WSDL
     * - documentation: Транспортные средства
     * @var \AisFssp\StructType\TransportDataType
     */
    public $TransportData;
    /**
     * The SvedRabData
     * Meta informations extracted from the WSDL
     * - documentation: Место получения дохода
     * @var \AisFssp\StructType\SvedRabDataType
     */
    public $SvedRabData;
    /**
     * The ManagementData
     * Meta informations extracted from the WSDL
     * - documentation: Должностные лица
     * @var \AisFssp\StructType\ManagementDataType
     */
    public $ManagementData;
    /**
     * The SvedDoxodData
     * Meta informations extracted from the WSDL
     * - documentation: Полученный доход
     * @var \AisFssp\StructType\SvedDoxodDataType
     */
    public $SvedDoxodData;
    /**
     * The DebtorStateData
     * Meta informations extracted from the WSDL
     * - documentation: Статус должника
     * @var \AisFssp\StructType\DebtorStateDataType
     */
    public $DebtorStateData;
    /**
     * The AvailabilityAccData
     * Meta informations extracted from the WSDL
     * - documentation: Наличие денежных средств на счете
     * @var \AisFssp\StructType\AvailabilityAccDataType
     */
    public $AvailabilityAccData;
    /**
     * The AvailabilityAccExtData
     * Meta informations extracted from the WSDL
     * - documentation: Наличие денежных средств на счете
     * @var \AisFssp\StructType\AvailabilityAccExtDataType
     */
    public $AvailabilityAccExtData;
    /**
     * The ArrestRecoveryAmountData
     * Meta informations extracted from the WSDL
     * - documentation: Арестованные и взысканные средства
     * @var \AisFssp\StructType\ArrestRecoveryAmountDataType
     */
    public $ArrestRecoveryAmountData;
    /**
     * The AvailabilityAccDepoData
     * Meta informations extracted from the WSDL
     * - documentation: Наличие счетов ДЕПО
     * @var \AisFssp\StructType\AvailabilityAccDepoDataType
     */
    public $AvailabilityAccDepoData;
    /**
     * The RealtyRegistryExtractData
     * Meta informations extracted from the WSDL
     * - documentation: Выписка из реестра недвижимости
     * @var \AisFssp\StructType\RealtyRegistryExtractType
     */
    public $RealtyRegistryExtractData;
    /**
     * The SvedNedvData
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о недвижимости
     * @var \AisFssp\StructType\SvedNedvDataType
     */
    public $SvedNedvData;
    /**
     * The SvedNedvObject
     * Meta informations extracted from the WSDL
     * - documentation: Сведения об объекте недвижимости
     * @var \AisFssp\StructType\SvedNedvObjectType
     */
    public $SvedNedvObject;
    /**
     * The SvedNedvRightData
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о правах на недвижимость
     * @var \AisFssp\StructType\SvedNedvRightType
     */
    public $SvedNedvRightData;
    /**
     * The SvedNedvEncumbranceData
     * Meta informations extracted from the WSDL
     * - documentation: Сведения об обременениях
     * @var \AisFssp\StructType\SvedNedvEncumbranceType
     */
    public $SvedNedvEncumbranceData;
    /**
     * The SvedNedvShareHoldingData
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о долевом участии
     * @var \AisFssp\StructType\SvedNedvShareHoldingType
     */
    public $SvedNedvShareHoldingData;
    /**
     * The ObjectData
     * Meta informations extracted from the WSDL
     * - documentation: Объекты учета
     * @var \AisFssp\StructType\ObjectDataType
     */
    public $ObjectData;
    /**
     * The KKTData
     * Meta informations extracted from the WSDL
     * - documentation: Наличие ККТ
     * @var \AisFssp\StructType\KKTDataType
     */
    public $KKTData;
    /**
     * The AccountingData
     * Meta informations extracted from the WSDL
     * - documentation: Бухгалтерская отчетность
     * @var \AisFssp\StructType\AccountingDataType
     */
    public $AccountingData;
    /**
     * The TicketDatum
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о передвижении
     * @var \AisFssp\StructType\TicketDatumType
     */
    public $TicketDatum;
    /**
     * The personDatum
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о физическом лице
     * @var \AisFssp\StructType\PersonDatumType
     */
    public $personDatum;
    /**
     * The companyDatum
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о юридическом лице
     * @var \AisFssp\StructType\CompanyDatumType
     */
    public $companyDatum;
    /**
     * The paymentDatum
     * Meta informations extracted from the WSDL
     * - documentation: Сведения об оплате
     * @var \AisFssp\StructType\PaymentDatumType
     */
    public $paymentDatum;
    /**
     * The countDatum
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о количестве сведений
     * @var \AisFssp\StructType\CountDatumType
     */
    public $countDatum;
    /**
     * The companyAddressDatum
     * Meta informations extracted from the WSDL
     * - documentation: Адрес юридического лица
     * - minOccurs: 0
     * @var \AisFssp\StructType\CompanyAddressDatumType
     */
    public $companyAddressDatum;
    /**
     * The regOrganDatum
     * Meta informations extracted from the WSDL
     * - documentation: Регистрирующая организация
     * @var \AisFssp\StructType\RegOrganDatumType
     */
    public $regOrganDatum;
    /**
     * The shipDatum
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о судне
     * @var \AisFssp\StructType\ShipDatumType
     */
    public $shipDatum;
    /**
     * The machineDatum
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о машине
     * @var \AisFssp\StructType\MachineDatumType
     */
    public $machineDatum;
    /**
     * The founderCompanyDatum
     * Meta informations extracted from the WSDL
     * - documentation: Учредитель—юридическое лицо
     * @var \AisFssp\StructType\FounderCompanyDatumType
     */
    public $founderCompanyDatum;
    /**
     * The forgnFndrCompanyDatum
     * Meta informations extracted from the WSDL
     * - documentation: Иностранный учредитель—юр. лицо
     * @var \AisFssp\StructType\ForgnFndrCompanyDatumType
     */
    public $forgnFndrCompanyDatum;
    /**
     * The companyExtDatum
     * Meta informations extracted from the WSDL
     * - documentation: Выписка из ЕГРЮЛ
     * @var \AisFssp\StructType\CompanyExtDatumType
     */
    public $companyExtDatum;
    /**
     * The founderPersonDatum
     * Meta informations extracted from the WSDL
     * - documentation: Учредитель—физическое лицо
     * @var \AisFssp\StructType\FounderPersonDatumType
     */
    public $founderPersonDatum;
    /**
     * The companyManagementDatum
     * Meta informations extracted from the WSDL
     * - documentation: Лица, имеющие право действовать от имени юридического лица
     * @var \AisFssp\StructType\CompanyManagementDatumType
     */
    public $companyManagementDatum;
    /**
     * The soleEntrepreneurDatum
     * Meta informations extracted from the WSDL
     * - documentation: Выписка из ЕГРИП
     * @var \AisFssp\StructType\SoleEntrepreneurDatumType
     */
    public $soleEntrepreneurDatum;
    /**
     * The registrationDatum
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о регистрации
     * @var \AisFssp\StructType\RegistrationDatumType
     */
    public $registrationDatum;
    /**
     * The licenseDatum
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о лицензии
     * @var \AisFssp\StructType\LicenseDatumType
     */
    public $licenseDatum;
    /**
     * The subdivisionDatum
     * Meta informations extracted from the WSDL
     * - documentation: Обособленное подразделение
     * @var \AisFssp\StructType\SubdivisionDatumType
     */
    public $subdivisionDatum;
    /**
     * The egrulEgripDatum
     * Meta informations extracted from the WSDL
     * - documentation: Состояние записи ЕГРЮЛ/ЕГРИП
     * @var \AisFssp\StructType\EgrulEgripDatumType
     */
    public $egrulEgripDatum;
    /**
     * The accountDatum
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о банковском счете
     * @var \AisFssp\StructType\AccountDatumType
     */
    public $accountDatum;
    /**
     * The accountExtDatum
     * Meta informations extracted from the WSDL
     * - documentation: Расширенные сведения о банковском счете
     * @var \AisFssp\StructType\AccountExtDatumType
     */
    public $accountExtDatum;
    /**
     * The soleEntrepreneurOldRegDatum
     * Meta informations extracted from the WSDL
     * - documentation: Регистрация ИП до 2004 г.
     * @var \AisFssp\StructType\SoleEntrepreneurOldRegDatumType
     */
    public $soleEntrepreneurOldRegDatum;
    /**
     * The documentDatum
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о документе
     * @var \AisFssp\StructType\DocumentDatumType
     */
    public $documentDatum;
    /**
     * The fishQuotaContractDatum
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о наличии договора на закрепление долей квот добычи (вылова) биоресурсов
     * @var \AisFssp\StructType\FishQuotaContractDatumType
     */
    public $fishQuotaContractDatum;
    /**
     * The fishQuotaYearDatum
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о наличии квот на вылов биоресурсов на текущий год
     * @var \AisFssp\StructType\FishQuotaCurYearDatumType
     */
    public $fishQuotaYearDatum;
    /**
     * The fishNonquotaContractDatum
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о договорах пользования водными биоресурсами, которые отнесены к объектам рыболовства и общий допустимый улов
     * которых не устанавливается
     * @var \AisFssp\StructType\FishNonquotaContractDatumType
     */
    public $fishNonquotaContractDatum;
    /**
     * The transactionDatum
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о финансовых операциях
     * @var \AisFssp\StructType\TransactionDatumType
     */
    public $transactionDatum;
    /**
     * The deathDatum
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о смерти
     * @var \AisFssp\StructType\DeathDatumType
     */
    public $deathDatum;
    /**
     * The unaccountedForDatum
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о пропавшем без вести
     * @var \AisFssp\StructType\UnaccountedForDatumType
     */
    public $unaccountedForDatum;
    /**
     * The DepositBoxDatum
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о банковских ячейках
     * @var \AisFssp\StructType\DepositBoxDatumType
     */
    public $DepositBoxDatum;
    /**
     * The accountTransactionType
     * Meta informations extracted from the WSDL
     * - documentation: Сведения об операциях по счету
     * @var \AisFssp\StructType\AccountTransactionDatumType
     */
    public $accountTransactionType;
    /**
     * The AccountEncumbranceDatum
     * Meta informations extracted from the WSDL
     * - documentation: Сведения об арестах и обременениях
     * @var \AisFssp\StructType\AccountEncumbranceDatumType
     */
    public $AccountEncumbranceDatum;
    /**
     * The propertyObligationDatum
     * Meta informations extracted from the WSDL
     * - documentation: Сведения об имущественных обязательствах
     * @var \AisFssp\StructType\PropertyObligationDatumType
     */
    public $propertyObligationDatum;
    /**
     * The unstructuredDatum
     * Meta informations extracted from the WSDL
     * - documentation: Неструктурированные сведения
     * @var \AisFssp\StructType\UnstructuredDatumType
     */
    public $unstructuredDatum;
    /**
     * The unemployedPersonCaseDatum
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о личном деле безработного
     * @var \AisFssp\StructType\UnemployedPersonCaseDatumType
     */
    public $unemployedPersonCaseDatum;
    /**
     * The unemployedPersonRegistrationDatum
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о периоде нахождения на регистрационном учете в качестве безработного
     * @var \AisFssp\StructType\UnemployedPersonRegistrationDatumType
     */
    public $unemployedPersonRegistrationDatum;
    /**
     * The seniorityPeriodDatum
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о периоде трудового стажа
     * @var \AisFssp\StructType\SeniorityPeriodDatumType
     */
    public $seniorityPeriodDatum;
    /**
     * The SalaryWithheldDatum
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о начисленном денежном довольствии и произведенных удержаниях
     * @var \AisFssp\StructType\SalaryWithheldDatumType
     */
    public $SalaryWithheldDatum;
    /**
     * The CashLetterDatum
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о начисленном денежном довольствии и произведенных удержаниях
     * @var \AisFssp\StructType\CashLetterDatumType
     */
    public $CashLetterDatum;
    /**
     * The ValidationDatum
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о проверке нотариального документа
     * @var \AisFssp\StructType\ValidationDatumType
     */
    public $ValidationDatum;
    /**
     * The GoodsDatum
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о начисленном денежном довольствии и произведенных удержаниях
     * @var \AisFssp\StructType\GoodsDatumType
     */
    public $GoodsDatum;
    /**
     * The WeaponDatum
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о зарегистрированном оружии
     * @var \AisFssp\StructType\WeaponDatumType
     */
    public $WeaponDatum;
    /**
     * The SentencedPersonImprisonmentDatum
     * Meta informations extracted from the WSDL
     * - documentation: Сведения об отбывании наказания осужденным должником в местах лишения свободы
     * @var \AisFssp\StructType\SentencedPersonImprisonmentType
     */
    public $SentencedPersonImprisonmentDatum;
    /**
     * The SentencedPersonNoImprisonmentDatum
     * Meta informations extracted from the WSDL
     * - documentation: Сведения об отбывании осужденным должником наказания, не связанного с лишением свободы
     * @var \AisFssp\StructType\SentencedPersonNoImprisonmentType
     */
    public $SentencedPersonNoImprisonmentDatum;
    /**
     * The BKIDatum
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о бюро кредитных историй
     * @var \AisFssp\StructType\BKIDatumType
     */
    public $BKIDatum;
    /**
     * Constructor method for Data
     * @uses Data::setIdentificationData()
     * @uses Data::setAddressData()
     * @uses Data::setTelephoneData()
     * @uses Data::setTransportData()
     * @uses Data::setSvedRabData()
     * @uses Data::setManagementData()
     * @uses Data::setSvedDoxodData()
     * @uses Data::setDebtorStateData()
     * @uses Data::setAvailabilityAccData()
     * @uses Data::setAvailabilityAccExtData()
     * @uses Data::setArrestRecoveryAmountData()
     * @uses Data::setAvailabilityAccDepoData()
     * @uses Data::setRealtyRegistryExtractData()
     * @uses Data::setSvedNedvData()
     * @uses Data::setSvedNedvObject()
     * @uses Data::setSvedNedvRightData()
     * @uses Data::setSvedNedvEncumbranceData()
     * @uses Data::setSvedNedvShareHoldingData()
     * @uses Data::setObjectData()
     * @uses Data::setKKTData()
     * @uses Data::setAccountingData()
     * @uses Data::setTicketDatum()
     * @uses Data::setPersonDatum()
     * @uses Data::setCompanyDatum()
     * @uses Data::setPaymentDatum()
     * @uses Data::setCountDatum()
     * @uses Data::setCompanyAddressDatum()
     * @uses Data::setRegOrganDatum()
     * @uses Data::setShipDatum()
     * @uses Data::setMachineDatum()
     * @uses Data::setFounderCompanyDatum()
     * @uses Data::setForgnFndrCompanyDatum()
     * @uses Data::setCompanyExtDatum()
     * @uses Data::setFounderPersonDatum()
     * @uses Data::setCompanyManagementDatum()
     * @uses Data::setSoleEntrepreneurDatum()
     * @uses Data::setRegistrationDatum()
     * @uses Data::setLicenseDatum()
     * @uses Data::setSubdivisionDatum()
     * @uses Data::setEgrulEgripDatum()
     * @uses Data::setAccountDatum()
     * @uses Data::setAccountExtDatum()
     * @uses Data::setSoleEntrepreneurOldRegDatum()
     * @uses Data::setDocumentDatum()
     * @uses Data::setFishQuotaContractDatum()
     * @uses Data::setFishQuotaYearDatum()
     * @uses Data::setFishNonquotaContractDatum()
     * @uses Data::setTransactionDatum()
     * @uses Data::setDeathDatum()
     * @uses Data::setUnaccountedForDatum()
     * @uses Data::setDepositBoxDatum()
     * @uses Data::setAccountTransactionType()
     * @uses Data::setAccountEncumbranceDatum()
     * @uses Data::setPropertyObligationDatum()
     * @uses Data::setUnstructuredDatum()
     * @uses Data::setUnemployedPersonCaseDatum()
     * @uses Data::setUnemployedPersonRegistrationDatum()
     * @uses Data::setSeniorityPeriodDatum()
     * @uses Data::setSalaryWithheldDatum()
     * @uses Data::setCashLetterDatum()
     * @uses Data::setValidationDatum()
     * @uses Data::setGoodsDatum()
     * @uses Data::setWeaponDatum()
     * @uses Data::setSentencedPersonImprisonmentDatum()
     * @uses Data::setSentencedPersonNoImprisonmentDatum()
     * @uses Data::setBKIDatum()
     * @param \AisFssp\StructType\IdentificationDataType $identificationData
     * @param \AisFssp\StructType\AddressDataType $addressData
     * @param \AisFssp\StructType\TelephoneDataType $telephoneData
     * @param \AisFssp\StructType\TransportDataType $transportData
     * @param \AisFssp\StructType\SvedRabDataType $svedRabData
     * @param \AisFssp\StructType\ManagementDataType $managementData
     * @param \AisFssp\StructType\SvedDoxodDataType $svedDoxodData
     * @param \AisFssp\StructType\DebtorStateDataType $debtorStateData
     * @param \AisFssp\StructType\AvailabilityAccDataType $availabilityAccData
     * @param \AisFssp\StructType\AvailabilityAccExtDataType $availabilityAccExtData
     * @param \AisFssp\StructType\ArrestRecoveryAmountDataType $arrestRecoveryAmountData
     * @param \AisFssp\StructType\AvailabilityAccDepoDataType $availabilityAccDepoData
     * @param \AisFssp\StructType\RealtyRegistryExtractType $realtyRegistryExtractData
     * @param \AisFssp\StructType\SvedNedvDataType $svedNedvData
     * @param \AisFssp\StructType\SvedNedvObjectType $svedNedvObject
     * @param \AisFssp\StructType\SvedNedvRightType $svedNedvRightData
     * @param \AisFssp\StructType\SvedNedvEncumbranceType $svedNedvEncumbranceData
     * @param \AisFssp\StructType\SvedNedvShareHoldingType $svedNedvShareHoldingData
     * @param \AisFssp\StructType\ObjectDataType $objectData
     * @param \AisFssp\StructType\KKTDataType $kKTData
     * @param \AisFssp\StructType\AccountingDataType $accountingData
     * @param \AisFssp\StructType\TicketDatumType $ticketDatum
     * @param \AisFssp\StructType\PersonDatumType $personDatum
     * @param \AisFssp\StructType\CompanyDatumType $companyDatum
     * @param \AisFssp\StructType\PaymentDatumType $paymentDatum
     * @param \AisFssp\StructType\CountDatumType $countDatum
     * @param \AisFssp\StructType\CompanyAddressDatumType $companyAddressDatum
     * @param \AisFssp\StructType\RegOrganDatumType $regOrganDatum
     * @param \AisFssp\StructType\ShipDatumType $shipDatum
     * @param \AisFssp\StructType\MachineDatumType $machineDatum
     * @param \AisFssp\StructType\FounderCompanyDatumType $founderCompanyDatum
     * @param \AisFssp\StructType\ForgnFndrCompanyDatumType $forgnFndrCompanyDatum
     * @param \AisFssp\StructType\CompanyExtDatumType $companyExtDatum
     * @param \AisFssp\StructType\FounderPersonDatumType $founderPersonDatum
     * @param \AisFssp\StructType\CompanyManagementDatumType $companyManagementDatum
     * @param \AisFssp\StructType\SoleEntrepreneurDatumType $soleEntrepreneurDatum
     * @param \AisFssp\StructType\RegistrationDatumType $registrationDatum
     * @param \AisFssp\StructType\LicenseDatumType $licenseDatum
     * @param \AisFssp\StructType\SubdivisionDatumType $subdivisionDatum
     * @param \AisFssp\StructType\EgrulEgripDatumType $egrulEgripDatum
     * @param \AisFssp\StructType\AccountDatumType $accountDatum
     * @param \AisFssp\StructType\AccountExtDatumType $accountExtDatum
     * @param \AisFssp\StructType\SoleEntrepreneurOldRegDatumType $soleEntrepreneurOldRegDatum
     * @param \AisFssp\StructType\DocumentDatumType $documentDatum
     * @param \AisFssp\StructType\FishQuotaContractDatumType $fishQuotaContractDatum
     * @param \AisFssp\StructType\FishQuotaCurYearDatumType $fishQuotaYearDatum
     * @param \AisFssp\StructType\FishNonquotaContractDatumType $fishNonquotaContractDatum
     * @param \AisFssp\StructType\TransactionDatumType $transactionDatum
     * @param \AisFssp\StructType\DeathDatumType $deathDatum
     * @param \AisFssp\StructType\UnaccountedForDatumType $unaccountedForDatum
     * @param \AisFssp\StructType\DepositBoxDatumType $depositBoxDatum
     * @param \AisFssp\StructType\AccountTransactionDatumType $accountTransactionType
     * @param \AisFssp\StructType\AccountEncumbranceDatumType $accountEncumbranceDatum
     * @param \AisFssp\StructType\PropertyObligationDatumType $propertyObligationDatum
     * @param \AisFssp\StructType\UnstructuredDatumType $unstructuredDatum
     * @param \AisFssp\StructType\UnemployedPersonCaseDatumType $unemployedPersonCaseDatum
     * @param \AisFssp\StructType\UnemployedPersonRegistrationDatumType $unemployedPersonRegistrationDatum
     * @param \AisFssp\StructType\SeniorityPeriodDatumType $seniorityPeriodDatum
     * @param \AisFssp\StructType\SalaryWithheldDatumType $salaryWithheldDatum
     * @param \AisFssp\StructType\CashLetterDatumType $cashLetterDatum
     * @param \AisFssp\StructType\ValidationDatumType $validationDatum
     * @param \AisFssp\StructType\GoodsDatumType $goodsDatum
     * @param \AisFssp\StructType\WeaponDatumType $weaponDatum
     * @param \AisFssp\StructType\SentencedPersonImprisonmentType $sentencedPersonImprisonmentDatum
     * @param \AisFssp\StructType\SentencedPersonNoImprisonmentType $sentencedPersonNoImprisonmentDatum
     * @param \AisFssp\StructType\BKIDatumType $bKIDatum
     */
    public function __construct(\AisFssp\StructType\IdentificationDataType $identificationData = null, \AisFssp\StructType\AddressDataType $addressData = null, \AisFssp\StructType\TelephoneDataType $telephoneData = null, \AisFssp\StructType\TransportDataType $transportData = null, \AisFssp\StructType\SvedRabDataType $svedRabData = null, \AisFssp\StructType\ManagementDataType $managementData = null, \AisFssp\StructType\SvedDoxodDataType $svedDoxodData = null, \AisFssp\StructType\DebtorStateDataType $debtorStateData = null, \AisFssp\StructType\AvailabilityAccDataType $availabilityAccData = null, \AisFssp\StructType\AvailabilityAccExtDataType $availabilityAccExtData = null, \AisFssp\StructType\ArrestRecoveryAmountDataType $arrestRecoveryAmountData = null, \AisFssp\StructType\AvailabilityAccDepoDataType $availabilityAccDepoData = null, \AisFssp\StructType\RealtyRegistryExtractType $realtyRegistryExtractData = null, \AisFssp\StructType\SvedNedvDataType $svedNedvData = null, \AisFssp\StructType\SvedNedvObjectType $svedNedvObject = null, \AisFssp\StructType\SvedNedvRightType $svedNedvRightData = null, \AisFssp\StructType\SvedNedvEncumbranceType $svedNedvEncumbranceData = null, \AisFssp\StructType\SvedNedvShareHoldingType $svedNedvShareHoldingData = null, \AisFssp\StructType\ObjectDataType $objectData = null, \AisFssp\StructType\KKTDataType $kKTData = null, \AisFssp\StructType\AccountingDataType $accountingData = null, \AisFssp\StructType\TicketDatumType $ticketDatum = null, \AisFssp\StructType\PersonDatumType $personDatum = null, \AisFssp\StructType\CompanyDatumType $companyDatum = null, \AisFssp\StructType\PaymentDatumType $paymentDatum = null, \AisFssp\StructType\CountDatumType $countDatum = null, \AisFssp\StructType\CompanyAddressDatumType $companyAddressDatum = null, \AisFssp\StructType\RegOrganDatumType $regOrganDatum = null, \AisFssp\StructType\ShipDatumType $shipDatum = null, \AisFssp\StructType\MachineDatumType $machineDatum = null, \AisFssp\StructType\FounderCompanyDatumType $founderCompanyDatum = null, \AisFssp\StructType\ForgnFndrCompanyDatumType $forgnFndrCompanyDatum = null, \AisFssp\StructType\CompanyExtDatumType $companyExtDatum = null, \AisFssp\StructType\FounderPersonDatumType $founderPersonDatum = null, \AisFssp\StructType\CompanyManagementDatumType $companyManagementDatum = null, \AisFssp\StructType\SoleEntrepreneurDatumType $soleEntrepreneurDatum = null, \AisFssp\StructType\RegistrationDatumType $registrationDatum = null, \AisFssp\StructType\LicenseDatumType $licenseDatum = null, \AisFssp\StructType\SubdivisionDatumType $subdivisionDatum = null, \AisFssp\StructType\EgrulEgripDatumType $egrulEgripDatum = null, \AisFssp\StructType\AccountDatumType $accountDatum = null, \AisFssp\StructType\AccountExtDatumType $accountExtDatum = null, \AisFssp\StructType\SoleEntrepreneurOldRegDatumType $soleEntrepreneurOldRegDatum = null, \AisFssp\StructType\DocumentDatumType $documentDatum = null, \AisFssp\StructType\FishQuotaContractDatumType $fishQuotaContractDatum = null, \AisFssp\StructType\FishQuotaCurYearDatumType $fishQuotaYearDatum = null, \AisFssp\StructType\FishNonquotaContractDatumType $fishNonquotaContractDatum = null, \AisFssp\StructType\TransactionDatumType $transactionDatum = null, \AisFssp\StructType\DeathDatumType $deathDatum = null, \AisFssp\StructType\UnaccountedForDatumType $unaccountedForDatum = null, \AisFssp\StructType\DepositBoxDatumType $depositBoxDatum = null, \AisFssp\StructType\AccountTransactionDatumType $accountTransactionType = null, \AisFssp\StructType\AccountEncumbranceDatumType $accountEncumbranceDatum = null, \AisFssp\StructType\PropertyObligationDatumType $propertyObligationDatum = null, \AisFssp\StructType\UnstructuredDatumType $unstructuredDatum = null, \AisFssp\StructType\UnemployedPersonCaseDatumType $unemployedPersonCaseDatum = null, \AisFssp\StructType\UnemployedPersonRegistrationDatumType $unemployedPersonRegistrationDatum = null, \AisFssp\StructType\SeniorityPeriodDatumType $seniorityPeriodDatum = null, \AisFssp\StructType\SalaryWithheldDatumType $salaryWithheldDatum = null, \AisFssp\StructType\CashLetterDatumType $cashLetterDatum = null, \AisFssp\StructType\ValidationDatumType $validationDatum = null, \AisFssp\StructType\GoodsDatumType $goodsDatum = null, \AisFssp\StructType\WeaponDatumType $weaponDatum = null, \AisFssp\StructType\SentencedPersonImprisonmentType $sentencedPersonImprisonmentDatum = null, \AisFssp\StructType\SentencedPersonNoImprisonmentType $sentencedPersonNoImprisonmentDatum = null, \AisFssp\StructType\BKIDatumType $bKIDatum = null)
    {
        $this
            ->setIdentificationData($identificationData)
            ->setAddressData($addressData)
            ->setTelephoneData($telephoneData)
            ->setTransportData($transportData)
            ->setSvedRabData($svedRabData)
            ->setManagementData($managementData)
            ->setSvedDoxodData($svedDoxodData)
            ->setDebtorStateData($debtorStateData)
            ->setAvailabilityAccData($availabilityAccData)
            ->setAvailabilityAccExtData($availabilityAccExtData)
            ->setArrestRecoveryAmountData($arrestRecoveryAmountData)
            ->setAvailabilityAccDepoData($availabilityAccDepoData)
            ->setRealtyRegistryExtractData($realtyRegistryExtractData)
            ->setSvedNedvData($svedNedvData)
            ->setSvedNedvObject($svedNedvObject)
            ->setSvedNedvRightData($svedNedvRightData)
            ->setSvedNedvEncumbranceData($svedNedvEncumbranceData)
            ->setSvedNedvShareHoldingData($svedNedvShareHoldingData)
            ->setObjectData($objectData)
            ->setKKTData($kKTData)
            ->setAccountingData($accountingData)
            ->setTicketDatum($ticketDatum)
            ->setPersonDatum($personDatum)
            ->setCompanyDatum($companyDatum)
            ->setPaymentDatum($paymentDatum)
            ->setCountDatum($countDatum)
            ->setCompanyAddressDatum($companyAddressDatum)
            ->setRegOrganDatum($regOrganDatum)
            ->setShipDatum($shipDatum)
            ->setMachineDatum($machineDatum)
            ->setFounderCompanyDatum($founderCompanyDatum)
            ->setForgnFndrCompanyDatum($forgnFndrCompanyDatum)
            ->setCompanyExtDatum($companyExtDatum)
            ->setFounderPersonDatum($founderPersonDatum)
            ->setCompanyManagementDatum($companyManagementDatum)
            ->setSoleEntrepreneurDatum($soleEntrepreneurDatum)
            ->setRegistrationDatum($registrationDatum)
            ->setLicenseDatum($licenseDatum)
            ->setSubdivisionDatum($subdivisionDatum)
            ->setEgrulEgripDatum($egrulEgripDatum)
            ->setAccountDatum($accountDatum)
            ->setAccountExtDatum($accountExtDatum)
            ->setSoleEntrepreneurOldRegDatum($soleEntrepreneurOldRegDatum)
            ->setDocumentDatum($documentDatum)
            ->setFishQuotaContractDatum($fishQuotaContractDatum)
            ->setFishQuotaYearDatum($fishQuotaYearDatum)
            ->setFishNonquotaContractDatum($fishNonquotaContractDatum)
            ->setTransactionDatum($transactionDatum)
            ->setDeathDatum($deathDatum)
            ->setUnaccountedForDatum($unaccountedForDatum)
            ->setDepositBoxDatum($depositBoxDatum)
            ->setAccountTransactionType($accountTransactionType)
            ->setAccountEncumbranceDatum($accountEncumbranceDatum)
            ->setPropertyObligationDatum($propertyObligationDatum)
            ->setUnstructuredDatum($unstructuredDatum)
            ->setUnemployedPersonCaseDatum($unemployedPersonCaseDatum)
            ->setUnemployedPersonRegistrationDatum($unemployedPersonRegistrationDatum)
            ->setSeniorityPeriodDatum($seniorityPeriodDatum)
            ->setSalaryWithheldDatum($salaryWithheldDatum)
            ->setCashLetterDatum($cashLetterDatum)
            ->setValidationDatum($validationDatum)
            ->setGoodsDatum($goodsDatum)
            ->setWeaponDatum($weaponDatum)
            ->setSentencedPersonImprisonmentDatum($sentencedPersonImprisonmentDatum)
            ->setSentencedPersonNoImprisonmentDatum($sentencedPersonNoImprisonmentDatum)
            ->setBKIDatum($bKIDatum);
    }
    /**
     * Get IdentificationData value
     * @return \AisFssp\StructType\IdentificationDataType|null
     */
    public function getIdentificationData()
    {
        return $this->IdentificationData;
    }
    /**
     * Set IdentificationData value
     * @param \AisFssp\StructType\IdentificationDataType $identificationData
     * @return \AisFssp\StructType\Data
     */
    public function setIdentificationData(\AisFssp\StructType\IdentificationDataType $identificationData = null)
    {
        $this->IdentificationData = $identificationData;
        return $this;
    }
    /**
     * Get AddressData value
     * @return \AisFssp\StructType\AddressDataType|null
     */
    public function getAddressData()
    {
        return $this->AddressData;
    }
    /**
     * Set AddressData value
     * @param \AisFssp\StructType\AddressDataType $addressData
     * @return \AisFssp\StructType\Data
     */
    public function setAddressData(\AisFssp\StructType\AddressDataType $addressData = null)
    {
        $this->AddressData = $addressData;
        return $this;
    }
    /**
     * Get TelephoneData value
     * @return \AisFssp\StructType\TelephoneDataType|null
     */
    public function getTelephoneData()
    {
        return $this->TelephoneData;
    }
    /**
     * Set TelephoneData value
     * @param \AisFssp\StructType\TelephoneDataType $telephoneData
     * @return \AisFssp\StructType\Data
     */
    public function setTelephoneData(\AisFssp\StructType\TelephoneDataType $telephoneData = null)
    {
        $this->TelephoneData = $telephoneData;
        return $this;
    }
    /**
     * Get TransportData value
     * @return \AisFssp\StructType\TransportDataType|null
     */
    public function getTransportData()
    {
        return $this->TransportData;
    }
    /**
     * Set TransportData value
     * @param \AisFssp\StructType\TransportDataType $transportData
     * @return \AisFssp\StructType\Data
     */
    public function setTransportData(\AisFssp\StructType\TransportDataType $transportData = null)
    {
        $this->TransportData = $transportData;
        return $this;
    }
    /**
     * Get SvedRabData value
     * @return \AisFssp\StructType\SvedRabDataType|null
     */
    public function getSvedRabData()
    {
        return $this->SvedRabData;
    }
    /**
     * Set SvedRabData value
     * @param \AisFssp\StructType\SvedRabDataType $svedRabData
     * @return \AisFssp\StructType\Data
     */
    public function setSvedRabData(\AisFssp\StructType\SvedRabDataType $svedRabData = null)
    {
        $this->SvedRabData = $svedRabData;
        return $this;
    }
    /**
     * Get ManagementData value
     * @return \AisFssp\StructType\ManagementDataType|null
     */
    public function getManagementData()
    {
        return $this->ManagementData;
    }
    /**
     * Set ManagementData value
     * @param \AisFssp\StructType\ManagementDataType $managementData
     * @return \AisFssp\StructType\Data
     */
    public function setManagementData(\AisFssp\StructType\ManagementDataType $managementData = null)
    {
        $this->ManagementData = $managementData;
        return $this;
    }
    /**
     * Get SvedDoxodData value
     * @return \AisFssp\StructType\SvedDoxodDataType|null
     */
    public function getSvedDoxodData()
    {
        return $this->SvedDoxodData;
    }
    /**
     * Set SvedDoxodData value
     * @param \AisFssp\StructType\SvedDoxodDataType $svedDoxodData
     * @return \AisFssp\StructType\Data
     */
    public function setSvedDoxodData(\AisFssp\StructType\SvedDoxodDataType $svedDoxodData = null)
    {
        $this->SvedDoxodData = $svedDoxodData;
        return $this;
    }
    /**
     * Get DebtorStateData value
     * @return \AisFssp\StructType\DebtorStateDataType|null
     */
    public function getDebtorStateData()
    {
        return $this->DebtorStateData;
    }
    /**
     * Set DebtorStateData value
     * @param \AisFssp\StructType\DebtorStateDataType $debtorStateData
     * @return \AisFssp\StructType\Data
     */
    public function setDebtorStateData(\AisFssp\StructType\DebtorStateDataType $debtorStateData = null)
    {
        $this->DebtorStateData = $debtorStateData;
        return $this;
    }
    /**
     * Get AvailabilityAccData value
     * @return \AisFssp\StructType\AvailabilityAccDataType|null
     */
    public function getAvailabilityAccData()
    {
        return $this->AvailabilityAccData;
    }
    /**
     * Set AvailabilityAccData value
     * @param \AisFssp\StructType\AvailabilityAccDataType $availabilityAccData
     * @return \AisFssp\StructType\Data
     */
    public function setAvailabilityAccData(\AisFssp\StructType\AvailabilityAccDataType $availabilityAccData = null)
    {
        $this->AvailabilityAccData = $availabilityAccData;
        return $this;
    }
    /**
     * Get AvailabilityAccExtData value
     * @return \AisFssp\StructType\AvailabilityAccExtDataType|null
     */
    public function getAvailabilityAccExtData()
    {
        return $this->AvailabilityAccExtData;
    }
    /**
     * Set AvailabilityAccExtData value
     * @param \AisFssp\StructType\AvailabilityAccExtDataType $availabilityAccExtData
     * @return \AisFssp\StructType\Data
     */
    public function setAvailabilityAccExtData(\AisFssp\StructType\AvailabilityAccExtDataType $availabilityAccExtData = null)
    {
        $this->AvailabilityAccExtData = $availabilityAccExtData;
        return $this;
    }
    /**
     * Get ArrestRecoveryAmountData value
     * @return \AisFssp\StructType\ArrestRecoveryAmountDataType|null
     */
    public function getArrestRecoveryAmountData()
    {
        return $this->ArrestRecoveryAmountData;
    }
    /**
     * Set ArrestRecoveryAmountData value
     * @param \AisFssp\StructType\ArrestRecoveryAmountDataType $arrestRecoveryAmountData
     * @return \AisFssp\StructType\Data
     */
    public function setArrestRecoveryAmountData(\AisFssp\StructType\ArrestRecoveryAmountDataType $arrestRecoveryAmountData = null)
    {
        $this->ArrestRecoveryAmountData = $arrestRecoveryAmountData;
        return $this;
    }
    /**
     * Get AvailabilityAccDepoData value
     * @return \AisFssp\StructType\AvailabilityAccDepoDataType|null
     */
    public function getAvailabilityAccDepoData()
    {
        return $this->AvailabilityAccDepoData;
    }
    /**
     * Set AvailabilityAccDepoData value
     * @param \AisFssp\StructType\AvailabilityAccDepoDataType $availabilityAccDepoData
     * @return \AisFssp\StructType\Data
     */
    public function setAvailabilityAccDepoData(\AisFssp\StructType\AvailabilityAccDepoDataType $availabilityAccDepoData = null)
    {
        $this->AvailabilityAccDepoData = $availabilityAccDepoData;
        return $this;
    }
    /**
     * Get RealtyRegistryExtractData value
     * @return \AisFssp\StructType\RealtyRegistryExtractType|null
     */
    public function getRealtyRegistryExtractData()
    {
        return $this->RealtyRegistryExtractData;
    }
    /**
     * Set RealtyRegistryExtractData value
     * @param \AisFssp\StructType\RealtyRegistryExtractType $realtyRegistryExtractData
     * @return \AisFssp\StructType\Data
     */
    public function setRealtyRegistryExtractData(\AisFssp\StructType\RealtyRegistryExtractType $realtyRegistryExtractData = null)
    {
        $this->RealtyRegistryExtractData = $realtyRegistryExtractData;
        return $this;
    }
    /**
     * Get SvedNedvData value
     * @return \AisFssp\StructType\SvedNedvDataType|null
     */
    public function getSvedNedvData()
    {
        return $this->SvedNedvData;
    }
    /**
     * Set SvedNedvData value
     * @param \AisFssp\StructType\SvedNedvDataType $svedNedvData
     * @return \AisFssp\StructType\Data
     */
    public function setSvedNedvData(\AisFssp\StructType\SvedNedvDataType $svedNedvData = null)
    {
        $this->SvedNedvData = $svedNedvData;
        return $this;
    }
    /**
     * Get SvedNedvObject value
     * @return \AisFssp\StructType\SvedNedvObjectType|null
     */
    public function getSvedNedvObject()
    {
        return $this->SvedNedvObject;
    }
    /**
     * Set SvedNedvObject value
     * @param \AisFssp\StructType\SvedNedvObjectType $svedNedvObject
     * @return \AisFssp\StructType\Data
     */
    public function setSvedNedvObject(\AisFssp\StructType\SvedNedvObjectType $svedNedvObject = null)
    {
        $this->SvedNedvObject = $svedNedvObject;
        return $this;
    }
    /**
     * Get SvedNedvRightData value
     * @return \AisFssp\StructType\SvedNedvRightType|null
     */
    public function getSvedNedvRightData()
    {
        return $this->SvedNedvRightData;
    }
    /**
     * Set SvedNedvRightData value
     * @param \AisFssp\StructType\SvedNedvRightType $svedNedvRightData
     * @return \AisFssp\StructType\Data
     */
    public function setSvedNedvRightData(\AisFssp\StructType\SvedNedvRightType $svedNedvRightData = null)
    {
        $this->SvedNedvRightData = $svedNedvRightData;
        return $this;
    }
    /**
     * Get SvedNedvEncumbranceData value
     * @return \AisFssp\StructType\SvedNedvEncumbranceType|null
     */
    public function getSvedNedvEncumbranceData()
    {
        return $this->SvedNedvEncumbranceData;
    }
    /**
     * Set SvedNedvEncumbranceData value
     * @param \AisFssp\StructType\SvedNedvEncumbranceType $svedNedvEncumbranceData
     * @return \AisFssp\StructType\Data
     */
    public function setSvedNedvEncumbranceData(\AisFssp\StructType\SvedNedvEncumbranceType $svedNedvEncumbranceData = null)
    {
        $this->SvedNedvEncumbranceData = $svedNedvEncumbranceData;
        return $this;
    }
    /**
     * Get SvedNedvShareHoldingData value
     * @return \AisFssp\StructType\SvedNedvShareHoldingType|null
     */
    public function getSvedNedvShareHoldingData()
    {
        return $this->SvedNedvShareHoldingData;
    }
    /**
     * Set SvedNedvShareHoldingData value
     * @param \AisFssp\StructType\SvedNedvShareHoldingType $svedNedvShareHoldingData
     * @return \AisFssp\StructType\Data
     */
    public function setSvedNedvShareHoldingData(\AisFssp\StructType\SvedNedvShareHoldingType $svedNedvShareHoldingData = null)
    {
        $this->SvedNedvShareHoldingData = $svedNedvShareHoldingData;
        return $this;
    }
    /**
     * Get ObjectData value
     * @return \AisFssp\StructType\ObjectDataType|null
     */
    public function getObjectData()
    {
        return $this->ObjectData;
    }
    /**
     * Set ObjectData value
     * @param \AisFssp\StructType\ObjectDataType $objectData
     * @return \AisFssp\StructType\Data
     */
    public function setObjectData(\AisFssp\StructType\ObjectDataType $objectData = null)
    {
        $this->ObjectData = $objectData;
        return $this;
    }
    /**
     * Get KKTData value
     * @return \AisFssp\StructType\KKTDataType|null
     */
    public function getKKTData()
    {
        return $this->KKTData;
    }
    /**
     * Set KKTData value
     * @param \AisFssp\StructType\KKTDataType $kKTData
     * @return \AisFssp\StructType\Data
     */
    public function setKKTData(\AisFssp\StructType\KKTDataType $kKTData = null)
    {
        $this->KKTData = $kKTData;
        return $this;
    }
    /**
     * Get AccountingData value
     * @return \AisFssp\StructType\AccountingDataType|null
     */
    public function getAccountingData()
    {
        return $this->AccountingData;
    }
    /**
     * Set AccountingData value
     * @param \AisFssp\StructType\AccountingDataType $accountingData
     * @return \AisFssp\StructType\Data
     */
    public function setAccountingData(\AisFssp\StructType\AccountingDataType $accountingData = null)
    {
        $this->AccountingData = $accountingData;
        return $this;
    }
    /**
     * Get TicketDatum value
     * @return \AisFssp\StructType\TicketDatumType|null
     */
    public function getTicketDatum()
    {
        return $this->TicketDatum;
    }
    /**
     * Set TicketDatum value
     * @param \AisFssp\StructType\TicketDatumType $ticketDatum
     * @return \AisFssp\StructType\Data
     */
    public function setTicketDatum(\AisFssp\StructType\TicketDatumType $ticketDatum = null)
    {
        $this->TicketDatum = $ticketDatum;
        return $this;
    }
    /**
     * Get personDatum value
     * @return \AisFssp\StructType\PersonDatumType|null
     */
    public function getPersonDatum()
    {
        return $this->personDatum;
    }
    /**
     * Set personDatum value
     * @param \AisFssp\StructType\PersonDatumType $personDatum
     * @return \AisFssp\StructType\Data
     */
    public function setPersonDatum(\AisFssp\StructType\PersonDatumType $personDatum = null)
    {
        $this->personDatum = $personDatum;
        return $this;
    }
    /**
     * Get companyDatum value
     * @return \AisFssp\StructType\CompanyDatumType|null
     */
    public function getCompanyDatum()
    {
        return $this->companyDatum;
    }
    /**
     * Set companyDatum value
     * @param \AisFssp\StructType\CompanyDatumType $companyDatum
     * @return \AisFssp\StructType\Data
     */
    public function setCompanyDatum(\AisFssp\StructType\CompanyDatumType $companyDatum = null)
    {
        $this->companyDatum = $companyDatum;
        return $this;
    }
    /**
     * Get paymentDatum value
     * @return \AisFssp\StructType\PaymentDatumType|null
     */
    public function getPaymentDatum()
    {
        return $this->paymentDatum;
    }
    /**
     * Set paymentDatum value
     * @param \AisFssp\StructType\PaymentDatumType $paymentDatum
     * @return \AisFssp\StructType\Data
     */
    public function setPaymentDatum(\AisFssp\StructType\PaymentDatumType $paymentDatum = null)
    {
        $this->paymentDatum = $paymentDatum;
        return $this;
    }
    /**
     * Get countDatum value
     * @return \AisFssp\StructType\CountDatumType|null
     */
    public function getCountDatum()
    {
        return $this->countDatum;
    }
    /**
     * Set countDatum value
     * @param \AisFssp\StructType\CountDatumType $countDatum
     * @return \AisFssp\StructType\Data
     */
    public function setCountDatum(\AisFssp\StructType\CountDatumType $countDatum = null)
    {
        $this->countDatum = $countDatum;
        return $this;
    }
    /**
     * Get companyAddressDatum value
     * @return \AisFssp\StructType\CompanyAddressDatumType|null
     */
    public function getCompanyAddressDatum()
    {
        return $this->companyAddressDatum;
    }
    /**
     * Set companyAddressDatum value
     * @param \AisFssp\StructType\CompanyAddressDatumType $companyAddressDatum
     * @return \AisFssp\StructType\Data
     */
    public function setCompanyAddressDatum(\AisFssp\StructType\CompanyAddressDatumType $companyAddressDatum = null)
    {
        $this->companyAddressDatum = $companyAddressDatum;
        return $this;
    }
    /**
     * Get regOrganDatum value
     * @return \AisFssp\StructType\RegOrganDatumType|null
     */
    public function getRegOrganDatum()
    {
        return $this->regOrganDatum;
    }
    /**
     * Set regOrganDatum value
     * @param \AisFssp\StructType\RegOrganDatumType $regOrganDatum
     * @return \AisFssp\StructType\Data
     */
    public function setRegOrganDatum(\AisFssp\StructType\RegOrganDatumType $regOrganDatum = null)
    {
        $this->regOrganDatum = $regOrganDatum;
        return $this;
    }
    /**
     * Get shipDatum value
     * @return \AisFssp\StructType\ShipDatumType|null
     */
    public function getShipDatum()
    {
        return $this->shipDatum;
    }
    /**
     * Set shipDatum value
     * @param \AisFssp\StructType\ShipDatumType $shipDatum
     * @return \AisFssp\StructType\Data
     */
    public function setShipDatum(\AisFssp\StructType\ShipDatumType $shipDatum = null)
    {
        $this->shipDatum = $shipDatum;
        return $this;
    }
    /**
     * Get machineDatum value
     * @return \AisFssp\StructType\MachineDatumType|null
     */
    public function getMachineDatum()
    {
        return $this->machineDatum;
    }
    /**
     * Set machineDatum value
     * @param \AisFssp\StructType\MachineDatumType $machineDatum
     * @return \AisFssp\StructType\Data
     */
    public function setMachineDatum(\AisFssp\StructType\MachineDatumType $machineDatum = null)
    {
        $this->machineDatum = $machineDatum;
        return $this;
    }
    /**
     * Get founderCompanyDatum value
     * @return \AisFssp\StructType\FounderCompanyDatumType|null
     */
    public function getFounderCompanyDatum()
    {
        return $this->founderCompanyDatum;
    }
    /**
     * Set founderCompanyDatum value
     * @param \AisFssp\StructType\FounderCompanyDatumType $founderCompanyDatum
     * @return \AisFssp\StructType\Data
     */
    public function setFounderCompanyDatum(\AisFssp\StructType\FounderCompanyDatumType $founderCompanyDatum = null)
    {
        $this->founderCompanyDatum = $founderCompanyDatum;
        return $this;
    }
    /**
     * Get forgnFndrCompanyDatum value
     * @return \AisFssp\StructType\ForgnFndrCompanyDatumType|null
     */
    public function getForgnFndrCompanyDatum()
    {
        return $this->forgnFndrCompanyDatum;
    }
    /**
     * Set forgnFndrCompanyDatum value
     * @param \AisFssp\StructType\ForgnFndrCompanyDatumType $forgnFndrCompanyDatum
     * @return \AisFssp\StructType\Data
     */
    public function setForgnFndrCompanyDatum(\AisFssp\StructType\ForgnFndrCompanyDatumType $forgnFndrCompanyDatum = null)
    {
        $this->forgnFndrCompanyDatum = $forgnFndrCompanyDatum;
        return $this;
    }
    /**
     * Get companyExtDatum value
     * @return \AisFssp\StructType\CompanyExtDatumType|null
     */
    public function getCompanyExtDatum()
    {
        return $this->companyExtDatum;
    }
    /**
     * Set companyExtDatum value
     * @param \AisFssp\StructType\CompanyExtDatumType $companyExtDatum
     * @return \AisFssp\StructType\Data
     */
    public function setCompanyExtDatum(\AisFssp\StructType\CompanyExtDatumType $companyExtDatum = null)
    {
        $this->companyExtDatum = $companyExtDatum;
        return $this;
    }
    /**
     * Get founderPersonDatum value
     * @return \AisFssp\StructType\FounderPersonDatumType|null
     */
    public function getFounderPersonDatum()
    {
        return $this->founderPersonDatum;
    }
    /**
     * Set founderPersonDatum value
     * @param \AisFssp\StructType\FounderPersonDatumType $founderPersonDatum
     * @return \AisFssp\StructType\Data
     */
    public function setFounderPersonDatum(\AisFssp\StructType\FounderPersonDatumType $founderPersonDatum = null)
    {
        $this->founderPersonDatum = $founderPersonDatum;
        return $this;
    }
    /**
     * Get companyManagementDatum value
     * @return \AisFssp\StructType\CompanyManagementDatumType|null
     */
    public function getCompanyManagementDatum()
    {
        return $this->companyManagementDatum;
    }
    /**
     * Set companyManagementDatum value
     * @param \AisFssp\StructType\CompanyManagementDatumType $companyManagementDatum
     * @return \AisFssp\StructType\Data
     */
    public function setCompanyManagementDatum(\AisFssp\StructType\CompanyManagementDatumType $companyManagementDatum = null)
    {
        $this->companyManagementDatum = $companyManagementDatum;
        return $this;
    }
    /**
     * Get soleEntrepreneurDatum value
     * @return \AisFssp\StructType\SoleEntrepreneurDatumType|null
     */
    public function getSoleEntrepreneurDatum()
    {
        return $this->soleEntrepreneurDatum;
    }
    /**
     * Set soleEntrepreneurDatum value
     * @param \AisFssp\StructType\SoleEntrepreneurDatumType $soleEntrepreneurDatum
     * @return \AisFssp\StructType\Data
     */
    public function setSoleEntrepreneurDatum(\AisFssp\StructType\SoleEntrepreneurDatumType $soleEntrepreneurDatum = null)
    {
        $this->soleEntrepreneurDatum = $soleEntrepreneurDatum;
        return $this;
    }
    /**
     * Get registrationDatum value
     * @return \AisFssp\StructType\RegistrationDatumType|null
     */
    public function getRegistrationDatum()
    {
        return $this->registrationDatum;
    }
    /**
     * Set registrationDatum value
     * @param \AisFssp\StructType\RegistrationDatumType $registrationDatum
     * @return \AisFssp\StructType\Data
     */
    public function setRegistrationDatum(\AisFssp\StructType\RegistrationDatumType $registrationDatum = null)
    {
        $this->registrationDatum = $registrationDatum;
        return $this;
    }
    /**
     * Get licenseDatum value
     * @return \AisFssp\StructType\LicenseDatumType|null
     */
    public function getLicenseDatum()
    {
        return $this->licenseDatum;
    }
    /**
     * Set licenseDatum value
     * @param \AisFssp\StructType\LicenseDatumType $licenseDatum
     * @return \AisFssp\StructType\Data
     */
    public function setLicenseDatum(\AisFssp\StructType\LicenseDatumType $licenseDatum = null)
    {
        $this->licenseDatum = $licenseDatum;
        return $this;
    }
    /**
     * Get subdivisionDatum value
     * @return \AisFssp\StructType\SubdivisionDatumType|null
     */
    public function getSubdivisionDatum()
    {
        return $this->subdivisionDatum;
    }
    /**
     * Set subdivisionDatum value
     * @param \AisFssp\StructType\SubdivisionDatumType $subdivisionDatum
     * @return \AisFssp\StructType\Data
     */
    public function setSubdivisionDatum(\AisFssp\StructType\SubdivisionDatumType $subdivisionDatum = null)
    {
        $this->subdivisionDatum = $subdivisionDatum;
        return $this;
    }
    /**
     * Get egrulEgripDatum value
     * @return \AisFssp\StructType\EgrulEgripDatumType|null
     */
    public function getEgrulEgripDatum()
    {
        return $this->egrulEgripDatum;
    }
    /**
     * Set egrulEgripDatum value
     * @param \AisFssp\StructType\EgrulEgripDatumType $egrulEgripDatum
     * @return \AisFssp\StructType\Data
     */
    public function setEgrulEgripDatum(\AisFssp\StructType\EgrulEgripDatumType $egrulEgripDatum = null)
    {
        $this->egrulEgripDatum = $egrulEgripDatum;
        return $this;
    }
    /**
     * Get accountDatum value
     * @return \AisFssp\StructType\AccountDatumType|null
     */
    public function getAccountDatum()
    {
        return $this->accountDatum;
    }
    /**
     * Set accountDatum value
     * @param \AisFssp\StructType\AccountDatumType $accountDatum
     * @return \AisFssp\StructType\Data
     */
    public function setAccountDatum(\AisFssp\StructType\AccountDatumType $accountDatum = null)
    {
        $this->accountDatum = $accountDatum;
        return $this;
    }
    /**
     * Get accountExtDatum value
     * @return \AisFssp\StructType\AccountExtDatumType|null
     */
    public function getAccountExtDatum()
    {
        return $this->accountExtDatum;
    }
    /**
     * Set accountExtDatum value
     * @param \AisFssp\StructType\AccountExtDatumType $accountExtDatum
     * @return \AisFssp\StructType\Data
     */
    public function setAccountExtDatum(\AisFssp\StructType\AccountExtDatumType $accountExtDatum = null)
    {
        $this->accountExtDatum = $accountExtDatum;
        return $this;
    }
    /**
     * Get soleEntrepreneurOldRegDatum value
     * @return \AisFssp\StructType\SoleEntrepreneurOldRegDatumType|null
     */
    public function getSoleEntrepreneurOldRegDatum()
    {
        return $this->soleEntrepreneurOldRegDatum;
    }
    /**
     * Set soleEntrepreneurOldRegDatum value
     * @param \AisFssp\StructType\SoleEntrepreneurOldRegDatumType $soleEntrepreneurOldRegDatum
     * @return \AisFssp\StructType\Data
     */
    public function setSoleEntrepreneurOldRegDatum(\AisFssp\StructType\SoleEntrepreneurOldRegDatumType $soleEntrepreneurOldRegDatum = null)
    {
        $this->soleEntrepreneurOldRegDatum = $soleEntrepreneurOldRegDatum;
        return $this;
    }
    /**
     * Get documentDatum value
     * @return \AisFssp\StructType\DocumentDatumType|null
     */
    public function getDocumentDatum()
    {
        return $this->documentDatum;
    }
    /**
     * Set documentDatum value
     * @param \AisFssp\StructType\DocumentDatumType $documentDatum
     * @return \AisFssp\StructType\Data
     */
    public function setDocumentDatum(\AisFssp\StructType\DocumentDatumType $documentDatum = null)
    {
        $this->documentDatum = $documentDatum;
        return $this;
    }
    /**
     * Get fishQuotaContractDatum value
     * @return \AisFssp\StructType\FishQuotaContractDatumType|null
     */
    public function getFishQuotaContractDatum()
    {
        return $this->fishQuotaContractDatum;
    }
    /**
     * Set fishQuotaContractDatum value
     * @param \AisFssp\StructType\FishQuotaContractDatumType $fishQuotaContractDatum
     * @return \AisFssp\StructType\Data
     */
    public function setFishQuotaContractDatum(\AisFssp\StructType\FishQuotaContractDatumType $fishQuotaContractDatum = null)
    {
        $this->fishQuotaContractDatum = $fishQuotaContractDatum;
        return $this;
    }
    /**
     * Get fishQuotaYearDatum value
     * @return \AisFssp\StructType\FishQuotaCurYearDatumType|null
     */
    public function getFishQuotaYearDatum()
    {
        return $this->fishQuotaYearDatum;
    }
    /**
     * Set fishQuotaYearDatum value
     * @param \AisFssp\StructType\FishQuotaCurYearDatumType $fishQuotaYearDatum
     * @return \AisFssp\StructType\Data
     */
    public function setFishQuotaYearDatum(\AisFssp\StructType\FishQuotaCurYearDatumType $fishQuotaYearDatum = null)
    {
        $this->fishQuotaYearDatum = $fishQuotaYearDatum;
        return $this;
    }
    /**
     * Get fishNonquotaContractDatum value
     * @return \AisFssp\StructType\FishNonquotaContractDatumType|null
     */
    public function getFishNonquotaContractDatum()
    {
        return $this->fishNonquotaContractDatum;
    }
    /**
     * Set fishNonquotaContractDatum value
     * @param \AisFssp\StructType\FishNonquotaContractDatumType $fishNonquotaContractDatum
     * @return \AisFssp\StructType\Data
     */
    public function setFishNonquotaContractDatum(\AisFssp\StructType\FishNonquotaContractDatumType $fishNonquotaContractDatum = null)
    {
        $this->fishNonquotaContractDatum = $fishNonquotaContractDatum;
        return $this;
    }
    /**
     * Get transactionDatum value
     * @return \AisFssp\StructType\TransactionDatumType|null
     */
    public function getTransactionDatum()
    {
        return $this->transactionDatum;
    }
    /**
     * Set transactionDatum value
     * @param \AisFssp\StructType\TransactionDatumType $transactionDatum
     * @return \AisFssp\StructType\Data
     */
    public function setTransactionDatum(\AisFssp\StructType\TransactionDatumType $transactionDatum = null)
    {
        $this->transactionDatum = $transactionDatum;
        return $this;
    }
    /**
     * Get deathDatum value
     * @return \AisFssp\StructType\DeathDatumType|null
     */
    public function getDeathDatum()
    {
        return $this->deathDatum;
    }
    /**
     * Set deathDatum value
     * @param \AisFssp\StructType\DeathDatumType $deathDatum
     * @return \AisFssp\StructType\Data
     */
    public function setDeathDatum(\AisFssp\StructType\DeathDatumType $deathDatum = null)
    {
        $this->deathDatum = $deathDatum;
        return $this;
    }
    /**
     * Get unaccountedForDatum value
     * @return \AisFssp\StructType\UnaccountedForDatumType|null
     */
    public function getUnaccountedForDatum()
    {
        return $this->unaccountedForDatum;
    }
    /**
     * Set unaccountedForDatum value
     * @param \AisFssp\StructType\UnaccountedForDatumType $unaccountedForDatum
     * @return \AisFssp\StructType\Data
     */
    public function setUnaccountedForDatum(\AisFssp\StructType\UnaccountedForDatumType $unaccountedForDatum = null)
    {
        $this->unaccountedForDatum = $unaccountedForDatum;
        return $this;
    }
    /**
     * Get DepositBoxDatum value
     * @return \AisFssp\StructType\DepositBoxDatumType|null
     */
    public function getDepositBoxDatum()
    {
        return $this->DepositBoxDatum;
    }
    /**
     * Set DepositBoxDatum value
     * @param \AisFssp\StructType\DepositBoxDatumType $depositBoxDatum
     * @return \AisFssp\StructType\Data
     */
    public function setDepositBoxDatum(\AisFssp\StructType\DepositBoxDatumType $depositBoxDatum = null)
    {
        $this->DepositBoxDatum = $depositBoxDatum;
        return $this;
    }
    /**
     * Get accountTransactionType value
     * @return \AisFssp\StructType\AccountTransactionDatumType|null
     */
    public function getAccountTransactionType()
    {
        return $this->accountTransactionType;
    }
    /**
     * Set accountTransactionType value
     * @param \AisFssp\StructType\AccountTransactionDatumType $accountTransactionType
     * @return \AisFssp\StructType\Data
     */
    public function setAccountTransactionType(\AisFssp\StructType\AccountTransactionDatumType $accountTransactionType = null)
    {
        $this->accountTransactionType = $accountTransactionType;
        return $this;
    }
    /**
     * Get AccountEncumbranceDatum value
     * @return \AisFssp\StructType\AccountEncumbranceDatumType|null
     */
    public function getAccountEncumbranceDatum()
    {
        return $this->AccountEncumbranceDatum;
    }
    /**
     * Set AccountEncumbranceDatum value
     * @param \AisFssp\StructType\AccountEncumbranceDatumType $accountEncumbranceDatum
     * @return \AisFssp\StructType\Data
     */
    public function setAccountEncumbranceDatum(\AisFssp\StructType\AccountEncumbranceDatumType $accountEncumbranceDatum = null)
    {
        $this->AccountEncumbranceDatum = $accountEncumbranceDatum;
        return $this;
    }
    /**
     * Get propertyObligationDatum value
     * @return \AisFssp\StructType\PropertyObligationDatumType|null
     */
    public function getPropertyObligationDatum()
    {
        return $this->propertyObligationDatum;
    }
    /**
     * Set propertyObligationDatum value
     * @param \AisFssp\StructType\PropertyObligationDatumType $propertyObligationDatum
     * @return \AisFssp\StructType\Data
     */
    public function setPropertyObligationDatum(\AisFssp\StructType\PropertyObligationDatumType $propertyObligationDatum = null)
    {
        $this->propertyObligationDatum = $propertyObligationDatum;
        return $this;
    }
    /**
     * Get unstructuredDatum value
     * @return \AisFssp\StructType\UnstructuredDatumType|null
     */
    public function getUnstructuredDatum()
    {
        return $this->unstructuredDatum;
    }
    /**
     * Set unstructuredDatum value
     * @param \AisFssp\StructType\UnstructuredDatumType $unstructuredDatum
     * @return \AisFssp\StructType\Data
     */
    public function setUnstructuredDatum(\AisFssp\StructType\UnstructuredDatumType $unstructuredDatum = null)
    {
        $this->unstructuredDatum = $unstructuredDatum;
        return $this;
    }
    /**
     * Get unemployedPersonCaseDatum value
     * @return \AisFssp\StructType\UnemployedPersonCaseDatumType|null
     */
    public function getUnemployedPersonCaseDatum()
    {
        return $this->unemployedPersonCaseDatum;
    }
    /**
     * Set unemployedPersonCaseDatum value
     * @param \AisFssp\StructType\UnemployedPersonCaseDatumType $unemployedPersonCaseDatum
     * @return \AisFssp\StructType\Data
     */
    public function setUnemployedPersonCaseDatum(\AisFssp\StructType\UnemployedPersonCaseDatumType $unemployedPersonCaseDatum = null)
    {
        $this->unemployedPersonCaseDatum = $unemployedPersonCaseDatum;
        return $this;
    }
    /**
     * Get unemployedPersonRegistrationDatum value
     * @return \AisFssp\StructType\UnemployedPersonRegistrationDatumType|null
     */
    public function getUnemployedPersonRegistrationDatum()
    {
        return $this->unemployedPersonRegistrationDatum;
    }
    /**
     * Set unemployedPersonRegistrationDatum value
     * @param \AisFssp\StructType\UnemployedPersonRegistrationDatumType $unemployedPersonRegistrationDatum
     * @return \AisFssp\StructType\Data
     */
    public function setUnemployedPersonRegistrationDatum(\AisFssp\StructType\UnemployedPersonRegistrationDatumType $unemployedPersonRegistrationDatum = null)
    {
        $this->unemployedPersonRegistrationDatum = $unemployedPersonRegistrationDatum;
        return $this;
    }
    /**
     * Get seniorityPeriodDatum value
     * @return \AisFssp\StructType\SeniorityPeriodDatumType|null
     */
    public function getSeniorityPeriodDatum()
    {
        return $this->seniorityPeriodDatum;
    }
    /**
     * Set seniorityPeriodDatum value
     * @param \AisFssp\StructType\SeniorityPeriodDatumType $seniorityPeriodDatum
     * @return \AisFssp\StructType\Data
     */
    public function setSeniorityPeriodDatum(\AisFssp\StructType\SeniorityPeriodDatumType $seniorityPeriodDatum = null)
    {
        $this->seniorityPeriodDatum = $seniorityPeriodDatum;
        return $this;
    }
    /**
     * Get SalaryWithheldDatum value
     * @return \AisFssp\StructType\SalaryWithheldDatumType|null
     */
    public function getSalaryWithheldDatum()
    {
        return $this->SalaryWithheldDatum;
    }
    /**
     * Set SalaryWithheldDatum value
     * @param \AisFssp\StructType\SalaryWithheldDatumType $salaryWithheldDatum
     * @return \AisFssp\StructType\Data
     */
    public function setSalaryWithheldDatum(\AisFssp\StructType\SalaryWithheldDatumType $salaryWithheldDatum = null)
    {
        $this->SalaryWithheldDatum = $salaryWithheldDatum;
        return $this;
    }
    /**
     * Get CashLetterDatum value
     * @return \AisFssp\StructType\CashLetterDatumType|null
     */
    public function getCashLetterDatum()
    {
        return $this->CashLetterDatum;
    }
    /**
     * Set CashLetterDatum value
     * @param \AisFssp\StructType\CashLetterDatumType $cashLetterDatum
     * @return \AisFssp\StructType\Data
     */
    public function setCashLetterDatum(\AisFssp\StructType\CashLetterDatumType $cashLetterDatum = null)
    {
        $this->CashLetterDatum = $cashLetterDatum;
        return $this;
    }
    /**
     * Get ValidationDatum value
     * @return \AisFssp\StructType\ValidationDatumType|null
     */
    public function getValidationDatum()
    {
        return $this->ValidationDatum;
    }
    /**
     * Set ValidationDatum value
     * @param \AisFssp\StructType\ValidationDatumType $validationDatum
     * @return \AisFssp\StructType\Data
     */
    public function setValidationDatum(\AisFssp\StructType\ValidationDatumType $validationDatum = null)
    {
        $this->ValidationDatum = $validationDatum;
        return $this;
    }
    /**
     * Get GoodsDatum value
     * @return \AisFssp\StructType\GoodsDatumType|null
     */
    public function getGoodsDatum()
    {
        return $this->GoodsDatum;
    }
    /**
     * Set GoodsDatum value
     * @param \AisFssp\StructType\GoodsDatumType $goodsDatum
     * @return \AisFssp\StructType\Data
     */
    public function setGoodsDatum(\AisFssp\StructType\GoodsDatumType $goodsDatum = null)
    {
        $this->GoodsDatum = $goodsDatum;
        return $this;
    }
    /**
     * Get WeaponDatum value
     * @return \AisFssp\StructType\WeaponDatumType|null
     */
    public function getWeaponDatum()
    {
        return $this->WeaponDatum;
    }
    /**
     * Set WeaponDatum value
     * @param \AisFssp\StructType\WeaponDatumType $weaponDatum
     * @return \AisFssp\StructType\Data
     */
    public function setWeaponDatum(\AisFssp\StructType\WeaponDatumType $weaponDatum = null)
    {
        $this->WeaponDatum = $weaponDatum;
        return $this;
    }
    /**
     * Get SentencedPersonImprisonmentDatum value
     * @return \AisFssp\StructType\SentencedPersonImprisonmentType|null
     */
    public function getSentencedPersonImprisonmentDatum()
    {
        return $this->SentencedPersonImprisonmentDatum;
    }
    /**
     * Set SentencedPersonImprisonmentDatum value
     * @param \AisFssp\StructType\SentencedPersonImprisonmentType $sentencedPersonImprisonmentDatum
     * @return \AisFssp\StructType\Data
     */
    public function setSentencedPersonImprisonmentDatum(\AisFssp\StructType\SentencedPersonImprisonmentType $sentencedPersonImprisonmentDatum = null)
    {
        $this->SentencedPersonImprisonmentDatum = $sentencedPersonImprisonmentDatum;
        return $this;
    }
    /**
     * Get SentencedPersonNoImprisonmentDatum value
     * @return \AisFssp\StructType\SentencedPersonNoImprisonmentType|null
     */
    public function getSentencedPersonNoImprisonmentDatum()
    {
        return $this->SentencedPersonNoImprisonmentDatum;
    }
    /**
     * Set SentencedPersonNoImprisonmentDatum value
     * @param \AisFssp\StructType\SentencedPersonNoImprisonmentType $sentencedPersonNoImprisonmentDatum
     * @return \AisFssp\StructType\Data
     */
    public function setSentencedPersonNoImprisonmentDatum(\AisFssp\StructType\SentencedPersonNoImprisonmentType $sentencedPersonNoImprisonmentDatum = null)
    {
        $this->SentencedPersonNoImprisonmentDatum = $sentencedPersonNoImprisonmentDatum;
        return $this;
    }
    /**
     * Get BKIDatum value
     * @return \AisFssp\StructType\BKIDatumType|null
     */
    public function getBKIDatum()
    {
        return $this->BKIDatum;
    }
    /**
     * Set BKIDatum value
     * @param \AisFssp\StructType\BKIDatumType $bKIDatum
     * @return \AisFssp\StructType\Data
     */
    public function setBKIDatum(\AisFssp\StructType\BKIDatumType $bKIDatum = null)
    {
        $this->BKIDatum = $bKIDatum;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\Data
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
