<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DXLookupTableData StructType
 * Meta informations extracted from the WSDL
 * - documentation: Данные справочника
 * - type: tns:DXLookupTableData
 * @subpackage Structs
 */
class DXLookupTableData extends DXBlock
{
    /**
     * The LookupTableName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование справочника | Тип метаобъекта
     * - maxLength: 31
     * - minLength: 1
     * @var string
     */
    public $LookupTableName;
    /**
     * The LookupTableData
     * Meta informations extracted from the WSDL
     * - documentation: Данные справочника
     * @var \AisFssp\StructType\LookupTableData
     */
    public $LookupTableData;
    /**
     * The Message
     * Meta informations extracted from the WSDL
     * - documentation: Сообщение об ошибке
     * @var \AisFssp\StructType\MessageEx
     */
    public $Message;
    /**
     * Constructor method for DXLookupTableData
     * @uses DXLookupTableData::setLookupTableName()
     * @uses DXLookupTableData::setLookupTableData()
     * @uses DXLookupTableData::setMessage()
     * @param string $lookupTableName
     * @param \AisFssp\StructType\LookupTableData $lookupTableData
     * @param \AisFssp\StructType\MessageEx $message
     */
    public function __construct($lookupTableName = null, \AisFssp\StructType\LookupTableData $lookupTableData = null, \AisFssp\StructType\MessageEx $message = null)
    {
        $this
            ->setLookupTableName($lookupTableName)
            ->setLookupTableData($lookupTableData)
            ->setMessage($message);
    }
    /**
     * Get LookupTableName value
     * @return string|null
     */
    public function getLookupTableName()
    {
        return $this->LookupTableName;
    }
    /**
     * Set LookupTableName value
     * @param string $lookupTableName
     * @return \AisFssp\StructType\DXLookupTableData
     */
    public function setLookupTableName($lookupTableName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($lookupTableName) && strlen($lookupTableName) > 31) || (is_array($lookupTableName) && count($lookupTableName) > 31)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 31 element(s) or a scalar of 31 character(s) at most, "%d" length given', is_scalar($lookupTableName) ? strlen($lookupTableName) : count($lookupTableName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($lookupTableName) && strlen($lookupTableName) < 1) || (is_array($lookupTableName) && count($lookupTableName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($lookupTableName) && !is_string($lookupTableName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lookupTableName)), __LINE__);
        }
        $this->LookupTableName = $lookupTableName;
        return $this;
    }
    /**
     * Get LookupTableData value
     * @return \AisFssp\StructType\LookupTableData|null
     */
    public function getLookupTableData()
    {
        return $this->LookupTableData;
    }
    /**
     * Set LookupTableData value
     * @param \AisFssp\StructType\LookupTableData $lookupTableData
     * @return \AisFssp\StructType\DXLookupTableData
     */
    public function setLookupTableData(\AisFssp\StructType\LookupTableData $lookupTableData = null)
    {
        $this->LookupTableData = $lookupTableData;
        return $this;
    }
    /**
     * Get Message value
     * @return \AisFssp\StructType\MessageEx|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param \AisFssp\StructType\MessageEx $message
     * @return \AisFssp\StructType\DXLookupTableData
     */
    public function setMessage(\AisFssp\StructType\MessageEx $message = null)
    {
        $this->Message = $message;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\DXLookupTableData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
