<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DXFileReceipt StructType
 * Meta informations extracted from the WSDL
 * - documentation: Квитанция на файл (фрагмент файла)
 * - type: tns:DXFileReceipt
 * @subpackage Structs
 */
class DXFileReceipt extends DXBlock
{
    /**
     * The FileBlockInfo
     * Meta informations extracted from the WSDL
     * - documentation: Информация о фрагменте файла
     * @var \AisFssp\StructType\FileBlockInfo
     */
    public $FileBlockInfo;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - documentation: Статус обработки файла
     * @var string
     */
    public $Status;
    /**
     * The Message
     * Meta informations extracted from the WSDL
     * - documentation: Сообщение об ошибке
     * - minOccurs: 0
     * @var \AisFssp\StructType\MessageEx
     */
    public $Message;
    /**
     * Constructor method for DXFileReceipt
     * @uses DXFileReceipt::setFileBlockInfo()
     * @uses DXFileReceipt::setStatus()
     * @uses DXFileReceipt::setMessage()
     * @param \AisFssp\StructType\FileBlockInfo $fileBlockInfo
     * @param string $status
     * @param \AisFssp\StructType\MessageEx $message
     */
    public function __construct(\AisFssp\StructType\FileBlockInfo $fileBlockInfo = null, $status = null, \AisFssp\StructType\MessageEx $message = null)
    {
        $this
            ->setFileBlockInfo($fileBlockInfo)
            ->setStatus($status)
            ->setMessage($message);
    }
    /**
     * Get FileBlockInfo value
     * @return \AisFssp\StructType\FileBlockInfo|null
     */
    public function getFileBlockInfo()
    {
        return $this->FileBlockInfo;
    }
    /**
     * Set FileBlockInfo value
     * @param \AisFssp\StructType\FileBlockInfo $fileBlockInfo
     * @return \AisFssp\StructType\DXFileReceipt
     */
    public function setFileBlockInfo(\AisFssp\StructType\FileBlockInfo $fileBlockInfo = null)
    {
        $this->FileBlockInfo = $fileBlockInfo;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \AisFssp\EnumType\ProcessResult::valueIsValid()
     * @uses \AisFssp\EnumType\ProcessResult::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \AisFssp\StructType\DXFileReceipt
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\ProcessResult::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \AisFssp\EnumType\ProcessResult::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Message value
     * @return \AisFssp\StructType\MessageEx|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param \AisFssp\StructType\MessageEx $message
     * @return \AisFssp\StructType\DXFileReceipt
     */
    public function setMessage(\AisFssp\StructType\MessageEx $message = null)
    {
        $this->Message = $message;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\DXFileReceipt
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
