<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DXDocumentResult StructType
 * Meta informations extracted from the WSDL
 * - type: tns:DXDocumentResult
 * @subpackage Structs
 */
class DXDocumentResult extends DXBlock
{
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - documentation: Статус обработки документа
     * @var string
     */
    public $Status;
    /**
     * The DocRef
     * Meta informations extracted from the WSDL
     * - documentation: Ссылка на документ
     * @var \AisFssp\StructType\DocumentRef
     */
    public $DocRef;
    /**
     * The State
     * Meta informations extracted from the WSDL
     * - documentation: Состояние документа после обработки запроса | Статус документа
     * - maxLength: 31
     * - minLength: 1
     * @var string
     */
    public $State;
    /**
     * The ErrorMessage
     * Meta informations extracted from the WSDL
     * - documentation: Информация об ошибке
     * @var \AisFssp\StructType\MessageEx
     */
    public $ErrorMessage;
    /**
     * The DocDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DocDate;
    /**
     * The DocNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $DocNumber;
    /**
     * The Document
     * @var \AisFssp\StructType\DocumentContainer
     */
    public $Document;
    /**
     * Constructor method for DXDocumentResult
     * @uses DXDocumentResult::setStatus()
     * @uses DXDocumentResult::setDocRef()
     * @uses DXDocumentResult::setState()
     * @uses DXDocumentResult::setErrorMessage()
     * @uses DXDocumentResult::setDocDate()
     * @uses DXDocumentResult::setDocNumber()
     * @uses DXDocumentResult::setDocument()
     * @param string $status
     * @param \AisFssp\StructType\DocumentRef $docRef
     * @param string $state
     * @param \AisFssp\StructType\MessageEx $errorMessage
     * @param string $docDate
     * @param string $docNumber
     * @param \AisFssp\StructType\DocumentContainer $document
     */
    public function __construct($status = null, \AisFssp\StructType\DocumentRef $docRef = null, $state = null, \AisFssp\StructType\MessageEx $errorMessage = null, $docDate = null, $docNumber = null, \AisFssp\StructType\DocumentContainer $document = null)
    {
        $this
            ->setStatus($status)
            ->setDocRef($docRef)
            ->setState($state)
            ->setErrorMessage($errorMessage)
            ->setDocDate($docDate)
            ->setDocNumber($docNumber)
            ->setDocument($document);
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \AisFssp\EnumType\ProcessResult::valueIsValid()
     * @uses \AisFssp\EnumType\ProcessResult::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \AisFssp\StructType\DXDocumentResult
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\ProcessResult::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \AisFssp\EnumType\ProcessResult::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get DocRef value
     * @return \AisFssp\StructType\DocumentRef|null
     */
    public function getDocRef()
    {
        return $this->DocRef;
    }
    /**
     * Set DocRef value
     * @param \AisFssp\StructType\DocumentRef $docRef
     * @return \AisFssp\StructType\DXDocumentResult
     */
    public function setDocRef(\AisFssp\StructType\DocumentRef $docRef = null)
    {
        $this->DocRef = $docRef;
        return $this;
    }
    /**
     * Get State value
     * @return string|null
     */
    public function getState()
    {
        return $this->State;
    }
    /**
     * Set State value
     * @param string $state
     * @return \AisFssp\StructType\DXDocumentResult
     */
    public function setState($state = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($state) && strlen($state) > 31) || (is_array($state) && count($state) > 31)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 31 element(s) or a scalar of 31 character(s) at most, "%d" length given', is_scalar($state) ? strlen($state) : count($state)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($state) && strlen($state) < 1) || (is_array($state) && count($state) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($state)), __LINE__);
        }
        $this->State = $state;
        return $this;
    }
    /**
     * Get ErrorMessage value
     * @return \AisFssp\StructType\MessageEx|null
     */
    public function getErrorMessage()
    {
        return $this->ErrorMessage;
    }
    /**
     * Set ErrorMessage value
     * @param \AisFssp\StructType\MessageEx $errorMessage
     * @return \AisFssp\StructType\DXDocumentResult
     */
    public function setErrorMessage(\AisFssp\StructType\MessageEx $errorMessage = null)
    {
        $this->ErrorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get DocDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->DocDate;
    }
    /**
     * Set DocDate value
     * @param string $docDate
     * @return \AisFssp\StructType\DXDocumentResult
     */
    public function setDocDate($docDate = null)
    {
        // validation for constraint: maxExclusive
        if ($docDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $docDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($docDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $docDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docDate) && !is_string($docDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docDate)), __LINE__);
        }
        $this->DocDate = $docDate;
        return $this;
    }
    /**
     * Get DocNumber value
     * @return string|null
     */
    public function getDocNumber()
    {
        return $this->DocNumber;
    }
    /**
     * Set DocNumber value
     * @param string $docNumber
     * @return \AisFssp\StructType\DXDocumentResult
     */
    public function setDocNumber($docNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($docNumber) && strlen($docNumber) > 25) || (is_array($docNumber) && count($docNumber) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($docNumber) ? strlen($docNumber) : count($docNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($docNumber) && strlen($docNumber) < 1) || (is_array($docNumber) && count($docNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docNumber) && !is_string($docNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docNumber)), __LINE__);
        }
        $this->DocNumber = $docNumber;
        return $this;
    }
    /**
     * Get Document value
     * @return \AisFssp\StructType\DocumentContainer|null
     */
    public function getDocument()
    {
        return $this->Document;
    }
    /**
     * Set Document value
     * @param \AisFssp\StructType\DocumentContainer $document
     * @return \AisFssp\StructType\DXDocumentResult
     */
    public function setDocument(\AisFssp\StructType\DocumentContainer $document = null)
    {
        $this->Document = $document;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\DXDocumentResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
