<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CrimeRegistryInfo StructType
 * Meta informations extracted from the WSDL
 * - documentation: Выписка из реестра розыска подозреваемых в преступлениях | ЭП
 * - type: tns:CrimeRegistryInfo
 * @subpackage Structs
 */
class CrimeRegistryInfo extends AbstractStructBase
{
    /**
     * The InternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ФССП России | Уникальный идентификатор документа, присвоенный АИС ФССП России. | Ключ объекта, присвоенний информационной
     * системой ФССП РФ при создании объекта или при получении объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $InternalKey;
    /**
     * The QueryExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор запроса АИС ВК | Идентификатор запроса (значение поля ExternalKey), переданного ранее в ФССП России. | Идентификатор
     * объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный идентификатор должен быть уникальным для типа
     * идентифицируемого документа в пространстве обмена данными с конкретным внешним контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $QueryExternalKey;
    /**
     * The isActInfo
     * Meta informations extracted from the WSDL
     * - documentation: Признак наличия сведений | Признак наличия сведений из реестра розыска подозреваемых в преступлениях. | Обертка стандартного
     * xs:boolean | Логический
     * @var bool
     */
    public $isActInfo;
    /**
     * The Detail
     * Meta informations extracted from the WSDL
     * - documentation: Состав выписки
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\CrimeRegistryDetail[]
     */
    public $Detail;
    /**
     * The SignDateTime
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время формирования подписи | Дата и время | Дата и время
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $SignDateTime;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \AisFssp\StructType\SignatureType[]
     */
    public $Signature;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Атрибут документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Id;
    /**
     * Constructor method for CrimeRegistryInfo
     * @uses CrimeRegistryInfo::setInternalKey()
     * @uses CrimeRegistryInfo::setQueryExternalKey()
     * @uses CrimeRegistryInfo::setIsActInfo()
     * @uses CrimeRegistryInfo::setDetail()
     * @uses CrimeRegistryInfo::setSignDateTime()
     * @uses CrimeRegistryInfo::setSignature()
     * @uses CrimeRegistryInfo::setId()
     * @param int $internalKey
     * @param string $queryExternalKey
     * @param bool $isActInfo
     * @param \AisFssp\StructType\CrimeRegistryDetail[] $detail
     * @param string $signDateTime
     * @param \AisFssp\StructType\SignatureType[] $signature
     * @param string $id
     */
    public function __construct($internalKey = null, $queryExternalKey = null, $isActInfo = null, array $detail = array(), $signDateTime = null, array $signature = array(), $id = null)
    {
        $this
            ->setInternalKey($internalKey)
            ->setQueryExternalKey($queryExternalKey)
            ->setIsActInfo($isActInfo)
            ->setDetail($detail)
            ->setSignDateTime($signDateTime)
            ->setSignature($signature)
            ->setId($id);
    }
    /**
     * Get InternalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->InternalKey;
    }
    /**
     * Set InternalKey value
     * @param int $internalKey
     * @return \AisFssp\StructType\CrimeRegistryInfo
     */
    public function setInternalKey($internalKey = null)
    {
        // validation for constraint: maxInclusive
        if ($internalKey > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($internalKey < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($internalKey) && !is_numeric($internalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($internalKey)), __LINE__);
        }
        $this->InternalKey = $internalKey;
        return $this;
    }
    /**
     * Get QueryExternalKey value
     * @return string|null
     */
    public function getQueryExternalKey()
    {
        return $this->QueryExternalKey;
    }
    /**
     * Set QueryExternalKey value
     * @param string $queryExternalKey
     * @return \AisFssp\StructType\CrimeRegistryInfo
     */
    public function setQueryExternalKey($queryExternalKey = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($queryExternalKey) && strlen($queryExternalKey) > 60) || (is_array($queryExternalKey) && count($queryExternalKey) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($queryExternalKey) ? strlen($queryExternalKey) : count($queryExternalKey)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($queryExternalKey) && strlen($queryExternalKey) < 1) || (is_array($queryExternalKey) && count($queryExternalKey) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($queryExternalKey) && !is_string($queryExternalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($queryExternalKey)), __LINE__);
        }
        $this->QueryExternalKey = $queryExternalKey;
        return $this;
    }
    /**
     * Get isActInfo value
     * @return bool|null
     */
    public function getIsActInfo()
    {
        return $this->isActInfo;
    }
    /**
     * Set isActInfo value
     * @param bool $isActInfo
     * @return \AisFssp\StructType\CrimeRegistryInfo
     */
    public function setIsActInfo($isActInfo = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActInfo) && !is_bool($isActInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isActInfo)), __LINE__);
        }
        $this->isActInfo = $isActInfo;
        return $this;
    }
    /**
     * Get Detail value
     * @return \AisFssp\StructType\CrimeRegistryDetail[]|null
     */
    public function getDetail()
    {
        return $this->Detail;
    }
    /**
     * Set Detail value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\CrimeRegistryDetail[] $detail
     * @return \AisFssp\StructType\CrimeRegistryInfo
     */
    public function setDetail(array $detail = array())
    {
        foreach ($detail as $crimeRegistryInfoDetailItem) {
            // validation for constraint: itemType
            if (!$crimeRegistryInfoDetailItem instanceof \AisFssp\StructType\CrimeRegistryDetail) {
                throw new \InvalidArgumentException(sprintf('The Detail property can only contain items of \AisFssp\StructType\CrimeRegistryDetail, "%s" given', is_object($crimeRegistryInfoDetailItem) ? get_class($crimeRegistryInfoDetailItem) : gettype($crimeRegistryInfoDetailItem)), __LINE__);
            }
        }
        $this->Detail = $detail;
        return $this;
    }
    /**
     * Add item to Detail value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\CrimeRegistryDetail $item
     * @return \AisFssp\StructType\CrimeRegistryInfo
     */
    public function addToDetail(\AisFssp\StructType\CrimeRegistryDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\CrimeRegistryDetail) {
            throw new \InvalidArgumentException(sprintf('The Detail property can only contain items of \AisFssp\StructType\CrimeRegistryDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Detail[] = $item;
        return $this;
    }
    /**
     * Get SignDateTime value
     * @return string|null
     */
    public function getSignDateTime()
    {
        return $this->SignDateTime;
    }
    /**
     * Set SignDateTime value
     * @param string $signDateTime
     * @return \AisFssp\StructType\CrimeRegistryInfo
     */
    public function setSignDateTime($signDateTime = null)
    {
        // validation for constraint: maxExclusive
        if ($signDateTime >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $signDateTime), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($signDateTime < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $signDateTime), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($signDateTime) && !is_string($signDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($signDateTime)), __LINE__);
        }
        $this->SignDateTime = $signDateTime;
        return $this;
    }
    /**
     * Get Signature value
     * @return \AisFssp\StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType[] $signature
     * @return \AisFssp\StructType\CrimeRegistryInfo
     */
    public function setSignature(array $signature = array())
    {
        foreach ($signature as $crimeRegistryInfoSignatureItem) {
            // validation for constraint: itemType
            if (!$crimeRegistryInfoSignatureItem instanceof \AisFssp\StructType\SignatureType) {
                throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($crimeRegistryInfoSignatureItem) ? get_class($crimeRegistryInfoSignatureItem) : gettype($crimeRegistryInfoSignatureItem)), __LINE__);
            }
        }
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType $item
     * @return \AisFssp\StructType\CrimeRegistryInfo
     */
    public function addToSignature(\AisFssp\StructType\SignatureType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\SignatureType) {
            throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \AisFssp\StructType\CrimeRegistryInfo
     */
    public function setId($id = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($id) && strlen($id) > 60) || (is_array($id) && count($id) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($id) ? strlen($id) : count($id)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($id) && strlen($id) < 1) || (is_array($id) && count($id) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\CrimeRegistryInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
