<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CitizenQuestionsResult StructType
 * Meta informations extracted from the WSDL
 * - documentation: Статус вопроса по обращению гражданина, полученного из Администрации Президента
 * - type: tns:CitizenQuestionsResult
 * @subpackage Structs
 */
class CitizenQuestionsResult extends AbstractStructBase
{
    /**
     * The InternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ФССП России | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от
     * контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $InternalKey;
    /**
     * The RequestExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор обращения | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный
     * идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $RequestExternalKey;
    /**
     * The IsAppStatus
     * Meta informations extracted from the WSDL
     * - documentation: Признак наличия статуса | Обертка стандартного xs:boolean | Логический
     * @var bool
     */
    public $IsAppStatus;
    /**
     * The TreatmentText
     * Meta informations extracted from the WSDL
     * - documentation: Текст обращения | Массив произвольных данных (текстовый)
     * - minOccurs: 0
     * @var string
     */
    public $TreatmentText;
    /**
     * The IncomingDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата поступления | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $IncomingDate;
    /**
     * The CitizenQuestionsResData
     * Meta informations extracted from the WSDL
     * - documentation: Данные по вопросам обращений граждан
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\CitizenQuestionsResData[]
     */
    public $CitizenQuestionsResData;
    /**
     * Constructor method for CitizenQuestionsResult
     * @uses CitizenQuestionsResult::setInternalKey()
     * @uses CitizenQuestionsResult::setRequestExternalKey()
     * @uses CitizenQuestionsResult::setIsAppStatus()
     * @uses CitizenQuestionsResult::setTreatmentText()
     * @uses CitizenQuestionsResult::setIncomingDate()
     * @uses CitizenQuestionsResult::setCitizenQuestionsResData()
     * @param int $internalKey
     * @param string $requestExternalKey
     * @param bool $isAppStatus
     * @param string $treatmentText
     * @param string $incomingDate
     * @param \AisFssp\StructType\CitizenQuestionsResData[] $citizenQuestionsResData
     */
    public function __construct($internalKey = null, $requestExternalKey = null, $isAppStatus = null, $treatmentText = null, $incomingDate = null, array $citizenQuestionsResData = array())
    {
        $this
            ->setInternalKey($internalKey)
            ->setRequestExternalKey($requestExternalKey)
            ->setIsAppStatus($isAppStatus)
            ->setTreatmentText($treatmentText)
            ->setIncomingDate($incomingDate)
            ->setCitizenQuestionsResData($citizenQuestionsResData);
    }
    /**
     * Get InternalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->InternalKey;
    }
    /**
     * Set InternalKey value
     * @param int $internalKey
     * @return \AisFssp\StructType\CitizenQuestionsResult
     */
    public function setInternalKey($internalKey = null)
    {
        // validation for constraint: maxInclusive
        if ($internalKey > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($internalKey < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($internalKey) && !is_numeric($internalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($internalKey)), __LINE__);
        }
        $this->InternalKey = $internalKey;
        return $this;
    }
    /**
     * Get RequestExternalKey value
     * @return string|null
     */
    public function getRequestExternalKey()
    {
        return $this->RequestExternalKey;
    }
    /**
     * Set RequestExternalKey value
     * @param string $requestExternalKey
     * @return \AisFssp\StructType\CitizenQuestionsResult
     */
    public function setRequestExternalKey($requestExternalKey = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestExternalKey) && strlen($requestExternalKey) > 60) || (is_array($requestExternalKey) && count($requestExternalKey) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($requestExternalKey) ? strlen($requestExternalKey) : count($requestExternalKey)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($requestExternalKey) && strlen($requestExternalKey) < 1) || (is_array($requestExternalKey) && count($requestExternalKey) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestExternalKey) && !is_string($requestExternalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestExternalKey)), __LINE__);
        }
        $this->RequestExternalKey = $requestExternalKey;
        return $this;
    }
    /**
     * Get IsAppStatus value
     * @return bool|null
     */
    public function getIsAppStatus()
    {
        return $this->IsAppStatus;
    }
    /**
     * Set IsAppStatus value
     * @param bool $isAppStatus
     * @return \AisFssp\StructType\CitizenQuestionsResult
     */
    public function setIsAppStatus($isAppStatus = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAppStatus) && !is_bool($isAppStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isAppStatus)), __LINE__);
        }
        $this->IsAppStatus = $isAppStatus;
        return $this;
    }
    /**
     * Get TreatmentText value
     * @return string|null
     */
    public function getTreatmentText()
    {
        return $this->TreatmentText;
    }
    /**
     * Set TreatmentText value
     * @param string $treatmentText
     * @return \AisFssp\StructType\CitizenQuestionsResult
     */
    public function setTreatmentText($treatmentText = null)
    {
        // validation for constraint: string
        if (!is_null($treatmentText) && !is_string($treatmentText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($treatmentText)), __LINE__);
        }
        $this->TreatmentText = $treatmentText;
        return $this;
    }
    /**
     * Get IncomingDate value
     * @return string|null
     */
    public function getIncomingDate()
    {
        return $this->IncomingDate;
    }
    /**
     * Set IncomingDate value
     * @param string $incomingDate
     * @return \AisFssp\StructType\CitizenQuestionsResult
     */
    public function setIncomingDate($incomingDate = null)
    {
        // validation for constraint: maxExclusive
        if ($incomingDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $incomingDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($incomingDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $incomingDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($incomingDate) && !is_string($incomingDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($incomingDate)), __LINE__);
        }
        $this->IncomingDate = $incomingDate;
        return $this;
    }
    /**
     * Get CitizenQuestionsResData value
     * @return \AisFssp\StructType\CitizenQuestionsResData[]|null
     */
    public function getCitizenQuestionsResData()
    {
        return $this->CitizenQuestionsResData;
    }
    /**
     * Set CitizenQuestionsResData value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\CitizenQuestionsResData[] $citizenQuestionsResData
     * @return \AisFssp\StructType\CitizenQuestionsResult
     */
    public function setCitizenQuestionsResData(array $citizenQuestionsResData = array())
    {
        foreach ($citizenQuestionsResData as $citizenQuestionsResultCitizenQuestionsResDataItem) {
            // validation for constraint: itemType
            if (!$citizenQuestionsResultCitizenQuestionsResDataItem instanceof \AisFssp\StructType\CitizenQuestionsResData) {
                throw new \InvalidArgumentException(sprintf('The CitizenQuestionsResData property can only contain items of \AisFssp\StructType\CitizenQuestionsResData, "%s" given', is_object($citizenQuestionsResultCitizenQuestionsResDataItem) ? get_class($citizenQuestionsResultCitizenQuestionsResDataItem) : gettype($citizenQuestionsResultCitizenQuestionsResDataItem)), __LINE__);
            }
        }
        $this->CitizenQuestionsResData = $citizenQuestionsResData;
        return $this;
    }
    /**
     * Add item to CitizenQuestionsResData value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\CitizenQuestionsResData $item
     * @return \AisFssp\StructType\CitizenQuestionsResult
     */
    public function addToCitizenQuestionsResData(\AisFssp\StructType\CitizenQuestionsResData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\CitizenQuestionsResData) {
            throw new \InvalidArgumentException(sprintf('The CitizenQuestionsResData property can only contain items of \AisFssp\StructType\CitizenQuestionsResData, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CitizenQuestionsResData[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\CitizenQuestionsResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
