<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CitizenQuestionsResData StructType
 * Meta informations extracted from the WSDL
 * - documentation: Данные по вопросам из обращений граждан | ЭП
 * @subpackage Structs
 */
class CitizenQuestionsResData extends AbstractStructBase
{
    /**
     * The InternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ФССП России | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от
     * контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $InternalKey;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - documentation: Статус обращения
     * @var string
     */
    public $Status;
    /**
     * The RegDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата регистрации | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $RegDate;
    /**
     * The RegDocNumber
     * Meta informations extracted from the WSDL
     * - documentation: Регистрационный номер | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $RegDocNumber;
    /**
     * The OspCode
     * Meta informations extracted from the WSDL
     * - documentation: Код отдела записи | Ведомственный классификатор отделов судебных приставов | NSI_Departments
     * - length: 5
     * - pattern: [0-9]{5}
     * @var string
     */
    public $OspCode;
    /**
     * The ForwardOspCode
     * Meta informations extracted from the WSDL
     * - documentation: Код подразделения пересылки | Ведомственный классификатор отделов судебных приставов | NSI_Departments
     * - minOccurs: 0
     * - length: 5
     * - pattern: [0-9]{5}
     * @var string
     */
    public $ForwardOspCode;
    /**
     * The ForwardDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата пересылки | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $ForwardDate;
    /**
     * The ForwardNum
     * Meta informations extracted from the WSDL
     * - documentation: Номер исходящего о пересылке | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $ForwardNum;
    /**
     * The Text
     * Meta informations extracted from the WSDL
     * - documentation: Текст уведомления | Строка длиной от 1 до 1000 символов
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $Text;
    /**
     * The AnswerDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата ответа | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $AnswerDate;
    /**
     * The AnswerRegDocNumber
     * Meta informations extracted from the WSDL
     * - documentation: Регистрационный номер ответа | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $AnswerRegDocNumber;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \AisFssp\StructType\SignatureType[]
     */
    public $Signature;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Атрибут документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Id;
    /**
     * Constructor method for CitizenQuestionsResData
     * @uses CitizenQuestionsResData::setInternalKey()
     * @uses CitizenQuestionsResData::setStatus()
     * @uses CitizenQuestionsResData::setRegDate()
     * @uses CitizenQuestionsResData::setRegDocNumber()
     * @uses CitizenQuestionsResData::setOspCode()
     * @uses CitizenQuestionsResData::setForwardOspCode()
     * @uses CitizenQuestionsResData::setForwardDate()
     * @uses CitizenQuestionsResData::setForwardNum()
     * @uses CitizenQuestionsResData::setText()
     * @uses CitizenQuestionsResData::setAnswerDate()
     * @uses CitizenQuestionsResData::setAnswerRegDocNumber()
     * @uses CitizenQuestionsResData::setSignature()
     * @uses CitizenQuestionsResData::setId()
     * @param int $internalKey
     * @param string $status
     * @param string $regDate
     * @param string $regDocNumber
     * @param string $ospCode
     * @param string $forwardOspCode
     * @param string $forwardDate
     * @param string $forwardNum
     * @param string $text
     * @param string $answerDate
     * @param string $answerRegDocNumber
     * @param \AisFssp\StructType\SignatureType[] $signature
     * @param string $id
     */
    public function __construct($internalKey = null, $status = null, $regDate = null, $regDocNumber = null, $ospCode = null, $forwardOspCode = null, $forwardDate = null, $forwardNum = null, $text = null, $answerDate = null, $answerRegDocNumber = null, array $signature = array(), $id = null)
    {
        $this
            ->setInternalKey($internalKey)
            ->setStatus($status)
            ->setRegDate($regDate)
            ->setRegDocNumber($regDocNumber)
            ->setOspCode($ospCode)
            ->setForwardOspCode($forwardOspCode)
            ->setForwardDate($forwardDate)
            ->setForwardNum($forwardNum)
            ->setText($text)
            ->setAnswerDate($answerDate)
            ->setAnswerRegDocNumber($answerRegDocNumber)
            ->setSignature($signature)
            ->setId($id);
    }
    /**
     * Get InternalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->InternalKey;
    }
    /**
     * Set InternalKey value
     * @param int $internalKey
     * @return \AisFssp\StructType\CitizenQuestionsResData
     */
    public function setInternalKey($internalKey = null)
    {
        // validation for constraint: maxInclusive
        if ($internalKey > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($internalKey < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($internalKey) && !is_numeric($internalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($internalKey)), __LINE__);
        }
        $this->InternalKey = $internalKey;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \AisFssp\EnumType\TreatmentStatusCode::valueIsValid()
     * @uses \AisFssp\EnumType\TreatmentStatusCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \AisFssp\StructType\CitizenQuestionsResData
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\TreatmentStatusCode::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \AisFssp\EnumType\TreatmentStatusCode::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get RegDate value
     * @return string|null
     */
    public function getRegDate()
    {
        return $this->RegDate;
    }
    /**
     * Set RegDate value
     * @param string $regDate
     * @return \AisFssp\StructType\CitizenQuestionsResData
     */
    public function setRegDate($regDate = null)
    {
        // validation for constraint: maxExclusive
        if ($regDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $regDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($regDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $regDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($regDate) && !is_string($regDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($regDate)), __LINE__);
        }
        $this->RegDate = $regDate;
        return $this;
    }
    /**
     * Get RegDocNumber value
     * @return string|null
     */
    public function getRegDocNumber()
    {
        return $this->RegDocNumber;
    }
    /**
     * Set RegDocNumber value
     * @param string $regDocNumber
     * @return \AisFssp\StructType\CitizenQuestionsResData
     */
    public function setRegDocNumber($regDocNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($regDocNumber) && strlen($regDocNumber) > 25) || (is_array($regDocNumber) && count($regDocNumber) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($regDocNumber) ? strlen($regDocNumber) : count($regDocNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($regDocNumber) && strlen($regDocNumber) < 1) || (is_array($regDocNumber) && count($regDocNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($regDocNumber) && !is_string($regDocNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($regDocNumber)), __LINE__);
        }
        $this->RegDocNumber = $regDocNumber;
        return $this;
    }
    /**
     * Get OspCode value
     * @return string|null
     */
    public function getOspCode()
    {
        return $this->OspCode;
    }
    /**
     * Set OspCode value
     * @param string $ospCode
     * @return \AisFssp\StructType\CitizenQuestionsResData
     */
    public function setOspCode($ospCode = null)
    {
        // validation for constraint: length
        if ((is_scalar($ospCode) && strlen($ospCode) !== 5) || (is_array($ospCode) && count($ospCode) !== 5)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 5 element(s) or a scalar of 5 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($ospCode) && !preg_match('/[0-9]{5}/', $ospCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{5}", "%s" given', var_export($ospCode, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ospCode) && !is_string($ospCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ospCode)), __LINE__);
        }
        $this->OspCode = $ospCode;
        return $this;
    }
    /**
     * Get ForwardOspCode value
     * @return string|null
     */
    public function getForwardOspCode()
    {
        return $this->ForwardOspCode;
    }
    /**
     * Set ForwardOspCode value
     * @param string $forwardOspCode
     * @return \AisFssp\StructType\CitizenQuestionsResData
     */
    public function setForwardOspCode($forwardOspCode = null)
    {
        // validation for constraint: length
        if ((is_scalar($forwardOspCode) && strlen($forwardOspCode) !== 5) || (is_array($forwardOspCode) && count($forwardOspCode) !== 5)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 5 element(s) or a scalar of 5 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($forwardOspCode) && !preg_match('/[0-9]{5}/', $forwardOspCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{5}", "%s" given', var_export($forwardOspCode, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($forwardOspCode) && !is_string($forwardOspCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($forwardOspCode)), __LINE__);
        }
        $this->ForwardOspCode = $forwardOspCode;
        return $this;
    }
    /**
     * Get ForwardDate value
     * @return string|null
     */
    public function getForwardDate()
    {
        return $this->ForwardDate;
    }
    /**
     * Set ForwardDate value
     * @param string $forwardDate
     * @return \AisFssp\StructType\CitizenQuestionsResData
     */
    public function setForwardDate($forwardDate = null)
    {
        // validation for constraint: maxExclusive
        if ($forwardDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $forwardDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($forwardDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $forwardDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($forwardDate) && !is_string($forwardDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($forwardDate)), __LINE__);
        }
        $this->ForwardDate = $forwardDate;
        return $this;
    }
    /**
     * Get ForwardNum value
     * @return string|null
     */
    public function getForwardNum()
    {
        return $this->ForwardNum;
    }
    /**
     * Set ForwardNum value
     * @param string $forwardNum
     * @return \AisFssp\StructType\CitizenQuestionsResData
     */
    public function setForwardNum($forwardNum = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($forwardNum) && strlen($forwardNum) > 25) || (is_array($forwardNum) && count($forwardNum) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($forwardNum) ? strlen($forwardNum) : count($forwardNum)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($forwardNum) && strlen($forwardNum) < 1) || (is_array($forwardNum) && count($forwardNum) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($forwardNum) && !is_string($forwardNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($forwardNum)), __LINE__);
        }
        $this->ForwardNum = $forwardNum;
        return $this;
    }
    /**
     * Get Text value
     * @return string|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param string $text
     * @return \AisFssp\StructType\CitizenQuestionsResData
     */
    public function setText($text = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($text) && strlen($text) > 1000) || (is_array($text) && count($text) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($text) ? strlen($text) : count($text)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($text) && strlen($text) < 1) || (is_array($text) && count($text) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($text)), __LINE__);
        }
        $this->Text = $text;
        return $this;
    }
    /**
     * Get AnswerDate value
     * @return string|null
     */
    public function getAnswerDate()
    {
        return $this->AnswerDate;
    }
    /**
     * Set AnswerDate value
     * @param string $answerDate
     * @return \AisFssp\StructType\CitizenQuestionsResData
     */
    public function setAnswerDate($answerDate = null)
    {
        // validation for constraint: maxExclusive
        if ($answerDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $answerDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($answerDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $answerDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($answerDate) && !is_string($answerDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($answerDate)), __LINE__);
        }
        $this->AnswerDate = $answerDate;
        return $this;
    }
    /**
     * Get AnswerRegDocNumber value
     * @return string|null
     */
    public function getAnswerRegDocNumber()
    {
        return $this->AnswerRegDocNumber;
    }
    /**
     * Set AnswerRegDocNumber value
     * @param string $answerRegDocNumber
     * @return \AisFssp\StructType\CitizenQuestionsResData
     */
    public function setAnswerRegDocNumber($answerRegDocNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($answerRegDocNumber) && strlen($answerRegDocNumber) > 25) || (is_array($answerRegDocNumber) && count($answerRegDocNumber) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($answerRegDocNumber) ? strlen($answerRegDocNumber) : count($answerRegDocNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($answerRegDocNumber) && strlen($answerRegDocNumber) < 1) || (is_array($answerRegDocNumber) && count($answerRegDocNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($answerRegDocNumber) && !is_string($answerRegDocNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($answerRegDocNumber)), __LINE__);
        }
        $this->AnswerRegDocNumber = $answerRegDocNumber;
        return $this;
    }
    /**
     * Get Signature value
     * @return \AisFssp\StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType[] $signature
     * @return \AisFssp\StructType\CitizenQuestionsResData
     */
    public function setSignature(array $signature = array())
    {
        foreach ($signature as $citizenQuestionsResDataSignatureItem) {
            // validation for constraint: itemType
            if (!$citizenQuestionsResDataSignatureItem instanceof \AisFssp\StructType\SignatureType) {
                throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($citizenQuestionsResDataSignatureItem) ? get_class($citizenQuestionsResDataSignatureItem) : gettype($citizenQuestionsResDataSignatureItem)), __LINE__);
            }
        }
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType $item
     * @return \AisFssp\StructType\CitizenQuestionsResData
     */
    public function addToSignature(\AisFssp\StructType\SignatureType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\SignatureType) {
            throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \AisFssp\StructType\CitizenQuestionsResData
     */
    public function setId($id = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($id) && strlen($id) > 60) || (is_array($id) && count($id) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($id) ? strlen($id) : count($id)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($id) && strlen($id) < 1) || (is_array($id) && count($id) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\CitizenQuestionsResData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
