<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CaRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Запрос в ВУЦ | ЭП
 * - type: tns:CaRequest
 * @subpackage Structs
 */
class CaRequest extends AbstractStructBase
{
    /**
     * The internalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ФССП России | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от
     * контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $internalKey;
    /**
     * The docNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер запроса | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $docNumber;
    /**
     * The docDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата запроса | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $docDate;
    /**
     * The spiKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор СПИ | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта
     * от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $spiKey;
    /**
     * The spiPost
     * Meta informations extracted from the WSDL
     * - documentation: Код должности СПИ | Код должности СПИ
     * - maxLength: 25
     * - minLength: 1
     * - pattern: [0-9\-\.\s]+
     * @var string
     */
    public $spiPost;
    /**
     * The spiFIO
     * Meta informations extracted from the WSDL
     * - documentation: ФИО СПИ
     * @var \AisFssp\StructType\FioType
     */
    public $spiFIO;
    /**
     * The chiefSpiKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор старшего СПИ | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении
     * объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $chiefSpiKey;
    /**
     * The chiefSpiPost
     * Meta informations extracted from the WSDL
     * - documentation: Код должности старшего СПИ | Код должности СПИ
     * - maxLength: 25
     * - minLength: 1
     * - pattern: [0-9\-\.\s]+
     * @var string
     */
    public $chiefSpiPost;
    /**
     * The chiefSpiFIO
     * Meta informations extracted from the WSDL
     * - documentation: ФИО старшего СПИ
     * @var \AisFssp\StructType\FioType
     */
    public $chiefSpiFIO;
    /**
     * The requestType
     * Meta informations extracted from the WSDL
     * - documentation: Тип запроса ВУЦ | Тип запроса в ВУЦ
     * - length: 1
     * @var string
     */
    public $requestType;
    /**
     * The certRequest
     * Meta informations extracted from the WSDL
     * - documentation: Запрос ВУЦ | Строка длиной от 1 до 4000 символов
     * - maxLength: 4000
     * - minLength: 1
     * @var string
     */
    public $certRequest;
    /**
     * The certSign
     * Meta informations extracted from the WSDL
     * - documentation: ЭП запроса | Строка длиной от 1 до 4000 символов
     * - minOccurs: 0
     * - maxLength: 4000
     * - minLength: 1
     * @var string
     */
    public $certSign;
    /**
     * The SignDateTime
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время формирования подписи | Дата и время | Дата и время
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $SignDateTime;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \AisFssp\StructType\SignatureType[]
     */
    public $Signature;
    /**
     * Constructor method for CaRequest
     * @uses CaRequest::setInternalKey()
     * @uses CaRequest::setDocNumber()
     * @uses CaRequest::setDocDate()
     * @uses CaRequest::setSpiKey()
     * @uses CaRequest::setSpiPost()
     * @uses CaRequest::setSpiFIO()
     * @uses CaRequest::setChiefSpiKey()
     * @uses CaRequest::setChiefSpiPost()
     * @uses CaRequest::setChiefSpiFIO()
     * @uses CaRequest::setRequestType()
     * @uses CaRequest::setCertRequest()
     * @uses CaRequest::setCertSign()
     * @uses CaRequest::setSignDateTime()
     * @uses CaRequest::setSignature()
     * @param int $internalKey
     * @param string $docNumber
     * @param string $docDate
     * @param int $spiKey
     * @param string $spiPost
     * @param \AisFssp\StructType\FioType $spiFIO
     * @param int $chiefSpiKey
     * @param string $chiefSpiPost
     * @param \AisFssp\StructType\FioType $chiefSpiFIO
     * @param string $requestType
     * @param string $certRequest
     * @param string $certSign
     * @param string $signDateTime
     * @param \AisFssp\StructType\SignatureType[] $signature
     */
    public function __construct($internalKey = null, $docNumber = null, $docDate = null, $spiKey = null, $spiPost = null, \AisFssp\StructType\FioType $spiFIO = null, $chiefSpiKey = null, $chiefSpiPost = null, \AisFssp\StructType\FioType $chiefSpiFIO = null, $requestType = null, $certRequest = null, $certSign = null, $signDateTime = null, array $signature = array())
    {
        $this
            ->setInternalKey($internalKey)
            ->setDocNumber($docNumber)
            ->setDocDate($docDate)
            ->setSpiKey($spiKey)
            ->setSpiPost($spiPost)
            ->setSpiFIO($spiFIO)
            ->setChiefSpiKey($chiefSpiKey)
            ->setChiefSpiPost($chiefSpiPost)
            ->setChiefSpiFIO($chiefSpiFIO)
            ->setRequestType($requestType)
            ->setCertRequest($certRequest)
            ->setCertSign($certSign)
            ->setSignDateTime($signDateTime)
            ->setSignature($signature);
    }
    /**
     * Get internalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->internalKey;
    }
    /**
     * Set internalKey value
     * @param int $internalKey
     * @return \AisFssp\StructType\CaRequest
     */
    public function setInternalKey($internalKey = null)
    {
        // validation for constraint: maxInclusive
        if ($internalKey > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($internalKey < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($internalKey) && !is_numeric($internalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($internalKey)), __LINE__);
        }
        $this->internalKey = $internalKey;
        return $this;
    }
    /**
     * Get docNumber value
     * @return string|null
     */
    public function getDocNumber()
    {
        return $this->docNumber;
    }
    /**
     * Set docNumber value
     * @param string $docNumber
     * @return \AisFssp\StructType\CaRequest
     */
    public function setDocNumber($docNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($docNumber) && strlen($docNumber) > 25) || (is_array($docNumber) && count($docNumber) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($docNumber) ? strlen($docNumber) : count($docNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($docNumber) && strlen($docNumber) < 1) || (is_array($docNumber) && count($docNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docNumber) && !is_string($docNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docNumber)), __LINE__);
        }
        $this->docNumber = $docNumber;
        return $this;
    }
    /**
     * Get docDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->docDate;
    }
    /**
     * Set docDate value
     * @param string $docDate
     * @return \AisFssp\StructType\CaRequest
     */
    public function setDocDate($docDate = null)
    {
        // validation for constraint: maxExclusive
        if ($docDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $docDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($docDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $docDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docDate) && !is_string($docDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docDate)), __LINE__);
        }
        $this->docDate = $docDate;
        return $this;
    }
    /**
     * Get spiKey value
     * @return int|null
     */
    public function getSpiKey()
    {
        return $this->spiKey;
    }
    /**
     * Set spiKey value
     * @param int $spiKey
     * @return \AisFssp\StructType\CaRequest
     */
    public function setSpiKey($spiKey = null)
    {
        // validation for constraint: maxInclusive
        if ($spiKey > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $spiKey), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($spiKey < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $spiKey), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($spiKey) && !is_numeric($spiKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($spiKey)), __LINE__);
        }
        $this->spiKey = $spiKey;
        return $this;
    }
    /**
     * Get spiPost value
     * @return string|null
     */
    public function getSpiPost()
    {
        return $this->spiPost;
    }
    /**
     * Set spiPost value
     * @param string $spiPost
     * @return \AisFssp\StructType\CaRequest
     */
    public function setSpiPost($spiPost = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($spiPost) && strlen($spiPost) > 25) || (is_array($spiPost) && count($spiPost) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($spiPost) ? strlen($spiPost) : count($spiPost)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($spiPost) && strlen($spiPost) < 1) || (is_array($spiPost) && count($spiPost) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($spiPost) && !preg_match('/[0-9\\-\\.\\s]+/', $spiPost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9\-\.\s]+", "%s" given', var_export($spiPost, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($spiPost) && !is_string($spiPost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($spiPost)), __LINE__);
        }
        $this->spiPost = $spiPost;
        return $this;
    }
    /**
     * Get spiFIO value
     * @return \AisFssp\StructType\FioType|null
     */
    public function getSpiFIO()
    {
        return $this->spiFIO;
    }
    /**
     * Set spiFIO value
     * @param \AisFssp\StructType\FioType $spiFIO
     * @return \AisFssp\StructType\CaRequest
     */
    public function setSpiFIO(\AisFssp\StructType\FioType $spiFIO = null)
    {
        $this->spiFIO = $spiFIO;
        return $this;
    }
    /**
     * Get chiefSpiKey value
     * @return int|null
     */
    public function getChiefSpiKey()
    {
        return $this->chiefSpiKey;
    }
    /**
     * Set chiefSpiKey value
     * @param int $chiefSpiKey
     * @return \AisFssp\StructType\CaRequest
     */
    public function setChiefSpiKey($chiefSpiKey = null)
    {
        // validation for constraint: maxInclusive
        if ($chiefSpiKey > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $chiefSpiKey), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($chiefSpiKey < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $chiefSpiKey), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($chiefSpiKey) && !is_numeric($chiefSpiKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($chiefSpiKey)), __LINE__);
        }
        $this->chiefSpiKey = $chiefSpiKey;
        return $this;
    }
    /**
     * Get chiefSpiPost value
     * @return string|null
     */
    public function getChiefSpiPost()
    {
        return $this->chiefSpiPost;
    }
    /**
     * Set chiefSpiPost value
     * @param string $chiefSpiPost
     * @return \AisFssp\StructType\CaRequest
     */
    public function setChiefSpiPost($chiefSpiPost = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($chiefSpiPost) && strlen($chiefSpiPost) > 25) || (is_array($chiefSpiPost) && count($chiefSpiPost) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($chiefSpiPost) ? strlen($chiefSpiPost) : count($chiefSpiPost)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($chiefSpiPost) && strlen($chiefSpiPost) < 1) || (is_array($chiefSpiPost) && count($chiefSpiPost) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($chiefSpiPost) && !preg_match('/[0-9\\-\\.\\s]+/', $chiefSpiPost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9\-\.\s]+", "%s" given', var_export($chiefSpiPost, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($chiefSpiPost) && !is_string($chiefSpiPost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($chiefSpiPost)), __LINE__);
        }
        $this->chiefSpiPost = $chiefSpiPost;
        return $this;
    }
    /**
     * Get chiefSpiFIO value
     * @return \AisFssp\StructType\FioType|null
     */
    public function getChiefSpiFIO()
    {
        return $this->chiefSpiFIO;
    }
    /**
     * Set chiefSpiFIO value
     * @param \AisFssp\StructType\FioType $chiefSpiFIO
     * @return \AisFssp\StructType\CaRequest
     */
    public function setChiefSpiFIO(\AisFssp\StructType\FioType $chiefSpiFIO = null)
    {
        $this->chiefSpiFIO = $chiefSpiFIO;
        return $this;
    }
    /**
     * Get requestType value
     * @return string|null
     */
    public function getRequestType()
    {
        return $this->requestType;
    }
    /**
     * Set requestType value
     * @param string $requestType
     * @return \AisFssp\StructType\CaRequest
     */
    public function setRequestType($requestType = null)
    {
        // validation for constraint: length
        if ((is_scalar($requestType) && strlen($requestType) !== 1) || (is_array($requestType) && count($requestType) !== 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s)', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestType) && !is_string($requestType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestType)), __LINE__);
        }
        $this->requestType = $requestType;
        return $this;
    }
    /**
     * Get certRequest value
     * @return string|null
     */
    public function getCertRequest()
    {
        return $this->certRequest;
    }
    /**
     * Set certRequest value
     * @param string $certRequest
     * @return \AisFssp\StructType\CaRequest
     */
    public function setCertRequest($certRequest = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($certRequest) && strlen($certRequest) > 4000) || (is_array($certRequest) && count($certRequest) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($certRequest) ? strlen($certRequest) : count($certRequest)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($certRequest) && strlen($certRequest) < 1) || (is_array($certRequest) && count($certRequest) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($certRequest) && !is_string($certRequest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($certRequest)), __LINE__);
        }
        $this->certRequest = $certRequest;
        return $this;
    }
    /**
     * Get certSign value
     * @return string|null
     */
    public function getCertSign()
    {
        return $this->certSign;
    }
    /**
     * Set certSign value
     * @param string $certSign
     * @return \AisFssp\StructType\CaRequest
     */
    public function setCertSign($certSign = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($certSign) && strlen($certSign) > 4000) || (is_array($certSign) && count($certSign) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($certSign) ? strlen($certSign) : count($certSign)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($certSign) && strlen($certSign) < 1) || (is_array($certSign) && count($certSign) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($certSign) && !is_string($certSign)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($certSign)), __LINE__);
        }
        $this->certSign = $certSign;
        return $this;
    }
    /**
     * Get SignDateTime value
     * @return string|null
     */
    public function getSignDateTime()
    {
        return $this->SignDateTime;
    }
    /**
     * Set SignDateTime value
     * @param string $signDateTime
     * @return \AisFssp\StructType\CaRequest
     */
    public function setSignDateTime($signDateTime = null)
    {
        // validation for constraint: maxExclusive
        if ($signDateTime >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $signDateTime), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($signDateTime < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $signDateTime), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($signDateTime) && !is_string($signDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($signDateTime)), __LINE__);
        }
        $this->SignDateTime = $signDateTime;
        return $this;
    }
    /**
     * Get Signature value
     * @return \AisFssp\StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType[] $signature
     * @return \AisFssp\StructType\CaRequest
     */
    public function setSignature(array $signature = array())
    {
        foreach ($signature as $caRequestSignatureItem) {
            // validation for constraint: itemType
            if (!$caRequestSignatureItem instanceof \AisFssp\StructType\SignatureType) {
                throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($caRequestSignatureItem) ? get_class($caRequestSignatureItem) : gettype($caRequestSignatureItem)), __LINE__);
            }
        }
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType $item
     * @return \AisFssp\StructType\CaRequest
     */
    public function addToSignature(\AisFssp\StructType\SignatureType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\SignatureType) {
            throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\CaRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
