<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BriefIPInformationType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип данных BriefIPInformationType «Сокращенные сведения об ИП»
 * @subpackage Structs
 */
class BriefIPInformationType extends AbstractStructBase
{
    /**
     * The IPKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ИП ФССП России | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта
     * от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $IPKey;
    /**
     * The IDType
     * Meta informations extracted from the WSDL
     * - documentation: Тип ИД
     * @var string
     */
    public $IDType;
    /**
     * The IDName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование типа ИД | Строка длиной от 1 до 100 символов
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $IDName;
    /**
     * The IDOrgCode
     * Meta informations extracted from the WSDL
     * - documentation: Код органа, выдавшего ИД | Код организации | NSI_MVV_Organization
     * - minOccurs: 0
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $IDOrgCode;
    /**
     * The IDOrgName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование органа, выдавшего ИД | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $IDOrgName;
    /**
     * The IDNum
     * Meta informations extracted from the WSDL
     * - documentation: Номер ИД | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $IDNum;
    /**
     * The IDDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата ИД | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $IDDate;
    /**
     * The number
     * Meta informations extracted from the WSDL
     * - documentation: Номер исполнительного производства | Строка длиной от 1 до 25 символов
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $number;
    /**
     * The riseDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата возбуждения | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $riseDate;
    /**
     * The numberComposite
     * Meta informations extracted from the WSDL
     * - documentation: Номер сводного исполнительного производства | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $numberComposite;
    /**
     * The debtText
     * Meta informations extracted from the WSDL
     * - documentation: Предмет исполнения | Строка длиной от 1 до 200 символов
     * - minOccurs: 0
     * - maxLength: 200
     * - minLength: 1
     * @var string
     */
    public $debtText;
    /**
     * The debtorName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование должника | Строка длиной от 1 до 200 символов
     * - maxLength: 200
     * - minLength: 1
     * @var string
     */
    public $debtorName;
    /**
     * The debtorBirthDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата рождения должника | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $debtorBirthDate;
    /**
     * The debtorBirthYear
     * Meta informations extracted from the WSDL
     * - documentation: Год рождения | Год (выпуска, рождения и т. п.)
     * - minOccurs: 0
     * - maxInclusive: 2099
     * - minInclusive: 1900
     * @var string
     */
    public $debtorBirthYear;
    /**
     * The debtorBirthplace
     * Meta informations extracted from the WSDL
     * - documentation: Место рождения должника | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $debtorBirthplace;
    /**
     * The debtorAddress
     * Meta informations extracted from the WSDL
     * - documentation: Адрес должника ЮЛ | Строка длиной от 1 до 150 символов
     * - minOccurs: 0
     * - maxLength: 150
     * - minLength: 1
     * @var string
     */
    public $debtorAddress;
    /**
     * The debtSum
     * Meta informations extracted from the WSDL
     * - documentation: Сумма долга по ИД | Сумма
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $debtSum;
    /**
     * The debtRestTotal
     * Meta informations extracted from the WSDL
     * - documentation: Остаток долга всего | Сумма
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $debtRestTotal;
    /**
     * The debtRestIP
     * Meta informations extracted from the WSDL
     * - documentation: Остаток долга по ИП | Сумма
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $debtRestIP;
    /**
     * The debtRestFine
     * Meta informations extracted from the WSDL
     * - documentation: Остаток долга по штрафу СПИ | Сумма
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $debtRestFine;
    /**
     * The debtRestDuty
     * Meta informations extracted from the WSDL
     * - documentation: Остаток задолженности по исполнительскому сбору | Сумма
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $debtRestDuty;
    /**
     * The debtRestOther
     * Meta informations extracted from the WSDL
     * - documentation: Остаток задолженности по расходам по исполнительским действиям | Сумма
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $debtRestOther;
    /**
     * The IPEndDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата завершения ИП | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $IPEndDate;
    /**
     * The IPEndArticle
     * Meta informations extracted from the WSDL
     * - documentation: Cтатья основание окончания ИП | Строка длиной от 1 до 10 символов
     * - minOccurs: 0
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $IPEndArticle;
    /**
     * The IPEndPoint
     * Meta informations extracted from the WSDL
     * - documentation: Пункт основание окончания ИП | Строка длиной от 1 до 10 символов
     * - minOccurs: 0
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $IPEndPoint;
    /**
     * The IPEndSubpoint
     * Meta informations extracted from the WSDL
     * - documentation: Подпункт основание окончания ИП | Строка длиной от 1 до 10 символов
     * - minOccurs: 0
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $IPEndSubpoint;
    /**
     * The ospCode
     * Meta informations extracted from the WSDL
     * - documentation: Код отдела судебных приставов | Ведомственный классификатор отделов судебных приставов | NSI_Departments
     * - length: 5
     * - pattern: [0-9]{5}
     * @var string
     */
    public $ospCode;
    /**
     * The divName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование отдела судебных приставов | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $divName;
    /**
     * The divAdr
     * Meta informations extracted from the WSDL
     * - documentation: Адрес отдела судебных приставов | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $divAdr;
    /**
     * The SPIShortName
     * Meta informations extracted from the WSDL
     * - documentation: Фамилия и инициалы судебного пристава-исполнителя | Строка длиной от 1 до 20 символов
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $SPIShortName;
    /**
     * The SPITelephone
     * Meta informations extracted from the WSDL
     * - documentation: Телефон судебного пристава-исполнителя | Номер телефона
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $SPITelephone;
    /**
     * The actualityDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время актуальности данных | Дата и время | Дата и время
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $actualityDate;
    /**
     * The unifoChargeFssp
     * Meta informations extracted from the WSDL
     * - documentation: УИН ФССП | Код начисления УНИФО
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 20
     * - pattern: (([0-9a-zA-Zа-яА-Я]{19})|([0-9]{8}[0-9a-zA-Zа-яА-Я]{16}))[0-9]
     * @var string
     */
    public $unifoChargeFssp;
    /**
     * The unifoChargeExt
     * Meta informations extracted from the WSDL
     * - documentation: УИН Внешнего контрагента | Код начисления УНИФО
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 20
     * - pattern: (([0-9a-zA-Zа-яА-Я]{19})|([0-9]{8}[0-9a-zA-Zа-яА-Я]{16}))[0-9]
     * @var string
     */
    public $unifoChargeExt;
    /**
     * Constructor method for BriefIPInformationType
     * @uses BriefIPInformationType::setIPKey()
     * @uses BriefIPInformationType::setIDType()
     * @uses BriefIPInformationType::setIDName()
     * @uses BriefIPInformationType::setIDOrgCode()
     * @uses BriefIPInformationType::setIDOrgName()
     * @uses BriefIPInformationType::setIDNum()
     * @uses BriefIPInformationType::setIDDate()
     * @uses BriefIPInformationType::setNumber()
     * @uses BriefIPInformationType::setRiseDate()
     * @uses BriefIPInformationType::setNumberComposite()
     * @uses BriefIPInformationType::setDebtText()
     * @uses BriefIPInformationType::setDebtorName()
     * @uses BriefIPInformationType::setDebtorBirthDate()
     * @uses BriefIPInformationType::setDebtorBirthYear()
     * @uses BriefIPInformationType::setDebtorBirthplace()
     * @uses BriefIPInformationType::setDebtorAddress()
     * @uses BriefIPInformationType::setDebtSum()
     * @uses BriefIPInformationType::setDebtRestTotal()
     * @uses BriefIPInformationType::setDebtRestIP()
     * @uses BriefIPInformationType::setDebtRestFine()
     * @uses BriefIPInformationType::setDebtRestDuty()
     * @uses BriefIPInformationType::setDebtRestOther()
     * @uses BriefIPInformationType::setIPEndDate()
     * @uses BriefIPInformationType::setIPEndArticle()
     * @uses BriefIPInformationType::setIPEndPoint()
     * @uses BriefIPInformationType::setIPEndSubpoint()
     * @uses BriefIPInformationType::setOspCode()
     * @uses BriefIPInformationType::setDivName()
     * @uses BriefIPInformationType::setDivAdr()
     * @uses BriefIPInformationType::setSPIShortName()
     * @uses BriefIPInformationType::setSPITelephone()
     * @uses BriefIPInformationType::setActualityDate()
     * @uses BriefIPInformationType::setUnifoChargeFssp()
     * @uses BriefIPInformationType::setUnifoChargeExt()
     * @param int $iPKey
     * @param string $iDType
     * @param string $iDName
     * @param string $iDOrgCode
     * @param string $iDOrgName
     * @param string $iDNum
     * @param string $iDDate
     * @param string $number
     * @param string $riseDate
     * @param string $numberComposite
     * @param string $debtText
     * @param string $debtorName
     * @param string $debtorBirthDate
     * @param string $debtorBirthYear
     * @param string $debtorBirthplace
     * @param string $debtorAddress
     * @param float $debtSum
     * @param float $debtRestTotal
     * @param float $debtRestIP
     * @param float $debtRestFine
     * @param float $debtRestDuty
     * @param float $debtRestOther
     * @param string $iPEndDate
     * @param string $iPEndArticle
     * @param string $iPEndPoint
     * @param string $iPEndSubpoint
     * @param string $ospCode
     * @param string $divName
     * @param string $divAdr
     * @param string $sPIShortName
     * @param string $sPITelephone
     * @param string $actualityDate
     * @param string $unifoChargeFssp
     * @param string $unifoChargeExt
     */
    public function __construct($iPKey = null, $iDType = null, $iDName = null, $iDOrgCode = null, $iDOrgName = null, $iDNum = null, $iDDate = null, $number = null, $riseDate = null, $numberComposite = null, $debtText = null, $debtorName = null, $debtorBirthDate = null, $debtorBirthYear = null, $debtorBirthplace = null, $debtorAddress = null, $debtSum = null, $debtRestTotal = null, $debtRestIP = null, $debtRestFine = null, $debtRestDuty = null, $debtRestOther = null, $iPEndDate = null, $iPEndArticle = null, $iPEndPoint = null, $iPEndSubpoint = null, $ospCode = null, $divName = null, $divAdr = null, $sPIShortName = null, $sPITelephone = null, $actualityDate = null, $unifoChargeFssp = null, $unifoChargeExt = null)
    {
        $this
            ->setIPKey($iPKey)
            ->setIDType($iDType)
            ->setIDName($iDName)
            ->setIDOrgCode($iDOrgCode)
            ->setIDOrgName($iDOrgName)
            ->setIDNum($iDNum)
            ->setIDDate($iDDate)
            ->setNumber($number)
            ->setRiseDate($riseDate)
            ->setNumberComposite($numberComposite)
            ->setDebtText($debtText)
            ->setDebtorName($debtorName)
            ->setDebtorBirthDate($debtorBirthDate)
            ->setDebtorBirthYear($debtorBirthYear)
            ->setDebtorBirthplace($debtorBirthplace)
            ->setDebtorAddress($debtorAddress)
            ->setDebtSum($debtSum)
            ->setDebtRestTotal($debtRestTotal)
            ->setDebtRestIP($debtRestIP)
            ->setDebtRestFine($debtRestFine)
            ->setDebtRestDuty($debtRestDuty)
            ->setDebtRestOther($debtRestOther)
            ->setIPEndDate($iPEndDate)
            ->setIPEndArticle($iPEndArticle)
            ->setIPEndPoint($iPEndPoint)
            ->setIPEndSubpoint($iPEndSubpoint)
            ->setOspCode($ospCode)
            ->setDivName($divName)
            ->setDivAdr($divAdr)
            ->setSPIShortName($sPIShortName)
            ->setSPITelephone($sPITelephone)
            ->setActualityDate($actualityDate)
            ->setUnifoChargeFssp($unifoChargeFssp)
            ->setUnifoChargeExt($unifoChargeExt);
    }
    /**
     * Get IPKey value
     * @return int|null
     */
    public function getIPKey()
    {
        return $this->IPKey;
    }
    /**
     * Set IPKey value
     * @param int $iPKey
     * @return \AisFssp\StructType\BriefIPInformationType
     */
    public function setIPKey($iPKey = null)
    {
        // validation for constraint: maxInclusive
        if ($iPKey > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $iPKey), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($iPKey < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $iPKey), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($iPKey) && !is_numeric($iPKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iPKey)), __LINE__);
        }
        $this->IPKey = $iPKey;
        return $this;
    }
    /**
     * Get IDType value
     * @return string|null
     */
    public function getIDType()
    {
        return $this->IDType;
    }
    /**
     * Set IDType value
     * @uses \AisFssp\EnumType\IdType::valueIsValid()
     * @uses \AisFssp\EnumType\IdType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $iDType
     * @return \AisFssp\StructType\BriefIPInformationType
     */
    public function setIDType($iDType = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\IdType::valueIsValid($iDType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $iDType, implode(', ', \AisFssp\EnumType\IdType::getValidValues())), __LINE__);
        }
        $this->IDType = $iDType;
        return $this;
    }
    /**
     * Get IDName value
     * @return string|null
     */
    public function getIDName()
    {
        return $this->IDName;
    }
    /**
     * Set IDName value
     * @param string $iDName
     * @return \AisFssp\StructType\BriefIPInformationType
     */
    public function setIDName($iDName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iDName) && strlen($iDName) > 100) || (is_array($iDName) && count($iDName) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($iDName) ? strlen($iDName) : count($iDName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($iDName) && strlen($iDName) < 1) || (is_array($iDName) && count($iDName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iDName) && !is_string($iDName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iDName)), __LINE__);
        }
        $this->IDName = $iDName;
        return $this;
    }
    /**
     * Get IDOrgCode value
     * @return string|null
     */
    public function getIDOrgCode()
    {
        return $this->IDOrgCode;
    }
    /**
     * Set IDOrgCode value
     * @param string $iDOrgCode
     * @return \AisFssp\StructType\BriefIPInformationType
     */
    public function setIDOrgCode($iDOrgCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iDOrgCode) && strlen($iDOrgCode) > 20) || (is_array($iDOrgCode) && count($iDOrgCode) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($iDOrgCode) ? strlen($iDOrgCode) : count($iDOrgCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($iDOrgCode) && strlen($iDOrgCode) < 1) || (is_array($iDOrgCode) && count($iDOrgCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iDOrgCode) && !is_string($iDOrgCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iDOrgCode)), __LINE__);
        }
        $this->IDOrgCode = $iDOrgCode;
        return $this;
    }
    /**
     * Get IDOrgName value
     * @return string|null
     */
    public function getIDOrgName()
    {
        return $this->IDOrgName;
    }
    /**
     * Set IDOrgName value
     * @param string $iDOrgName
     * @return \AisFssp\StructType\BriefIPInformationType
     */
    public function setIDOrgName($iDOrgName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iDOrgName) && strlen($iDOrgName) > 300) || (is_array($iDOrgName) && count($iDOrgName) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($iDOrgName) ? strlen($iDOrgName) : count($iDOrgName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($iDOrgName) && strlen($iDOrgName) < 1) || (is_array($iDOrgName) && count($iDOrgName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iDOrgName) && !is_string($iDOrgName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iDOrgName)), __LINE__);
        }
        $this->IDOrgName = $iDOrgName;
        return $this;
    }
    /**
     * Get IDNum value
     * @return string|null
     */
    public function getIDNum()
    {
        return $this->IDNum;
    }
    /**
     * Set IDNum value
     * @param string $iDNum
     * @return \AisFssp\StructType\BriefIPInformationType
     */
    public function setIDNum($iDNum = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iDNum) && strlen($iDNum) > 25) || (is_array($iDNum) && count($iDNum) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($iDNum) ? strlen($iDNum) : count($iDNum)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($iDNum) && strlen($iDNum) < 1) || (is_array($iDNum) && count($iDNum) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iDNum) && !is_string($iDNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iDNum)), __LINE__);
        }
        $this->IDNum = $iDNum;
        return $this;
    }
    /**
     * Get IDDate value
     * @return string|null
     */
    public function getIDDate()
    {
        return $this->IDDate;
    }
    /**
     * Set IDDate value
     * @param string $iDDate
     * @return \AisFssp\StructType\BriefIPInformationType
     */
    public function setIDDate($iDDate = null)
    {
        // validation for constraint: maxExclusive
        if ($iDDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $iDDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($iDDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $iDDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iDDate) && !is_string($iDDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iDDate)), __LINE__);
        }
        $this->IDDate = $iDDate;
        return $this;
    }
    /**
     * Get number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param string $number
     * @return \AisFssp\StructType\BriefIPInformationType
     */
    public function setNumber($number = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($number) && strlen($number) > 25) || (is_array($number) && count($number) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($number) ? strlen($number) : count($number)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($number) && strlen($number) < 1) || (is_array($number) && count($number) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($number)), __LINE__);
        }
        $this->number = $number;
        return $this;
    }
    /**
     * Get riseDate value
     * @return string|null
     */
    public function getRiseDate()
    {
        return $this->riseDate;
    }
    /**
     * Set riseDate value
     * @param string $riseDate
     * @return \AisFssp\StructType\BriefIPInformationType
     */
    public function setRiseDate($riseDate = null)
    {
        // validation for constraint: maxExclusive
        if ($riseDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $riseDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($riseDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $riseDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($riseDate) && !is_string($riseDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($riseDate)), __LINE__);
        }
        $this->riseDate = $riseDate;
        return $this;
    }
    /**
     * Get numberComposite value
     * @return string|null
     */
    public function getNumberComposite()
    {
        return $this->numberComposite;
    }
    /**
     * Set numberComposite value
     * @param string $numberComposite
     * @return \AisFssp\StructType\BriefIPInformationType
     */
    public function setNumberComposite($numberComposite = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($numberComposite) && strlen($numberComposite) > 25) || (is_array($numberComposite) && count($numberComposite) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($numberComposite) ? strlen($numberComposite) : count($numberComposite)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($numberComposite) && strlen($numberComposite) < 1) || (is_array($numberComposite) && count($numberComposite) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($numberComposite) && !is_string($numberComposite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($numberComposite)), __LINE__);
        }
        $this->numberComposite = $numberComposite;
        return $this;
    }
    /**
     * Get debtText value
     * @return string|null
     */
    public function getDebtText()
    {
        return $this->debtText;
    }
    /**
     * Set debtText value
     * @param string $debtText
     * @return \AisFssp\StructType\BriefIPInformationType
     */
    public function setDebtText($debtText = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($debtText) && strlen($debtText) > 200) || (is_array($debtText) && count($debtText) > 200)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 200 element(s) or a scalar of 200 character(s) at most, "%d" length given', is_scalar($debtText) ? strlen($debtText) : count($debtText)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($debtText) && strlen($debtText) < 1) || (is_array($debtText) && count($debtText) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($debtText) && !is_string($debtText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($debtText)), __LINE__);
        }
        $this->debtText = $debtText;
        return $this;
    }
    /**
     * Get debtorName value
     * @return string|null
     */
    public function getDebtorName()
    {
        return $this->debtorName;
    }
    /**
     * Set debtorName value
     * @param string $debtorName
     * @return \AisFssp\StructType\BriefIPInformationType
     */
    public function setDebtorName($debtorName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($debtorName) && strlen($debtorName) > 200) || (is_array($debtorName) && count($debtorName) > 200)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 200 element(s) or a scalar of 200 character(s) at most, "%d" length given', is_scalar($debtorName) ? strlen($debtorName) : count($debtorName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($debtorName) && strlen($debtorName) < 1) || (is_array($debtorName) && count($debtorName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($debtorName) && !is_string($debtorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($debtorName)), __LINE__);
        }
        $this->debtorName = $debtorName;
        return $this;
    }
    /**
     * Get debtorBirthDate value
     * @return string|null
     */
    public function getDebtorBirthDate()
    {
        return $this->debtorBirthDate;
    }
    /**
     * Set debtorBirthDate value
     * @param string $debtorBirthDate
     * @return \AisFssp\StructType\BriefIPInformationType
     */
    public function setDebtorBirthDate($debtorBirthDate = null)
    {
        // validation for constraint: maxExclusive
        if ($debtorBirthDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $debtorBirthDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($debtorBirthDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $debtorBirthDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($debtorBirthDate) && !is_string($debtorBirthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($debtorBirthDate)), __LINE__);
        }
        $this->debtorBirthDate = $debtorBirthDate;
        return $this;
    }
    /**
     * Get debtorBirthYear value
     * @return string|null
     */
    public function getDebtorBirthYear()
    {
        return $this->debtorBirthYear;
    }
    /**
     * Set debtorBirthYear value
     * @param string $debtorBirthYear
     * @return \AisFssp\StructType\BriefIPInformationType
     */
    public function setDebtorBirthYear($debtorBirthYear = null)
    {
        // validation for constraint: maxInclusive
        if ($debtorBirthYear > 2099) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 2099, "%s" given', $debtorBirthYear), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($debtorBirthYear < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $debtorBirthYear), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($debtorBirthYear) && !is_string($debtorBirthYear)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($debtorBirthYear)), __LINE__);
        }
        $this->debtorBirthYear = $debtorBirthYear;
        return $this;
    }
    /**
     * Get debtorBirthplace value
     * @return string|null
     */
    public function getDebtorBirthplace()
    {
        return $this->debtorBirthplace;
    }
    /**
     * Set debtorBirthplace value
     * @param string $debtorBirthplace
     * @return \AisFssp\StructType\BriefIPInformationType
     */
    public function setDebtorBirthplace($debtorBirthplace = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($debtorBirthplace) && strlen($debtorBirthplace) > 300) || (is_array($debtorBirthplace) && count($debtorBirthplace) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($debtorBirthplace) ? strlen($debtorBirthplace) : count($debtorBirthplace)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($debtorBirthplace) && strlen($debtorBirthplace) < 1) || (is_array($debtorBirthplace) && count($debtorBirthplace) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($debtorBirthplace) && !is_string($debtorBirthplace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($debtorBirthplace)), __LINE__);
        }
        $this->debtorBirthplace = $debtorBirthplace;
        return $this;
    }
    /**
     * Get debtorAddress value
     * @return string|null
     */
    public function getDebtorAddress()
    {
        return $this->debtorAddress;
    }
    /**
     * Set debtorAddress value
     * @param string $debtorAddress
     * @return \AisFssp\StructType\BriefIPInformationType
     */
    public function setDebtorAddress($debtorAddress = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($debtorAddress) && strlen($debtorAddress) > 150) || (is_array($debtorAddress) && count($debtorAddress) > 150)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 150 element(s) or a scalar of 150 character(s) at most, "%d" length given', is_scalar($debtorAddress) ? strlen($debtorAddress) : count($debtorAddress)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($debtorAddress) && strlen($debtorAddress) < 1) || (is_array($debtorAddress) && count($debtorAddress) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($debtorAddress) && !is_string($debtorAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($debtorAddress)), __LINE__);
        }
        $this->debtorAddress = $debtorAddress;
        return $this;
    }
    /**
     * Get debtSum value
     * @return float|null
     */
    public function getDebtSum()
    {
        return $this->debtSum;
    }
    /**
     * Set debtSum value
     * @param float $debtSum
     * @return \AisFssp\StructType\BriefIPInformationType
     */
    public function setDebtSum($debtSum = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($debtSum) && strlen(substr($debtSum, strpos($debtSum, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($debtSum, strpos($debtSum, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($debtSum) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $debtSum)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($debtSum, strpos($debtSum, '.')))), __LINE__);
        }
        $this->debtSum = $debtSum;
        return $this;
    }
    /**
     * Get debtRestTotal value
     * @return float|null
     */
    public function getDebtRestTotal()
    {
        return $this->debtRestTotal;
    }
    /**
     * Set debtRestTotal value
     * @param float $debtRestTotal
     * @return \AisFssp\StructType\BriefIPInformationType
     */
    public function setDebtRestTotal($debtRestTotal = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($debtRestTotal) && strlen(substr($debtRestTotal, strpos($debtRestTotal, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($debtRestTotal, strpos($debtRestTotal, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($debtRestTotal) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $debtRestTotal)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($debtRestTotal, strpos($debtRestTotal, '.')))), __LINE__);
        }
        $this->debtRestTotal = $debtRestTotal;
        return $this;
    }
    /**
     * Get debtRestIP value
     * @return float|null
     */
    public function getDebtRestIP()
    {
        return $this->debtRestIP;
    }
    /**
     * Set debtRestIP value
     * @param float $debtRestIP
     * @return \AisFssp\StructType\BriefIPInformationType
     */
    public function setDebtRestIP($debtRestIP = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($debtRestIP) && strlen(substr($debtRestIP, strpos($debtRestIP, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($debtRestIP, strpos($debtRestIP, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($debtRestIP) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $debtRestIP)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($debtRestIP, strpos($debtRestIP, '.')))), __LINE__);
        }
        $this->debtRestIP = $debtRestIP;
        return $this;
    }
    /**
     * Get debtRestFine value
     * @return float|null
     */
    public function getDebtRestFine()
    {
        return $this->debtRestFine;
    }
    /**
     * Set debtRestFine value
     * @param float $debtRestFine
     * @return \AisFssp\StructType\BriefIPInformationType
     */
    public function setDebtRestFine($debtRestFine = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($debtRestFine) && strlen(substr($debtRestFine, strpos($debtRestFine, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($debtRestFine, strpos($debtRestFine, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($debtRestFine) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $debtRestFine)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($debtRestFine, strpos($debtRestFine, '.')))), __LINE__);
        }
        $this->debtRestFine = $debtRestFine;
        return $this;
    }
    /**
     * Get debtRestDuty value
     * @return float|null
     */
    public function getDebtRestDuty()
    {
        return $this->debtRestDuty;
    }
    /**
     * Set debtRestDuty value
     * @param float $debtRestDuty
     * @return \AisFssp\StructType\BriefIPInformationType
     */
    public function setDebtRestDuty($debtRestDuty = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($debtRestDuty) && strlen(substr($debtRestDuty, strpos($debtRestDuty, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($debtRestDuty, strpos($debtRestDuty, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($debtRestDuty) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $debtRestDuty)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($debtRestDuty, strpos($debtRestDuty, '.')))), __LINE__);
        }
        $this->debtRestDuty = $debtRestDuty;
        return $this;
    }
    /**
     * Get debtRestOther value
     * @return float|null
     */
    public function getDebtRestOther()
    {
        return $this->debtRestOther;
    }
    /**
     * Set debtRestOther value
     * @param float $debtRestOther
     * @return \AisFssp\StructType\BriefIPInformationType
     */
    public function setDebtRestOther($debtRestOther = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($debtRestOther) && strlen(substr($debtRestOther, strpos($debtRestOther, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($debtRestOther, strpos($debtRestOther, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($debtRestOther) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $debtRestOther)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($debtRestOther, strpos($debtRestOther, '.')))), __LINE__);
        }
        $this->debtRestOther = $debtRestOther;
        return $this;
    }
    /**
     * Get IPEndDate value
     * @return string|null
     */
    public function getIPEndDate()
    {
        return $this->IPEndDate;
    }
    /**
     * Set IPEndDate value
     * @param string $iPEndDate
     * @return \AisFssp\StructType\BriefIPInformationType
     */
    public function setIPEndDate($iPEndDate = null)
    {
        // validation for constraint: maxExclusive
        if ($iPEndDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $iPEndDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($iPEndDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $iPEndDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iPEndDate) && !is_string($iPEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iPEndDate)), __LINE__);
        }
        $this->IPEndDate = $iPEndDate;
        return $this;
    }
    /**
     * Get IPEndArticle value
     * @return string|null
     */
    public function getIPEndArticle()
    {
        return $this->IPEndArticle;
    }
    /**
     * Set IPEndArticle value
     * @param string $iPEndArticle
     * @return \AisFssp\StructType\BriefIPInformationType
     */
    public function setIPEndArticle($iPEndArticle = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iPEndArticle) && strlen($iPEndArticle) > 10) || (is_array($iPEndArticle) && count($iPEndArticle) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($iPEndArticle) ? strlen($iPEndArticle) : count($iPEndArticle)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($iPEndArticle) && strlen($iPEndArticle) < 1) || (is_array($iPEndArticle) && count($iPEndArticle) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iPEndArticle) && !is_string($iPEndArticle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iPEndArticle)), __LINE__);
        }
        $this->IPEndArticle = $iPEndArticle;
        return $this;
    }
    /**
     * Get IPEndPoint value
     * @return string|null
     */
    public function getIPEndPoint()
    {
        return $this->IPEndPoint;
    }
    /**
     * Set IPEndPoint value
     * @param string $iPEndPoint
     * @return \AisFssp\StructType\BriefIPInformationType
     */
    public function setIPEndPoint($iPEndPoint = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iPEndPoint) && strlen($iPEndPoint) > 10) || (is_array($iPEndPoint) && count($iPEndPoint) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($iPEndPoint) ? strlen($iPEndPoint) : count($iPEndPoint)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($iPEndPoint) && strlen($iPEndPoint) < 1) || (is_array($iPEndPoint) && count($iPEndPoint) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iPEndPoint) && !is_string($iPEndPoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iPEndPoint)), __LINE__);
        }
        $this->IPEndPoint = $iPEndPoint;
        return $this;
    }
    /**
     * Get IPEndSubpoint value
     * @return string|null
     */
    public function getIPEndSubpoint()
    {
        return $this->IPEndSubpoint;
    }
    /**
     * Set IPEndSubpoint value
     * @param string $iPEndSubpoint
     * @return \AisFssp\StructType\BriefIPInformationType
     */
    public function setIPEndSubpoint($iPEndSubpoint = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iPEndSubpoint) && strlen($iPEndSubpoint) > 10) || (is_array($iPEndSubpoint) && count($iPEndSubpoint) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($iPEndSubpoint) ? strlen($iPEndSubpoint) : count($iPEndSubpoint)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($iPEndSubpoint) && strlen($iPEndSubpoint) < 1) || (is_array($iPEndSubpoint) && count($iPEndSubpoint) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iPEndSubpoint) && !is_string($iPEndSubpoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iPEndSubpoint)), __LINE__);
        }
        $this->IPEndSubpoint = $iPEndSubpoint;
        return $this;
    }
    /**
     * Get ospCode value
     * @return string|null
     */
    public function getOspCode()
    {
        return $this->ospCode;
    }
    /**
     * Set ospCode value
     * @param string $ospCode
     * @return \AisFssp\StructType\BriefIPInformationType
     */
    public function setOspCode($ospCode = null)
    {
        // validation for constraint: length
        if ((is_scalar($ospCode) && strlen($ospCode) !== 5) || (is_array($ospCode) && count($ospCode) !== 5)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 5 element(s) or a scalar of 5 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($ospCode) && !preg_match('/[0-9]{5}/', $ospCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{5}", "%s" given', var_export($ospCode, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ospCode) && !is_string($ospCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ospCode)), __LINE__);
        }
        $this->ospCode = $ospCode;
        return $this;
    }
    /**
     * Get divName value
     * @return string|null
     */
    public function getDivName()
    {
        return $this->divName;
    }
    /**
     * Set divName value
     * @param string $divName
     * @return \AisFssp\StructType\BriefIPInformationType
     */
    public function setDivName($divName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($divName) && strlen($divName) > 1000) || (is_array($divName) && count($divName) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($divName) ? strlen($divName) : count($divName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($divName) && strlen($divName) < 1) || (is_array($divName) && count($divName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($divName) && !is_string($divName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($divName)), __LINE__);
        }
        $this->divName = $divName;
        return $this;
    }
    /**
     * Get divAdr value
     * @return string|null
     */
    public function getDivAdr()
    {
        return $this->divAdr;
    }
    /**
     * Set divAdr value
     * @param string $divAdr
     * @return \AisFssp\StructType\BriefIPInformationType
     */
    public function setDivAdr($divAdr = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($divAdr) && strlen($divAdr) > 300) || (is_array($divAdr) && count($divAdr) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($divAdr) ? strlen($divAdr) : count($divAdr)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($divAdr) && strlen($divAdr) < 1) || (is_array($divAdr) && count($divAdr) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($divAdr) && !is_string($divAdr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($divAdr)), __LINE__);
        }
        $this->divAdr = $divAdr;
        return $this;
    }
    /**
     * Get SPIShortName value
     * @return string|null
     */
    public function getSPIShortName()
    {
        return $this->SPIShortName;
    }
    /**
     * Set SPIShortName value
     * @param string $sPIShortName
     * @return \AisFssp\StructType\BriefIPInformationType
     */
    public function setSPIShortName($sPIShortName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($sPIShortName) && strlen($sPIShortName) > 20) || (is_array($sPIShortName) && count($sPIShortName) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($sPIShortName) ? strlen($sPIShortName) : count($sPIShortName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($sPIShortName) && strlen($sPIShortName) < 1) || (is_array($sPIShortName) && count($sPIShortName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sPIShortName) && !is_string($sPIShortName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sPIShortName)), __LINE__);
        }
        $this->SPIShortName = $sPIShortName;
        return $this;
    }
    /**
     * Get SPITelephone value
     * @return string|null
     */
    public function getSPITelephone()
    {
        return $this->SPITelephone;
    }
    /**
     * Set SPITelephone value
     * @param string $sPITelephone
     * @return \AisFssp\StructType\BriefIPInformationType
     */
    public function setSPITelephone($sPITelephone = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($sPITelephone) && strlen($sPITelephone) > 25) || (is_array($sPITelephone) && count($sPITelephone) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($sPITelephone) ? strlen($sPITelephone) : count($sPITelephone)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($sPITelephone) && strlen($sPITelephone) < 1) || (is_array($sPITelephone) && count($sPITelephone) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sPITelephone) && !is_string($sPITelephone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sPITelephone)), __LINE__);
        }
        $this->SPITelephone = $sPITelephone;
        return $this;
    }
    /**
     * Get actualityDate value
     * @return string|null
     */
    public function getActualityDate()
    {
        return $this->actualityDate;
    }
    /**
     * Set actualityDate value
     * @param string $actualityDate
     * @return \AisFssp\StructType\BriefIPInformationType
     */
    public function setActualityDate($actualityDate = null)
    {
        // validation for constraint: maxExclusive
        if ($actualityDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $actualityDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($actualityDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $actualityDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($actualityDate) && !is_string($actualityDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($actualityDate)), __LINE__);
        }
        $this->actualityDate = $actualityDate;
        return $this;
    }
    /**
     * Get unifoChargeFssp value
     * @return string|null
     */
    public function getUnifoChargeFssp()
    {
        return $this->unifoChargeFssp;
    }
    /**
     * Set unifoChargeFssp value
     * @param string $unifoChargeFssp
     * @return \AisFssp\StructType\BriefIPInformationType
     */
    public function setUnifoChargeFssp($unifoChargeFssp = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($unifoChargeFssp) && strlen($unifoChargeFssp) > 25) || (is_array($unifoChargeFssp) && count($unifoChargeFssp) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($unifoChargeFssp) ? strlen($unifoChargeFssp) : count($unifoChargeFssp)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($unifoChargeFssp) && strlen($unifoChargeFssp) < 20) || (is_array($unifoChargeFssp) && count($unifoChargeFssp) < 20)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($unifoChargeFssp) && !preg_match('/(([0-9a-zA-Zа-яА-Я]{19})|([0-9]{8}[0-9a-zA-Zа-яА-Я]{16}))[0-9]/', $unifoChargeFssp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(([0-9a-zA-Zа-яА-Я]{19})|([0-9]{8}[0-9a-zA-Zа-яА-Я]{16}))[0-9]", "%s" given', var_export($unifoChargeFssp, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($unifoChargeFssp) && !is_string($unifoChargeFssp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unifoChargeFssp)), __LINE__);
        }
        $this->unifoChargeFssp = $unifoChargeFssp;
        return $this;
    }
    /**
     * Get unifoChargeExt value
     * @return string|null
     */
    public function getUnifoChargeExt()
    {
        return $this->unifoChargeExt;
    }
    /**
     * Set unifoChargeExt value
     * @param string $unifoChargeExt
     * @return \AisFssp\StructType\BriefIPInformationType
     */
    public function setUnifoChargeExt($unifoChargeExt = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($unifoChargeExt) && strlen($unifoChargeExt) > 25) || (is_array($unifoChargeExt) && count($unifoChargeExt) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($unifoChargeExt) ? strlen($unifoChargeExt) : count($unifoChargeExt)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($unifoChargeExt) && strlen($unifoChargeExt) < 20) || (is_array($unifoChargeExt) && count($unifoChargeExt) < 20)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($unifoChargeExt) && !preg_match('/(([0-9a-zA-Zа-яА-Я]{19})|([0-9]{8}[0-9a-zA-Zа-яА-Я]{16}))[0-9]/', $unifoChargeExt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(([0-9a-zA-Zа-яА-Я]{19})|([0-9]{8}[0-9a-zA-Zа-яА-Я]{16}))[0-9]", "%s" given', var_export($unifoChargeExt, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($unifoChargeExt) && !is_string($unifoChargeExt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unifoChargeExt)), __LINE__);
        }
        $this->unifoChargeExt = $unifoChargeExt;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\BriefIPInformationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
