<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BKIDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения о бюро кредитных историй
 * @subpackage Structs
 */
class BKIDatumType extends InformationType
{
    /**
     * The Number
     * Meta informations extracted from the WSDL
     * - documentation: Номер БКИ | Строка длиной от 1 до 10 символов
     * - minOccurs: 1
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $Number;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - documentation: Наименование БКИ | Строка длиной от 1 до 255 символов
     * - minOccurs: 1
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $Name;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - documentation: Адрес БКИ | Строка длиной от 1 до 300 символов
     * - minOccurs: 1
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $Address;
    /**
     * The Phone
     * Meta informations extracted from the WSDL
     * - documentation: Телефон БКИ | Строка длиной от 1 до 100 символов
     * - minOccurs: 1
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $Phone;
    /**
     * Constructor method for BKIDatumType
     * @uses BKIDatumType::setNumber()
     * @uses BKIDatumType::setName()
     * @uses BKIDatumType::setAddress()
     * @uses BKIDatumType::setPhone()
     * @param string $number
     * @param string $name
     * @param string $address
     * @param string $phone
     */
    public function __construct($number = null, $name = null, $address = null, $phone = null)
    {
        $this
            ->setNumber($number)
            ->setName($name)
            ->setAddress($address)
            ->setPhone($phone);
    }
    /**
     * Get Number value
     * @return string
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param string $number
     * @return \AisFssp\StructType\BKIDatumType
     */
    public function setNumber($number = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($number) && strlen($number) > 10) || (is_array($number) && count($number) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($number) ? strlen($number) : count($number)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($number) && strlen($number) < 1) || (is_array($number) && count($number) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($number)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
    /**
     * Get Name value
     * @return string
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \AisFssp\StructType\BKIDatumType
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 255) || (is_array($name) && count($name) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($name) && strlen($name) < 1) || (is_array($name) && count($name) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Address value
     * @return string
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param string $address
     * @return \AisFssp\StructType\BKIDatumType
     */
    public function setAddress($address = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($address) && strlen($address) > 300) || (is_array($address) && count($address) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($address) ? strlen($address) : count($address)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($address) && strlen($address) < 1) || (is_array($address) && count($address) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address)), __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Get Phone value
     * @return string
     */
    public function getPhone()
    {
        return $this->Phone;
    }
    /**
     * Set Phone value
     * @param string $phone
     * @return \AisFssp\StructType\BKIDatumType
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($phone) && strlen($phone) > 100) || (is_array($phone) && count($phone) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($phone) ? strlen($phone) : count($phone)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($phone) && strlen($phone) < 1) || (is_array($phone) && count($phone) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phone)), __LINE__);
        }
        $this->Phone = $phone;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\BKIDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
