<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AnswerMessage StructType
 * Meta informations extracted from the WSDL
 * - documentation: Ответ интерактивный (синхронный) | ЭЦП | Технологическая ЭЦП (накладывается сервером, формирующим сообщение)
 * @subpackage Structs
 */
class AnswerMessage extends SyncRs
{
    /**
     * The DebtorIPListResponseType
     * Meta informations extracted from the WSDL
     * - documentation: Список исполнительных производств по должнику
     * @var \AisFssp\StructType\DebtorIPListResponseType
     */
    public $DebtorIPListResponseType;
    /**
     * The IPReqAppResponseType
     * Meta informations extracted from the WSDL
     * - documentation: Подтверждение регистрации запроса или заявления в ОСП
     * @var \AisFssp\StructType\IPReqAppResponseType
     */
    public $IPReqAppResponseType;
    /**
     * The IPReqAppResultReponseType
     * Meta informations extracted from the WSDL
     * - documentation: Ответы ОСП на запросы или заявления
     * @var \AisFssp\StructType\IPReqAppResultReponseType
     */
    public $IPReqAppResultReponseType;
    /**
     * The IPBriefInfoResponse
     * Meta informations extracted from the WSDL
     * - documentation: Сведения ИП
     * @var \AisFssp\StructType\IPBriefInfoResponseType
     */
    public $IPBriefInfoResponse;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \AisFssp\StructType\SignatureType[]
     */
    public $Signature;
    /**
     * Constructor method for AnswerMessage
     * @uses AnswerMessage::setDebtorIPListResponseType()
     * @uses AnswerMessage::setIPReqAppResponseType()
     * @uses AnswerMessage::setIPReqAppResultReponseType()
     * @uses AnswerMessage::setIPBriefInfoResponse()
     * @uses AnswerMessage::setSignature()
     * @param \AisFssp\StructType\DebtorIPListResponseType $debtorIPListResponseType
     * @param \AisFssp\StructType\IPReqAppResponseType $iPReqAppResponseType
     * @param \AisFssp\StructType\IPReqAppResultReponseType $iPReqAppResultReponseType
     * @param \AisFssp\StructType\IPBriefInfoResponseType $iPBriefInfoResponse
     * @param \AisFssp\StructType\SignatureType[] $signature
     */
    public function __construct(\AisFssp\StructType\DebtorIPListResponseType $debtorIPListResponseType = null, \AisFssp\StructType\IPReqAppResponseType $iPReqAppResponseType = null, \AisFssp\StructType\IPReqAppResultReponseType $iPReqAppResultReponseType = null, \AisFssp\StructType\IPBriefInfoResponseType $iPBriefInfoResponse = null, array $signature = array())
    {
        $this
            ->setDebtorIPListResponseType($debtorIPListResponseType)
            ->setIPReqAppResponseType($iPReqAppResponseType)
            ->setIPReqAppResultReponseType($iPReqAppResultReponseType)
            ->setIPBriefInfoResponse($iPBriefInfoResponse)
            ->setSignature($signature);
    }
    /**
     * Get DebtorIPListResponseType value
     * @return \AisFssp\StructType\DebtorIPListResponseType|null
     */
    public function getDebtorIPListResponseType()
    {
        return $this->DebtorIPListResponseType;
    }
    /**
     * Set DebtorIPListResponseType value
     * @param \AisFssp\StructType\DebtorIPListResponseType $debtorIPListResponseType
     * @return \AisFssp\StructType\AnswerMessage
     */
    public function setDebtorIPListResponseType(\AisFssp\StructType\DebtorIPListResponseType $debtorIPListResponseType = null)
    {
        $this->DebtorIPListResponseType = $debtorIPListResponseType;
        return $this;
    }
    /**
     * Get IPReqAppResponseType value
     * @return \AisFssp\StructType\IPReqAppResponseType|null
     */
    public function getIPReqAppResponseType()
    {
        return $this->IPReqAppResponseType;
    }
    /**
     * Set IPReqAppResponseType value
     * @param \AisFssp\StructType\IPReqAppResponseType $iPReqAppResponseType
     * @return \AisFssp\StructType\AnswerMessage
     */
    public function setIPReqAppResponseType(\AisFssp\StructType\IPReqAppResponseType $iPReqAppResponseType = null)
    {
        $this->IPReqAppResponseType = $iPReqAppResponseType;
        return $this;
    }
    /**
     * Get IPReqAppResultReponseType value
     * @return \AisFssp\StructType\IPReqAppResultReponseType|null
     */
    public function getIPReqAppResultReponseType()
    {
        return $this->IPReqAppResultReponseType;
    }
    /**
     * Set IPReqAppResultReponseType value
     * @param \AisFssp\StructType\IPReqAppResultReponseType $iPReqAppResultReponseType
     * @return \AisFssp\StructType\AnswerMessage
     */
    public function setIPReqAppResultReponseType(\AisFssp\StructType\IPReqAppResultReponseType $iPReqAppResultReponseType = null)
    {
        $this->IPReqAppResultReponseType = $iPReqAppResultReponseType;
        return $this;
    }
    /**
     * Get IPBriefInfoResponse value
     * @return \AisFssp\StructType\IPBriefInfoResponseType|null
     */
    public function getIPBriefInfoResponse()
    {
        return $this->IPBriefInfoResponse;
    }
    /**
     * Set IPBriefInfoResponse value
     * @param \AisFssp\StructType\IPBriefInfoResponseType $iPBriefInfoResponse
     * @return \AisFssp\StructType\AnswerMessage
     */
    public function setIPBriefInfoResponse(\AisFssp\StructType\IPBriefInfoResponseType $iPBriefInfoResponse = null)
    {
        $this->IPBriefInfoResponse = $iPBriefInfoResponse;
        return $this;
    }
    /**
     * Get Signature value
     * @return \AisFssp\StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType[] $signature
     * @return \AisFssp\StructType\AnswerMessage
     */
    public function setSignature(array $signature = array())
    {
        foreach ($signature as $answerMessageSignatureItem) {
            // validation for constraint: itemType
            if (!$answerMessageSignatureItem instanceof \AisFssp\StructType\SignatureType) {
                throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($answerMessageSignatureItem) ? get_class($answerMessageSignatureItem) : gettype($answerMessageSignatureItem)), __LINE__);
            }
        }
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType $item
     * @return \AisFssp\StructType\AnswerMessage
     */
    public function addToSignature(\AisFssp\StructType\SignatureType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\SignatureType) {
            throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\AnswerMessage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
