<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Answer StructType
 * Meta informations extracted from the WSDL
 * - documentation: Документ Answer "Ответ на запрос СПИ" | ЭП
 * - type: tns:Answer
 * @subpackage Structs
 */
class Answer extends AbstractStructBase
{
    /**
     * The ExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор АИС ВК | Идентификатор ответа, присвоенный АИС внешнего контрагента Уникален в рамках типа документа и
     * конкретного внешнего контрагента | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный
     * идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $ExternalKey;
    /**
     * The QueryInternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ запроса ФССП России | Уникальный идентификатор запроса СПИ, присвоенный АИС ФССП России и переданный ранее внешнему
     * контрагенту | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от контрагента
     * - minOccurs: 0
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $QueryInternalKey;
    /**
     * The IpInternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ИП ФССП России | Уникальный идентификатор исполнительного производства, присвоенный АИС ФССП Росии и переданный ранее
     * внешнему контрагенту | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от
     * контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $IpInternalKey;
    /**
     * The applicationKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ заявления ЕПГУ | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный
     * идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - minOccurs: 0
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $applicationKey;
    /**
     * The answerDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата ответа | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $answerDate;
    /**
     * The AnswerType
     * Meta informations extracted from the WSDL
     * - documentation: Тип ответа | Тип ответа на запрос СПИ | NSI_MVV_QueryAnswer
     * - length: 2
     * @var string
     */
    public $AnswerType;
    /**
     * The authorName
     * Meta informations extracted from the WSDL
     * - documentation: ФИО должностного лица | Полное имя физического лица (фамилия, имя, отчество)
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $authorName;
    /**
     * The authorPost
     * Meta informations extracted from the WSDL
     * - documentation: Должность | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $authorPost;
    /**
     * The authorEmail
     * Meta informations extracted from the WSDL
     * - documentation: Электропочта | Адрес электронной почты
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $authorEmail;
    /**
     * The authorTelephone
     * Meta informations extracted from the WSDL
     * - documentation: Контактный телефон | Номер телефона
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $authorTelephone;
    /**
     * The LegalImpossibility
     * Meta informations extracted from the WSDL
     * - documentation: Причины невозможности исполнения требований СПИ | Строка длиной от 1 до 4000 символов
     * - minOccurs: 0
     * - maxLength: 4000
     * - minLength: 1
     * @var string
     */
    public $LegalImpossibility;
    /**
     * The Data
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о должнике
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\Data[]
     */
    public $Data;
    /**
     * The attachments
     * Meta informations extracted from the WSDL
     * - documentation: Прикрепленные файлы
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\AttachmentType[]
     */
    public $attachments;
    /**
     * The SignDateTime
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время формирования подписи | Дата и время | Дата и время
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $SignDateTime;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \AisFssp\StructType\SignatureType[]
     */
    public $Signature;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Атрибут документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Id;
    /**
     * Constructor method for Answer
     * @uses Answer::setExternalKey()
     * @uses Answer::setQueryInternalKey()
     * @uses Answer::setIpInternalKey()
     * @uses Answer::setApplicationKey()
     * @uses Answer::setAnswerDate()
     * @uses Answer::setAnswerType()
     * @uses Answer::setAuthorName()
     * @uses Answer::setAuthorPost()
     * @uses Answer::setAuthorEmail()
     * @uses Answer::setAuthorTelephone()
     * @uses Answer::setLegalImpossibility()
     * @uses Answer::setData()
     * @uses Answer::setAttachments()
     * @uses Answer::setSignDateTime()
     * @uses Answer::setSignature()
     * @uses Answer::setId()
     * @param string $externalKey
     * @param int $queryInternalKey
     * @param int $ipInternalKey
     * @param string $applicationKey
     * @param string $answerDate
     * @param string $answerType
     * @param string $authorName
     * @param string $authorPost
     * @param string $authorEmail
     * @param string $authorTelephone
     * @param string $legalImpossibility
     * @param \AisFssp\StructType\Data[] $data
     * @param \AisFssp\StructType\AttachmentType[] $attachments
     * @param string $signDateTime
     * @param \AisFssp\StructType\SignatureType[] $signature
     * @param string $id
     */
    public function __construct($externalKey = null, $queryInternalKey = null, $ipInternalKey = null, $applicationKey = null, $answerDate = null, $answerType = null, $authorName = null, $authorPost = null, $authorEmail = null, $authorTelephone = null, $legalImpossibility = null, array $data = array(), array $attachments = array(), $signDateTime = null, array $signature = array(), $id = null)
    {
        $this
            ->setExternalKey($externalKey)
            ->setQueryInternalKey($queryInternalKey)
            ->setIpInternalKey($ipInternalKey)
            ->setApplicationKey($applicationKey)
            ->setAnswerDate($answerDate)
            ->setAnswerType($answerType)
            ->setAuthorName($authorName)
            ->setAuthorPost($authorPost)
            ->setAuthorEmail($authorEmail)
            ->setAuthorTelephone($authorTelephone)
            ->setLegalImpossibility($legalImpossibility)
            ->setData($data)
            ->setAttachments($attachments)
            ->setSignDateTime($signDateTime)
            ->setSignature($signature)
            ->setId($id);
    }
    /**
     * Get ExternalKey value
     * @return string|null
     */
    public function getExternalKey()
    {
        return $this->ExternalKey;
    }
    /**
     * Set ExternalKey value
     * @param string $externalKey
     * @return \AisFssp\StructType\Answer
     */
    public function setExternalKey($externalKey = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($externalKey) && strlen($externalKey) > 60) || (is_array($externalKey) && count($externalKey) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($externalKey) ? strlen($externalKey) : count($externalKey)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($externalKey) && strlen($externalKey) < 1) || (is_array($externalKey) && count($externalKey) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($externalKey) && !is_string($externalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externalKey)), __LINE__);
        }
        $this->ExternalKey = $externalKey;
        return $this;
    }
    /**
     * Get QueryInternalKey value
     * @return int|null
     */
    public function getQueryInternalKey()
    {
        return $this->QueryInternalKey;
    }
    /**
     * Set QueryInternalKey value
     * @param int $queryInternalKey
     * @return \AisFssp\StructType\Answer
     */
    public function setQueryInternalKey($queryInternalKey = null)
    {
        // validation for constraint: maxInclusive
        if ($queryInternalKey > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $queryInternalKey), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($queryInternalKey < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $queryInternalKey), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($queryInternalKey) && !is_numeric($queryInternalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($queryInternalKey)), __LINE__);
        }
        $this->QueryInternalKey = $queryInternalKey;
        return $this;
    }
    /**
     * Get IpInternalKey value
     * @return int|null
     */
    public function getIpInternalKey()
    {
        return $this->IpInternalKey;
    }
    /**
     * Set IpInternalKey value
     * @param int $ipInternalKey
     * @return \AisFssp\StructType\Answer
     */
    public function setIpInternalKey($ipInternalKey = null)
    {
        // validation for constraint: maxInclusive
        if ($ipInternalKey > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $ipInternalKey), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($ipInternalKey < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $ipInternalKey), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($ipInternalKey) && !is_numeric($ipInternalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ipInternalKey)), __LINE__);
        }
        $this->IpInternalKey = $ipInternalKey;
        return $this;
    }
    /**
     * Get applicationKey value
     * @return string|null
     */
    public function getApplicationKey()
    {
        return $this->applicationKey;
    }
    /**
     * Set applicationKey value
     * @param string $applicationKey
     * @return \AisFssp\StructType\Answer
     */
    public function setApplicationKey($applicationKey = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($applicationKey) && strlen($applicationKey) > 60) || (is_array($applicationKey) && count($applicationKey) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($applicationKey) ? strlen($applicationKey) : count($applicationKey)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($applicationKey) && strlen($applicationKey) < 1) || (is_array($applicationKey) && count($applicationKey) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($applicationKey) && !is_string($applicationKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($applicationKey)), __LINE__);
        }
        $this->applicationKey = $applicationKey;
        return $this;
    }
    /**
     * Get answerDate value
     * @return string|null
     */
    public function getAnswerDate()
    {
        return $this->answerDate;
    }
    /**
     * Set answerDate value
     * @param string $answerDate
     * @return \AisFssp\StructType\Answer
     */
    public function setAnswerDate($answerDate = null)
    {
        // validation for constraint: maxExclusive
        if ($answerDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $answerDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($answerDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $answerDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($answerDate) && !is_string($answerDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($answerDate)), __LINE__);
        }
        $this->answerDate = $answerDate;
        return $this;
    }
    /**
     * Get AnswerType value
     * @return string|null
     */
    public function getAnswerType()
    {
        return $this->AnswerType;
    }
    /**
     * Set AnswerType value
     * @param string $answerType
     * @return \AisFssp\StructType\Answer
     */
    public function setAnswerType($answerType = null)
    {
        // validation for constraint: length
        if ((is_scalar($answerType) && strlen($answerType) !== 2) || (is_array($answerType) && count($answerType) !== 2)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 2 element(s) or a scalar of 2 character(s)', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($answerType) && !is_string($answerType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($answerType)), __LINE__);
        }
        $this->AnswerType = $answerType;
        return $this;
    }
    /**
     * Get authorName value
     * @return string|null
     */
    public function getAuthorName()
    {
        return $this->authorName;
    }
    /**
     * Set authorName value
     * @param string $authorName
     * @return \AisFssp\StructType\Answer
     */
    public function setAuthorName($authorName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($authorName) && strlen($authorName) > 100) || (is_array($authorName) && count($authorName) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($authorName) ? strlen($authorName) : count($authorName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($authorName) && strlen($authorName) < 1) || (is_array($authorName) && count($authorName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($authorName) && !is_string($authorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authorName)), __LINE__);
        }
        $this->authorName = $authorName;
        return $this;
    }
    /**
     * Get authorPost value
     * @return string|null
     */
    public function getAuthorPost()
    {
        return $this->authorPost;
    }
    /**
     * Set authorPost value
     * @param string $authorPost
     * @return \AisFssp\StructType\Answer
     */
    public function setAuthorPost($authorPost = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($authorPost) && strlen($authorPost) > 50) || (is_array($authorPost) && count($authorPost) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($authorPost) ? strlen($authorPost) : count($authorPost)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($authorPost) && strlen($authorPost) < 1) || (is_array($authorPost) && count($authorPost) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($authorPost) && !is_string($authorPost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authorPost)), __LINE__);
        }
        $this->authorPost = $authorPost;
        return $this;
    }
    /**
     * Get authorEmail value
     * @return string|null
     */
    public function getAuthorEmail()
    {
        return $this->authorEmail;
    }
    /**
     * Set authorEmail value
     * @param string $authorEmail
     * @return \AisFssp\StructType\Answer
     */
    public function setAuthorEmail($authorEmail = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($authorEmail) && strlen($authorEmail) > 100) || (is_array($authorEmail) && count($authorEmail) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($authorEmail) ? strlen($authorEmail) : count($authorEmail)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($authorEmail) && strlen($authorEmail) < 1) || (is_array($authorEmail) && count($authorEmail) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($authorEmail) && !is_string($authorEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authorEmail)), __LINE__);
        }
        $this->authorEmail = $authorEmail;
        return $this;
    }
    /**
     * Get authorTelephone value
     * @return string|null
     */
    public function getAuthorTelephone()
    {
        return $this->authorTelephone;
    }
    /**
     * Set authorTelephone value
     * @param string $authorTelephone
     * @return \AisFssp\StructType\Answer
     */
    public function setAuthorTelephone($authorTelephone = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($authorTelephone) && strlen($authorTelephone) > 25) || (is_array($authorTelephone) && count($authorTelephone) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($authorTelephone) ? strlen($authorTelephone) : count($authorTelephone)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($authorTelephone) && strlen($authorTelephone) < 1) || (is_array($authorTelephone) && count($authorTelephone) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($authorTelephone) && !is_string($authorTelephone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authorTelephone)), __LINE__);
        }
        $this->authorTelephone = $authorTelephone;
        return $this;
    }
    /**
     * Get LegalImpossibility value
     * @return string|null
     */
    public function getLegalImpossibility()
    {
        return $this->LegalImpossibility;
    }
    /**
     * Set LegalImpossibility value
     * @param string $legalImpossibility
     * @return \AisFssp\StructType\Answer
     */
    public function setLegalImpossibility($legalImpossibility = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($legalImpossibility) && strlen($legalImpossibility) > 4000) || (is_array($legalImpossibility) && count($legalImpossibility) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($legalImpossibility) ? strlen($legalImpossibility) : count($legalImpossibility)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($legalImpossibility) && strlen($legalImpossibility) < 1) || (is_array($legalImpossibility) && count($legalImpossibility) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($legalImpossibility) && !is_string($legalImpossibility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($legalImpossibility)), __LINE__);
        }
        $this->LegalImpossibility = $legalImpossibility;
        return $this;
    }
    /**
     * Get Data value
     * @return \AisFssp\StructType\Data[]|null
     */
    public function getData()
    {
        return $this->Data;
    }
    /**
     * Set Data value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\Data[] $data
     * @return \AisFssp\StructType\Answer
     */
    public function setData(array $data = array())
    {
        foreach ($data as $answerDataItem) {
            // validation for constraint: itemType
            if (!$answerDataItem instanceof \AisFssp\StructType\Data) {
                throw new \InvalidArgumentException(sprintf('The Data property can only contain items of \AisFssp\StructType\Data, "%s" given', is_object($answerDataItem) ? get_class($answerDataItem) : gettype($answerDataItem)), __LINE__);
            }
        }
        $this->Data = $data;
        return $this;
    }
    /**
     * Add item to Data value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\Data $item
     * @return \AisFssp\StructType\Answer
     */
    public function addToData(\AisFssp\StructType\Data $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\Data) {
            throw new \InvalidArgumentException(sprintf('The Data property can only contain items of \AisFssp\StructType\Data, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Data[] = $item;
        return $this;
    }
    /**
     * Get attachments value
     * @return \AisFssp\StructType\AttachmentType[]|null
     */
    public function getAttachments()
    {
        return $this->attachments;
    }
    /**
     * Set attachments value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\AttachmentType[] $attachments
     * @return \AisFssp\StructType\Answer
     */
    public function setAttachments(array $attachments = array())
    {
        foreach ($attachments as $answerAttachmentsItem) {
            // validation for constraint: itemType
            if (!$answerAttachmentsItem instanceof \AisFssp\StructType\AttachmentType) {
                throw new \InvalidArgumentException(sprintf('The attachments property can only contain items of \AisFssp\StructType\AttachmentType, "%s" given', is_object($answerAttachmentsItem) ? get_class($answerAttachmentsItem) : gettype($answerAttachmentsItem)), __LINE__);
            }
        }
        $this->attachments = $attachments;
        return $this;
    }
    /**
     * Add item to attachments value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\AttachmentType $item
     * @return \AisFssp\StructType\Answer
     */
    public function addToAttachments(\AisFssp\StructType\AttachmentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\AttachmentType) {
            throw new \InvalidArgumentException(sprintf('The attachments property can only contain items of \AisFssp\StructType\AttachmentType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->attachments[] = $item;
        return $this;
    }
    /**
     * Get SignDateTime value
     * @return string|null
     */
    public function getSignDateTime()
    {
        return $this->SignDateTime;
    }
    /**
     * Set SignDateTime value
     * @param string $signDateTime
     * @return \AisFssp\StructType\Answer
     */
    public function setSignDateTime($signDateTime = null)
    {
        // validation for constraint: maxExclusive
        if ($signDateTime >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $signDateTime), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($signDateTime < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $signDateTime), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($signDateTime) && !is_string($signDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($signDateTime)), __LINE__);
        }
        $this->SignDateTime = $signDateTime;
        return $this;
    }
    /**
     * Get Signature value
     * @return \AisFssp\StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType[] $signature
     * @return \AisFssp\StructType\Answer
     */
    public function setSignature(array $signature = array())
    {
        foreach ($signature as $answerSignatureItem) {
            // validation for constraint: itemType
            if (!$answerSignatureItem instanceof \AisFssp\StructType\SignatureType) {
                throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($answerSignatureItem) ? get_class($answerSignatureItem) : gettype($answerSignatureItem)), __LINE__);
            }
        }
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType $item
     * @return \AisFssp\StructType\Answer
     */
    public function addToSignature(\AisFssp\StructType\SignatureType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\SignatureType) {
            throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \AisFssp\StructType\Answer
     */
    public function setId($id = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($id) && strlen($id) > 60) || (is_array($id) && count($id) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($id) ? strlen($id) : count($id)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($id) && strlen($id) < 1) || (is_array($id) && count($id) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\Answer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
