<?php

namespace AisFssp\EnumType;

/**
 * This class stands for StatusCode EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Код результата приема пакета
 * @subpackage Enumerations
 */
class StatusCode
{
    /**
     * Constant for value 'received'
     * @return string 'received'
     */
    const VALUE_RECEIVED = 'received';
    /**
     * Constant for value 'error'
     * @return string 'error'
     */
    const VALUE_ERROR = 'error';
    /**
     * Constant for value 'confirmed'
     * @return string 'confirmed'
     */
    const VALUE_CONFIRMED = 'confirmed';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_RECEIVED
     * @uses self::VALUE_ERROR
     * @uses self::VALUE_CONFIRMED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_RECEIVED,
            self::VALUE_ERROR,
            self::VALUE_CONFIRMED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
