<?php

namespace AisFssp\EnumType;

/**
 * This class stands for RestrictionAnswerType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Тип ответа на постановление СПИ | NSI_MVV_RestrictionAnswer
 * @subpackage Enumerations
 */
class RestrictionAnswerType
{
    /**
     * Constant for value '2'
     * @return string '2'
     */
    const VALUE_2 = '2';
    /**
     * Constant for value '3'
     * @return string '3'
     */
    const VALUE_3 = '3';
    /**
     * Constant for value '4'
     * @return string '4'
     */
    const VALUE_4 = '4';
    /**
     * Constant for value '5'
     * @return string '5'
     */
    const VALUE_5 = '5';
    /**
     * Constant for value '6'
     * @return string '6'
     */
    const VALUE_6 = '6';
    /**
     * Constant for value '7'
     * @return string '7'
     */
    const VALUE_7 = '7';
    /**
     * Constant for value '8'
     * @return string '8'
     */
    const VALUE_8 = '8';
    /**
     * Constant for value '12'
     * @return string '12'
     */
    const VALUE_12 = '12';
    /**
     * Constant for value '90'
     * @return string '90'
     */
    const VALUE_90 = '90';
    /**
     * Constant for value '91'
     * @return string '91'
     */
    const VALUE_91 = '91';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_2
     * @uses self::VALUE_3
     * @uses self::VALUE_4
     * @uses self::VALUE_5
     * @uses self::VALUE_6
     * @uses self::VALUE_7
     * @uses self::VALUE_8
     * @uses self::VALUE_12
     * @uses self::VALUE_90
     * @uses self::VALUE_91
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_2,
            self::VALUE_3,
            self::VALUE_4,
            self::VALUE_5,
            self::VALUE_6,
            self::VALUE_7,
            self::VALUE_8,
            self::VALUE_12,
            self::VALUE_90,
            self::VALUE_91,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
