<?php

namespace AisFssp\EnumType;

/**
 * This class stands for RegistryDocType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Тип передаваемого реестра или справочника
 * @subpackage Enumerations
 */
class RegistryDocType
{
    /**
     * Constant for value 'PHONEBOOK'
     * @return string 'PHONEBOOK'
     */
    const VALUE_PHONEBOOK = 'PHONEBOOK';
    /**
     * Constant for value 'SELL_PROPERTY'
     * @return string 'SELL_PROPERTY'
     */
    const VALUE_SELL_PROPERTY = 'SELL_PROPERTY';
    /**
     * Constant for value 'SEARCH_AMTS'
     * @return string 'SEARCH_AMTS'
     */
    const VALUE_SEARCH_AMTS = 'SEARCH_AMTS';
    /**
     * Constant for value 'SUSPECT_INFO'
     * @return string 'SUSPECT_INFO'
     */
    const VALUE_SUSPECT_INFO = 'SUSPECT_INFO';
    /**
     * Constant for value 'TENDER'
     * @return string 'TENDER'
     */
    const VALUE_TENDER = 'TENDER';
    /**
     * Constant for value 'TENDER_DOC'
     * @return string 'TENDER_DOC'
     */
    const VALUE_TENDER_DOC = 'TENDER_DOC';
    /**
     * Constant for value 'TENDER_DOC_LIST'
     * @return string 'TENDER_DOC_LIST'
     */
    const VALUE_TENDER_DOC_LIST = 'TENDER_DOC_LIST';
    /**
     * Constant for value 'VACANCIES'
     * @return string 'VACANCIES'
     */
    const VALUE_VACANCIES = 'VACANCIES';
    /**
     * Constant for value 'EQ_APPOINTMENT'
     * @return string 'EQ_APPOINTMENT'
     */
    const VALUE_EQ_APPOINTMENT = 'EQ_APPOINTMENT';
    /**
     * Constant for value 'EQ_OFFICIAL'
     * @return string 'EQ_OFFICIAL'
     */
    const VALUE_EQ_OFFICIAL = 'EQ_OFFICIAL';
    /**
     * Constant for value 'EQ_OSP'
     * @return string 'EQ_OSP'
     */
    const VALUE_EQ_OSP = 'EQ_OSP';
    /**
     * Constant for value 'EQ_POST'
     * @return string 'EQ_POST'
     */
    const VALUE_EQ_POST = 'EQ_POST';
    /**
     * Constant for value 'EQ_TIMETABLE'
     * @return string 'EQ_TIMETABLE'
     */
    const VALUE_EQ_TIMETABLE = 'EQ_TIMETABLE';
    /**
     * Constant for value 'EQ_TREATMENT_KIND'
     * @return string 'EQ_TREATMENT_KIND'
     */
    const VALUE_EQ_TREATMENT_KIND = 'EQ_TREATMENT_KIND';
    /**
     * Constant for value 'IP_DEBT'
     * @return string 'IP_DEBT'
     */
    const VALUE_IP_DEBT = 'IP_DEBT';
    /**
     * Constant for value 'IP_INVESTIGATION'
     * @return string 'IP_INVESTIGATION'
     */
    const VALUE_IP_INVESTIGATION = 'IP_INVESTIGATION';
    /**
     * Constant for value 'AGENCY_REESTR'
     * @return string 'AGENCY_REESTR'
     */
    const VALUE_AGENCY_REESTR = 'AGENCY_REESTR';
    /**
     * Constant for value 'PAYMENT_RECEIVER'
     * @return string 'PAYMENT_RECEIVER'
     */
    const VALUE_PAYMENT_RECEIVER = 'PAYMENT_RECEIVER';
    /**
     * Constant for value 'OSP_CRITERION'
     * @return string 'OSP_CRITERION'
     */
    const VALUE_OSP_CRITERION = 'OSP_CRITERION';
    /**
     * Constant for value 'SSTU_CITIZEN_QUESTIONS'
     * @return string 'SSTU_CITIZEN_QUESTIONS'
     */
    const VALUE_SSTU_CITIZEN_QUESTIONS = 'SSTU_CITIZEN_QUESTIONS';
    /**
     * Constant for value 'PIEV_FORMAT_VERSION'
     * @return string 'PIEV_FORMAT_VERSION'
     */
    const VALUE_PIEV_FORMAT_VERSION = 'PIEV_FORMAT_VERSION';
    /**
     * Constant for value 'IP_DEBT_BKI'
     * @return string 'IP_DEBT_BKI'
     */
    const VALUE_IP_DEBT_BKI = 'IP_DEBT_BKI';
    /**
     * Constant for value 'ID_SUBJ'
     * @return string 'ID_SUBJ'
     */
    const VALUE_ID_SUBJ = 'ID_SUBJ';
    /**
     * Constant for value 'ID_TYPE'
     * @return string 'ID_TYPE'
     */
    const VALUE_ID_TYPE = 'ID_TYPE';
    /**
     * Constant for value 'MOBILE_INV'
     * @return string 'MOBILE_INV'
     */
    const VALUE_MOBILE_INV = 'MOBILE_INV';
    /**
     * Constant for value 'MOBILE_UDID'
     * @return string 'MOBILE_UDID'
     */
    const VALUE_MOBILE_UDID = 'MOBILE_UDID';
    /**
     * Constant for value 'CRIME_CASES_FSSP'
     * @return string 'CRIME_CASES_FSSP'
     */
    const VALUE_CRIME_CASES_FSSP = 'CRIME_CASES_FSSP';
    /**
     * Constant for value 'IP_OLD_REGNUMBER'
     * @return string 'IP_OLD_REGNUMBER'
     */
    const VALUE_IP_OLD_REGNUMBER = 'IP_OLD_REGNUMBER';
    /**
     * Constant for value 'GSPTO_ACT'
     * @return string 'GSPTO_ACT'
     */
    const VALUE_GSPTO_ACT = 'GSPTO_ACT';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PHONEBOOK
     * @uses self::VALUE_SELL_PROPERTY
     * @uses self::VALUE_SEARCH_AMTS
     * @uses self::VALUE_SUSPECT_INFO
     * @uses self::VALUE_TENDER
     * @uses self::VALUE_TENDER_DOC
     * @uses self::VALUE_TENDER_DOC_LIST
     * @uses self::VALUE_VACANCIES
     * @uses self::VALUE_EQ_APPOINTMENT
     * @uses self::VALUE_EQ_OFFICIAL
     * @uses self::VALUE_EQ_OSP
     * @uses self::VALUE_EQ_POST
     * @uses self::VALUE_EQ_TIMETABLE
     * @uses self::VALUE_EQ_TREATMENT_KIND
     * @uses self::VALUE_IP_DEBT
     * @uses self::VALUE_IP_INVESTIGATION
     * @uses self::VALUE_AGENCY_REESTR
     * @uses self::VALUE_PAYMENT_RECEIVER
     * @uses self::VALUE_OSP_CRITERION
     * @uses self::VALUE_SSTU_CITIZEN_QUESTIONS
     * @uses self::VALUE_PIEV_FORMAT_VERSION
     * @uses self::VALUE_IP_DEBT_BKI
     * @uses self::VALUE_ID_SUBJ
     * @uses self::VALUE_ID_TYPE
     * @uses self::VALUE_MOBILE_INV
     * @uses self::VALUE_MOBILE_UDID
     * @uses self::VALUE_CRIME_CASES_FSSP
     * @uses self::VALUE_IP_OLD_REGNUMBER
     * @uses self::VALUE_GSPTO_ACT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PHONEBOOK,
            self::VALUE_SELL_PROPERTY,
            self::VALUE_SEARCH_AMTS,
            self::VALUE_SUSPECT_INFO,
            self::VALUE_TENDER,
            self::VALUE_TENDER_DOC,
            self::VALUE_TENDER_DOC_LIST,
            self::VALUE_VACANCIES,
            self::VALUE_EQ_APPOINTMENT,
            self::VALUE_EQ_OFFICIAL,
            self::VALUE_EQ_OSP,
            self::VALUE_EQ_POST,
            self::VALUE_EQ_TIMETABLE,
            self::VALUE_EQ_TREATMENT_KIND,
            self::VALUE_IP_DEBT,
            self::VALUE_IP_INVESTIGATION,
            self::VALUE_AGENCY_REESTR,
            self::VALUE_PAYMENT_RECEIVER,
            self::VALUE_OSP_CRITERION,
            self::VALUE_SSTU_CITIZEN_QUESTIONS,
            self::VALUE_PIEV_FORMAT_VERSION,
            self::VALUE_IP_DEBT_BKI,
            self::VALUE_ID_SUBJ,
            self::VALUE_ID_TYPE,
            self::VALUE_MOBILE_INV,
            self::VALUE_MOBILE_UDID,
            self::VALUE_CRIME_CASES_FSSP,
            self::VALUE_IP_OLD_REGNUMBER,
            self::VALUE_GSPTO_ACT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
