<?php

namespace AisFssp\EnumType;

/**
 * This class stands for OPFKindType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Наименование классификатора: ОКОПФ, КОПФ
 * @subpackage Enumerations
 */
class OPFKindType
{
    /**
     * Constant for value 'ОКОПФ'
     * @return string 'ОКОПФ'
     */
    const VALUE_ОКОПФ = 'ОКОПФ';
    /**
     * Constant for value 'КОПФ'
     * @return string 'КОПФ'
     */
    const VALUE_КОПФ = 'КОПФ';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ОКОПФ
     * @uses self::VALUE_КОПФ
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ОКОПФ,
            self::VALUE_КОПФ,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
