<?php

namespace AisFssp\EnumType;

/**
 * This class stands for NotifyStateCodeType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Результат доставки сообщения
 * @subpackage Enumerations
 */
class NotifyStateCodeType
{
    /**
     * Constant for value '10'
     * @return string '10'
     */
    const VALUE_10 = '10';
    /**
     * Constant for value '11'
     * @return string '11'
     */
    const VALUE_11 = '11';
    /**
     * Constant for value '12'
     * @return string '12'
     */
    const VALUE_12 = '12';
    /**
     * Constant for value '40'
     * @return string '40'
     */
    const VALUE_40 = '40';
    /**
     * Constant for value '41'
     * @return string '41'
     */
    const VALUE_41 = '41';
    /**
     * Constant for value '42'
     * @return string '42'
     */
    const VALUE_42 = '42';
    /**
     * Constant for value '60'
     * @return string '60'
     */
    const VALUE_60 = '60';
    /**
     * Constant for value '61'
     * @return string '61'
     */
    const VALUE_61 = '61';
    /**
     * Constant for value '62'
     * @return string '62'
     */
    const VALUE_62 = '62';
    /**
     * Constant for value '80'
     * @return string '80'
     */
    const VALUE_80 = '80';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_10
     * @uses self::VALUE_11
     * @uses self::VALUE_12
     * @uses self::VALUE_40
     * @uses self::VALUE_41
     * @uses self::VALUE_42
     * @uses self::VALUE_60
     * @uses self::VALUE_61
     * @uses self::VALUE_62
     * @uses self::VALUE_80
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_10,
            self::VALUE_11,
            self::VALUE_12,
            self::VALUE_40,
            self::VALUE_41,
            self::VALUE_42,
            self::VALUE_60,
            self::VALUE_61,
            self::VALUE_62,
            self::VALUE_80,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
