<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WeaponDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения о зарегистрированном оружии
 * @subpackage Structs
 */
class WeaponDatumType extends InformationType
{
    /**
     * The WeaponKind
     * Meta informations extracted from the WSDL
     * - documentation: Вид оружия | Строка длиной от 1 до 80 символов
     * - maxLength: 80
     * - minLength: 1
     * @var string
     */
    public $WeaponKind;
    /**
     * The WeaponType
     * Meta informations extracted from the WSDL
     * - documentation: Тип оружия | Строка длиной от 1 до 50 символов
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $WeaponType;
    /**
     * The WeaponName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование оружия | Строка длиной от 1 до 200 символов
     * - maxLength: 200
     * - minLength: 1
     * @var string
     */
    public $WeaponName;
    /**
     * The WeaponQuantity
     * Meta informations extracted from the WSDL
     * - documentation: Количество найденных единиц оружия данной модели | Целое | Целое
     * - maxInclusive: 2147483647
     * @var int
     */
    public $WeaponQuantity;
    /**
     * The RegDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата регистрации | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $RegDate;
    /**
     * The WeaponAdress
     * Meta informations extracted from the WSDL
     * - documentation: Место хранения оружия
     * - minOccurs: 0
     * @var \AisFssp\StructType\AddressType
     */
    public $WeaponAdress;
    /**
     * Constructor method for WeaponDatumType
     * @uses WeaponDatumType::setWeaponKind()
     * @uses WeaponDatumType::setWeaponType()
     * @uses WeaponDatumType::setWeaponName()
     * @uses WeaponDatumType::setWeaponQuantity()
     * @uses WeaponDatumType::setRegDate()
     * @uses WeaponDatumType::setWeaponAdress()
     * @param string $weaponKind
     * @param string $weaponType
     * @param string $weaponName
     * @param int $weaponQuantity
     * @param string $regDate
     * @param \AisFssp\StructType\AddressType $weaponAdress
     */
    public function __construct($weaponKind = null, $weaponType = null, $weaponName = null, $weaponQuantity = null, $regDate = null, \AisFssp\StructType\AddressType $weaponAdress = null)
    {
        $this
            ->setWeaponKind($weaponKind)
            ->setWeaponType($weaponType)
            ->setWeaponName($weaponName)
            ->setWeaponQuantity($weaponQuantity)
            ->setRegDate($regDate)
            ->setWeaponAdress($weaponAdress);
    }
    /**
     * Get WeaponKind value
     * @return string|null
     */
    public function getWeaponKind()
    {
        return $this->WeaponKind;
    }
    /**
     * Set WeaponKind value
     * @param string $weaponKind
     * @return \AisFssp\StructType\WeaponDatumType
     */
    public function setWeaponKind($weaponKind = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($weaponKind) && strlen($weaponKind) > 80) || (is_array($weaponKind) && count($weaponKind) > 80)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 80 element(s) or a scalar of 80 character(s) at most, "%d" length given', is_scalar($weaponKind) ? strlen($weaponKind) : count($weaponKind)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($weaponKind) && strlen($weaponKind) < 1) || (is_array($weaponKind) && count($weaponKind) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($weaponKind) && !is_string($weaponKind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($weaponKind)), __LINE__);
        }
        $this->WeaponKind = $weaponKind;
        return $this;
    }
    /**
     * Get WeaponType value
     * @return string|null
     */
    public function getWeaponType()
    {
        return $this->WeaponType;
    }
    /**
     * Set WeaponType value
     * @param string $weaponType
     * @return \AisFssp\StructType\WeaponDatumType
     */
    public function setWeaponType($weaponType = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($weaponType) && strlen($weaponType) > 50) || (is_array($weaponType) && count($weaponType) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($weaponType) ? strlen($weaponType) : count($weaponType)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($weaponType) && strlen($weaponType) < 1) || (is_array($weaponType) && count($weaponType) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($weaponType) && !is_string($weaponType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($weaponType)), __LINE__);
        }
        $this->WeaponType = $weaponType;
        return $this;
    }
    /**
     * Get WeaponName value
     * @return string|null
     */
    public function getWeaponName()
    {
        return $this->WeaponName;
    }
    /**
     * Set WeaponName value
     * @param string $weaponName
     * @return \AisFssp\StructType\WeaponDatumType
     */
    public function setWeaponName($weaponName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($weaponName) && strlen($weaponName) > 200) || (is_array($weaponName) && count($weaponName) > 200)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 200 element(s) or a scalar of 200 character(s) at most, "%d" length given', is_scalar($weaponName) ? strlen($weaponName) : count($weaponName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($weaponName) && strlen($weaponName) < 1) || (is_array($weaponName) && count($weaponName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($weaponName) && !is_string($weaponName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($weaponName)), __LINE__);
        }
        $this->WeaponName = $weaponName;
        return $this;
    }
    /**
     * Get WeaponQuantity value
     * @return int|null
     */
    public function getWeaponQuantity()
    {
        return $this->WeaponQuantity;
    }
    /**
     * Set WeaponQuantity value
     * @param int $weaponQuantity
     * @return \AisFssp\StructType\WeaponDatumType
     */
    public function setWeaponQuantity($weaponQuantity = null)
    {
        // validation for constraint: maxInclusive
        if ($weaponQuantity > 2147483647) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 2147483647, "%s" given', $weaponQuantity), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($weaponQuantity) && !is_numeric($weaponQuantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($weaponQuantity)), __LINE__);
        }
        $this->WeaponQuantity = $weaponQuantity;
        return $this;
    }
    /**
     * Get RegDate value
     * @return string|null
     */
    public function getRegDate()
    {
        return $this->RegDate;
    }
    /**
     * Set RegDate value
     * @param string $regDate
     * @return \AisFssp\StructType\WeaponDatumType
     */
    public function setRegDate($regDate = null)
    {
        // validation for constraint: maxExclusive
        if ($regDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $regDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($regDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $regDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($regDate) && !is_string($regDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($regDate)), __LINE__);
        }
        $this->RegDate = $regDate;
        return $this;
    }
    /**
     * Get WeaponAdress value
     * @return \AisFssp\StructType\AddressType|null
     */
    public function getWeaponAdress()
    {
        return $this->WeaponAdress;
    }
    /**
     * Set WeaponAdress value
     * @param \AisFssp\StructType\AddressType $weaponAdress
     * @return \AisFssp\StructType\WeaponDatumType
     */
    public function setWeaponAdress(\AisFssp\StructType\AddressType $weaponAdress = null)
    {
        $this->WeaponAdress = $weaponAdress;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\WeaponDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
