<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidationStepDetailType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения об этапах проверки
 * @subpackage Structs
 */
class ValidationStepDetailType extends AbstractStructBase
{
    /**
     * The IdValidationStep
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор этапа проверки | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при
     * получении объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $IdValidationStep;
    /**
     * The TypeValidationStep
     * Meta informations extracted from the WSDL
     * - documentation: Тип этапа проверки
     * @var string
     */
    public $TypeValidationStep;
    /**
     * The ResultValidationStep
     * Meta informations extracted from the WSDL
     * - documentation: Результат этапа проверки | Обертка стандартного xs:boolean | Логический
     * @var bool
     */
    public $ResultValidationStep;
    /**
     * The DescriptionValidationStep
     * Meta informations extracted from the WSDL
     * - documentation: Описание | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $DescriptionValidationStep;
    /**
     * Constructor method for ValidationStepDetailType
     * @uses ValidationStepDetailType::setIdValidationStep()
     * @uses ValidationStepDetailType::setTypeValidationStep()
     * @uses ValidationStepDetailType::setResultValidationStep()
     * @uses ValidationStepDetailType::setDescriptionValidationStep()
     * @param int $idValidationStep
     * @param string $typeValidationStep
     * @param bool $resultValidationStep
     * @param string $descriptionValidationStep
     */
    public function __construct($idValidationStep = null, $typeValidationStep = null, $resultValidationStep = null, $descriptionValidationStep = null)
    {
        $this
            ->setIdValidationStep($idValidationStep)
            ->setTypeValidationStep($typeValidationStep)
            ->setResultValidationStep($resultValidationStep)
            ->setDescriptionValidationStep($descriptionValidationStep);
    }
    /**
     * Get IdValidationStep value
     * @return int|null
     */
    public function getIdValidationStep()
    {
        return $this->IdValidationStep;
    }
    /**
     * Set IdValidationStep value
     * @param int $idValidationStep
     * @return \AisFssp\StructType\ValidationStepDetailType
     */
    public function setIdValidationStep($idValidationStep = null)
    {
        // validation for constraint: maxInclusive
        if ($idValidationStep > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $idValidationStep), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($idValidationStep < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $idValidationStep), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($idValidationStep) && !is_numeric($idValidationStep)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($idValidationStep)), __LINE__);
        }
        $this->IdValidationStep = $idValidationStep;
        return $this;
    }
    /**
     * Get TypeValidationStep value
     * @return string|null
     */
    public function getTypeValidationStep()
    {
        return $this->TypeValidationStep;
    }
    /**
     * Set TypeValidationStep value
     * @uses \AisFssp\EnumType\ValidationStepType::valueIsValid()
     * @uses \AisFssp\EnumType\ValidationStepType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $typeValidationStep
     * @return \AisFssp\StructType\ValidationStepDetailType
     */
    public function setTypeValidationStep($typeValidationStep = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\ValidationStepType::valueIsValid($typeValidationStep)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $typeValidationStep, implode(', ', \AisFssp\EnumType\ValidationStepType::getValidValues())), __LINE__);
        }
        $this->TypeValidationStep = $typeValidationStep;
        return $this;
    }
    /**
     * Get ResultValidationStep value
     * @return bool|null
     */
    public function getResultValidationStep()
    {
        return $this->ResultValidationStep;
    }
    /**
     * Set ResultValidationStep value
     * @param bool $resultValidationStep
     * @return \AisFssp\StructType\ValidationStepDetailType
     */
    public function setResultValidationStep($resultValidationStep = null)
    {
        // validation for constraint: boolean
        if (!is_null($resultValidationStep) && !is_bool($resultValidationStep)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($resultValidationStep)), __LINE__);
        }
        $this->ResultValidationStep = $resultValidationStep;
        return $this;
    }
    /**
     * Get DescriptionValidationStep value
     * @return string|null
     */
    public function getDescriptionValidationStep()
    {
        return $this->DescriptionValidationStep;
    }
    /**
     * Set DescriptionValidationStep value
     * @param string $descriptionValidationStep
     * @return \AisFssp\StructType\ValidationStepDetailType
     */
    public function setDescriptionValidationStep($descriptionValidationStep = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($descriptionValidationStep) && strlen($descriptionValidationStep) > 1000) || (is_array($descriptionValidationStep) && count($descriptionValidationStep) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($descriptionValidationStep) ? strlen($descriptionValidationStep) : count($descriptionValidationStep)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($descriptionValidationStep) && strlen($descriptionValidationStep) < 1) || (is_array($descriptionValidationStep) && count($descriptionValidationStep) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($descriptionValidationStep) && !is_string($descriptionValidationStep)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($descriptionValidationStep)), __LINE__);
        }
        $this->DescriptionValidationStep = $descriptionValidationStep;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\ValidationStepDetailType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
