<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnemployedPersonRegistrationDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения о периоде нахождения на регистрационном учете в качестве безработного
 * @subpackage Structs
 */
class UnemployedPersonRegistrationDatumType extends InformationType
{
    /**
     * The RegistrationDateBegin
     * Meta informations extracted from the WSDL
     * - documentation: Дата начала периода в качестве безработного | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $RegistrationDateBegin;
    /**
     * The RegistrationDateEnd
     * Meta informations extracted from the WSDL
     * - documentation: Дата конца периода в качестве безработного | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $RegistrationDateEnd;
    /**
     * The SearchDateBegin
     * Meta informations extracted from the WSDL
     * - documentation: Дата начала периода в целях поиска подходящей работы | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $SearchDateBegin;
    /**
     * The SearchDateEnd
     * Meta informations extracted from the WSDL
     * - documentation: Дата конца периода в целях поиска подходящей работы | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $SearchDateEnd;
    /**
     * Constructor method for UnemployedPersonRegistrationDatumType
     * @uses UnemployedPersonRegistrationDatumType::setRegistrationDateBegin()
     * @uses UnemployedPersonRegistrationDatumType::setRegistrationDateEnd()
     * @uses UnemployedPersonRegistrationDatumType::setSearchDateBegin()
     * @uses UnemployedPersonRegistrationDatumType::setSearchDateEnd()
     * @param string $registrationDateBegin
     * @param string $registrationDateEnd
     * @param string $searchDateBegin
     * @param string $searchDateEnd
     */
    public function __construct($registrationDateBegin = null, $registrationDateEnd = null, $searchDateBegin = null, $searchDateEnd = null)
    {
        $this
            ->setRegistrationDateBegin($registrationDateBegin)
            ->setRegistrationDateEnd($registrationDateEnd)
            ->setSearchDateBegin($searchDateBegin)
            ->setSearchDateEnd($searchDateEnd);
    }
    /**
     * Get RegistrationDateBegin value
     * @return string|null
     */
    public function getRegistrationDateBegin()
    {
        return $this->RegistrationDateBegin;
    }
    /**
     * Set RegistrationDateBegin value
     * @param string $registrationDateBegin
     * @return \AisFssp\StructType\UnemployedPersonRegistrationDatumType
     */
    public function setRegistrationDateBegin($registrationDateBegin = null)
    {
        // validation for constraint: maxExclusive
        if ($registrationDateBegin >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $registrationDateBegin), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($registrationDateBegin < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $registrationDateBegin), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($registrationDateBegin) && !is_string($registrationDateBegin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($registrationDateBegin)), __LINE__);
        }
        $this->RegistrationDateBegin = $registrationDateBegin;
        return $this;
    }
    /**
     * Get RegistrationDateEnd value
     * @return string|null
     */
    public function getRegistrationDateEnd()
    {
        return $this->RegistrationDateEnd;
    }
    /**
     * Set RegistrationDateEnd value
     * @param string $registrationDateEnd
     * @return \AisFssp\StructType\UnemployedPersonRegistrationDatumType
     */
    public function setRegistrationDateEnd($registrationDateEnd = null)
    {
        // validation for constraint: maxExclusive
        if ($registrationDateEnd >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $registrationDateEnd), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($registrationDateEnd < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $registrationDateEnd), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($registrationDateEnd) && !is_string($registrationDateEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($registrationDateEnd)), __LINE__);
        }
        $this->RegistrationDateEnd = $registrationDateEnd;
        return $this;
    }
    /**
     * Get SearchDateBegin value
     * @return string|null
     */
    public function getSearchDateBegin()
    {
        return $this->SearchDateBegin;
    }
    /**
     * Set SearchDateBegin value
     * @param string $searchDateBegin
     * @return \AisFssp\StructType\UnemployedPersonRegistrationDatumType
     */
    public function setSearchDateBegin($searchDateBegin = null)
    {
        // validation for constraint: maxExclusive
        if ($searchDateBegin >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $searchDateBegin), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($searchDateBegin < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $searchDateBegin), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($searchDateBegin) && !is_string($searchDateBegin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($searchDateBegin)), __LINE__);
        }
        $this->SearchDateBegin = $searchDateBegin;
        return $this;
    }
    /**
     * Get SearchDateEnd value
     * @return string|null
     */
    public function getSearchDateEnd()
    {
        return $this->SearchDateEnd;
    }
    /**
     * Set SearchDateEnd value
     * @param string $searchDateEnd
     * @return \AisFssp\StructType\UnemployedPersonRegistrationDatumType
     */
    public function setSearchDateEnd($searchDateEnd = null)
    {
        // validation for constraint: maxExclusive
        if ($searchDateEnd >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $searchDateEnd), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($searchDateEnd < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $searchDateEnd), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($searchDateEnd) && !is_string($searchDateEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($searchDateEnd)), __LINE__);
        }
        $this->SearchDateEnd = $searchDateEnd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\UnemployedPersonRegistrationDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
