<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnaccountedForDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения о пропавшем без вести
 * @subpackage Structs
 */
class UnaccountedForDatumType extends InformationType
{
    /**
     * The AktDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата объявления | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $AktDate;
    /**
     * The ComplementaryInfo
     * Meta informations extracted from the WSDL
     * - documentation: Дополнительная информация | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $ComplementaryInfo;
    /**
     * Constructor method for UnaccountedForDatumType
     * @uses UnaccountedForDatumType::setAktDate()
     * @uses UnaccountedForDatumType::setComplementaryInfo()
     * @param string $aktDate
     * @param string $complementaryInfo
     */
    public function __construct($aktDate = null, $complementaryInfo = null)
    {
        $this
            ->setAktDate($aktDate)
            ->setComplementaryInfo($complementaryInfo);
    }
    /**
     * Get AktDate value
     * @return string|null
     */
    public function getAktDate()
    {
        return $this->AktDate;
    }
    /**
     * Set AktDate value
     * @param string $aktDate
     * @return \AisFssp\StructType\UnaccountedForDatumType
     */
    public function setAktDate($aktDate = null)
    {
        // validation for constraint: maxExclusive
        if ($aktDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $aktDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($aktDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $aktDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aktDate) && !is_string($aktDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aktDate)), __LINE__);
        }
        $this->AktDate = $aktDate;
        return $this;
    }
    /**
     * Get ComplementaryInfo value
     * @return string|null
     */
    public function getComplementaryInfo()
    {
        return $this->ComplementaryInfo;
    }
    /**
     * Set ComplementaryInfo value
     * @param string $complementaryInfo
     * @return \AisFssp\StructType\UnaccountedForDatumType
     */
    public function setComplementaryInfo($complementaryInfo = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($complementaryInfo) && strlen($complementaryInfo) > 1000) || (is_array($complementaryInfo) && count($complementaryInfo) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($complementaryInfo) ? strlen($complementaryInfo) : count($complementaryInfo)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($complementaryInfo) && strlen($complementaryInfo) < 1) || (is_array($complementaryInfo) && count($complementaryInfo) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($complementaryInfo) && !is_string($complementaryInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($complementaryInfo)), __LINE__);
        }
        $this->ComplementaryInfo = $complementaryInfo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\UnaccountedForDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
