<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransactionSideType StructType
 * @subpackage Structs
 */
class TransactionSideType extends AbstractStructBase
{
    /**
     * The transactSideCode
     * Meta informations extracted from the WSDL
     * - documentation: Код вида стороны операции | Строка длиной от 1 до 10 символов
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $transactSideCode;
    /**
     * The transactSideName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование стороны операции | Строка длиной от 1 до 100 символов
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $transactSideName;
    /**
     * The companyDatum
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о юридическом лице
     * @var \AisFssp\StructType\CompanyDatumType
     */
    public $companyDatum;
    /**
     * The personDatumPersonDatumType
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о физическом лице
     * @var \AisFssp\StructType\PersonDatumType
     */
    public $personDatumPersonDatumType;
    /**
     * Constructor method for TransactionSideType
     * @uses TransactionSideType::setTransactSideCode()
     * @uses TransactionSideType::setTransactSideName()
     * @uses TransactionSideType::setCompanyDatum()
     * @uses TransactionSideType::setPersonDatumPersonDatumType()
     * @param string $transactSideCode
     * @param string $transactSideName
     * @param \AisFssp\StructType\CompanyDatumType $companyDatum
     * @param \AisFssp\StructType\PersonDatumType $personDatumPersonDatumType
     */
    public function __construct($transactSideCode = null, $transactSideName = null, \AisFssp\StructType\CompanyDatumType $companyDatum = null, \AisFssp\StructType\PersonDatumType $personDatumPersonDatumType = null)
    {
        $this
            ->setTransactSideCode($transactSideCode)
            ->setTransactSideName($transactSideName)
            ->setCompanyDatum($companyDatum)
            ->setPersonDatumPersonDatumType($personDatumPersonDatumType);
    }
    /**
     * Get transactSideCode value
     * @return string|null
     */
    public function getTransactSideCode()
    {
        return $this->transactSideCode;
    }
    /**
     * Set transactSideCode value
     * @param string $transactSideCode
     * @return \AisFssp\StructType\TransactionSideType
     */
    public function setTransactSideCode($transactSideCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($transactSideCode) && strlen($transactSideCode) > 10) || (is_array($transactSideCode) && count($transactSideCode) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($transactSideCode) ? strlen($transactSideCode) : count($transactSideCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($transactSideCode) && strlen($transactSideCode) < 1) || (is_array($transactSideCode) && count($transactSideCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($transactSideCode) && !is_string($transactSideCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactSideCode)), __LINE__);
        }
        $this->transactSideCode = $transactSideCode;
        return $this;
    }
    /**
     * Get transactSideName value
     * @return string|null
     */
    public function getTransactSideName()
    {
        return $this->transactSideName;
    }
    /**
     * Set transactSideName value
     * @param string $transactSideName
     * @return \AisFssp\StructType\TransactionSideType
     */
    public function setTransactSideName($transactSideName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($transactSideName) && strlen($transactSideName) > 100) || (is_array($transactSideName) && count($transactSideName) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($transactSideName) ? strlen($transactSideName) : count($transactSideName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($transactSideName) && strlen($transactSideName) < 1) || (is_array($transactSideName) && count($transactSideName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($transactSideName) && !is_string($transactSideName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactSideName)), __LINE__);
        }
        $this->transactSideName = $transactSideName;
        return $this;
    }
    /**
     * Get companyDatum value
     * @return \AisFssp\StructType\CompanyDatumType|null
     */
    public function getCompanyDatum()
    {
        return $this->companyDatum;
    }
    /**
     * Set companyDatum value
     * @param \AisFssp\StructType\CompanyDatumType $companyDatum
     * @return \AisFssp\StructType\TransactionSideType
     */
    public function setCompanyDatum(\AisFssp\StructType\CompanyDatumType $companyDatum = null)
    {
        $this->companyDatum = $companyDatum;
        return $this;
    }
    /**
     * Get personDatumPersonDatumType value
     * @return \AisFssp\StructType\PersonDatumType|null
     */
    public function getPersonDatumPersonDatumType()
    {
        return $this->personDatumPersonDatumType;
    }
    /**
     * Set personDatumPersonDatumType value
     * @param \AisFssp\StructType\PersonDatumType $personDatumPersonDatumType
     * @return \AisFssp\StructType\TransactionSideType
     */
    public function setPersonDatumPersonDatumType(\AisFssp\StructType\PersonDatumType $personDatumPersonDatumType = null)
    {
        $this->personDatumPersonDatumType = $personDatumPersonDatumType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\TransactionSideType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
