<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TelephoneDataType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип сведений TelephoneDataType "Телефон"
 * @subpackage Structs
 */
class TelephoneDataType extends InformationType
{
    /**
     * The TelephoneNo
     * Meta informations extracted from the WSDL
     * - documentation: Номер телефона абонента | Номер телефона
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $TelephoneNo;
    /**
     * The FaxNo
     * Meta informations extracted from the WSDL
     * - documentation: Номер факса | Строка длиной от 1 до 25 символов
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $FaxNo;
    /**
     * The DeptCode
     * Meta informations extracted from the WSDL
     * - documentation: Код подразделения | Строка длиной от 1 до 10 символов
     * - minOccurs: 0
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $DeptCode;
    /**
     * Constructor method for TelephoneDataType
     * @uses TelephoneDataType::setTelephoneNo()
     * @uses TelephoneDataType::setFaxNo()
     * @uses TelephoneDataType::setDeptCode()
     * @param string $telephoneNo
     * @param string $faxNo
     * @param string $deptCode
     */
    public function __construct($telephoneNo = null, $faxNo = null, $deptCode = null)
    {
        $this
            ->setTelephoneNo($telephoneNo)
            ->setFaxNo($faxNo)
            ->setDeptCode($deptCode);
    }
    /**
     * Get TelephoneNo value
     * @return string|null
     */
    public function getTelephoneNo()
    {
        return $this->TelephoneNo;
    }
    /**
     * Set TelephoneNo value
     * @param string $telephoneNo
     * @return \AisFssp\StructType\TelephoneDataType
     */
    public function setTelephoneNo($telephoneNo = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($telephoneNo) && strlen($telephoneNo) > 25) || (is_array($telephoneNo) && count($telephoneNo) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($telephoneNo) ? strlen($telephoneNo) : count($telephoneNo)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($telephoneNo) && strlen($telephoneNo) < 1) || (is_array($telephoneNo) && count($telephoneNo) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($telephoneNo) && !is_string($telephoneNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($telephoneNo)), __LINE__);
        }
        $this->TelephoneNo = $telephoneNo;
        return $this;
    }
    /**
     * Get FaxNo value
     * @return string|null
     */
    public function getFaxNo()
    {
        return $this->FaxNo;
    }
    /**
     * Set FaxNo value
     * @param string $faxNo
     * @return \AisFssp\StructType\TelephoneDataType
     */
    public function setFaxNo($faxNo = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($faxNo) && strlen($faxNo) > 25) || (is_array($faxNo) && count($faxNo) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($faxNo) ? strlen($faxNo) : count($faxNo)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($faxNo) && strlen($faxNo) < 1) || (is_array($faxNo) && count($faxNo) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($faxNo) && !is_string($faxNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($faxNo)), __LINE__);
        }
        $this->FaxNo = $faxNo;
        return $this;
    }
    /**
     * Get DeptCode value
     * @return string|null
     */
    public function getDeptCode()
    {
        return $this->DeptCode;
    }
    /**
     * Set DeptCode value
     * @param string $deptCode
     * @return \AisFssp\StructType\TelephoneDataType
     */
    public function setDeptCode($deptCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($deptCode) && strlen($deptCode) > 10) || (is_array($deptCode) && count($deptCode) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($deptCode) ? strlen($deptCode) : count($deptCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($deptCode) && strlen($deptCode) < 1) || (is_array($deptCode) && count($deptCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($deptCode) && !is_string($deptCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deptCode)), __LINE__);
        }
        $this->DeptCode = $deptCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\TelephoneDataType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
