<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SyncRs StructType
 * @subpackage Structs
 */
abstract class SyncRs extends AbstractStructBase
{
    /**
     * The inquiryKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ сообщения внешнего контрагента | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие).
     * Данный идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - minOccurs: 0
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $inquiryKey;
    /**
     * The internalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ сообщения АИС ФССП России | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при
     * получении объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $internalKey;
    /**
     * The origin
     * Meta informations extracted from the WSDL
     * - documentation: Адрес отправителя пакета
     * @var \AisFssp\StructType\RedAddress
     */
    public $origin;
    /**
     * The target
     * Meta informations extracted from the WSDL
     * - documentation: Адрес получателя пакета
     * @var \AisFssp\StructType\RedAddress
     */
    public $target;
    /**
     * The errorCode
     * Meta informations extracted from the WSDL
     * - documentation: Код ошибки | Код ошибки
     * - minOccurs: 0
     * @var int
     */
    public $errorCode;
    /**
     * The errorText
     * Meta informations extracted from the WSDL
     * - documentation: Текст ошибки | Текст ошибки
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 0
     * @var string
     */
    public $errorText;
    /**
     * Constructor method for SyncRs
     * @uses SyncRs::setInquiryKey()
     * @uses SyncRs::setInternalKey()
     * @uses SyncRs::setOrigin()
     * @uses SyncRs::setTarget()
     * @uses SyncRs::setErrorCode()
     * @uses SyncRs::setErrorText()
     * @param string $inquiryKey
     * @param int $internalKey
     * @param \AisFssp\StructType\RedAddress $origin
     * @param \AisFssp\StructType\RedAddress $target
     * @param int $errorCode
     * @param string $errorText
     */
    public function __construct($inquiryKey = null, $internalKey = null, \AisFssp\StructType\RedAddress $origin = null, \AisFssp\StructType\RedAddress $target = null, $errorCode = null, $errorText = null)
    {
        $this
            ->setInquiryKey($inquiryKey)
            ->setInternalKey($internalKey)
            ->setOrigin($origin)
            ->setTarget($target)
            ->setErrorCode($errorCode)
            ->setErrorText($errorText);
    }
    /**
     * Get inquiryKey value
     * @return string|null
     */
    public function getInquiryKey()
    {
        return $this->inquiryKey;
    }
    /**
     * Set inquiryKey value
     * @param string $inquiryKey
     * @return \AisFssp\StructType\SyncRs
     */
    public function setInquiryKey($inquiryKey = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($inquiryKey) && strlen($inquiryKey) > 60) || (is_array($inquiryKey) && count($inquiryKey) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($inquiryKey) ? strlen($inquiryKey) : count($inquiryKey)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($inquiryKey) && strlen($inquiryKey) < 1) || (is_array($inquiryKey) && count($inquiryKey) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($inquiryKey) && !is_string($inquiryKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($inquiryKey)), __LINE__);
        }
        $this->inquiryKey = $inquiryKey;
        return $this;
    }
    /**
     * Get internalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->internalKey;
    }
    /**
     * Set internalKey value
     * @param int $internalKey
     * @return \AisFssp\StructType\SyncRs
     */
    public function setInternalKey($internalKey = null)
    {
        // validation for constraint: maxInclusive
        if ($internalKey > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($internalKey < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($internalKey) && !is_numeric($internalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($internalKey)), __LINE__);
        }
        $this->internalKey = $internalKey;
        return $this;
    }
    /**
     * Get origin value
     * @return \AisFssp\StructType\RedAddress|null
     */
    public function getOrigin()
    {
        return $this->origin;
    }
    /**
     * Set origin value
     * @param \AisFssp\StructType\RedAddress $origin
     * @return \AisFssp\StructType\SyncRs
     */
    public function setOrigin(\AisFssp\StructType\RedAddress $origin = null)
    {
        $this->origin = $origin;
        return $this;
    }
    /**
     * Get target value
     * @return \AisFssp\StructType\RedAddress|null
     */
    public function getTarget()
    {
        return $this->target;
    }
    /**
     * Set target value
     * @param \AisFssp\StructType\RedAddress $target
     * @return \AisFssp\StructType\SyncRs
     */
    public function setTarget(\AisFssp\StructType\RedAddress $target = null)
    {
        $this->target = $target;
        return $this;
    }
    /**
     * Get errorCode value
     * @return int|null
     */
    public function getErrorCode()
    {
        return $this->errorCode;
    }
    /**
     * Set errorCode value
     * @param int $errorCode
     * @return \AisFssp\StructType\SyncRs
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: int
        if (!is_null($errorCode) && !is_numeric($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($errorCode)), __LINE__);
        }
        $this->errorCode = $errorCode;
        return $this;
    }
    /**
     * Get errorText value
     * @return string|null
     */
    public function getErrorText()
    {
        return $this->errorText;
    }
    /**
     * Set errorText value
     * @param string $errorText
     * @return \AisFssp\StructType\SyncRs
     */
    public function setErrorText($errorText = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($errorText) && strlen($errorText) > 1000) || (is_array($errorText) && count($errorText) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($errorText) ? strlen($errorText) : count($errorText)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($errorText) && strlen($errorText) < 0) || (is_array($errorText) && count($errorText) < 0)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 0 element(s) or a scalar of 0 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($errorText) && !is_string($errorText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($errorText)), __LINE__);
        }
        $this->errorText = $errorText;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\SyncRs
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
