<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SvedNedvShareHoldingType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения о долевом участии
 * @subpackage Structs
 */
class SvedNedvShareHoldingType extends InformationType
{
    /**
     * The shareHolders
     * Meta informations extracted from the WSDL
     * - documentation: Описание объекта долевого строительства | Строка длиной от 1 до 4000 символов
     * - maxLength: 4000
     * - minLength: 1
     * @var string
     */
    public $shareHolders;
    /**
     * Constructor method for SvedNedvShareHoldingType
     * @uses SvedNedvShareHoldingType::setShareHolders()
     * @param string $shareHolders
     */
    public function __construct($shareHolders = null)
    {
        $this
            ->setShareHolders($shareHolders);
    }
    /**
     * Get shareHolders value
     * @return string|null
     */
    public function getShareHolders()
    {
        return $this->shareHolders;
    }
    /**
     * Set shareHolders value
     * @param string $shareHolders
     * @return \AisFssp\StructType\SvedNedvShareHoldingType
     */
    public function setShareHolders($shareHolders = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($shareHolders) && strlen($shareHolders) > 4000) || (is_array($shareHolders) && count($shareHolders) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($shareHolders) ? strlen($shareHolders) : count($shareHolders)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($shareHolders) && strlen($shareHolders) < 1) || (is_array($shareHolders) && count($shareHolders) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($shareHolders) && !is_string($shareHolders)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareHolders)), __LINE__);
        }
        $this->shareHolders = $shareHolders;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\SvedNedvShareHoldingType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
