<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SvedDoxodDataType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип сведений SvedDoxodDataType "Полученный доход"
 * @subpackage Structs
 */
class SvedDoxodDataType extends InformationType
{
    /**
     * The DataDox
     * Meta informations extracted from the WSDL
     * - documentation: Дата получения дохода | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DataDox;
    /**
     * The SumDox
     * Meta informations extracted from the WSDL
     * - documentation: Сумма | Сумма выплат и иных вознаграждений, начисленных в пользу физического лица | Сумма
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $SumDox;
    /**
     * The SumOPS
     * Meta informations extracted from the WSDL
     * - documentation: Сумма по ОПС | Из них на которые начислены страховые взносы на ОПС за календарный год | Сумма
     * - minOccurs: 0
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $SumOPS;
    /**
     * The Ground
     * Meta informations extracted from the WSDL
     * - documentation: Основание получения дохода | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $Ground;
    /**
     * The CodePFR
     * Meta informations extracted from the WSDL
     * - documentation: Код вида выплаты ПФР | Строка длиной от 1 до 15 символов
     * - minOccurs: 0
     * - maxLength: 15
     * - minLength: 1
     * @var string
     */
    public $CodePFR;
    /**
     * Constructor method for SvedDoxodDataType
     * @uses SvedDoxodDataType::setDataDox()
     * @uses SvedDoxodDataType::setSumDox()
     * @uses SvedDoxodDataType::setSumOPS()
     * @uses SvedDoxodDataType::setGround()
     * @uses SvedDoxodDataType::setCodePFR()
     * @param string $dataDox
     * @param float $sumDox
     * @param float $sumOPS
     * @param string $ground
     * @param string $codePFR
     */
    public function __construct($dataDox = null, $sumDox = null, $sumOPS = null, $ground = null, $codePFR = null)
    {
        $this
            ->setDataDox($dataDox)
            ->setSumDox($sumDox)
            ->setSumOPS($sumOPS)
            ->setGround($ground)
            ->setCodePFR($codePFR);
    }
    /**
     * Get DataDox value
     * @return string|null
     */
    public function getDataDox()
    {
        return $this->DataDox;
    }
    /**
     * Set DataDox value
     * @param string $dataDox
     * @return \AisFssp\StructType\SvedDoxodDataType
     */
    public function setDataDox($dataDox = null)
    {
        // validation for constraint: maxExclusive
        if ($dataDox >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $dataDox), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($dataDox < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $dataDox), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dataDox) && !is_string($dataDox)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dataDox)), __LINE__);
        }
        $this->DataDox = $dataDox;
        return $this;
    }
    /**
     * Get SumDox value
     * @return float|null
     */
    public function getSumDox()
    {
        return $this->SumDox;
    }
    /**
     * Set SumDox value
     * @param float $sumDox
     * @return \AisFssp\StructType\SvedDoxodDataType
     */
    public function setSumDox($sumDox = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($sumDox) && strlen(substr($sumDox, strpos($sumDox, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($sumDox, strpos($sumDox, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($sumDox) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $sumDox)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($sumDox, strpos($sumDox, '.')))), __LINE__);
        }
        $this->SumDox = $sumDox;
        return $this;
    }
    /**
     * Get SumOPS value
     * @return float|null
     */
    public function getSumOPS()
    {
        return $this->SumOPS;
    }
    /**
     * Set SumOPS value
     * @param float $sumOPS
     * @return \AisFssp\StructType\SvedDoxodDataType
     */
    public function setSumOPS($sumOPS = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($sumOPS) && strlen(substr($sumOPS, strpos($sumOPS, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($sumOPS, strpos($sumOPS, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($sumOPS) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $sumOPS)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($sumOPS, strpos($sumOPS, '.')))), __LINE__);
        }
        $this->SumOPS = $sumOPS;
        return $this;
    }
    /**
     * Get Ground value
     * @return string|null
     */
    public function getGround()
    {
        return $this->Ground;
    }
    /**
     * Set Ground value
     * @param string $ground
     * @return \AisFssp\StructType\SvedDoxodDataType
     */
    public function setGround($ground = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($ground) && strlen($ground) > 300) || (is_array($ground) && count($ground) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($ground) ? strlen($ground) : count($ground)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($ground) && strlen($ground) < 1) || (is_array($ground) && count($ground) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ground) && !is_string($ground)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ground)), __LINE__);
        }
        $this->Ground = $ground;
        return $this;
    }
    /**
     * Get CodePFR value
     * @return string|null
     */
    public function getCodePFR()
    {
        return $this->CodePFR;
    }
    /**
     * Set CodePFR value
     * @param string $codePFR
     * @return \AisFssp\StructType\SvedDoxodDataType
     */
    public function setCodePFR($codePFR = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($codePFR) && strlen($codePFR) > 15) || (is_array($codePFR) && count($codePFR) > 15)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 15 element(s) or a scalar of 15 character(s) at most, "%d" length given', is_scalar($codePFR) ? strlen($codePFR) : count($codePFR)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($codePFR) && strlen($codePFR) < 1) || (is_array($codePFR) && count($codePFR) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($codePFR) && !is_string($codePFR)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codePFR)), __LINE__);
        }
        $this->CodePFR = $codePFR;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\SvedDoxodDataType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
