<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SoleEntrepreneurOldRegDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения о регистрации индивидуального предпринимателя до 01.01.2004 г.
 * @subpackage Structs
 */
class SoleEntrepreneurOldRegDatumType extends InformationType
{
    /**
     * The oldRegNumber
     * Meta informations extracted from the WSDL
     * - documentation: Регистрационный номер | Строка длиной от 1 до 255 символов
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $oldRegNumber;
    /**
     * The regDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата регистрации | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $regDate;
    /**
     * Constructor method for SoleEntrepreneurOldRegDatumType
     * @uses SoleEntrepreneurOldRegDatumType::setOldRegNumber()
     * @uses SoleEntrepreneurOldRegDatumType::setRegDate()
     * @param string $oldRegNumber
     * @param string $regDate
     */
    public function __construct($oldRegNumber = null, $regDate = null)
    {
        $this
            ->setOldRegNumber($oldRegNumber)
            ->setRegDate($regDate);
    }
    /**
     * Get oldRegNumber value
     * @return string|null
     */
    public function getOldRegNumber()
    {
        return $this->oldRegNumber;
    }
    /**
     * Set oldRegNumber value
     * @param string $oldRegNumber
     * @return \AisFssp\StructType\SoleEntrepreneurOldRegDatumType
     */
    public function setOldRegNumber($oldRegNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($oldRegNumber) && strlen($oldRegNumber) > 255) || (is_array($oldRegNumber) && count($oldRegNumber) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($oldRegNumber) ? strlen($oldRegNumber) : count($oldRegNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($oldRegNumber) && strlen($oldRegNumber) < 1) || (is_array($oldRegNumber) && count($oldRegNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($oldRegNumber) && !is_string($oldRegNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oldRegNumber)), __LINE__);
        }
        $this->oldRegNumber = $oldRegNumber;
        return $this;
    }
    /**
     * Get regDate value
     * @return string|null
     */
    public function getRegDate()
    {
        return $this->regDate;
    }
    /**
     * Set regDate value
     * @param string $regDate
     * @return \AisFssp\StructType\SoleEntrepreneurOldRegDatumType
     */
    public function setRegDate($regDate = null)
    {
        // validation for constraint: maxExclusive
        if ($regDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $regDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($regDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $regDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($regDate) && !is_string($regDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($regDate)), __LINE__);
        }
        $this->regDate = $regDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\SoleEntrepreneurOldRegDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
