<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipEngineType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения о двигателях судна
 * @subpackage Structs
 */
class ShipEngineType extends AbstractStructBase
{
    /**
     * The EngineType
     * Meta informations extracted from the WSDL
     * - documentation: Тип двигателя
     * @var string
     */
    public $EngineType;
    /**
     * The BrandModelName
     * Meta informations extracted from the WSDL
     * - documentation: Марка и модель двигателя | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $BrandModelName;
    /**
     * The SeriesNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер/Серия двигателя | Строка длиной от 1 до 50 символов
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $SeriesNumber;
    /**
     * The EnginePowerKWh
     * Meta informations extracted from the WSDL
     * - documentation: Суммарная мощность двигателей, кВт. | Количество
     * - minOccurs: 0
     * - fractionDigits: 3
     * - totalDigits: 15
     * @var float
     */
    public $EnginePowerKWh;
    /**
     * The EnginePowerHp
     * Meta informations extracted from the WSDL
     * - documentation: Суммарная мощность двигателей, л. с. | Количество
     * - fractionDigits: 3
     * - totalDigits: 15
     * @var float
     */
    public $EnginePowerHp;
    /**
     * Constructor method for ShipEngineType
     * @uses ShipEngineType::setEngineType()
     * @uses ShipEngineType::setBrandModelName()
     * @uses ShipEngineType::setSeriesNumber()
     * @uses ShipEngineType::setEnginePowerKWh()
     * @uses ShipEngineType::setEnginePowerHp()
     * @param string $engineType
     * @param string $brandModelName
     * @param string $seriesNumber
     * @param float $enginePowerKWh
     * @param float $enginePowerHp
     */
    public function __construct($engineType = null, $brandModelName = null, $seriesNumber = null, $enginePowerKWh = null, $enginePowerHp = null)
    {
        $this
            ->setEngineType($engineType)
            ->setBrandModelName($brandModelName)
            ->setSeriesNumber($seriesNumber)
            ->setEnginePowerKWh($enginePowerKWh)
            ->setEnginePowerHp($enginePowerHp);
    }
    /**
     * Get EngineType value
     * @return string|null
     */
    public function getEngineType()
    {
        return $this->EngineType;
    }
    /**
     * Set EngineType value
     * @uses \AisFssp\EnumType\ShipEngineCodeType::valueIsValid()
     * @uses \AisFssp\EnumType\ShipEngineCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $engineType
     * @return \AisFssp\StructType\ShipEngineType
     */
    public function setEngineType($engineType = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\ShipEngineCodeType::valueIsValid($engineType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $engineType, implode(', ', \AisFssp\EnumType\ShipEngineCodeType::getValidValues())), __LINE__);
        }
        $this->EngineType = $engineType;
        return $this;
    }
    /**
     * Get BrandModelName value
     * @return string|null
     */
    public function getBrandModelName()
    {
        return $this->BrandModelName;
    }
    /**
     * Set BrandModelName value
     * @param string $brandModelName
     * @return \AisFssp\StructType\ShipEngineType
     */
    public function setBrandModelName($brandModelName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($brandModelName) && strlen($brandModelName) > 50) || (is_array($brandModelName) && count($brandModelName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($brandModelName) ? strlen($brandModelName) : count($brandModelName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($brandModelName) && strlen($brandModelName) < 1) || (is_array($brandModelName) && count($brandModelName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($brandModelName) && !is_string($brandModelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($brandModelName)), __LINE__);
        }
        $this->BrandModelName = $brandModelName;
        return $this;
    }
    /**
     * Get SeriesNumber value
     * @return string|null
     */
    public function getSeriesNumber()
    {
        return $this->SeriesNumber;
    }
    /**
     * Set SeriesNumber value
     * @param string $seriesNumber
     * @return \AisFssp\StructType\ShipEngineType
     */
    public function setSeriesNumber($seriesNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($seriesNumber) && strlen($seriesNumber) > 50) || (is_array($seriesNumber) && count($seriesNumber) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($seriesNumber) ? strlen($seriesNumber) : count($seriesNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($seriesNumber) && strlen($seriesNumber) < 1) || (is_array($seriesNumber) && count($seriesNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($seriesNumber) && !is_string($seriesNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($seriesNumber)), __LINE__);
        }
        $this->SeriesNumber = $seriesNumber;
        return $this;
    }
    /**
     * Get EnginePowerKWh value
     * @return float|null
     */
    public function getEnginePowerKWh()
    {
        return $this->EnginePowerKWh;
    }
    /**
     * Set EnginePowerKWh value
     * @param float $enginePowerKWh
     * @return \AisFssp\StructType\ShipEngineType
     */
    public function setEnginePowerKWh($enginePowerKWh = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($enginePowerKWh) && strlen(substr($enginePowerKWh, strpos($enginePowerKWh, '.') + 1)) !== 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 3 fraction digits, "%d" given', strlen(substr($enginePowerKWh, strpos($enginePowerKWh, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($enginePowerKWh) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $enginePowerKWh)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($enginePowerKWh, strpos($enginePowerKWh, '.')))), __LINE__);
        }
        $this->EnginePowerKWh = $enginePowerKWh;
        return $this;
    }
    /**
     * Get EnginePowerHp value
     * @return float|null
     */
    public function getEnginePowerHp()
    {
        return $this->EnginePowerHp;
    }
    /**
     * Set EnginePowerHp value
     * @param float $enginePowerHp
     * @return \AisFssp\StructType\ShipEngineType
     */
    public function setEnginePowerHp($enginePowerHp = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($enginePowerHp) && strlen(substr($enginePowerHp, strpos($enginePowerHp, '.') + 1)) !== 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 3 fraction digits, "%d" given', strlen(substr($enginePowerHp, strpos($enginePowerHp, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($enginePowerHp) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $enginePowerHp)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($enginePowerHp, strpos($enginePowerHp, '.')))), __LINE__);
        }
        $this->EnginePowerHp = $enginePowerHp;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\ShipEngineType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
