<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SentencedPersonImprisonmentType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения об отбывании наказания осужденным должником в местах лишения свободы
 * @subpackage Structs
 */
class SentencedPersonImprisonmentType extends InformationType
{
    /**
     * The DatePunishment
     * Meta informations extracted from the WSDL
     * - documentation: Срок (дата) отбывания наказания | Дата | Дата
     * - minOccurs: 1
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DatePunishment;
    /**
     * The FactEmployment
     * Meta informations extracted from the WSDL
     * - documentation: Факт трудоустройства по месту отбывания наказания | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $FactEmployment;
    /**
     * The PersonalAccConvict
     * Meta informations extracted from the WSDL
     * - documentation: Номер лицевого счета осужденного должника | Строка длиной от 1 до 25 символов
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $PersonalAccConvict;
    /**
     * The SumPersonalAccConvict
     * Meta informations extracted from the WSDL
     * - documentation: Сумма денежных средств на лицевом счете осужденного должника | Сумма
     * - minOccurs: 0
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $SumPersonalAccConvict;
    /**
     * The DateGrantParole
     * Meta informations extracted from the WSDL
     * - documentation: Дата возможного рассмотрения вопроса об условно-досрочном освобождении | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DateGrantParole;
    /**
     * The AdrPunishment
     * Meta informations extracted from the WSDL
     * - documentation: Адрес места отбывания наказания | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $AdrPunishment;
    /**
     * Constructor method for SentencedPersonImprisonmentType
     * @uses SentencedPersonImprisonmentType::setDatePunishment()
     * @uses SentencedPersonImprisonmentType::setFactEmployment()
     * @uses SentencedPersonImprisonmentType::setPersonalAccConvict()
     * @uses SentencedPersonImprisonmentType::setSumPersonalAccConvict()
     * @uses SentencedPersonImprisonmentType::setDateGrantParole()
     * @uses SentencedPersonImprisonmentType::setAdrPunishment()
     * @param string $datePunishment
     * @param string $factEmployment
     * @param string $personalAccConvict
     * @param float $sumPersonalAccConvict
     * @param string $dateGrantParole
     * @param string $adrPunishment
     */
    public function __construct($datePunishment = null, $factEmployment = null, $personalAccConvict = null, $sumPersonalAccConvict = null, $dateGrantParole = null, $adrPunishment = null)
    {
        $this
            ->setDatePunishment($datePunishment)
            ->setFactEmployment($factEmployment)
            ->setPersonalAccConvict($personalAccConvict)
            ->setSumPersonalAccConvict($sumPersonalAccConvict)
            ->setDateGrantParole($dateGrantParole)
            ->setAdrPunishment($adrPunishment);
    }
    /**
     * Get DatePunishment value
     * @return string
     */
    public function getDatePunishment()
    {
        return $this->DatePunishment;
    }
    /**
     * Set DatePunishment value
     * @param string $datePunishment
     * @return \AisFssp\StructType\SentencedPersonImprisonmentType
     */
    public function setDatePunishment($datePunishment = null)
    {
        // validation for constraint: maxExclusive
        if ($datePunishment >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $datePunishment), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($datePunishment < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $datePunishment), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($datePunishment) && !is_string($datePunishment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($datePunishment)), __LINE__);
        }
        $this->DatePunishment = $datePunishment;
        return $this;
    }
    /**
     * Get FactEmployment value
     * @return string|null
     */
    public function getFactEmployment()
    {
        return $this->FactEmployment;
    }
    /**
     * Set FactEmployment value
     * @param string $factEmployment
     * @return \AisFssp\StructType\SentencedPersonImprisonmentType
     */
    public function setFactEmployment($factEmployment = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($factEmployment) && strlen($factEmployment) > 300) || (is_array($factEmployment) && count($factEmployment) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($factEmployment) ? strlen($factEmployment) : count($factEmployment)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($factEmployment) && strlen($factEmployment) < 1) || (is_array($factEmployment) && count($factEmployment) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($factEmployment) && !is_string($factEmployment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($factEmployment)), __LINE__);
        }
        $this->FactEmployment = $factEmployment;
        return $this;
    }
    /**
     * Get PersonalAccConvict value
     * @return string|null
     */
    public function getPersonalAccConvict()
    {
        return $this->PersonalAccConvict;
    }
    /**
     * Set PersonalAccConvict value
     * @param string $personalAccConvict
     * @return \AisFssp\StructType\SentencedPersonImprisonmentType
     */
    public function setPersonalAccConvict($personalAccConvict = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($personalAccConvict) && strlen($personalAccConvict) > 25) || (is_array($personalAccConvict) && count($personalAccConvict) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($personalAccConvict) ? strlen($personalAccConvict) : count($personalAccConvict)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($personalAccConvict) && strlen($personalAccConvict) < 1) || (is_array($personalAccConvict) && count($personalAccConvict) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($personalAccConvict) && !is_string($personalAccConvict)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($personalAccConvict)), __LINE__);
        }
        $this->PersonalAccConvict = $personalAccConvict;
        return $this;
    }
    /**
     * Get SumPersonalAccConvict value
     * @return float|null
     */
    public function getSumPersonalAccConvict()
    {
        return $this->SumPersonalAccConvict;
    }
    /**
     * Set SumPersonalAccConvict value
     * @param float $sumPersonalAccConvict
     * @return \AisFssp\StructType\SentencedPersonImprisonmentType
     */
    public function setSumPersonalAccConvict($sumPersonalAccConvict = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($sumPersonalAccConvict) && strlen(substr($sumPersonalAccConvict, strpos($sumPersonalAccConvict, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($sumPersonalAccConvict, strpos($sumPersonalAccConvict, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($sumPersonalAccConvict) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $sumPersonalAccConvict)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($sumPersonalAccConvict, strpos($sumPersonalAccConvict, '.')))), __LINE__);
        }
        $this->SumPersonalAccConvict = $sumPersonalAccConvict;
        return $this;
    }
    /**
     * Get DateGrantParole value
     * @return string|null
     */
    public function getDateGrantParole()
    {
        return $this->DateGrantParole;
    }
    /**
     * Set DateGrantParole value
     * @param string $dateGrantParole
     * @return \AisFssp\StructType\SentencedPersonImprisonmentType
     */
    public function setDateGrantParole($dateGrantParole = null)
    {
        // validation for constraint: maxExclusive
        if ($dateGrantParole >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $dateGrantParole), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($dateGrantParole < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $dateGrantParole), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dateGrantParole) && !is_string($dateGrantParole)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateGrantParole)), __LINE__);
        }
        $this->DateGrantParole = $dateGrantParole;
        return $this;
    }
    /**
     * Get AdrPunishment value
     * @return string|null
     */
    public function getAdrPunishment()
    {
        return $this->AdrPunishment;
    }
    /**
     * Set AdrPunishment value
     * @param string $adrPunishment
     * @return \AisFssp\StructType\SentencedPersonImprisonmentType
     */
    public function setAdrPunishment($adrPunishment = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($adrPunishment) && strlen($adrPunishment) > 300) || (is_array($adrPunishment) && count($adrPunishment) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($adrPunishment) ? strlen($adrPunishment) : count($adrPunishment)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($adrPunishment) && strlen($adrPunishment) < 1) || (is_array($adrPunishment) && count($adrPunishment) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($adrPunishment) && !is_string($adrPunishment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($adrPunishment)), __LINE__);
        }
        $this->AdrPunishment = $adrPunishment;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\SentencedPersonImprisonmentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
