<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeniorityPeriodDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения о периоде трудового стажа
 * @subpackage Structs
 */
class SeniorityPeriodDatumType extends InformationType
{
    /**
     * The DateBegin
     * Meta informations extracted from the WSDL
     * - documentation: Дата начала периода | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DateBegin;
    /**
     * The DateEnd
     * Meta informations extracted from the WSDL
     * - documentation: Дата конца периода | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DateEnd;
    /**
     * Constructor method for SeniorityPeriodDatumType
     * @uses SeniorityPeriodDatumType::setDateBegin()
     * @uses SeniorityPeriodDatumType::setDateEnd()
     * @param string $dateBegin
     * @param string $dateEnd
     */
    public function __construct($dateBegin = null, $dateEnd = null)
    {
        $this
            ->setDateBegin($dateBegin)
            ->setDateEnd($dateEnd);
    }
    /**
     * Get DateBegin value
     * @return string|null
     */
    public function getDateBegin()
    {
        return $this->DateBegin;
    }
    /**
     * Set DateBegin value
     * @param string $dateBegin
     * @return \AisFssp\StructType\SeniorityPeriodDatumType
     */
    public function setDateBegin($dateBegin = null)
    {
        // validation for constraint: maxExclusive
        if ($dateBegin >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $dateBegin), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($dateBegin < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $dateBegin), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dateBegin) && !is_string($dateBegin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateBegin)), __LINE__);
        }
        $this->DateBegin = $dateBegin;
        return $this;
    }
    /**
     * Get DateEnd value
     * @return string|null
     */
    public function getDateEnd()
    {
        return $this->DateEnd;
    }
    /**
     * Set DateEnd value
     * @param string $dateEnd
     * @return \AisFssp\StructType\SeniorityPeriodDatumType
     */
    public function setDateEnd($dateEnd = null)
    {
        // validation for constraint: maxExclusive
        if ($dateEnd >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $dateEnd), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($dateEnd < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $dateEnd), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dateEnd) && !is_string($dateEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateEnd)), __LINE__);
        }
        $this->DateEnd = $dateEnd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\SeniorityPeriodDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
