<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SenderSPIType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Реквизиты отправителя документа-СПИ | Используется для передачи сведений об отделе судебных приставов и должностном лице,
 * направившем документ в адрес внешнего контрагента
 * @subpackage Structs
 */
class SenderSPIType extends AbstractStructBase
{
    /**
     * The SPIKey
     * Meta informations extracted from the WSDL
     * - documentation: Код должностного лица сделавшего заявление | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта
     * или при получении объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $SPIKey;
    /**
     * The SPIFio
     * Meta informations extracted from the WSDL
     * - documentation: ФИО должностного лица сделавшего заявление | Полное имя физического лица (фамилия, имя, отчество)
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $SPIFio;
    /**
     * The SPIFioParts
     * Meta informations extracted from the WSDL
     * - documentation: ФИО должностного лица сделавшего заявление | Заполняется, если соответствующие данные есть в системе. Для запросов к
     * операторам сотовой связи обязательно
     * - minOccurs: 0
     * @var \AisFssp\StructType\FioType
     */
    public $SPIFioParts;
    /**
     * The SPITel
     * Meta informations extracted from the WSDL
     * - documentation: Телефон должностного лица сделавшего заявление | Номер телефона
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $SPITel;
    /**
     * The SPIPost
     * Meta informations extracted from the WSDL
     * - documentation: Код должности должностного лица, сделавшего заявления | Заполняется по справочнику должностей ФССП России на основе ОКПДТР /
     * РДФГГС | Код должности СПИ
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * - pattern: [0-9\-\.\s]+
     * @var string
     */
    public $SPIPost;
    /**
     * Constructor method for SenderSPIType
     * @uses SenderSPIType::setSPIKey()
     * @uses SenderSPIType::setSPIFio()
     * @uses SenderSPIType::setSPIFioParts()
     * @uses SenderSPIType::setSPITel()
     * @uses SenderSPIType::setSPIPost()
     * @param int $sPIKey
     * @param string $sPIFio
     * @param \AisFssp\StructType\FioType $sPIFioParts
     * @param string $sPITel
     * @param string $sPIPost
     */
    public function __construct($sPIKey = null, $sPIFio = null, \AisFssp\StructType\FioType $sPIFioParts = null, $sPITel = null, $sPIPost = null)
    {
        $this
            ->setSPIKey($sPIKey)
            ->setSPIFio($sPIFio)
            ->setSPIFioParts($sPIFioParts)
            ->setSPITel($sPITel)
            ->setSPIPost($sPIPost);
    }
    /**
     * Get SPIKey value
     * @return int|null
     */
    public function getSPIKey()
    {
        return $this->SPIKey;
    }
    /**
     * Set SPIKey value
     * @param int $sPIKey
     * @return \AisFssp\StructType\SenderSPIType
     */
    public function setSPIKey($sPIKey = null)
    {
        // validation for constraint: maxInclusive
        if ($sPIKey > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $sPIKey), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($sPIKey < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $sPIKey), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($sPIKey) && !is_numeric($sPIKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sPIKey)), __LINE__);
        }
        $this->SPIKey = $sPIKey;
        return $this;
    }
    /**
     * Get SPIFio value
     * @return string|null
     */
    public function getSPIFio()
    {
        return $this->SPIFio;
    }
    /**
     * Set SPIFio value
     * @param string $sPIFio
     * @return \AisFssp\StructType\SenderSPIType
     */
    public function setSPIFio($sPIFio = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($sPIFio) && strlen($sPIFio) > 100) || (is_array($sPIFio) && count($sPIFio) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($sPIFio) ? strlen($sPIFio) : count($sPIFio)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($sPIFio) && strlen($sPIFio) < 1) || (is_array($sPIFio) && count($sPIFio) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sPIFio) && !is_string($sPIFio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sPIFio)), __LINE__);
        }
        $this->SPIFio = $sPIFio;
        return $this;
    }
    /**
     * Get SPIFioParts value
     * @return \AisFssp\StructType\FioType|null
     */
    public function getSPIFioParts()
    {
        return $this->SPIFioParts;
    }
    /**
     * Set SPIFioParts value
     * @param \AisFssp\StructType\FioType $sPIFioParts
     * @return \AisFssp\StructType\SenderSPIType
     */
    public function setSPIFioParts(\AisFssp\StructType\FioType $sPIFioParts = null)
    {
        $this->SPIFioParts = $sPIFioParts;
        return $this;
    }
    /**
     * Get SPITel value
     * @return string|null
     */
    public function getSPITel()
    {
        return $this->SPITel;
    }
    /**
     * Set SPITel value
     * @param string $sPITel
     * @return \AisFssp\StructType\SenderSPIType
     */
    public function setSPITel($sPITel = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($sPITel) && strlen($sPITel) > 25) || (is_array($sPITel) && count($sPITel) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($sPITel) ? strlen($sPITel) : count($sPITel)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($sPITel) && strlen($sPITel) < 1) || (is_array($sPITel) && count($sPITel) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sPITel) && !is_string($sPITel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sPITel)), __LINE__);
        }
        $this->SPITel = $sPITel;
        return $this;
    }
    /**
     * Get SPIPost value
     * @return string|null
     */
    public function getSPIPost()
    {
        return $this->SPIPost;
    }
    /**
     * Set SPIPost value
     * @param string $sPIPost
     * @return \AisFssp\StructType\SenderSPIType
     */
    public function setSPIPost($sPIPost = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($sPIPost) && strlen($sPIPost) > 25) || (is_array($sPIPost) && count($sPIPost) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($sPIPost) ? strlen($sPIPost) : count($sPIPost)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($sPIPost) && strlen($sPIPost) < 1) || (is_array($sPIPost) && count($sPIPost) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($sPIPost) && !preg_match('/[0-9\\-\\.\\s]+/', $sPIPost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9\-\.\s]+", "%s" given', var_export($sPIPost, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sPIPost) && !is_string($sPIPost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sPIPost)), __LINE__);
        }
        $this->SPIPost = $sPIPost;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\SenderSPIType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
