<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RequestByDatum StructType
 * Meta informations extracted from the WSDL
 * - documentation: Запрос данных по имеющимся сведениям
 * @subpackage Structs
 */
abstract class RequestByDatum extends AbstractStructBase
{
    /**
     * The externalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор АИС ВК | Идентификатор документа, присвоенный АИС внешнего контрагента | Идентификатор объекта, присвоенный
     * объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный идентификатор должен быть уникальным для типа идентифицируемого документа
     * в пространстве обмена данными с конкретным внешним контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $externalKey;
    /**
     * The docDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата запроса | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $docDate;
    /**
     * The docNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер запроса | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $docNumber;
    /**
     * The authorName
     * Meta informations extracted from the WSDL
     * - documentation: ФИО должностного лица | ФИО должностного лица, от имени которого направляется запрос
     * @var \AisFssp\StructType\FioType
     */
    public $authorName;
    /**
     * The authorPost
     * Meta informations extracted from the WSDL
     * - documentation: Должность | Наименование должности | Строка длиной от 1 до 50 символов
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $authorPost;
    /**
     * The data
     * Meta informations extracted from the WSDL
     * - documentation: Сведения | Таблица 18:Тип данных «Сведения» Data. Сведения о физическом лице. Обязательна передача сведений типа PersonDatumType (тип
     * сведений 18) «Сведения о физическом лице», сведений типа AddressDataType (тип сведений 16) «Адрес регистрации» и сведений типа IdentificationDataType (тип
     * сведений 01). Сведения юридическом лице. Обязательна передача сведений типах CompanyDatumType (тип сведений 19) «Сведения о юридическом лице»,
     * сведений типа AddressDataType (тип сведений 16) «Адрес регистрации».
     * - maxOccurs: unbounded
     * @var \AisFssp\StructType\Data[]
     */
    public $data;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Атрибут документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Id;
    /**
     * Constructor method for RequestByDatum
     * @uses RequestByDatum::setExternalKey()
     * @uses RequestByDatum::setDocDate()
     * @uses RequestByDatum::setDocNumber()
     * @uses RequestByDatum::setAuthorName()
     * @uses RequestByDatum::setAuthorPost()
     * @uses RequestByDatum::setData()
     * @uses RequestByDatum::setId()
     * @param string $externalKey
     * @param string $docDate
     * @param string $docNumber
     * @param \AisFssp\StructType\FioType $authorName
     * @param string $authorPost
     * @param \AisFssp\StructType\Data[] $data
     * @param string $id
     */
    public function __construct($externalKey = null, $docDate = null, $docNumber = null, \AisFssp\StructType\FioType $authorName = null, $authorPost = null, array $data = array(), $id = null)
    {
        $this
            ->setExternalKey($externalKey)
            ->setDocDate($docDate)
            ->setDocNumber($docNumber)
            ->setAuthorName($authorName)
            ->setAuthorPost($authorPost)
            ->setData($data)
            ->setId($id);
    }
    /**
     * Get externalKey value
     * @return string|null
     */
    public function getExternalKey()
    {
        return $this->externalKey;
    }
    /**
     * Set externalKey value
     * @param string $externalKey
     * @return \AisFssp\StructType\RequestByDatum
     */
    public function setExternalKey($externalKey = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($externalKey) && strlen($externalKey) > 60) || (is_array($externalKey) && count($externalKey) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($externalKey) ? strlen($externalKey) : count($externalKey)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($externalKey) && strlen($externalKey) < 1) || (is_array($externalKey) && count($externalKey) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($externalKey) && !is_string($externalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externalKey)), __LINE__);
        }
        $this->externalKey = $externalKey;
        return $this;
    }
    /**
     * Get docDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->docDate;
    }
    /**
     * Set docDate value
     * @param string $docDate
     * @return \AisFssp\StructType\RequestByDatum
     */
    public function setDocDate($docDate = null)
    {
        // validation for constraint: maxExclusive
        if ($docDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $docDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($docDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $docDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docDate) && !is_string($docDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docDate)), __LINE__);
        }
        $this->docDate = $docDate;
        return $this;
    }
    /**
     * Get docNumber value
     * @return string|null
     */
    public function getDocNumber()
    {
        return $this->docNumber;
    }
    /**
     * Set docNumber value
     * @param string $docNumber
     * @return \AisFssp\StructType\RequestByDatum
     */
    public function setDocNumber($docNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($docNumber) && strlen($docNumber) > 25) || (is_array($docNumber) && count($docNumber) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($docNumber) ? strlen($docNumber) : count($docNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($docNumber) && strlen($docNumber) < 1) || (is_array($docNumber) && count($docNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docNumber) && !is_string($docNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docNumber)), __LINE__);
        }
        $this->docNumber = $docNumber;
        return $this;
    }
    /**
     * Get authorName value
     * @return \AisFssp\StructType\FioType|null
     */
    public function getAuthorName()
    {
        return $this->authorName;
    }
    /**
     * Set authorName value
     * @param \AisFssp\StructType\FioType $authorName
     * @return \AisFssp\StructType\RequestByDatum
     */
    public function setAuthorName(\AisFssp\StructType\FioType $authorName = null)
    {
        $this->authorName = $authorName;
        return $this;
    }
    /**
     * Get authorPost value
     * @return string|null
     */
    public function getAuthorPost()
    {
        return $this->authorPost;
    }
    /**
     * Set authorPost value
     * @param string $authorPost
     * @return \AisFssp\StructType\RequestByDatum
     */
    public function setAuthorPost($authorPost = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($authorPost) && strlen($authorPost) > 50) || (is_array($authorPost) && count($authorPost) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($authorPost) ? strlen($authorPost) : count($authorPost)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($authorPost) && strlen($authorPost) < 1) || (is_array($authorPost) && count($authorPost) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($authorPost) && !is_string($authorPost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authorPost)), __LINE__);
        }
        $this->authorPost = $authorPost;
        return $this;
    }
    /**
     * Get data value
     * @return \AisFssp\StructType\Data[]|null
     */
    public function getData()
    {
        return $this->data;
    }
    /**
     * Set data value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\Data[] $data
     * @return \AisFssp\StructType\RequestByDatum
     */
    public function setData(array $data = array())
    {
        foreach ($data as $requestByDatumDataItem) {
            // validation for constraint: itemType
            if (!$requestByDatumDataItem instanceof \AisFssp\StructType\Data) {
                throw new \InvalidArgumentException(sprintf('The data property can only contain items of \AisFssp\StructType\Data, "%s" given', is_object($requestByDatumDataItem) ? get_class($requestByDatumDataItem) : gettype($requestByDatumDataItem)), __LINE__);
            }
        }
        $this->data = $data;
        return $this;
    }
    /**
     * Add item to data value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\Data $item
     * @return \AisFssp\StructType\RequestByDatum
     */
    public function addToData(\AisFssp\StructType\Data $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\Data) {
            throw new \InvalidArgumentException(sprintf('The data property can only contain items of \AisFssp\StructType\Data, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->data[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \AisFssp\StructType\RequestByDatum
     */
    public function setId($id = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($id) && strlen($id) > 60) || (is_array($id) && count($id) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($id) ? strlen($id) : count($id)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($id) && strlen($id) < 1) || (is_array($id) && count($id) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\RequestByDatum
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
