<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReportExecutionSale StructType
 * Meta informations extracted from the WSDL
 * - documentation: Отчет о результатах реализации арестованного имущества | ЭП
 * - type: tns:ReportExecutionSale
 * @subpackage Structs
 */
class ReportExecutionSale extends AbstractStructBase
{
    /**
     * The ExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор АИС ВК | Идентификатор документа, присвоенный АИС внешнего контрагента. | Идентификатор объекта, присвоенный
     * объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный идентификатор должен быть уникальным для типа идентифицируемого документа
     * в пространстве обмена данными с конкретным внешним контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $ExternalKey;
    /**
     * The DocNum
     * Meta informations extracted from the WSDL
     * - documentation: Номер отчета | Номер отчета о результатах реализации арестованного имущества. | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $DocNum;
    /**
     * The DocDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата отчета | Дата отчета о результатах реализации арестованного имущества. | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DocDate;
    /**
     * The ProcDocId
     * Meta informations extracted from the WSDL
     * - documentation: Ключ постановления | Ключ постановления судебного пристава-исполнителя о передачи арестованного имущества должника на
     * реализацию. | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $ProcDocId;
    /**
     * The ReportExecutionSaleBase
     * Meta informations extracted from the WSDL
     * - documentation: Отчет | Оригинал отчета о результатах реализации арестованного имущества в электронном виде согласно формату Приложения № X
     * «Формат постановления должностного лица ФССП России, выданного в виде электронного документа, юридическая значимость которого
     * подтверждена электронной подписью в порядке, установленном законодательством Российской Федерации» в кодировке Base64.
     * - minOccurs: 0
     * @var string
     */
    public $ReportExecutionSaleBase;
    /**
     * The SignatureReportExecutionSaleBase
     * Meta informations extracted from the WSDL
     * - documentation: ЭП уведомления | ЭП отчета о результатах реализации арестованного имущества в электронном виде, элемента «CertificateDeliveryAcceptanceBase»
     * в формате pkcs#7, в кодировке Base64.
     * - minOccurs: 0
     * @var string
     */
    public $SignatureReportExecutionSaleBase;
    /**
     * The attachments
     * Meta informations extracted from the WSDL
     * - documentation: Приложенные файлы | Дополнительные данные в произвольных форматах.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\AttachmentType[]
     */
    public $attachments;
    /**
     * The SignDateTime
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время формирования подписи | Дата и время | Дата и время
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $SignDateTime;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \AisFssp\StructType\SignatureType[]
     */
    public $Signature;
    /**
     * Constructor method for ReportExecutionSale
     * @uses ReportExecutionSale::setExternalKey()
     * @uses ReportExecutionSale::setDocNum()
     * @uses ReportExecutionSale::setDocDate()
     * @uses ReportExecutionSale::setProcDocId()
     * @uses ReportExecutionSale::setReportExecutionSaleBase()
     * @uses ReportExecutionSale::setSignatureReportExecutionSaleBase()
     * @uses ReportExecutionSale::setAttachments()
     * @uses ReportExecutionSale::setSignDateTime()
     * @uses ReportExecutionSale::setSignature()
     * @param string $externalKey
     * @param string $docNum
     * @param string $docDate
     * @param int $procDocId
     * @param string $reportExecutionSaleBase
     * @param string $signatureReportExecutionSaleBase
     * @param \AisFssp\StructType\AttachmentType[] $attachments
     * @param string $signDateTime
     * @param \AisFssp\StructType\SignatureType[] $signature
     */
    public function __construct($externalKey = null, $docNum = null, $docDate = null, $procDocId = null, $reportExecutionSaleBase = null, $signatureReportExecutionSaleBase = null, array $attachments = array(), $signDateTime = null, array $signature = array())
    {
        $this
            ->setExternalKey($externalKey)
            ->setDocNum($docNum)
            ->setDocDate($docDate)
            ->setProcDocId($procDocId)
            ->setReportExecutionSaleBase($reportExecutionSaleBase)
            ->setSignatureReportExecutionSaleBase($signatureReportExecutionSaleBase)
            ->setAttachments($attachments)
            ->setSignDateTime($signDateTime)
            ->setSignature($signature);
    }
    /**
     * Get ExternalKey value
     * @return string|null
     */
    public function getExternalKey()
    {
        return $this->ExternalKey;
    }
    /**
     * Set ExternalKey value
     * @param string $externalKey
     * @return \AisFssp\StructType\ReportExecutionSale
     */
    public function setExternalKey($externalKey = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($externalKey) && strlen($externalKey) > 60) || (is_array($externalKey) && count($externalKey) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($externalKey) ? strlen($externalKey) : count($externalKey)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($externalKey) && strlen($externalKey) < 1) || (is_array($externalKey) && count($externalKey) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($externalKey) && !is_string($externalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externalKey)), __LINE__);
        }
        $this->ExternalKey = $externalKey;
        return $this;
    }
    /**
     * Get DocNum value
     * @return string|null
     */
    public function getDocNum()
    {
        return $this->DocNum;
    }
    /**
     * Set DocNum value
     * @param string $docNum
     * @return \AisFssp\StructType\ReportExecutionSale
     */
    public function setDocNum($docNum = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($docNum) && strlen($docNum) > 25) || (is_array($docNum) && count($docNum) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($docNum) ? strlen($docNum) : count($docNum)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($docNum) && strlen($docNum) < 1) || (is_array($docNum) && count($docNum) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docNum) && !is_string($docNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docNum)), __LINE__);
        }
        $this->DocNum = $docNum;
        return $this;
    }
    /**
     * Get DocDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->DocDate;
    }
    /**
     * Set DocDate value
     * @param string $docDate
     * @return \AisFssp\StructType\ReportExecutionSale
     */
    public function setDocDate($docDate = null)
    {
        // validation for constraint: maxExclusive
        if ($docDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $docDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($docDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $docDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docDate) && !is_string($docDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docDate)), __LINE__);
        }
        $this->DocDate = $docDate;
        return $this;
    }
    /**
     * Get ProcDocId value
     * @return int|null
     */
    public function getProcDocId()
    {
        return $this->ProcDocId;
    }
    /**
     * Set ProcDocId value
     * @param int $procDocId
     * @return \AisFssp\StructType\ReportExecutionSale
     */
    public function setProcDocId($procDocId = null)
    {
        // validation for constraint: maxInclusive
        if ($procDocId > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $procDocId), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($procDocId < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $procDocId), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($procDocId) && !is_numeric($procDocId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($procDocId)), __LINE__);
        }
        $this->ProcDocId = $procDocId;
        return $this;
    }
    /**
     * Get ReportExecutionSaleBase value
     * @return string|null
     */
    public function getReportExecutionSaleBase()
    {
        return $this->ReportExecutionSaleBase;
    }
    /**
     * Set ReportExecutionSaleBase value
     * @param string $reportExecutionSaleBase
     * @return \AisFssp\StructType\ReportExecutionSale
     */
    public function setReportExecutionSaleBase($reportExecutionSaleBase = null)
    {
        // validation for constraint: string
        if (!is_null($reportExecutionSaleBase) && !is_string($reportExecutionSaleBase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reportExecutionSaleBase)), __LINE__);
        }
        $this->ReportExecutionSaleBase = $reportExecutionSaleBase;
        return $this;
    }
    /**
     * Get SignatureReportExecutionSaleBase value
     * @return string|null
     */
    public function getSignatureReportExecutionSaleBase()
    {
        return $this->SignatureReportExecutionSaleBase;
    }
    /**
     * Set SignatureReportExecutionSaleBase value
     * @param string $signatureReportExecutionSaleBase
     * @return \AisFssp\StructType\ReportExecutionSale
     */
    public function setSignatureReportExecutionSaleBase($signatureReportExecutionSaleBase = null)
    {
        // validation for constraint: string
        if (!is_null($signatureReportExecutionSaleBase) && !is_string($signatureReportExecutionSaleBase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($signatureReportExecutionSaleBase)), __LINE__);
        }
        $this->SignatureReportExecutionSaleBase = $signatureReportExecutionSaleBase;
        return $this;
    }
    /**
     * Get attachments value
     * @return \AisFssp\StructType\AttachmentType[]|null
     */
    public function getAttachments()
    {
        return $this->attachments;
    }
    /**
     * Set attachments value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\AttachmentType[] $attachments
     * @return \AisFssp\StructType\ReportExecutionSale
     */
    public function setAttachments(array $attachments = array())
    {
        foreach ($attachments as $reportExecutionSaleAttachmentsItem) {
            // validation for constraint: itemType
            if (!$reportExecutionSaleAttachmentsItem instanceof \AisFssp\StructType\AttachmentType) {
                throw new \InvalidArgumentException(sprintf('The attachments property can only contain items of \AisFssp\StructType\AttachmentType, "%s" given', is_object($reportExecutionSaleAttachmentsItem) ? get_class($reportExecutionSaleAttachmentsItem) : gettype($reportExecutionSaleAttachmentsItem)), __LINE__);
            }
        }
        $this->attachments = $attachments;
        return $this;
    }
    /**
     * Add item to attachments value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\AttachmentType $item
     * @return \AisFssp\StructType\ReportExecutionSale
     */
    public function addToAttachments(\AisFssp\StructType\AttachmentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\AttachmentType) {
            throw new \InvalidArgumentException(sprintf('The attachments property can only contain items of \AisFssp\StructType\AttachmentType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->attachments[] = $item;
        return $this;
    }
    /**
     * Get SignDateTime value
     * @return string|null
     */
    public function getSignDateTime()
    {
        return $this->SignDateTime;
    }
    /**
     * Set SignDateTime value
     * @param string $signDateTime
     * @return \AisFssp\StructType\ReportExecutionSale
     */
    public function setSignDateTime($signDateTime = null)
    {
        // validation for constraint: maxExclusive
        if ($signDateTime >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $signDateTime), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($signDateTime < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $signDateTime), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($signDateTime) && !is_string($signDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($signDateTime)), __LINE__);
        }
        $this->SignDateTime = $signDateTime;
        return $this;
    }
    /**
     * Get Signature value
     * @return \AisFssp\StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType[] $signature
     * @return \AisFssp\StructType\ReportExecutionSale
     */
    public function setSignature(array $signature = array())
    {
        foreach ($signature as $reportExecutionSaleSignatureItem) {
            // validation for constraint: itemType
            if (!$reportExecutionSaleSignatureItem instanceof \AisFssp\StructType\SignatureType) {
                throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($reportExecutionSaleSignatureItem) ? get_class($reportExecutionSaleSignatureItem) : gettype($reportExecutionSaleSignatureItem)), __LINE__);
            }
        }
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType $item
     * @return \AisFssp\StructType\ReportExecutionSale
     */
    public function addToSignature(\AisFssp\StructType\SignatureType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\SignatureType) {
            throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\ReportExecutionSale
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
