<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PublicEnityType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения о субъекте публичного права
 * @subpackage Structs
 */
class PublicEnityType extends OrganizationDatumType
{
    /**
     * The entityType
     * Meta informations extracted from the WSDL
     * - documentation: Класс контрагента | Класс контрагента
     * @var int
     */
    public $entityType;
    /**
     * The OKATO
     * Meta informations extracted from the WSDL
     * - documentation: Код ОКАТО | Код объекта административно- территориального деления
     * - minOccurs: 0
     * - length: 11
     * - pattern: [0-9]{11}
     * @var string
     */
    public $OKATO;
    /**
     * The regNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер регистрационной записи | Строка длиной от 1 до 45 символов
     * - minOccurs: 0
     * - maxLength: 45
     * - minLength: 1
     * @var string
     */
    public $regNumber;
    /**
     * The regDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата государственной регистрации | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $regDate;
    /**
     * The regDateregCountry
     * Meta informations extracted from the WSDL
     * - documentation: Полное наименование страны регистрации | Строка длиной от 1 до 255 символов
     * - minOccurs: 0
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $regDateregCountry;
    /**
     * Constructor method for PublicEnityType
     * @uses PublicEnityType::setEntityType()
     * @uses PublicEnityType::setOKATO()
     * @uses PublicEnityType::setRegNumber()
     * @uses PublicEnityType::setRegDate()
     * @uses PublicEnityType::setRegDateregCountry()
     * @param int $entityType
     * @param string $oKATO
     * @param string $regNumber
     * @param string $regDate
     * @param string $regDateregCountry
     */
    public function __construct($entityType = null, $oKATO = null, $regNumber = null, $regDate = null, $regDateregCountry = null)
    {
        $this
            ->setEntityType($entityType)
            ->setOKATO($oKATO)
            ->setRegNumber($regNumber)
            ->setRegDate($regDate)
            ->setRegDateregCountry($regDateregCountry);
    }
    /**
     * Get entityType value
     * @return int|null
     */
    public function getEntityType()
    {
        return $this->entityType;
    }
    /**
     * Set entityType value
     * @param int $entityType
     * @return \AisFssp\StructType\PublicEnityType
     */
    public function setEntityType($entityType = null)
    {
        // validation for constraint: int
        if (!is_null($entityType) && !is_numeric($entityType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($entityType)), __LINE__);
        }
        $this->entityType = $entityType;
        return $this;
    }
    /**
     * Get OKATO value
     * @return string|null
     */
    public function getOKATO()
    {
        return $this->OKATO;
    }
    /**
     * Set OKATO value
     * @param string $oKATO
     * @return \AisFssp\StructType\PublicEnityType
     */
    public function setOKATO($oKATO = null)
    {
        // validation for constraint: length
        if ((is_scalar($oKATO) && strlen($oKATO) !== 11) || (is_array($oKATO) && count($oKATO) !== 11)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 11 element(s) or a scalar of 11 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($oKATO) && !preg_match('/[0-9]{11}/', $oKATO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{11}", "%s" given', var_export($oKATO, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($oKATO) && !is_string($oKATO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oKATO)), __LINE__);
        }
        $this->OKATO = $oKATO;
        return $this;
    }
    /**
     * Get regNumber value
     * @return string|null
     */
    public function getRegNumber()
    {
        return $this->regNumber;
    }
    /**
     * Set regNumber value
     * @param string $regNumber
     * @return \AisFssp\StructType\PublicEnityType
     */
    public function setRegNumber($regNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($regNumber) && strlen($regNumber) > 45) || (is_array($regNumber) && count($regNumber) > 45)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 45 element(s) or a scalar of 45 character(s) at most, "%d" length given', is_scalar($regNumber) ? strlen($regNumber) : count($regNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($regNumber) && strlen($regNumber) < 1) || (is_array($regNumber) && count($regNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($regNumber) && !is_string($regNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($regNumber)), __LINE__);
        }
        $this->regNumber = $regNumber;
        return $this;
    }
    /**
     * Get regDate value
     * @return string|null
     */
    public function getRegDate()
    {
        return $this->regDate;
    }
    /**
     * Set regDate value
     * @param string $regDate
     * @return \AisFssp\StructType\PublicEnityType
     */
    public function setRegDate($regDate = null)
    {
        // validation for constraint: maxExclusive
        if ($regDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $regDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($regDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $regDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($regDate) && !is_string($regDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($regDate)), __LINE__);
        }
        $this->regDate = $regDate;
        return $this;
    }
    /**
     * Get regDateregCountry value
     * @return string|null
     */
    public function getRegDateregCountry()
    {
        return $this->regDateregCountry;
    }
    /**
     * Set regDateregCountry value
     * @param string $regDateregCountry
     * @return \AisFssp\StructType\PublicEnityType
     */
    public function setRegDateregCountry($regDateregCountry = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($regDateregCountry) && strlen($regDateregCountry) > 255) || (is_array($regDateregCountry) && count($regDateregCountry) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($regDateregCountry) ? strlen($regDateregCountry) : count($regDateregCountry)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($regDateregCountry) && strlen($regDateregCountry) < 1) || (is_array($regDateregCountry) && count($regDateregCountry) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($regDateregCountry) && !is_string($regDateregCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($regDateregCountry)), __LINE__);
        }
        $this->regDateregCountry = $regDateregCountry;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\PublicEnityType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
