<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PropertyObligationDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения об имущественных обязательствах
 * @subpackage Structs
 */
class PropertyObligationDatumType extends InformationType
{
    /**
     * The ContractNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер договора | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $ContractNumber;
    /**
     * The ContractDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата договора | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $ContractDate;
    /**
     * The ContractEndDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата окончания договора | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $ContractEndDate;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - documentation: Сумма договора | Сумма
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $Amount;
    /**
     * The PropertyKind
     * Meta informations extracted from the WSDL
     * - documentation: Имущество
     * - minOccurs: 0
     * @var string
     */
    public $PropertyKind;
    /**
     * The PropertyType
     * Meta informations extracted from the WSDL
     * - documentation: Тип имущества
     * - minOccurs: 0
     * @var string
     */
    public $PropertyType;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - documentation: Общее описание | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $Description;
    /**
     * Constructor method for PropertyObligationDatumType
     * @uses PropertyObligationDatumType::setContractNumber()
     * @uses PropertyObligationDatumType::setContractDate()
     * @uses PropertyObligationDatumType::setContractEndDate()
     * @uses PropertyObligationDatumType::setAmount()
     * @uses PropertyObligationDatumType::setPropertyKind()
     * @uses PropertyObligationDatumType::setPropertyType()
     * @uses PropertyObligationDatumType::setDescription()
     * @param string $contractNumber
     * @param string $contractDate
     * @param string $contractEndDate
     * @param float $amount
     * @param string $propertyKind
     * @param string $propertyType
     * @param string $description
     */
    public function __construct($contractNumber = null, $contractDate = null, $contractEndDate = null, $amount = null, $propertyKind = null, $propertyType = null, $description = null)
    {
        $this
            ->setContractNumber($contractNumber)
            ->setContractDate($contractDate)
            ->setContractEndDate($contractEndDate)
            ->setAmount($amount)
            ->setPropertyKind($propertyKind)
            ->setPropertyType($propertyType)
            ->setDescription($description);
    }
    /**
     * Get ContractNumber value
     * @return string|null
     */
    public function getContractNumber()
    {
        return $this->ContractNumber;
    }
    /**
     * Set ContractNumber value
     * @param string $contractNumber
     * @return \AisFssp\StructType\PropertyObligationDatumType
     */
    public function setContractNumber($contractNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($contractNumber) && strlen($contractNumber) > 25) || (is_array($contractNumber) && count($contractNumber) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($contractNumber) ? strlen($contractNumber) : count($contractNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($contractNumber) && strlen($contractNumber) < 1) || (is_array($contractNumber) && count($contractNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($contractNumber) && !is_string($contractNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contractNumber)), __LINE__);
        }
        $this->ContractNumber = $contractNumber;
        return $this;
    }
    /**
     * Get ContractDate value
     * @return string|null
     */
    public function getContractDate()
    {
        return $this->ContractDate;
    }
    /**
     * Set ContractDate value
     * @param string $contractDate
     * @return \AisFssp\StructType\PropertyObligationDatumType
     */
    public function setContractDate($contractDate = null)
    {
        // validation for constraint: maxExclusive
        if ($contractDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $contractDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($contractDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $contractDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($contractDate) && !is_string($contractDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contractDate)), __LINE__);
        }
        $this->ContractDate = $contractDate;
        return $this;
    }
    /**
     * Get ContractEndDate value
     * @return string|null
     */
    public function getContractEndDate()
    {
        return $this->ContractEndDate;
    }
    /**
     * Set ContractEndDate value
     * @param string $contractEndDate
     * @return \AisFssp\StructType\PropertyObligationDatumType
     */
    public function setContractEndDate($contractEndDate = null)
    {
        // validation for constraint: maxExclusive
        if ($contractEndDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $contractEndDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($contractEndDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $contractEndDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($contractEndDate) && !is_string($contractEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contractEndDate)), __LINE__);
        }
        $this->ContractEndDate = $contractEndDate;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \AisFssp\StructType\PropertyObligationDatumType
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($amount) && strlen(substr($amount, strpos($amount, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($amount, strpos($amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($amount) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $amount)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($amount, strpos($amount, '.')))), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get PropertyKind value
     * @return string|null
     */
    public function getPropertyKind()
    {
        return $this->PropertyKind;
    }
    /**
     * Set PropertyKind value
     * @uses \AisFssp\EnumType\ObligationPropertyKindType::valueIsValid()
     * @uses \AisFssp\EnumType\ObligationPropertyKindType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $propertyKind
     * @return \AisFssp\StructType\PropertyObligationDatumType
     */
    public function setPropertyKind($propertyKind = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\ObligationPropertyKindType::valueIsValid($propertyKind)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $propertyKind, implode(', ', \AisFssp\EnumType\ObligationPropertyKindType::getValidValues())), __LINE__);
        }
        $this->PropertyKind = $propertyKind;
        return $this;
    }
    /**
     * Get PropertyType value
     * @return string|null
     */
    public function getPropertyType()
    {
        return $this->PropertyType;
    }
    /**
     * Set PropertyType value
     * @uses \AisFssp\EnumType\ObligationPropertyType::valueIsValid()
     * @uses \AisFssp\EnumType\ObligationPropertyType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $propertyType
     * @return \AisFssp\StructType\PropertyObligationDatumType
     */
    public function setPropertyType($propertyType = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\ObligationPropertyType::valueIsValid($propertyType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $propertyType, implode(', ', \AisFssp\EnumType\ObligationPropertyType::getValidValues())), __LINE__);
        }
        $this->PropertyType = $propertyType;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \AisFssp\StructType\PropertyObligationDatumType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 300) || (is_array($description) && count($description) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($description) && strlen($description) < 1) || (is_array($description) && count($description) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\PropertyObligationDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
