<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PenaltyChargesData StructType
 * Meta informations extracted from the WSDL
 * - documentation: Данные по штрафам
 * - type: tns:PenaltyChargesData
 * @subpackage Structs
 */
class PenaltyChargesData extends AbstractStructBase
{
    /**
     * The PenaltyKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор записи | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении
     * объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $PenaltyKey;
    /**
     * The OspCode
     * Meta informations extracted from the WSDL
     * - documentation: Код отдела | Ведомственный классификатор отделов судебных приставов | NSI_Departments
     * - length: 5
     * - pattern: [0-9]{5}
     * @var string
     */
    public $OspCode;
    /**
     * The UnloadDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время выгрузки | Дата и время | Дата и время
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $UnloadDate;
    /**
     * The PerpetratorType
     * Meta informations extracted from the WSDL
     * - documentation: Тип нарушителя
     * @var string
     */
    public $PerpetratorType;
    /**
     * The PerpetratorName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование нарушителя | Строка длиной от 1 до 1000 символов
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $PerpetratorName;
    /**
     * The PerpetratorBirthDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата рождения нарушителя | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $PerpetratorBirthDate;
    /**
     * The PerpetratorBirthplace
     * Meta informations extracted from the WSDL
     * - documentation: Место рождения нарушителя | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $PerpetratorBirthplace;
    /**
     * The PerpetratorSerDoc
     * Meta informations extracted from the WSDL
     * - documentation: Серия документа | Строка длиной от 1 до 25 символов
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $PerpetratorSerDoc;
    /**
     * The PerpetratorNumDoc
     * Meta informations extracted from the WSDL
     * - documentation: Номер документа | Строка длиной от 1 до 25 символов
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $PerpetratorNumDoc;
    /**
     * The PerpetratorSNILS
     * Meta informations extracted from the WSDL
     * - documentation: СНИЛС нарушителя | СНИЛС
     * - minOccurs: 0
     * - length: 11
     * - pattern: [0-9]{11}
     * @var string
     */
    public $PerpetratorSNILS;
    /**
     * The PerpetratorINN
     * Meta informations extracted from the WSDL
     * - documentation: ИНН нарушителя | ИНН
     * - minOccurs: 0
     * - maxLength: 12
     * - minLength: 10
     * - pattern: (([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{8})|(([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{10})
     * @var string
     */
    public $PerpetratorINN;
    /**
     * The PerpetratorKPP
     * Meta informations extracted from the WSDL
     * - documentation: КПП нарушителя | КПП
     * - minOccurs: 0
     * - length: 9
     * - pattern: ([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{7}
     * @var string
     */
    public $PerpetratorKPP;
    /**
     * The PerpetratorOGRN
     * Meta informations extracted from the WSDL
     * - documentation: ОГРН/ОГРНИП нарушителя | Основной государственный регистрационный номер (ОГРН)/Основной государственный регистрационный
     * номер индивидуального предпринимателя (ОГРНИП)
     * - minOccurs: 0
     * - maxLength: 15
     * - minLength: 13
     * - pattern: ([0-9]{13})|([0-9]{15})
     * @var string
     */
    public $PerpetratorOGRN;
    /**
     * The PerpetratorAdr
     * Meta informations extracted from the WSDL
     * - documentation: Адрес нарушителя | Строка длиной от 1 до 300 символов
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $PerpetratorAdr;
    /**
     * The PerpetratorWorkplace
     * Meta informations extracted from the WSDL
     * - documentation: Организация | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $PerpetratorWorkplace;
    /**
     * The PerpetratorWorkplaceINN
     * Meta informations extracted from the WSDL
     * - documentation: ИНН организации | ИНН
     * - minOccurs: 0
     * - maxLength: 12
     * - minLength: 10
     * - pattern: (([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{8})|(([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{10})
     * @var string
     */
    public $PerpetratorWorkplaceINN;
    /**
     * The PerpetratorWorkplaceTelephone
     * Meta informations extracted from the WSDL
     * - documentation: Телефон организации | Номер телефона
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $PerpetratorWorkplaceTelephone;
    /**
     * The PerpetratorWorkplaceAddress
     * Meta informations extracted from the WSDL
     * - documentation: Адрес организации | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $PerpetratorWorkplaceAddress;
    /**
     * The PenaltyNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер АД | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $PenaltyNumber;
    /**
     * The PenaltyDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата АД | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $PenaltyDate;
    /**
     * The PenaltyRiseDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата рассмотрения АД | Дата рассмотрения административного дела. Для документа «Реестр штрафов по АД» версии «PLTY_1_0» поле
     * обязательное. | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $PenaltyRiseDate;
    /**
     * The IPBasic
     * Meta informations extracted from the WSDL
     * - documentation: Номер ИП базового | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $IPBasic;
    /**
     * The PenaltyBasic
     * Meta informations extracted from the WSDL
     * - documentation: Номер базового АД | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $PenaltyBasic;
    /**
     * The PenaltyIP
     * Meta informations extracted from the WSDL
     * - documentation: ИП по штрафу | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $PenaltyIP;
    /**
     * The PenaltySum
     * Meta informations extracted from the WSDL
     * - documentation: Сумма штрафа | Сумма штрафа по административному делу. Для документа «Реестр штрафов по АД» версии «PLTY_1_0» поле обязательное. |
     * Сумма
     * - minOccurs: 0
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $PenaltySum;
    /**
     * The PenaltyRestTotal
     * Meta informations extracted from the WSDL
     * - documentation: Остаток штрафа | Остаток суммы штрафа по административному делу. Для документа «Реестр штрафов по АД» версии «PLTY_1_0» поле
     * обязательное. | Сумма
     * - minOccurs: 0
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $PenaltyRestTotal;
    /**
     * The PenaltyKbk
     * Meta informations extracted from the WSDL
     * - documentation: КБК | Указывается КБК для перечисления денежных средств. Для документа «Реестр штрафов по АД» версии «PLTY_1_0» поле обязательное.
     * | Код бюджетной классификации (КБК)
     * - minOccurs: 0
     * - length: 20
     * - pattern: [0-9]{20}
     * @var string
     */
    public $PenaltyKbk;
    /**
     * The PenaltyAuthorName
     * Meta informations extracted from the WSDL
     * - documentation: ФИО должностного лица | ФИО должностного лица, составившего протокол об административном правонарушении. | Полное имя
     * физического лица (фамилия, имя, отчество)
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $PenaltyAuthorName;
    /**
     * The PenaltyAuthorTel
     * Meta informations extracted from the WSDL
     * - documentation: Телефон должностного лица | Номер телефона
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $PenaltyAuthorTel;
    /**
     * The IsConfidential
     * Meta informations extracted from the WSDL
     * - documentation: Признак закрытых сведений | Обертка стандартного xs:boolean | Логический
     * @var bool
     */
    public $IsConfidential;
    /**
     * The PenaltyAdmRisepristName
     * Meta informations extracted from the WSDL
     * - documentation: Должностное лицо, вынесшее постановление | Полное имя физического лица (фамилия, имя, отчество)
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $PenaltyAdmRisepristName;
    /**
     * The PenaltyIdArtkoap
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор статьи КоАП | Идентификатор статьи КоАП. Для документа «Реестр штрафов по АД» версии «PLTY_1_1» поле обязательное. |
     * Положительное целое
     * - minOccurs: 0
     * - minInclusive: 1
     * @var int
     */
    public $PenaltyIdArtkoap;
    /**
     * The PenaltyUinCode
     * Meta informations extracted from the WSDL
     * - documentation: УИН | Код начисления УНИФО
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 20
     * - pattern: (([0-9a-zA-Zа-яА-Я]{19})|([0-9]{8}[0-9a-zA-Zа-яА-Я]{16}))[0-9]
     * @var string
     */
    public $PenaltyUinCode;
    /**
     * The PenaltyUip
     * Meta informations extracted from the WSDL
     * - documentation: УИП | УИП
     * - minOccurs: 0
     * - length: 25
     * @var string
     */
    public $PenaltyUip;
    /**
     * The PenaltyEssentialElements
     * Meta informations extracted from the WSDL
     * - documentation: Сущность правонарушения | Сущность правонарушения. Для документа «Реестр штрафов по АД» версии «PLTY_1_1» поле обязательное. |
     * Массив произвольных данных (текстовый)
     * - minOccurs: 0
     * @var string
     */
    public $PenaltyEssentialElements;
    /**
     * The PenaltyExaminationSendDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата направления административного дела на рассмотрение | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $PenaltyExaminationSendDate;
    /**
     * The PenaltyCourtName2
     * Meta informations extracted from the WSDL
     * - documentation: Место рассмотрения | Строка длиной от 0 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * @var string
     */
    public $PenaltyCourtName2;
    /**
     * The PenaltyExaminationResultCode
     * Meta informations extracted from the WSDL
     * - documentation: Результат рассмотрения (код) | Строка длиной от 1 до 10 символов
     * - minOccurs: 0
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $PenaltyExaminationResultCode;
    /**
     * The PenaltyCourtAdmCancelDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата отмены судом | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $PenaltyCourtAdmCancelDate;
    /**
     * The PenaltyPayDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата полной оплаты штрафа | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $PenaltyPayDate;
    /**
     * The PenaltyNoPayIntime
     * Meta informations extracted from the WSDL
     * - documentation: Не уплачено в срок | Признак оплаты административного штрафа в срок. Для документа «Реестр штрафов по АД» версии «PLTY_1_1» поле
     * обязательное. | Обертка стандартного xs:boolean | Логический
     * - minOccurs: 0
     * @var bool
     */
    public $PenaltyNoPayIntime;
    /**
     * The PenaltyDate2025
     * Meta informations extracted from the WSDL
     * - documentation: Дата составления протокола по 20.25 | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $PenaltyDate2025;
    /**
     * The PenaltyIdDocdate
     * Meta informations extracted from the WSDL
     * - documentation: Дата выдачи ИД по штрафу | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $PenaltyIdDocdate;
    /**
     * The PenaltyIpRisedate
     * Meta informations extracted from the WSDL
     * - documentation: Дата возбуждения ИП по штрафу | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $PenaltyIpRisedate;
    /**
     * The PenaltyGisGmp
     * Meta informations extracted from the WSDL
     * - documentation: Оплата штрафа через ГИС ГМП | Признак оплаты штрафа через ГИС ГМП. Для документа «Реестр штрафов по АД» версии «PLTY_1_1» поле
     * обязательное. | Обертка стандартного xs:boolean | Логический
     * - minOccurs: 0
     * @var bool
     */
    public $PenaltyGisGmp;
    /**
     * The PenaltyPostId
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор должности | Положительное короткое целое
     * - minOccurs: 0
     * - minInclusive: 1
     * @var int
     */
    public $PenaltyPostId;
    /**
     * The OffenderCitizenshipCode
     * Meta informations extracted from the WSDL
     * - documentation: Гражданство | Гражданство (код страны) нарушителя. | Код страны буквенный | Трехзначный (альфа-3) буквенный код страны мира по
     * классификатору ОКСМ
     * - minOccurs: 0
     * - length: 3
     * @var string
     */
    public $OffenderCitizenshipCode;
    /**
     * The PenaltyHoursDaysQty
     * Meta informations extracted from the WSDL
     * - documentation: Количество суток (адм.арест)/часов (об.работы) | Положительное целое
     * - minOccurs: 0
     * - minInclusive: 1
     * @var int
     */
    public $PenaltyHoursDaysQty;
    /**
     * The AdmMakeDecisionPostId
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор должности должностного лица, вынесшего постановление. | Положительное короткое целое
     * - minOccurs: 0
     * - minInclusive: 1
     * @var int
     */
    public $AdmMakeDecisionPostId;
    /**
     * Constructor method for PenaltyChargesData
     * @uses PenaltyChargesData::setPenaltyKey()
     * @uses PenaltyChargesData::setOspCode()
     * @uses PenaltyChargesData::setUnloadDate()
     * @uses PenaltyChargesData::setPerpetratorType()
     * @uses PenaltyChargesData::setPerpetratorName()
     * @uses PenaltyChargesData::setPerpetratorBirthDate()
     * @uses PenaltyChargesData::setPerpetratorBirthplace()
     * @uses PenaltyChargesData::setPerpetratorSerDoc()
     * @uses PenaltyChargesData::setPerpetratorNumDoc()
     * @uses PenaltyChargesData::setPerpetratorSNILS()
     * @uses PenaltyChargesData::setPerpetratorINN()
     * @uses PenaltyChargesData::setPerpetratorKPP()
     * @uses PenaltyChargesData::setPerpetratorOGRN()
     * @uses PenaltyChargesData::setPerpetratorAdr()
     * @uses PenaltyChargesData::setPerpetratorWorkplace()
     * @uses PenaltyChargesData::setPerpetratorWorkplaceINN()
     * @uses PenaltyChargesData::setPerpetratorWorkplaceTelephone()
     * @uses PenaltyChargesData::setPerpetratorWorkplaceAddress()
     * @uses PenaltyChargesData::setPenaltyNumber()
     * @uses PenaltyChargesData::setPenaltyDate()
     * @uses PenaltyChargesData::setPenaltyRiseDate()
     * @uses PenaltyChargesData::setIPBasic()
     * @uses PenaltyChargesData::setPenaltyBasic()
     * @uses PenaltyChargesData::setPenaltyIP()
     * @uses PenaltyChargesData::setPenaltySum()
     * @uses PenaltyChargesData::setPenaltyRestTotal()
     * @uses PenaltyChargesData::setPenaltyKbk()
     * @uses PenaltyChargesData::setPenaltyAuthorName()
     * @uses PenaltyChargesData::setPenaltyAuthorTel()
     * @uses PenaltyChargesData::setIsConfidential()
     * @uses PenaltyChargesData::setPenaltyAdmRisepristName()
     * @uses PenaltyChargesData::setPenaltyIdArtkoap()
     * @uses PenaltyChargesData::setPenaltyUinCode()
     * @uses PenaltyChargesData::setPenaltyUip()
     * @uses PenaltyChargesData::setPenaltyEssentialElements()
     * @uses PenaltyChargesData::setPenaltyExaminationSendDate()
     * @uses PenaltyChargesData::setPenaltyCourtName2()
     * @uses PenaltyChargesData::setPenaltyExaminationResultCode()
     * @uses PenaltyChargesData::setPenaltyCourtAdmCancelDate()
     * @uses PenaltyChargesData::setPenaltyPayDate()
     * @uses PenaltyChargesData::setPenaltyNoPayIntime()
     * @uses PenaltyChargesData::setPenaltyDate2025()
     * @uses PenaltyChargesData::setPenaltyIdDocdate()
     * @uses PenaltyChargesData::setPenaltyIpRisedate()
     * @uses PenaltyChargesData::setPenaltyGisGmp()
     * @uses PenaltyChargesData::setPenaltyPostId()
     * @uses PenaltyChargesData::setOffenderCitizenshipCode()
     * @uses PenaltyChargesData::setPenaltyHoursDaysQty()
     * @uses PenaltyChargesData::setAdmMakeDecisionPostId()
     * @param int $penaltyKey
     * @param string $ospCode
     * @param string $unloadDate
     * @param string $perpetratorType
     * @param string $perpetratorName
     * @param string $perpetratorBirthDate
     * @param string $perpetratorBirthplace
     * @param string $perpetratorSerDoc
     * @param string $perpetratorNumDoc
     * @param string $perpetratorSNILS
     * @param string $perpetratorINN
     * @param string $perpetratorKPP
     * @param string $perpetratorOGRN
     * @param string $perpetratorAdr
     * @param string $perpetratorWorkplace
     * @param string $perpetratorWorkplaceINN
     * @param string $perpetratorWorkplaceTelephone
     * @param string $perpetratorWorkplaceAddress
     * @param string $penaltyNumber
     * @param string $penaltyDate
     * @param string $penaltyRiseDate
     * @param string $iPBasic
     * @param string $penaltyBasic
     * @param string $penaltyIP
     * @param float $penaltySum
     * @param float $penaltyRestTotal
     * @param string $penaltyKbk
     * @param string $penaltyAuthorName
     * @param string $penaltyAuthorTel
     * @param bool $isConfidential
     * @param string $penaltyAdmRisepristName
     * @param int $penaltyIdArtkoap
     * @param string $penaltyUinCode
     * @param string $penaltyUip
     * @param string $penaltyEssentialElements
     * @param string $penaltyExaminationSendDate
     * @param string $penaltyCourtName2
     * @param string $penaltyExaminationResultCode
     * @param string $penaltyCourtAdmCancelDate
     * @param string $penaltyPayDate
     * @param bool $penaltyNoPayIntime
     * @param string $penaltyDate2025
     * @param string $penaltyIdDocdate
     * @param string $penaltyIpRisedate
     * @param bool $penaltyGisGmp
     * @param int $penaltyPostId
     * @param string $offenderCitizenshipCode
     * @param int $penaltyHoursDaysQty
     * @param int $admMakeDecisionPostId
     */
    public function __construct($penaltyKey = null, $ospCode = null, $unloadDate = null, $perpetratorType = null, $perpetratorName = null, $perpetratorBirthDate = null, $perpetratorBirthplace = null, $perpetratorSerDoc = null, $perpetratorNumDoc = null, $perpetratorSNILS = null, $perpetratorINN = null, $perpetratorKPP = null, $perpetratorOGRN = null, $perpetratorAdr = null, $perpetratorWorkplace = null, $perpetratorWorkplaceINN = null, $perpetratorWorkplaceTelephone = null, $perpetratorWorkplaceAddress = null, $penaltyNumber = null, $penaltyDate = null, $penaltyRiseDate = null, $iPBasic = null, $penaltyBasic = null, $penaltyIP = null, $penaltySum = null, $penaltyRestTotal = null, $penaltyKbk = null, $penaltyAuthorName = null, $penaltyAuthorTel = null, $isConfidential = null, $penaltyAdmRisepristName = null, $penaltyIdArtkoap = null, $penaltyUinCode = null, $penaltyUip = null, $penaltyEssentialElements = null, $penaltyExaminationSendDate = null, $penaltyCourtName2 = null, $penaltyExaminationResultCode = null, $penaltyCourtAdmCancelDate = null, $penaltyPayDate = null, $penaltyNoPayIntime = null, $penaltyDate2025 = null, $penaltyIdDocdate = null, $penaltyIpRisedate = null, $penaltyGisGmp = null, $penaltyPostId = null, $offenderCitizenshipCode = null, $penaltyHoursDaysQty = null, $admMakeDecisionPostId = null)
    {
        $this
            ->setPenaltyKey($penaltyKey)
            ->setOspCode($ospCode)
            ->setUnloadDate($unloadDate)
            ->setPerpetratorType($perpetratorType)
            ->setPerpetratorName($perpetratorName)
            ->setPerpetratorBirthDate($perpetratorBirthDate)
            ->setPerpetratorBirthplace($perpetratorBirthplace)
            ->setPerpetratorSerDoc($perpetratorSerDoc)
            ->setPerpetratorNumDoc($perpetratorNumDoc)
            ->setPerpetratorSNILS($perpetratorSNILS)
            ->setPerpetratorINN($perpetratorINN)
            ->setPerpetratorKPP($perpetratorKPP)
            ->setPerpetratorOGRN($perpetratorOGRN)
            ->setPerpetratorAdr($perpetratorAdr)
            ->setPerpetratorWorkplace($perpetratorWorkplace)
            ->setPerpetratorWorkplaceINN($perpetratorWorkplaceINN)
            ->setPerpetratorWorkplaceTelephone($perpetratorWorkplaceTelephone)
            ->setPerpetratorWorkplaceAddress($perpetratorWorkplaceAddress)
            ->setPenaltyNumber($penaltyNumber)
            ->setPenaltyDate($penaltyDate)
            ->setPenaltyRiseDate($penaltyRiseDate)
            ->setIPBasic($iPBasic)
            ->setPenaltyBasic($penaltyBasic)
            ->setPenaltyIP($penaltyIP)
            ->setPenaltySum($penaltySum)
            ->setPenaltyRestTotal($penaltyRestTotal)
            ->setPenaltyKbk($penaltyKbk)
            ->setPenaltyAuthorName($penaltyAuthorName)
            ->setPenaltyAuthorTel($penaltyAuthorTel)
            ->setIsConfidential($isConfidential)
            ->setPenaltyAdmRisepristName($penaltyAdmRisepristName)
            ->setPenaltyIdArtkoap($penaltyIdArtkoap)
            ->setPenaltyUinCode($penaltyUinCode)
            ->setPenaltyUip($penaltyUip)
            ->setPenaltyEssentialElements($penaltyEssentialElements)
            ->setPenaltyExaminationSendDate($penaltyExaminationSendDate)
            ->setPenaltyCourtName2($penaltyCourtName2)
            ->setPenaltyExaminationResultCode($penaltyExaminationResultCode)
            ->setPenaltyCourtAdmCancelDate($penaltyCourtAdmCancelDate)
            ->setPenaltyPayDate($penaltyPayDate)
            ->setPenaltyNoPayIntime($penaltyNoPayIntime)
            ->setPenaltyDate2025($penaltyDate2025)
            ->setPenaltyIdDocdate($penaltyIdDocdate)
            ->setPenaltyIpRisedate($penaltyIpRisedate)
            ->setPenaltyGisGmp($penaltyGisGmp)
            ->setPenaltyPostId($penaltyPostId)
            ->setOffenderCitizenshipCode($offenderCitizenshipCode)
            ->setPenaltyHoursDaysQty($penaltyHoursDaysQty)
            ->setAdmMakeDecisionPostId($admMakeDecisionPostId);
    }
    /**
     * Get PenaltyKey value
     * @return int|null
     */
    public function getPenaltyKey()
    {
        return $this->PenaltyKey;
    }
    /**
     * Set PenaltyKey value
     * @param int $penaltyKey
     * @return \AisFssp\StructType\PenaltyChargesData
     */
    public function setPenaltyKey($penaltyKey = null)
    {
        // validation for constraint: maxInclusive
        if ($penaltyKey > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $penaltyKey), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($penaltyKey < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $penaltyKey), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($penaltyKey) && !is_numeric($penaltyKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($penaltyKey)), __LINE__);
        }
        $this->PenaltyKey = $penaltyKey;
        return $this;
    }
    /**
     * Get OspCode value
     * @return string|null
     */
    public function getOspCode()
    {
        return $this->OspCode;
    }
    /**
     * Set OspCode value
     * @param string $ospCode
     * @return \AisFssp\StructType\PenaltyChargesData
     */
    public function setOspCode($ospCode = null)
    {
        // validation for constraint: length
        if ((is_scalar($ospCode) && strlen($ospCode) !== 5) || (is_array($ospCode) && count($ospCode) !== 5)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 5 element(s) or a scalar of 5 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($ospCode) && !preg_match('/[0-9]{5}/', $ospCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{5}", "%s" given', var_export($ospCode, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ospCode) && !is_string($ospCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ospCode)), __LINE__);
        }
        $this->OspCode = $ospCode;
        return $this;
    }
    /**
     * Get UnloadDate value
     * @return string|null
     */
    public function getUnloadDate()
    {
        return $this->UnloadDate;
    }
    /**
     * Set UnloadDate value
     * @param string $unloadDate
     * @return \AisFssp\StructType\PenaltyChargesData
     */
    public function setUnloadDate($unloadDate = null)
    {
        // validation for constraint: maxExclusive
        if ($unloadDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $unloadDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($unloadDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $unloadDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($unloadDate) && !is_string($unloadDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unloadDate)), __LINE__);
        }
        $this->UnloadDate = $unloadDate;
        return $this;
    }
    /**
     * Get PerpetratorType value
     * @return string|null
     */
    public function getPerpetratorType()
    {
        return $this->PerpetratorType;
    }
    /**
     * Set PerpetratorType value
     * @uses \AisFssp\EnumType\ContragentType::valueIsValid()
     * @uses \AisFssp\EnumType\ContragentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $perpetratorType
     * @return \AisFssp\StructType\PenaltyChargesData
     */
    public function setPerpetratorType($perpetratorType = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\ContragentType::valueIsValid($perpetratorType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $perpetratorType, implode(', ', \AisFssp\EnumType\ContragentType::getValidValues())), __LINE__);
        }
        $this->PerpetratorType = $perpetratorType;
        return $this;
    }
    /**
     * Get PerpetratorName value
     * @return string|null
     */
    public function getPerpetratorName()
    {
        return $this->PerpetratorName;
    }
    /**
     * Set PerpetratorName value
     * @param string $perpetratorName
     * @return \AisFssp\StructType\PenaltyChargesData
     */
    public function setPerpetratorName($perpetratorName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($perpetratorName) && strlen($perpetratorName) > 1000) || (is_array($perpetratorName) && count($perpetratorName) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($perpetratorName) ? strlen($perpetratorName) : count($perpetratorName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($perpetratorName) && strlen($perpetratorName) < 1) || (is_array($perpetratorName) && count($perpetratorName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($perpetratorName) && !is_string($perpetratorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($perpetratorName)), __LINE__);
        }
        $this->PerpetratorName = $perpetratorName;
        return $this;
    }
    /**
     * Get PerpetratorBirthDate value
     * @return string|null
     */
    public function getPerpetratorBirthDate()
    {
        return $this->PerpetratorBirthDate;
    }
    /**
     * Set PerpetratorBirthDate value
     * @param string $perpetratorBirthDate
     * @return \AisFssp\StructType\PenaltyChargesData
     */
    public function setPerpetratorBirthDate($perpetratorBirthDate = null)
    {
        // validation for constraint: maxExclusive
        if ($perpetratorBirthDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $perpetratorBirthDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($perpetratorBirthDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $perpetratorBirthDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($perpetratorBirthDate) && !is_string($perpetratorBirthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($perpetratorBirthDate)), __LINE__);
        }
        $this->PerpetratorBirthDate = $perpetratorBirthDate;
        return $this;
    }
    /**
     * Get PerpetratorBirthplace value
     * @return string|null
     */
    public function getPerpetratorBirthplace()
    {
        return $this->PerpetratorBirthplace;
    }
    /**
     * Set PerpetratorBirthplace value
     * @param string $perpetratorBirthplace
     * @return \AisFssp\StructType\PenaltyChargesData
     */
    public function setPerpetratorBirthplace($perpetratorBirthplace = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($perpetratorBirthplace) && strlen($perpetratorBirthplace) > 300) || (is_array($perpetratorBirthplace) && count($perpetratorBirthplace) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($perpetratorBirthplace) ? strlen($perpetratorBirthplace) : count($perpetratorBirthplace)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($perpetratorBirthplace) && strlen($perpetratorBirthplace) < 1) || (is_array($perpetratorBirthplace) && count($perpetratorBirthplace) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($perpetratorBirthplace) && !is_string($perpetratorBirthplace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($perpetratorBirthplace)), __LINE__);
        }
        $this->PerpetratorBirthplace = $perpetratorBirthplace;
        return $this;
    }
    /**
     * Get PerpetratorSerDoc value
     * @return string|null
     */
    public function getPerpetratorSerDoc()
    {
        return $this->PerpetratorSerDoc;
    }
    /**
     * Set PerpetratorSerDoc value
     * @param string $perpetratorSerDoc
     * @return \AisFssp\StructType\PenaltyChargesData
     */
    public function setPerpetratorSerDoc($perpetratorSerDoc = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($perpetratorSerDoc) && strlen($perpetratorSerDoc) > 25) || (is_array($perpetratorSerDoc) && count($perpetratorSerDoc) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($perpetratorSerDoc) ? strlen($perpetratorSerDoc) : count($perpetratorSerDoc)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($perpetratorSerDoc) && strlen($perpetratorSerDoc) < 1) || (is_array($perpetratorSerDoc) && count($perpetratorSerDoc) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($perpetratorSerDoc) && !is_string($perpetratorSerDoc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($perpetratorSerDoc)), __LINE__);
        }
        $this->PerpetratorSerDoc = $perpetratorSerDoc;
        return $this;
    }
    /**
     * Get PerpetratorNumDoc value
     * @return string|null
     */
    public function getPerpetratorNumDoc()
    {
        return $this->PerpetratorNumDoc;
    }
    /**
     * Set PerpetratorNumDoc value
     * @param string $perpetratorNumDoc
     * @return \AisFssp\StructType\PenaltyChargesData
     */
    public function setPerpetratorNumDoc($perpetratorNumDoc = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($perpetratorNumDoc) && strlen($perpetratorNumDoc) > 25) || (is_array($perpetratorNumDoc) && count($perpetratorNumDoc) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($perpetratorNumDoc) ? strlen($perpetratorNumDoc) : count($perpetratorNumDoc)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($perpetratorNumDoc) && strlen($perpetratorNumDoc) < 1) || (is_array($perpetratorNumDoc) && count($perpetratorNumDoc) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($perpetratorNumDoc) && !is_string($perpetratorNumDoc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($perpetratorNumDoc)), __LINE__);
        }
        $this->PerpetratorNumDoc = $perpetratorNumDoc;
        return $this;
    }
    /**
     * Get PerpetratorSNILS value
     * @return string|null
     */
    public function getPerpetratorSNILS()
    {
        return $this->PerpetratorSNILS;
    }
    /**
     * Set PerpetratorSNILS value
     * @param string $perpetratorSNILS
     * @return \AisFssp\StructType\PenaltyChargesData
     */
    public function setPerpetratorSNILS($perpetratorSNILS = null)
    {
        // validation for constraint: length
        if ((is_scalar($perpetratorSNILS) && strlen($perpetratorSNILS) !== 11) || (is_array($perpetratorSNILS) && count($perpetratorSNILS) !== 11)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 11 element(s) or a scalar of 11 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($perpetratorSNILS) && !preg_match('/[0-9]{11}/', $perpetratorSNILS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{11}", "%s" given', var_export($perpetratorSNILS, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($perpetratorSNILS) && !is_string($perpetratorSNILS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($perpetratorSNILS)), __LINE__);
        }
        $this->PerpetratorSNILS = $perpetratorSNILS;
        return $this;
    }
    /**
     * Get PerpetratorINN value
     * @return string|null
     */
    public function getPerpetratorINN()
    {
        return $this->PerpetratorINN;
    }
    /**
     * Set PerpetratorINN value
     * @param string $perpetratorINN
     * @return \AisFssp\StructType\PenaltyChargesData
     */
    public function setPerpetratorINN($perpetratorINN = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($perpetratorINN) && strlen($perpetratorINN) > 12) || (is_array($perpetratorINN) && count($perpetratorINN) > 12)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 12 element(s) or a scalar of 12 character(s) at most, "%d" length given', is_scalar($perpetratorINN) ? strlen($perpetratorINN) : count($perpetratorINN)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($perpetratorINN) && strlen($perpetratorINN) < 10) || (is_array($perpetratorINN) && count($perpetratorINN) < 10)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($perpetratorINN) && !preg_match('/(([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{8})|(([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{10})/', $perpetratorINN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{8})|(([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{10})", "%s" given', var_export($perpetratorINN, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($perpetratorINN) && !is_string($perpetratorINN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($perpetratorINN)), __LINE__);
        }
        $this->PerpetratorINN = $perpetratorINN;
        return $this;
    }
    /**
     * Get PerpetratorKPP value
     * @return string|null
     */
    public function getPerpetratorKPP()
    {
        return $this->PerpetratorKPP;
    }
    /**
     * Set PerpetratorKPP value
     * @param string $perpetratorKPP
     * @return \AisFssp\StructType\PenaltyChargesData
     */
    public function setPerpetratorKPP($perpetratorKPP = null)
    {
        // validation for constraint: length
        if ((is_scalar($perpetratorKPP) && strlen($perpetratorKPP) !== 9) || (is_array($perpetratorKPP) && count($perpetratorKPP) !== 9)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 9 element(s) or a scalar of 9 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($perpetratorKPP) && !preg_match('/([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{7}/', $perpetratorKPP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{7}", "%s" given', var_export($perpetratorKPP, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($perpetratorKPP) && !is_string($perpetratorKPP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($perpetratorKPP)), __LINE__);
        }
        $this->PerpetratorKPP = $perpetratorKPP;
        return $this;
    }
    /**
     * Get PerpetratorOGRN value
     * @return string|null
     */
    public function getPerpetratorOGRN()
    {
        return $this->PerpetratorOGRN;
    }
    /**
     * Set PerpetratorOGRN value
     * @param string $perpetratorOGRN
     * @return \AisFssp\StructType\PenaltyChargesData
     */
    public function setPerpetratorOGRN($perpetratorOGRN = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($perpetratorOGRN) && strlen($perpetratorOGRN) > 15) || (is_array($perpetratorOGRN) && count($perpetratorOGRN) > 15)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 15 element(s) or a scalar of 15 character(s) at most, "%d" length given', is_scalar($perpetratorOGRN) ? strlen($perpetratorOGRN) : count($perpetratorOGRN)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($perpetratorOGRN) && strlen($perpetratorOGRN) < 13) || (is_array($perpetratorOGRN) && count($perpetratorOGRN) < 13)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 13 element(s) or a scalar of 13 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($perpetratorOGRN) && !preg_match('/([0-9]{13})|([0-9]{15})/', $perpetratorOGRN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0-9]{13})|([0-9]{15})", "%s" given', var_export($perpetratorOGRN, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($perpetratorOGRN) && !is_string($perpetratorOGRN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($perpetratorOGRN)), __LINE__);
        }
        $this->PerpetratorOGRN = $perpetratorOGRN;
        return $this;
    }
    /**
     * Get PerpetratorAdr value
     * @return string|null
     */
    public function getPerpetratorAdr()
    {
        return $this->PerpetratorAdr;
    }
    /**
     * Set PerpetratorAdr value
     * @param string $perpetratorAdr
     * @return \AisFssp\StructType\PenaltyChargesData
     */
    public function setPerpetratorAdr($perpetratorAdr = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($perpetratorAdr) && strlen($perpetratorAdr) > 300) || (is_array($perpetratorAdr) && count($perpetratorAdr) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($perpetratorAdr) ? strlen($perpetratorAdr) : count($perpetratorAdr)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($perpetratorAdr) && strlen($perpetratorAdr) < 1) || (is_array($perpetratorAdr) && count($perpetratorAdr) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($perpetratorAdr) && !is_string($perpetratorAdr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($perpetratorAdr)), __LINE__);
        }
        $this->PerpetratorAdr = $perpetratorAdr;
        return $this;
    }
    /**
     * Get PerpetratorWorkplace value
     * @return string|null
     */
    public function getPerpetratorWorkplace()
    {
        return $this->PerpetratorWorkplace;
    }
    /**
     * Set PerpetratorWorkplace value
     * @param string $perpetratorWorkplace
     * @return \AisFssp\StructType\PenaltyChargesData
     */
    public function setPerpetratorWorkplace($perpetratorWorkplace = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($perpetratorWorkplace) && strlen($perpetratorWorkplace) > 1000) || (is_array($perpetratorWorkplace) && count($perpetratorWorkplace) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($perpetratorWorkplace) ? strlen($perpetratorWorkplace) : count($perpetratorWorkplace)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($perpetratorWorkplace) && strlen($perpetratorWorkplace) < 1) || (is_array($perpetratorWorkplace) && count($perpetratorWorkplace) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($perpetratorWorkplace) && !is_string($perpetratorWorkplace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($perpetratorWorkplace)), __LINE__);
        }
        $this->PerpetratorWorkplace = $perpetratorWorkplace;
        return $this;
    }
    /**
     * Get PerpetratorWorkplaceINN value
     * @return string|null
     */
    public function getPerpetratorWorkplaceINN()
    {
        return $this->PerpetratorWorkplaceINN;
    }
    /**
     * Set PerpetratorWorkplaceINN value
     * @param string $perpetratorWorkplaceINN
     * @return \AisFssp\StructType\PenaltyChargesData
     */
    public function setPerpetratorWorkplaceINN($perpetratorWorkplaceINN = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($perpetratorWorkplaceINN) && strlen($perpetratorWorkplaceINN) > 12) || (is_array($perpetratorWorkplaceINN) && count($perpetratorWorkplaceINN) > 12)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 12 element(s) or a scalar of 12 character(s) at most, "%d" length given', is_scalar($perpetratorWorkplaceINN) ? strlen($perpetratorWorkplaceINN) : count($perpetratorWorkplaceINN)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($perpetratorWorkplaceINN) && strlen($perpetratorWorkplaceINN) < 10) || (is_array($perpetratorWorkplaceINN) && count($perpetratorWorkplaceINN) < 10)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($perpetratorWorkplaceINN) && !preg_match('/(([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{8})|(([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{10})/', $perpetratorWorkplaceINN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{8})|(([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{10})", "%s" given', var_export($perpetratorWorkplaceINN, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($perpetratorWorkplaceINN) && !is_string($perpetratorWorkplaceINN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($perpetratorWorkplaceINN)), __LINE__);
        }
        $this->PerpetratorWorkplaceINN = $perpetratorWorkplaceINN;
        return $this;
    }
    /**
     * Get PerpetratorWorkplaceTelephone value
     * @return string|null
     */
    public function getPerpetratorWorkplaceTelephone()
    {
        return $this->PerpetratorWorkplaceTelephone;
    }
    /**
     * Set PerpetratorWorkplaceTelephone value
     * @param string $perpetratorWorkplaceTelephone
     * @return \AisFssp\StructType\PenaltyChargesData
     */
    public function setPerpetratorWorkplaceTelephone($perpetratorWorkplaceTelephone = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($perpetratorWorkplaceTelephone) && strlen($perpetratorWorkplaceTelephone) > 25) || (is_array($perpetratorWorkplaceTelephone) && count($perpetratorWorkplaceTelephone) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($perpetratorWorkplaceTelephone) ? strlen($perpetratorWorkplaceTelephone) : count($perpetratorWorkplaceTelephone)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($perpetratorWorkplaceTelephone) && strlen($perpetratorWorkplaceTelephone) < 1) || (is_array($perpetratorWorkplaceTelephone) && count($perpetratorWorkplaceTelephone) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($perpetratorWorkplaceTelephone) && !is_string($perpetratorWorkplaceTelephone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($perpetratorWorkplaceTelephone)), __LINE__);
        }
        $this->PerpetratorWorkplaceTelephone = $perpetratorWorkplaceTelephone;
        return $this;
    }
    /**
     * Get PerpetratorWorkplaceAddress value
     * @return string|null
     */
    public function getPerpetratorWorkplaceAddress()
    {
        return $this->PerpetratorWorkplaceAddress;
    }
    /**
     * Set PerpetratorWorkplaceAddress value
     * @param string $perpetratorWorkplaceAddress
     * @return \AisFssp\StructType\PenaltyChargesData
     */
    public function setPerpetratorWorkplaceAddress($perpetratorWorkplaceAddress = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($perpetratorWorkplaceAddress) && strlen($perpetratorWorkplaceAddress) > 300) || (is_array($perpetratorWorkplaceAddress) && count($perpetratorWorkplaceAddress) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($perpetratorWorkplaceAddress) ? strlen($perpetratorWorkplaceAddress) : count($perpetratorWorkplaceAddress)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($perpetratorWorkplaceAddress) && strlen($perpetratorWorkplaceAddress) < 1) || (is_array($perpetratorWorkplaceAddress) && count($perpetratorWorkplaceAddress) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($perpetratorWorkplaceAddress) && !is_string($perpetratorWorkplaceAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($perpetratorWorkplaceAddress)), __LINE__);
        }
        $this->PerpetratorWorkplaceAddress = $perpetratorWorkplaceAddress;
        return $this;
    }
    /**
     * Get PenaltyNumber value
     * @return string|null
     */
    public function getPenaltyNumber()
    {
        return $this->PenaltyNumber;
    }
    /**
     * Set PenaltyNumber value
     * @param string $penaltyNumber
     * @return \AisFssp\StructType\PenaltyChargesData
     */
    public function setPenaltyNumber($penaltyNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($penaltyNumber) && strlen($penaltyNumber) > 25) || (is_array($penaltyNumber) && count($penaltyNumber) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($penaltyNumber) ? strlen($penaltyNumber) : count($penaltyNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($penaltyNumber) && strlen($penaltyNumber) < 1) || (is_array($penaltyNumber) && count($penaltyNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($penaltyNumber) && !is_string($penaltyNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($penaltyNumber)), __LINE__);
        }
        $this->PenaltyNumber = $penaltyNumber;
        return $this;
    }
    /**
     * Get PenaltyDate value
     * @return string|null
     */
    public function getPenaltyDate()
    {
        return $this->PenaltyDate;
    }
    /**
     * Set PenaltyDate value
     * @param string $penaltyDate
     * @return \AisFssp\StructType\PenaltyChargesData
     */
    public function setPenaltyDate($penaltyDate = null)
    {
        // validation for constraint: maxExclusive
        if ($penaltyDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $penaltyDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($penaltyDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $penaltyDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($penaltyDate) && !is_string($penaltyDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($penaltyDate)), __LINE__);
        }
        $this->PenaltyDate = $penaltyDate;
        return $this;
    }
    /**
     * Get PenaltyRiseDate value
     * @return string|null
     */
    public function getPenaltyRiseDate()
    {
        return $this->PenaltyRiseDate;
    }
    /**
     * Set PenaltyRiseDate value
     * @param string $penaltyRiseDate
     * @return \AisFssp\StructType\PenaltyChargesData
     */
    public function setPenaltyRiseDate($penaltyRiseDate = null)
    {
        // validation for constraint: maxExclusive
        if ($penaltyRiseDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $penaltyRiseDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($penaltyRiseDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $penaltyRiseDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($penaltyRiseDate) && !is_string($penaltyRiseDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($penaltyRiseDate)), __LINE__);
        }
        $this->PenaltyRiseDate = $penaltyRiseDate;
        return $this;
    }
    /**
     * Get IPBasic value
     * @return string|null
     */
    public function getIPBasic()
    {
        return $this->IPBasic;
    }
    /**
     * Set IPBasic value
     * @param string $iPBasic
     * @return \AisFssp\StructType\PenaltyChargesData
     */
    public function setIPBasic($iPBasic = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iPBasic) && strlen($iPBasic) > 25) || (is_array($iPBasic) && count($iPBasic) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($iPBasic) ? strlen($iPBasic) : count($iPBasic)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($iPBasic) && strlen($iPBasic) < 1) || (is_array($iPBasic) && count($iPBasic) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iPBasic) && !is_string($iPBasic)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iPBasic)), __LINE__);
        }
        $this->IPBasic = $iPBasic;
        return $this;
    }
    /**
     * Get PenaltyBasic value
     * @return string|null
     */
    public function getPenaltyBasic()
    {
        return $this->PenaltyBasic;
    }
    /**
     * Set PenaltyBasic value
     * @param string $penaltyBasic
     * @return \AisFssp\StructType\PenaltyChargesData
     */
    public function setPenaltyBasic($penaltyBasic = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($penaltyBasic) && strlen($penaltyBasic) > 25) || (is_array($penaltyBasic) && count($penaltyBasic) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($penaltyBasic) ? strlen($penaltyBasic) : count($penaltyBasic)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($penaltyBasic) && strlen($penaltyBasic) < 1) || (is_array($penaltyBasic) && count($penaltyBasic) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($penaltyBasic) && !is_string($penaltyBasic)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($penaltyBasic)), __LINE__);
        }
        $this->PenaltyBasic = $penaltyBasic;
        return $this;
    }
    /**
     * Get PenaltyIP value
     * @return string|null
     */
    public function getPenaltyIP()
    {
        return $this->PenaltyIP;
    }
    /**
     * Set PenaltyIP value
     * @param string $penaltyIP
     * @return \AisFssp\StructType\PenaltyChargesData
     */
    public function setPenaltyIP($penaltyIP = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($penaltyIP) && strlen($penaltyIP) > 25) || (is_array($penaltyIP) && count($penaltyIP) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($penaltyIP) ? strlen($penaltyIP) : count($penaltyIP)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($penaltyIP) && strlen($penaltyIP) < 1) || (is_array($penaltyIP) && count($penaltyIP) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($penaltyIP) && !is_string($penaltyIP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($penaltyIP)), __LINE__);
        }
        $this->PenaltyIP = $penaltyIP;
        return $this;
    }
    /**
     * Get PenaltySum value
     * @return float|null
     */
    public function getPenaltySum()
    {
        return $this->PenaltySum;
    }
    /**
     * Set PenaltySum value
     * @param float $penaltySum
     * @return \AisFssp\StructType\PenaltyChargesData
     */
    public function setPenaltySum($penaltySum = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($penaltySum) && strlen(substr($penaltySum, strpos($penaltySum, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($penaltySum, strpos($penaltySum, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($penaltySum) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $penaltySum)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($penaltySum, strpos($penaltySum, '.')))), __LINE__);
        }
        $this->PenaltySum = $penaltySum;
        return $this;
    }
    /**
     * Get PenaltyRestTotal value
     * @return float|null
     */
    public function getPenaltyRestTotal()
    {
        return $this->PenaltyRestTotal;
    }
    /**
     * Set PenaltyRestTotal value
     * @param float $penaltyRestTotal
     * @return \AisFssp\StructType\PenaltyChargesData
     */
    public function setPenaltyRestTotal($penaltyRestTotal = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($penaltyRestTotal) && strlen(substr($penaltyRestTotal, strpos($penaltyRestTotal, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($penaltyRestTotal, strpos($penaltyRestTotal, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($penaltyRestTotal) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $penaltyRestTotal)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($penaltyRestTotal, strpos($penaltyRestTotal, '.')))), __LINE__);
        }
        $this->PenaltyRestTotal = $penaltyRestTotal;
        return $this;
    }
    /**
     * Get PenaltyKbk value
     * @return string|null
     */
    public function getPenaltyKbk()
    {
        return $this->PenaltyKbk;
    }
    /**
     * Set PenaltyKbk value
     * @param string $penaltyKbk
     * @return \AisFssp\StructType\PenaltyChargesData
     */
    public function setPenaltyKbk($penaltyKbk = null)
    {
        // validation for constraint: length
        if ((is_scalar($penaltyKbk) && strlen($penaltyKbk) !== 20) || (is_array($penaltyKbk) && count($penaltyKbk) !== 20)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($penaltyKbk) && !preg_match('/[0-9]{20}/', $penaltyKbk)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{20}", "%s" given', var_export($penaltyKbk, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($penaltyKbk) && !is_string($penaltyKbk)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($penaltyKbk)), __LINE__);
        }
        $this->PenaltyKbk = $penaltyKbk;
        return $this;
    }
    /**
     * Get PenaltyAuthorName value
     * @return string|null
     */
    public function getPenaltyAuthorName()
    {
        return $this->PenaltyAuthorName;
    }
    /**
     * Set PenaltyAuthorName value
     * @param string $penaltyAuthorName
     * @return \AisFssp\StructType\PenaltyChargesData
     */
    public function setPenaltyAuthorName($penaltyAuthorName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($penaltyAuthorName) && strlen($penaltyAuthorName) > 100) || (is_array($penaltyAuthorName) && count($penaltyAuthorName) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($penaltyAuthorName) ? strlen($penaltyAuthorName) : count($penaltyAuthorName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($penaltyAuthorName) && strlen($penaltyAuthorName) < 1) || (is_array($penaltyAuthorName) && count($penaltyAuthorName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($penaltyAuthorName) && !is_string($penaltyAuthorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($penaltyAuthorName)), __LINE__);
        }
        $this->PenaltyAuthorName = $penaltyAuthorName;
        return $this;
    }
    /**
     * Get PenaltyAuthorTel value
     * @return string|null
     */
    public function getPenaltyAuthorTel()
    {
        return $this->PenaltyAuthorTel;
    }
    /**
     * Set PenaltyAuthorTel value
     * @param string $penaltyAuthorTel
     * @return \AisFssp\StructType\PenaltyChargesData
     */
    public function setPenaltyAuthorTel($penaltyAuthorTel = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($penaltyAuthorTel) && strlen($penaltyAuthorTel) > 25) || (is_array($penaltyAuthorTel) && count($penaltyAuthorTel) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($penaltyAuthorTel) ? strlen($penaltyAuthorTel) : count($penaltyAuthorTel)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($penaltyAuthorTel) && strlen($penaltyAuthorTel) < 1) || (is_array($penaltyAuthorTel) && count($penaltyAuthorTel) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($penaltyAuthorTel) && !is_string($penaltyAuthorTel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($penaltyAuthorTel)), __LINE__);
        }
        $this->PenaltyAuthorTel = $penaltyAuthorTel;
        return $this;
    }
    /**
     * Get IsConfidential value
     * @return bool|null
     */
    public function getIsConfidential()
    {
        return $this->IsConfidential;
    }
    /**
     * Set IsConfidential value
     * @param bool $isConfidential
     * @return \AisFssp\StructType\PenaltyChargesData
     */
    public function setIsConfidential($isConfidential = null)
    {
        // validation for constraint: boolean
        if (!is_null($isConfidential) && !is_bool($isConfidential)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isConfidential)), __LINE__);
        }
        $this->IsConfidential = $isConfidential;
        return $this;
    }
    /**
     * Get PenaltyAdmRisepristName value
     * @return string|null
     */
    public function getPenaltyAdmRisepristName()
    {
        return $this->PenaltyAdmRisepristName;
    }
    /**
     * Set PenaltyAdmRisepristName value
     * @param string $penaltyAdmRisepristName
     * @return \AisFssp\StructType\PenaltyChargesData
     */
    public function setPenaltyAdmRisepristName($penaltyAdmRisepristName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($penaltyAdmRisepristName) && strlen($penaltyAdmRisepristName) > 100) || (is_array($penaltyAdmRisepristName) && count($penaltyAdmRisepristName) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($penaltyAdmRisepristName) ? strlen($penaltyAdmRisepristName) : count($penaltyAdmRisepristName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($penaltyAdmRisepristName) && strlen($penaltyAdmRisepristName) < 1) || (is_array($penaltyAdmRisepristName) && count($penaltyAdmRisepristName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($penaltyAdmRisepristName) && !is_string($penaltyAdmRisepristName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($penaltyAdmRisepristName)), __LINE__);
        }
        $this->PenaltyAdmRisepristName = $penaltyAdmRisepristName;
        return $this;
    }
    /**
     * Get PenaltyIdArtkoap value
     * @return int|null
     */
    public function getPenaltyIdArtkoap()
    {
        return $this->PenaltyIdArtkoap;
    }
    /**
     * Set PenaltyIdArtkoap value
     * @param int $penaltyIdArtkoap
     * @return \AisFssp\StructType\PenaltyChargesData
     */
    public function setPenaltyIdArtkoap($penaltyIdArtkoap = null)
    {
        // validation for constraint: minInclusive
        if ($penaltyIdArtkoap < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1, "%s" given', $penaltyIdArtkoap), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($penaltyIdArtkoap) && !is_numeric($penaltyIdArtkoap)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($penaltyIdArtkoap)), __LINE__);
        }
        $this->PenaltyIdArtkoap = $penaltyIdArtkoap;
        return $this;
    }
    /**
     * Get PenaltyUinCode value
     * @return string|null
     */
    public function getPenaltyUinCode()
    {
        return $this->PenaltyUinCode;
    }
    /**
     * Set PenaltyUinCode value
     * @param string $penaltyUinCode
     * @return \AisFssp\StructType\PenaltyChargesData
     */
    public function setPenaltyUinCode($penaltyUinCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($penaltyUinCode) && strlen($penaltyUinCode) > 25) || (is_array($penaltyUinCode) && count($penaltyUinCode) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($penaltyUinCode) ? strlen($penaltyUinCode) : count($penaltyUinCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($penaltyUinCode) && strlen($penaltyUinCode) < 20) || (is_array($penaltyUinCode) && count($penaltyUinCode) < 20)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($penaltyUinCode) && !preg_match('/(([0-9a-zA-Zа-яА-Я]{19})|([0-9]{8}[0-9a-zA-Zа-яА-Я]{16}))[0-9]/', $penaltyUinCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(([0-9a-zA-Zа-яА-Я]{19})|([0-9]{8}[0-9a-zA-Zа-яА-Я]{16}))[0-9]", "%s" given', var_export($penaltyUinCode, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($penaltyUinCode) && !is_string($penaltyUinCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($penaltyUinCode)), __LINE__);
        }
        $this->PenaltyUinCode = $penaltyUinCode;
        return $this;
    }
    /**
     * Get PenaltyUip value
     * @return string|null
     */
    public function getPenaltyUip()
    {
        return $this->PenaltyUip;
    }
    /**
     * Set PenaltyUip value
     * @param string $penaltyUip
     * @return \AisFssp\StructType\PenaltyChargesData
     */
    public function setPenaltyUip($penaltyUip = null)
    {
        // validation for constraint: length
        if ((is_scalar($penaltyUip) && strlen($penaltyUip) !== 25) || (is_array($penaltyUip) && count($penaltyUip) !== 25)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s)', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($penaltyUip) && !is_string($penaltyUip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($penaltyUip)), __LINE__);
        }
        $this->PenaltyUip = $penaltyUip;
        return $this;
    }
    /**
     * Get PenaltyEssentialElements value
     * @return string|null
     */
    public function getPenaltyEssentialElements()
    {
        return $this->PenaltyEssentialElements;
    }
    /**
     * Set PenaltyEssentialElements value
     * @param string $penaltyEssentialElements
     * @return \AisFssp\StructType\PenaltyChargesData
     */
    public function setPenaltyEssentialElements($penaltyEssentialElements = null)
    {
        // validation for constraint: string
        if (!is_null($penaltyEssentialElements) && !is_string($penaltyEssentialElements)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($penaltyEssentialElements)), __LINE__);
        }
        $this->PenaltyEssentialElements = $penaltyEssentialElements;
        return $this;
    }
    /**
     * Get PenaltyExaminationSendDate value
     * @return string|null
     */
    public function getPenaltyExaminationSendDate()
    {
        return $this->PenaltyExaminationSendDate;
    }
    /**
     * Set PenaltyExaminationSendDate value
     * @param string $penaltyExaminationSendDate
     * @return \AisFssp\StructType\PenaltyChargesData
     */
    public function setPenaltyExaminationSendDate($penaltyExaminationSendDate = null)
    {
        // validation for constraint: maxExclusive
        if ($penaltyExaminationSendDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $penaltyExaminationSendDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($penaltyExaminationSendDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $penaltyExaminationSendDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($penaltyExaminationSendDate) && !is_string($penaltyExaminationSendDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($penaltyExaminationSendDate)), __LINE__);
        }
        $this->PenaltyExaminationSendDate = $penaltyExaminationSendDate;
        return $this;
    }
    /**
     * Get PenaltyCourtName2 value
     * @return string|null
     */
    public function getPenaltyCourtName2()
    {
        return $this->PenaltyCourtName2;
    }
    /**
     * Set PenaltyCourtName2 value
     * @param string $penaltyCourtName2
     * @return \AisFssp\StructType\PenaltyChargesData
     */
    public function setPenaltyCourtName2($penaltyCourtName2 = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($penaltyCourtName2) && strlen($penaltyCourtName2) > 1000) || (is_array($penaltyCourtName2) && count($penaltyCourtName2) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($penaltyCourtName2) ? strlen($penaltyCourtName2) : count($penaltyCourtName2)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($penaltyCourtName2) && !is_string($penaltyCourtName2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($penaltyCourtName2)), __LINE__);
        }
        $this->PenaltyCourtName2 = $penaltyCourtName2;
        return $this;
    }
    /**
     * Get PenaltyExaminationResultCode value
     * @return string|null
     */
    public function getPenaltyExaminationResultCode()
    {
        return $this->PenaltyExaminationResultCode;
    }
    /**
     * Set PenaltyExaminationResultCode value
     * @param string $penaltyExaminationResultCode
     * @return \AisFssp\StructType\PenaltyChargesData
     */
    public function setPenaltyExaminationResultCode($penaltyExaminationResultCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($penaltyExaminationResultCode) && strlen($penaltyExaminationResultCode) > 10) || (is_array($penaltyExaminationResultCode) && count($penaltyExaminationResultCode) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($penaltyExaminationResultCode) ? strlen($penaltyExaminationResultCode) : count($penaltyExaminationResultCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($penaltyExaminationResultCode) && strlen($penaltyExaminationResultCode) < 1) || (is_array($penaltyExaminationResultCode) && count($penaltyExaminationResultCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($penaltyExaminationResultCode) && !is_string($penaltyExaminationResultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($penaltyExaminationResultCode)), __LINE__);
        }
        $this->PenaltyExaminationResultCode = $penaltyExaminationResultCode;
        return $this;
    }
    /**
     * Get PenaltyCourtAdmCancelDate value
     * @return string|null
     */
    public function getPenaltyCourtAdmCancelDate()
    {
        return $this->PenaltyCourtAdmCancelDate;
    }
    /**
     * Set PenaltyCourtAdmCancelDate value
     * @param string $penaltyCourtAdmCancelDate
     * @return \AisFssp\StructType\PenaltyChargesData
     */
    public function setPenaltyCourtAdmCancelDate($penaltyCourtAdmCancelDate = null)
    {
        // validation for constraint: maxExclusive
        if ($penaltyCourtAdmCancelDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $penaltyCourtAdmCancelDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($penaltyCourtAdmCancelDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $penaltyCourtAdmCancelDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($penaltyCourtAdmCancelDate) && !is_string($penaltyCourtAdmCancelDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($penaltyCourtAdmCancelDate)), __LINE__);
        }
        $this->PenaltyCourtAdmCancelDate = $penaltyCourtAdmCancelDate;
        return $this;
    }
    /**
     * Get PenaltyPayDate value
     * @return string|null
     */
    public function getPenaltyPayDate()
    {
        return $this->PenaltyPayDate;
    }
    /**
     * Set PenaltyPayDate value
     * @param string $penaltyPayDate
     * @return \AisFssp\StructType\PenaltyChargesData
     */
    public function setPenaltyPayDate($penaltyPayDate = null)
    {
        // validation for constraint: maxExclusive
        if ($penaltyPayDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $penaltyPayDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($penaltyPayDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $penaltyPayDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($penaltyPayDate) && !is_string($penaltyPayDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($penaltyPayDate)), __LINE__);
        }
        $this->PenaltyPayDate = $penaltyPayDate;
        return $this;
    }
    /**
     * Get PenaltyNoPayIntime value
     * @return bool|null
     */
    public function getPenaltyNoPayIntime()
    {
        return $this->PenaltyNoPayIntime;
    }
    /**
     * Set PenaltyNoPayIntime value
     * @param bool $penaltyNoPayIntime
     * @return \AisFssp\StructType\PenaltyChargesData
     */
    public function setPenaltyNoPayIntime($penaltyNoPayIntime = null)
    {
        // validation for constraint: boolean
        if (!is_null($penaltyNoPayIntime) && !is_bool($penaltyNoPayIntime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($penaltyNoPayIntime)), __LINE__);
        }
        $this->PenaltyNoPayIntime = $penaltyNoPayIntime;
        return $this;
    }
    /**
     * Get PenaltyDate2025 value
     * @return string|null
     */
    public function getPenaltyDate2025()
    {
        return $this->PenaltyDate2025;
    }
    /**
     * Set PenaltyDate2025 value
     * @param string $penaltyDate2025
     * @return \AisFssp\StructType\PenaltyChargesData
     */
    public function setPenaltyDate2025($penaltyDate2025 = null)
    {
        // validation for constraint: maxExclusive
        if ($penaltyDate2025 >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $penaltyDate2025), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($penaltyDate2025 < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $penaltyDate2025), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($penaltyDate2025) && !is_string($penaltyDate2025)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($penaltyDate2025)), __LINE__);
        }
        $this->PenaltyDate2025 = $penaltyDate2025;
        return $this;
    }
    /**
     * Get PenaltyIdDocdate value
     * @return string|null
     */
    public function getPenaltyIdDocdate()
    {
        return $this->PenaltyIdDocdate;
    }
    /**
     * Set PenaltyIdDocdate value
     * @param string $penaltyIdDocdate
     * @return \AisFssp\StructType\PenaltyChargesData
     */
    public function setPenaltyIdDocdate($penaltyIdDocdate = null)
    {
        // validation for constraint: maxExclusive
        if ($penaltyIdDocdate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $penaltyIdDocdate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($penaltyIdDocdate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $penaltyIdDocdate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($penaltyIdDocdate) && !is_string($penaltyIdDocdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($penaltyIdDocdate)), __LINE__);
        }
        $this->PenaltyIdDocdate = $penaltyIdDocdate;
        return $this;
    }
    /**
     * Get PenaltyIpRisedate value
     * @return string|null
     */
    public function getPenaltyIpRisedate()
    {
        return $this->PenaltyIpRisedate;
    }
    /**
     * Set PenaltyIpRisedate value
     * @param string $penaltyIpRisedate
     * @return \AisFssp\StructType\PenaltyChargesData
     */
    public function setPenaltyIpRisedate($penaltyIpRisedate = null)
    {
        // validation for constraint: maxExclusive
        if ($penaltyIpRisedate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $penaltyIpRisedate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($penaltyIpRisedate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $penaltyIpRisedate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($penaltyIpRisedate) && !is_string($penaltyIpRisedate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($penaltyIpRisedate)), __LINE__);
        }
        $this->PenaltyIpRisedate = $penaltyIpRisedate;
        return $this;
    }
    /**
     * Get PenaltyGisGmp value
     * @return bool|null
     */
    public function getPenaltyGisGmp()
    {
        return $this->PenaltyGisGmp;
    }
    /**
     * Set PenaltyGisGmp value
     * @param bool $penaltyGisGmp
     * @return \AisFssp\StructType\PenaltyChargesData
     */
    public function setPenaltyGisGmp($penaltyGisGmp = null)
    {
        // validation for constraint: boolean
        if (!is_null($penaltyGisGmp) && !is_bool($penaltyGisGmp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($penaltyGisGmp)), __LINE__);
        }
        $this->PenaltyGisGmp = $penaltyGisGmp;
        return $this;
    }
    /**
     * Get PenaltyPostId value
     * @return int|null
     */
    public function getPenaltyPostId()
    {
        return $this->PenaltyPostId;
    }
    /**
     * Set PenaltyPostId value
     * @param int $penaltyPostId
     * @return \AisFssp\StructType\PenaltyChargesData
     */
    public function setPenaltyPostId($penaltyPostId = null)
    {
        // validation for constraint: minInclusive
        if ($penaltyPostId < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1, "%s" given', $penaltyPostId), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($penaltyPostId) && !is_numeric($penaltyPostId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($penaltyPostId)), __LINE__);
        }
        $this->PenaltyPostId = $penaltyPostId;
        return $this;
    }
    /**
     * Get OffenderCitizenshipCode value
     * @return string|null
     */
    public function getOffenderCitizenshipCode()
    {
        return $this->OffenderCitizenshipCode;
    }
    /**
     * Set OffenderCitizenshipCode value
     * @param string $offenderCitizenshipCode
     * @return \AisFssp\StructType\PenaltyChargesData
     */
    public function setOffenderCitizenshipCode($offenderCitizenshipCode = null)
    {
        // validation for constraint: length
        if ((is_scalar($offenderCitizenshipCode) && strlen($offenderCitizenshipCode) !== 3) || (is_array($offenderCitizenshipCode) && count($offenderCitizenshipCode) !== 3)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 3 element(s) or a scalar of 3 character(s)', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($offenderCitizenshipCode) && !is_string($offenderCitizenshipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($offenderCitizenshipCode)), __LINE__);
        }
        $this->OffenderCitizenshipCode = $offenderCitizenshipCode;
        return $this;
    }
    /**
     * Get PenaltyHoursDaysQty value
     * @return int|null
     */
    public function getPenaltyHoursDaysQty()
    {
        return $this->PenaltyHoursDaysQty;
    }
    /**
     * Set PenaltyHoursDaysQty value
     * @param int $penaltyHoursDaysQty
     * @return \AisFssp\StructType\PenaltyChargesData
     */
    public function setPenaltyHoursDaysQty($penaltyHoursDaysQty = null)
    {
        // validation for constraint: minInclusive
        if ($penaltyHoursDaysQty < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1, "%s" given', $penaltyHoursDaysQty), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($penaltyHoursDaysQty) && !is_numeric($penaltyHoursDaysQty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($penaltyHoursDaysQty)), __LINE__);
        }
        $this->PenaltyHoursDaysQty = $penaltyHoursDaysQty;
        return $this;
    }
    /**
     * Get AdmMakeDecisionPostId value
     * @return int|null
     */
    public function getAdmMakeDecisionPostId()
    {
        return $this->AdmMakeDecisionPostId;
    }
    /**
     * Set AdmMakeDecisionPostId value
     * @param int $admMakeDecisionPostId
     * @return \AisFssp\StructType\PenaltyChargesData
     */
    public function setAdmMakeDecisionPostId($admMakeDecisionPostId = null)
    {
        // validation for constraint: minInclusive
        if ($admMakeDecisionPostId < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1, "%s" given', $admMakeDecisionPostId), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($admMakeDecisionPostId) && !is_numeric($admMakeDecisionPostId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($admMakeDecisionPostId)), __LINE__);
        }
        $this->AdmMakeDecisionPostId = $admMakeDecisionPostId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\PenaltyChargesData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
