<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OutgoingEMailMessage StructType
 * Meta informations extracted from the WSDL
 * - documentation: Исходящее сообщение ведомственной электронной почты
 * - type: tns:OutgoingEMailMessage
 * @subpackage Structs
 */
class OutgoingEMailMessage extends AbstractStructBase
{
    /**
     * The InternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ сообщения АИС ФССП России | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при
     * получении объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $InternalKey;
    /**
     * The IncomingMessageKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор сообщения сервера МВВ | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при
     * получении объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $IncomingMessageKey;
    /**
     * The InReplyTo
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор сообщения почтового сервера | Идентификатор сообщения электронной почты
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $InReplyTo;
    /**
     * The Recipient
     * Meta informations extracted from the WSDL
     * - documentation: Получатель | Адрес электронной почты
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string[]
     */
    public $Recipient;
    /**
     * The CC
     * Meta informations extracted from the WSDL
     * - documentation: Копия | Адрес электронной почты
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string[]
     */
    public $CC;
    /**
     * The Subject
     * Meta informations extracted from the WSDL
     * - documentation: Тема | Строка длиной от 1 до 1000 символов
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $Subject;
    /**
     * The Text
     * Meta informations extracted from the WSDL
     * - documentation: Текст сообщения | Массив произвольных данных (текстовый)
     * - minOccurs: 0
     * @var string
     */
    public $Text;
    /**
     * The Header
     * Meta informations extracted from the WSDL
     * - documentation: Заголовки
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\EMailHeaderType[]
     */
    public $Header;
    /**
     * The DocumentData
     * Meta informations extracted from the WSDL
     * - documentation: Исходящий документ в формате ПИЭВ
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\EmbeddedDocumentType[]
     */
    public $DocumentData;
    /**
     * Constructor method for OutgoingEMailMessage
     * @uses OutgoingEMailMessage::setInternalKey()
     * @uses OutgoingEMailMessage::setIncomingMessageKey()
     * @uses OutgoingEMailMessage::setInReplyTo()
     * @uses OutgoingEMailMessage::setRecipient()
     * @uses OutgoingEMailMessage::setCC()
     * @uses OutgoingEMailMessage::setSubject()
     * @uses OutgoingEMailMessage::setText()
     * @uses OutgoingEMailMessage::setHeader()
     * @uses OutgoingEMailMessage::setDocumentData()
     * @param int $internalKey
     * @param int $incomingMessageKey
     * @param string $inReplyTo
     * @param string[] $recipient
     * @param string[] $cC
     * @param string $subject
     * @param string $text
     * @param \AisFssp\StructType\EMailHeaderType[] $header
     * @param \AisFssp\StructType\EmbeddedDocumentType[] $documentData
     */
    public function __construct($internalKey = null, $incomingMessageKey = null, $inReplyTo = null, array $recipient = array(), array $cC = array(), $subject = null, $text = null, array $header = array(), array $documentData = array())
    {
        $this
            ->setInternalKey($internalKey)
            ->setIncomingMessageKey($incomingMessageKey)
            ->setInReplyTo($inReplyTo)
            ->setRecipient($recipient)
            ->setCC($cC)
            ->setSubject($subject)
            ->setText($text)
            ->setHeader($header)
            ->setDocumentData($documentData);
    }
    /**
     * Get InternalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->InternalKey;
    }
    /**
     * Set InternalKey value
     * @param int $internalKey
     * @return \AisFssp\StructType\OutgoingEMailMessage
     */
    public function setInternalKey($internalKey = null)
    {
        // validation for constraint: maxInclusive
        if ($internalKey > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($internalKey < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($internalKey) && !is_numeric($internalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($internalKey)), __LINE__);
        }
        $this->InternalKey = $internalKey;
        return $this;
    }
    /**
     * Get IncomingMessageKey value
     * @return int|null
     */
    public function getIncomingMessageKey()
    {
        return $this->IncomingMessageKey;
    }
    /**
     * Set IncomingMessageKey value
     * @param int $incomingMessageKey
     * @return \AisFssp\StructType\OutgoingEMailMessage
     */
    public function setIncomingMessageKey($incomingMessageKey = null)
    {
        // validation for constraint: maxInclusive
        if ($incomingMessageKey > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $incomingMessageKey), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($incomingMessageKey < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $incomingMessageKey), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($incomingMessageKey) && !is_numeric($incomingMessageKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($incomingMessageKey)), __LINE__);
        }
        $this->IncomingMessageKey = $incomingMessageKey;
        return $this;
    }
    /**
     * Get InReplyTo value
     * @return string|null
     */
    public function getInReplyTo()
    {
        return $this->InReplyTo;
    }
    /**
     * Set InReplyTo value
     * @param string $inReplyTo
     * @return \AisFssp\StructType\OutgoingEMailMessage
     */
    public function setInReplyTo($inReplyTo = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($inReplyTo) && strlen($inReplyTo) > 255) || (is_array($inReplyTo) && count($inReplyTo) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($inReplyTo) ? strlen($inReplyTo) : count($inReplyTo)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($inReplyTo) && strlen($inReplyTo) < 1) || (is_array($inReplyTo) && count($inReplyTo) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($inReplyTo) && !is_string($inReplyTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($inReplyTo)), __LINE__);
        }
        $this->InReplyTo = $inReplyTo;
        return $this;
    }
    /**
     * Get Recipient value
     * @return string[]|null
     */
    public function getRecipient()
    {
        return $this->Recipient;
    }
    /**
     * Set Recipient value
     * @throws \InvalidArgumentException
     * @param string[] $recipient
     * @return \AisFssp\StructType\OutgoingEMailMessage
     */
    public function setRecipient(array $recipient = array())
    {
        // validation for constraint: maxLength
        if ((is_scalar($recipient) && strlen($recipient) > 100) || (is_array($recipient) && count($recipient) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($recipient) ? strlen($recipient) : count($recipient)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($recipient) && strlen($recipient) < 1) || (is_array($recipient) && count($recipient) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        foreach ($recipient as $outgoingEMailMessageRecipientItem) {
            // validation for constraint: itemType
            if (!is_string($outgoingEMailMessageRecipientItem)) {
                throw new \InvalidArgumentException(sprintf('The Recipient property can only contain items of string, "%s" given', is_object($outgoingEMailMessageRecipientItem) ? get_class($outgoingEMailMessageRecipientItem) : gettype($outgoingEMailMessageRecipientItem)), __LINE__);
            }
        }
        $this->Recipient = $recipient;
        return $this;
    }
    /**
     * Add item to Recipient value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \AisFssp\StructType\OutgoingEMailMessage
     */
    public function addToRecipient($item)
    {
        // validation for constraint: maxLength
        if ((is_scalar($item) && strlen($item) > 100) || (is_array($item) && count($item) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($item) ? strlen($item) : count($item)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($item) && strlen($item) < 1) || (is_array($item) && count($item) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Recipient property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Recipient[] = $item;
        return $this;
    }
    /**
     * Get CC value
     * @return string[]|null
     */
    public function getCC()
    {
        return $this->CC;
    }
    /**
     * Set CC value
     * @throws \InvalidArgumentException
     * @param string[] $cC
     * @return \AisFssp\StructType\OutgoingEMailMessage
     */
    public function setCC(array $cC = array())
    {
        // validation for constraint: maxLength
        if ((is_scalar($cC) && strlen($cC) > 100) || (is_array($cC) && count($cC) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($cC) ? strlen($cC) : count($cC)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($cC) && strlen($cC) < 1) || (is_array($cC) && count($cC) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        foreach ($cC as $outgoingEMailMessageCCItem) {
            // validation for constraint: itemType
            if (!is_string($outgoingEMailMessageCCItem)) {
                throw new \InvalidArgumentException(sprintf('The CC property can only contain items of string, "%s" given', is_object($outgoingEMailMessageCCItem) ? get_class($outgoingEMailMessageCCItem) : gettype($outgoingEMailMessageCCItem)), __LINE__);
            }
        }
        $this->CC = $cC;
        return $this;
    }
    /**
     * Add item to CC value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \AisFssp\StructType\OutgoingEMailMessage
     */
    public function addToCC($item)
    {
        // validation for constraint: maxLength
        if ((is_scalar($item) && strlen($item) > 100) || (is_array($item) && count($item) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($item) ? strlen($item) : count($item)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($item) && strlen($item) < 1) || (is_array($item) && count($item) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The CC property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CC[] = $item;
        return $this;
    }
    /**
     * Get Subject value
     * @return string|null
     */
    public function getSubject()
    {
        return $this->Subject;
    }
    /**
     * Set Subject value
     * @param string $subject
     * @return \AisFssp\StructType\OutgoingEMailMessage
     */
    public function setSubject($subject = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($subject) && strlen($subject) > 1000) || (is_array($subject) && count($subject) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($subject) ? strlen($subject) : count($subject)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($subject) && strlen($subject) < 1) || (is_array($subject) && count($subject) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($subject) && !is_string($subject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subject)), __LINE__);
        }
        $this->Subject = $subject;
        return $this;
    }
    /**
     * Get Text value
     * @return string|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param string $text
     * @return \AisFssp\StructType\OutgoingEMailMessage
     */
    public function setText($text = null)
    {
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($text)), __LINE__);
        }
        $this->Text = $text;
        return $this;
    }
    /**
     * Get Header value
     * @return \AisFssp\StructType\EMailHeaderType[]|null
     */
    public function getHeader()
    {
        return $this->Header;
    }
    /**
     * Set Header value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\EMailHeaderType[] $header
     * @return \AisFssp\StructType\OutgoingEMailMessage
     */
    public function setHeader(array $header = array())
    {
        foreach ($header as $outgoingEMailMessageHeaderItem) {
            // validation for constraint: itemType
            if (!$outgoingEMailMessageHeaderItem instanceof \AisFssp\StructType\EMailHeaderType) {
                throw new \InvalidArgumentException(sprintf('The Header property can only contain items of \AisFssp\StructType\EMailHeaderType, "%s" given', is_object($outgoingEMailMessageHeaderItem) ? get_class($outgoingEMailMessageHeaderItem) : gettype($outgoingEMailMessageHeaderItem)), __LINE__);
            }
        }
        $this->Header = $header;
        return $this;
    }
    /**
     * Add item to Header value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\EMailHeaderType $item
     * @return \AisFssp\StructType\OutgoingEMailMessage
     */
    public function addToHeader(\AisFssp\StructType\EMailHeaderType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\EMailHeaderType) {
            throw new \InvalidArgumentException(sprintf('The Header property can only contain items of \AisFssp\StructType\EMailHeaderType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Header[] = $item;
        return $this;
    }
    /**
     * Get DocumentData value
     * @return \AisFssp\StructType\EmbeddedDocumentType[]|null
     */
    public function getDocumentData()
    {
        return $this->DocumentData;
    }
    /**
     * Set DocumentData value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\EmbeddedDocumentType[] $documentData
     * @return \AisFssp\StructType\OutgoingEMailMessage
     */
    public function setDocumentData(array $documentData = array())
    {
        foreach ($documentData as $outgoingEMailMessageDocumentDataItem) {
            // validation for constraint: itemType
            if (!$outgoingEMailMessageDocumentDataItem instanceof \AisFssp\StructType\EmbeddedDocumentType) {
                throw new \InvalidArgumentException(sprintf('The DocumentData property can only contain items of \AisFssp\StructType\EmbeddedDocumentType, "%s" given', is_object($outgoingEMailMessageDocumentDataItem) ? get_class($outgoingEMailMessageDocumentDataItem) : gettype($outgoingEMailMessageDocumentDataItem)), __LINE__);
            }
        }
        $this->DocumentData = $documentData;
        return $this;
    }
    /**
     * Add item to DocumentData value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\EmbeddedDocumentType $item
     * @return \AisFssp\StructType\OutgoingEMailMessage
     */
    public function addToDocumentData(\AisFssp\StructType\EmbeddedDocumentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\EmbeddedDocumentType) {
            throw new \InvalidArgumentException(sprintf('The DocumentData property can only contain items of \AisFssp\StructType\EmbeddedDocumentType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DocumentData[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\OutgoingEMailMessage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
